// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a VPC endpoint.
 */
class VpcEndpoint private constructor(builder: Builder) {
    /**
     * The date and time that the endpoint was created.
     */
    val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimestamp
    /**
     * (Interface endpoint) The DNS entries for the endpoint.
     */
    val dnsEntries: List<DnsEntry>? = builder.dnsEntries
    /**
     * The DNS options for the endpoint.
     */
    val dnsOptions: aws.sdk.kotlin.services.ec2.model.DnsOptions? = builder.dnsOptions
    /**
     * (Interface endpoint) Information about the security groups that are associated with the network interface.
     */
    val groups: List<SecurityGroupIdentifier>? = builder.groups
    /**
     * The IP address type for the endpoint.
     */
    val ipAddressType: aws.sdk.kotlin.services.ec2.model.IpAddressType? = builder.ipAddressType
    /**
     * The last error that occurred for endpoint.
     */
    val lastError: aws.sdk.kotlin.services.ec2.model.LastError? = builder.lastError
    /**
     * (Interface endpoint) One or more network interfaces for the endpoint.
     */
    val networkInterfaceIds: List<String>? = builder.networkInterfaceIds
    /**
     * The ID of the Amazon Web Services account that owns the endpoint.
     */
    val ownerId: kotlin.String? = builder.ownerId
    /**
     * The policy document associated with the endpoint, if applicable.
     */
    val policyDocument: kotlin.String? = builder.policyDocument
    /**
     * (Interface endpoint) Indicates whether the VPC is associated with a private hosted zone.
     */
    val privateDnsEnabled: kotlin.Boolean? = builder.privateDnsEnabled
    /**
     * Indicates whether the endpoint is being managed by its service.
     */
    val requesterManaged: kotlin.Boolean? = builder.requesterManaged
    /**
     * (Gateway endpoint) One or more route tables associated with the endpoint.
     */
    val routeTableIds: List<String>? = builder.routeTableIds
    /**
     * The name of the service to which the endpoint is associated.
     */
    val serviceName: kotlin.String? = builder.serviceName
    /**
     * The state of the endpoint.
     */
    val state: aws.sdk.kotlin.services.ec2.model.State? = builder.state
    /**
     * (Interface endpoint) The subnets for the endpoint.
     */
    val subnetIds: List<String>? = builder.subnetIds
    /**
     * Any tags assigned to the endpoint.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the endpoint.
     */
    val vpcEndpointId: kotlin.String? = builder.vpcEndpointId
    /**
     * The type of endpoint.
     */
    val vpcEndpointType: aws.sdk.kotlin.services.ec2.model.VpcEndpointType? = builder.vpcEndpointType
    /**
     * The ID of the VPC to which the endpoint is associated.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.VpcEndpoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcEndpoint(")
        append("creationTimestamp=$creationTimestamp,")
        append("dnsEntries=$dnsEntries,")
        append("dnsOptions=$dnsOptions,")
        append("groups=$groups,")
        append("ipAddressType=$ipAddressType,")
        append("lastError=$lastError,")
        append("networkInterfaceIds=$networkInterfaceIds,")
        append("ownerId=$ownerId,")
        append("policyDocument=$policyDocument,")
        append("privateDnsEnabled=$privateDnsEnabled,")
        append("requesterManaged=$requesterManaged,")
        append("routeTableIds=$routeTableIds,")
        append("serviceName=$serviceName,")
        append("state=$state,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("vpcEndpointId=$vpcEndpointId,")
        append("vpcEndpointType=$vpcEndpointType,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimestamp?.hashCode() ?: 0
        result = 31 * result + (dnsEntries?.hashCode() ?: 0)
        result = 31 * result + (dnsOptions?.hashCode() ?: 0)
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (lastError?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceIds?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (policyDocument?.hashCode() ?: 0)
        result = 31 * result + (privateDnsEnabled?.hashCode() ?: 0)
        result = 31 * result + (requesterManaged?.hashCode() ?: 0)
        result = 31 * result + (routeTableIds?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointId?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointType?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcEndpoint

        if (creationTimestamp != other.creationTimestamp) return false
        if (dnsEntries != other.dnsEntries) return false
        if (dnsOptions != other.dnsOptions) return false
        if (groups != other.groups) return false
        if (ipAddressType != other.ipAddressType) return false
        if (lastError != other.lastError) return false
        if (networkInterfaceIds != other.networkInterfaceIds) return false
        if (ownerId != other.ownerId) return false
        if (policyDocument != other.policyDocument) return false
        if (privateDnsEnabled != other.privateDnsEnabled) return false
        if (requesterManaged != other.requesterManaged) return false
        if (routeTableIds != other.routeTableIds) return false
        if (serviceName != other.serviceName) return false
        if (state != other.state) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (vpcEndpointId != other.vpcEndpointId) return false
        if (vpcEndpointType != other.vpcEndpointType) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.VpcEndpoint = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time that the endpoint was created.
         */
        var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * (Interface endpoint) The DNS entries for the endpoint.
         */
        var dnsEntries: List<DnsEntry>? = null
        /**
         * The DNS options for the endpoint.
         */
        var dnsOptions: aws.sdk.kotlin.services.ec2.model.DnsOptions? = null
        /**
         * (Interface endpoint) Information about the security groups that are associated with the network interface.
         */
        var groups: List<SecurityGroupIdentifier>? = null
        /**
         * The IP address type for the endpoint.
         */
        var ipAddressType: aws.sdk.kotlin.services.ec2.model.IpAddressType? = null
        /**
         * The last error that occurred for endpoint.
         */
        var lastError: aws.sdk.kotlin.services.ec2.model.LastError? = null
        /**
         * (Interface endpoint) One or more network interfaces for the endpoint.
         */
        var networkInterfaceIds: List<String>? = null
        /**
         * The ID of the Amazon Web Services account that owns the endpoint.
         */
        var ownerId: kotlin.String? = null
        /**
         * The policy document associated with the endpoint, if applicable.
         */
        var policyDocument: kotlin.String? = null
        /**
         * (Interface endpoint) Indicates whether the VPC is associated with a private hosted zone.
         */
        var privateDnsEnabled: kotlin.Boolean? = null
        /**
         * Indicates whether the endpoint is being managed by its service.
         */
        var requesterManaged: kotlin.Boolean? = null
        /**
         * (Gateway endpoint) One or more route tables associated with the endpoint.
         */
        var routeTableIds: List<String>? = null
        /**
         * The name of the service to which the endpoint is associated.
         */
        var serviceName: kotlin.String? = null
        /**
         * The state of the endpoint.
         */
        var state: aws.sdk.kotlin.services.ec2.model.State? = null
        /**
         * (Interface endpoint) The subnets for the endpoint.
         */
        var subnetIds: List<String>? = null
        /**
         * Any tags assigned to the endpoint.
         */
        var tags: List<Tag>? = null
        /**
         * The ID of the endpoint.
         */
        var vpcEndpointId: kotlin.String? = null
        /**
         * The type of endpoint.
         */
        var vpcEndpointType: aws.sdk.kotlin.services.ec2.model.VpcEndpointType? = null
        /**
         * The ID of the VPC to which the endpoint is associated.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.VpcEndpoint) : this() {
            this.creationTimestamp = x.creationTimestamp
            this.dnsEntries = x.dnsEntries
            this.dnsOptions = x.dnsOptions
            this.groups = x.groups
            this.ipAddressType = x.ipAddressType
            this.lastError = x.lastError
            this.networkInterfaceIds = x.networkInterfaceIds
            this.ownerId = x.ownerId
            this.policyDocument = x.policyDocument
            this.privateDnsEnabled = x.privateDnsEnabled
            this.requesterManaged = x.requesterManaged
            this.routeTableIds = x.routeTableIds
            this.serviceName = x.serviceName
            this.state = x.state
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.vpcEndpointId = x.vpcEndpointId
            this.vpcEndpointType = x.vpcEndpointType
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.VpcEndpoint = VpcEndpoint(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.DnsOptions] inside the given [block]
         */
        fun dnsOptions(block: aws.sdk.kotlin.services.ec2.model.DnsOptions.Builder.() -> kotlin.Unit) {
            this.dnsOptions = aws.sdk.kotlin.services.ec2.model.DnsOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LastError] inside the given [block]
         */
        fun lastError(block: aws.sdk.kotlin.services.ec2.model.LastError.Builder.() -> kotlin.Unit) {
            this.lastError = aws.sdk.kotlin.services.ec2.model.LastError.invoke(block)
        }
    }
}
