// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes VPN connection options.
 */
class VpnConnectionOptions private constructor(builder: Builder) {
    /**
     * Indicates whether acceleration is enabled for the VPN connection.
     */
    val enableAcceleration: kotlin.Boolean? = builder.enableAcceleration
    /**
     * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
     */
    val localIpv4NetworkCidr: kotlin.String? = builder.localIpv4NetworkCidr
    /**
     * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     */
    val localIpv6NetworkCidr: kotlin.String? = builder.localIpv6NetworkCidr
    /**
     * The IPv4 CIDR on the Amazon Web Services side of the VPN connection.
     */
    val remoteIpv4NetworkCidr: kotlin.String? = builder.remoteIpv4NetworkCidr
    /**
     * The IPv6 CIDR on the Amazon Web Services side of the VPN connection.
     */
    val remoteIpv6NetworkCidr: kotlin.String? = builder.remoteIpv6NetworkCidr
    /**
     * Indicates whether the VPN connection uses static routes only. Static routes must be used for devices that don't support BGP.
     */
    val staticRoutesOnly: kotlin.Boolean? = builder.staticRoutesOnly
    /**
     * Indicates whether the VPN tunnels process IPv4 or IPv6 traffic.
     */
    val tunnelInsideIpVersion: aws.sdk.kotlin.services.ec2.model.TunnelInsideIpVersion? = builder.tunnelInsideIpVersion
    /**
     * Indicates the VPN tunnel options.
     */
    val tunnelOptions: List<TunnelOption>? = builder.tunnelOptions

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.VpnConnectionOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpnConnectionOptions(")
        append("enableAcceleration=$enableAcceleration,")
        append("localIpv4NetworkCidr=$localIpv4NetworkCidr,")
        append("localIpv6NetworkCidr=$localIpv6NetworkCidr,")
        append("remoteIpv4NetworkCidr=$remoteIpv4NetworkCidr,")
        append("remoteIpv6NetworkCidr=$remoteIpv6NetworkCidr,")
        append("staticRoutesOnly=$staticRoutesOnly,")
        append("tunnelInsideIpVersion=$tunnelInsideIpVersion,")
        append("tunnelOptions=$tunnelOptions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enableAcceleration?.hashCode() ?: 0
        result = 31 * result + (localIpv4NetworkCidr?.hashCode() ?: 0)
        result = 31 * result + (localIpv6NetworkCidr?.hashCode() ?: 0)
        result = 31 * result + (remoteIpv4NetworkCidr?.hashCode() ?: 0)
        result = 31 * result + (remoteIpv6NetworkCidr?.hashCode() ?: 0)
        result = 31 * result + (staticRoutesOnly?.hashCode() ?: 0)
        result = 31 * result + (tunnelInsideIpVersion?.hashCode() ?: 0)
        result = 31 * result + (tunnelOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpnConnectionOptions

        if (enableAcceleration != other.enableAcceleration) return false
        if (localIpv4NetworkCidr != other.localIpv4NetworkCidr) return false
        if (localIpv6NetworkCidr != other.localIpv6NetworkCidr) return false
        if (remoteIpv4NetworkCidr != other.remoteIpv4NetworkCidr) return false
        if (remoteIpv6NetworkCidr != other.remoteIpv6NetworkCidr) return false
        if (staticRoutesOnly != other.staticRoutesOnly) return false
        if (tunnelInsideIpVersion != other.tunnelInsideIpVersion) return false
        if (tunnelOptions != other.tunnelOptions) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.VpnConnectionOptions = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether acceleration is enabled for the VPN connection.
         */
        var enableAcceleration: kotlin.Boolean? = null
        /**
         * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
         */
        var localIpv4NetworkCidr: kotlin.String? = null
        /**
         * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
         */
        var localIpv6NetworkCidr: kotlin.String? = null
        /**
         * The IPv4 CIDR on the Amazon Web Services side of the VPN connection.
         */
        var remoteIpv4NetworkCidr: kotlin.String? = null
        /**
         * The IPv6 CIDR on the Amazon Web Services side of the VPN connection.
         */
        var remoteIpv6NetworkCidr: kotlin.String? = null
        /**
         * Indicates whether the VPN connection uses static routes only. Static routes must be used for devices that don't support BGP.
         */
        var staticRoutesOnly: kotlin.Boolean? = null
        /**
         * Indicates whether the VPN tunnels process IPv4 or IPv6 traffic.
         */
        var tunnelInsideIpVersion: aws.sdk.kotlin.services.ec2.model.TunnelInsideIpVersion? = null
        /**
         * Indicates the VPN tunnel options.
         */
        var tunnelOptions: List<TunnelOption>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.VpnConnectionOptions) : this() {
            this.enableAcceleration = x.enableAcceleration
            this.localIpv4NetworkCidr = x.localIpv4NetworkCidr
            this.localIpv6NetworkCidr = x.localIpv6NetworkCidr
            this.remoteIpv4NetworkCidr = x.remoteIpv4NetworkCidr
            this.remoteIpv6NetworkCidr = x.remoteIpv6NetworkCidr
            this.staticRoutesOnly = x.staticRoutesOnly
            this.tunnelInsideIpVersion = x.tunnelInsideIpVersion
            this.tunnelOptions = x.tunnelOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.VpnConnectionOptions = VpnConnectionOptions(this)
    }
}
