// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a virtual private gateway.
 */
class VpnGateway private constructor(builder: Builder) {
    /**
     * The private Autonomous System Number (ASN) for the Amazon side of a BGP session.
     */
    val amazonSideAsn: kotlin.Long? = builder.amazonSideAsn
    /**
     * The Availability Zone where the virtual private gateway was created, if applicable. This field may be empty or not returned.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The current state of the virtual private gateway.
     */
    val state: aws.sdk.kotlin.services.ec2.model.VpnState? = builder.state
    /**
     * Any tags assigned to the virtual private gateway.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The type of VPN connection the virtual private gateway supports.
     */
    val type: aws.sdk.kotlin.services.ec2.model.GatewayType? = builder.type
    /**
     * Any VPCs attached to the virtual private gateway.
     */
    val vpcAttachments: List<VpcAttachment>? = builder.vpcAttachments
    /**
     * The ID of the virtual private gateway.
     */
    val vpnGatewayId: kotlin.String? = builder.vpnGatewayId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.VpnGateway = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpnGateway(")
        append("amazonSideAsn=$amazonSideAsn,")
        append("availabilityZone=$availabilityZone,")
        append("state=$state,")
        append("tags=$tags,")
        append("type=$type,")
        append("vpcAttachments=$vpcAttachments,")
        append("vpnGatewayId=$vpnGatewayId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amazonSideAsn?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vpcAttachments?.hashCode() ?: 0)
        result = 31 * result + (vpnGatewayId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpnGateway

        if (amazonSideAsn != other.amazonSideAsn) return false
        if (availabilityZone != other.availabilityZone) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (vpcAttachments != other.vpcAttachments) return false
        if (vpnGatewayId != other.vpnGatewayId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.VpnGateway = Builder(this).apply(block).build()

    class Builder {
        /**
         * The private Autonomous System Number (ASN) for the Amazon side of a BGP session.
         */
        var amazonSideAsn: kotlin.Long? = null
        /**
         * The Availability Zone where the virtual private gateway was created, if applicable. This field may be empty or not returned.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The current state of the virtual private gateway.
         */
        var state: aws.sdk.kotlin.services.ec2.model.VpnState? = null
        /**
         * Any tags assigned to the virtual private gateway.
         */
        var tags: List<Tag>? = null
        /**
         * The type of VPN connection the virtual private gateway supports.
         */
        var type: aws.sdk.kotlin.services.ec2.model.GatewayType? = null
        /**
         * Any VPCs attached to the virtual private gateway.
         */
        var vpcAttachments: List<VpcAttachment>? = null
        /**
         * The ID of the virtual private gateway.
         */
        var vpnGatewayId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.VpnGateway) : this() {
            this.amazonSideAsn = x.amazonSideAsn
            this.availabilityZone = x.availabilityZone
            this.state = x.state
            this.tags = x.tags
            this.type = x.type
            this.vpcAttachments = x.vpcAttachments
            this.vpnGatewayId = x.vpnGatewayId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.VpnGateway = VpnGateway(this)
    }
}
