// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.services.ec2.model.AllocateAddressRequest
import aws.sdk.kotlin.services.ec2.model.DomainType
import aws.sdk.kotlin.services.ec2.model.TagSpecification
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlFlattened
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class AllocateAddressOperationSerializer: HttpSerialize<AllocateAddressRequest> {
    override suspend fun serialize(context: ExecutionContext, input: AllocateAddressRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeAllocateAddressOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeAllocateAddressOperationBody(context: ExecutionContext, input: AllocateAddressRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val ADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Address"))
    val CUSTOMEROWNEDIPV4POOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("CustomerOwnedIpv4Pool"))
    val DOMAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Domain"))
    val DRYRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("DryRun"))
    val NETWORKBORDERGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("NetworkBorderGroup"))
    val PUBLICIPV4POOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PublicIpv4Pool"))
    val TAGSPECIFICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("TagSpecification"), FormUrlFlattened)
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("AllocateAddressRequest"))
        trait(QueryLiteral("Action", "AllocateAddress"))
        trait(QueryLiteral("Version", "2016-11-15"))
        field(ADDRESS_DESCRIPTOR)
        field(CUSTOMEROWNEDIPV4POOL_DESCRIPTOR)
        field(DOMAIN_DESCRIPTOR)
        field(DRYRUN_DESCRIPTOR)
        field(NETWORKBORDERGROUP_DESCRIPTOR)
        field(PUBLICIPV4POOL_DESCRIPTOR)
        field(TAGSPECIFICATIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.address?.let { field(ADDRESS_DESCRIPTOR, it) }
        input.customerOwnedIpv4Pool?.let { field(CUSTOMEROWNEDIPV4POOL_DESCRIPTOR, it) }
        input.domain?.let { field(DOMAIN_DESCRIPTOR, it.value) }
        input.dryRun?.let { field(DRYRUN_DESCRIPTOR, it) }
        input.networkBorderGroup?.let { field(NETWORKBORDERGROUP_DESCRIPTOR, it) }
        input.publicIpv4Pool?.let { field(PUBLICIPV4POOL_DESCRIPTOR, it) }
        if (input.tagSpecifications != null) {
            listField(TAGSPECIFICATIONS_DESCRIPTOR) {
                for (el0 in input.tagSpecifications) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagSpecificationDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
