// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.services.ec2.model.CopySnapshotRequest
import aws.sdk.kotlin.services.ec2.model.TagSpecification
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlFlattened
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CopySnapshotOperationSerializer: HttpSerialize<CopySnapshotRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CopySnapshotRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCopySnapshotOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeCopySnapshotOperationBody(context: ExecutionContext, input: CopySnapshotRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Description"))
    val DESTINATIONOUTPOSTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DestinationOutpostArn"))
    val DESTINATIONREGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DestinationRegion"))
    val DRYRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("DryRun"))
    val ENCRYPTED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("Encrypted"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("KmsKeyId"))
    val PRESIGNEDURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PresignedUrl"))
    val SOURCEREGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SourceRegion"))
    val SOURCESNAPSHOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SourceSnapshotId"))
    val TAGSPECIFICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("TagSpecification"), FormUrlFlattened)
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("CopySnapshotRequest"))
        trait(QueryLiteral("Action", "CopySnapshot"))
        trait(QueryLiteral("Version", "2016-11-15"))
        field(DESCRIPTION_DESCRIPTOR)
        field(DESTINATIONOUTPOSTARN_DESCRIPTOR)
        field(DESTINATIONREGION_DESCRIPTOR)
        field(DRYRUN_DESCRIPTOR)
        field(ENCRYPTED_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(PRESIGNEDURL_DESCRIPTOR)
        field(SOURCEREGION_DESCRIPTOR)
        field(SOURCESNAPSHOTID_DESCRIPTOR)
        field(TAGSPECIFICATIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.destinationOutpostArn?.let { field(DESTINATIONOUTPOSTARN_DESCRIPTOR, it) }
        input.destinationRegion?.let { field(DESTINATIONREGION_DESCRIPTOR, it) }
        input.dryRun?.let { field(DRYRUN_DESCRIPTOR, it) }
        input.encrypted?.let { field(ENCRYPTED_DESCRIPTOR, it) }
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        input.presignedUrl?.let { field(PRESIGNEDURL_DESCRIPTOR, it) }
        input.sourceRegion?.let { field(SOURCEREGION_DESCRIPTOR, it) }
        input.sourceSnapshotId?.let { field(SOURCESNAPSHOTID_DESCRIPTOR, it) }
        if (input.tagSpecifications != null) {
            listField(TAGSPECIFICATIONS_DESCRIPTOR) {
                for (el0 in input.tagSpecifications) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagSpecificationDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
