// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.services.ec2.model.ClientConnectOptions
import aws.sdk.kotlin.services.ec2.model.ClientLoginBannerOptions
import aws.sdk.kotlin.services.ec2.model.ClientVpnAuthenticationRequest
import aws.sdk.kotlin.services.ec2.model.ConnectionLogOptions
import aws.sdk.kotlin.services.ec2.model.CreateClientVpnEndpointRequest
import aws.sdk.kotlin.services.ec2.model.SelfServicePortal
import aws.sdk.kotlin.services.ec2.model.TagSpecification
import aws.sdk.kotlin.services.ec2.model.TransportProtocol
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlFlattened
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateClientVpnEndpointOperationSerializer: HttpSerialize<CreateClientVpnEndpointRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateClientVpnEndpointRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateClientVpnEndpointOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeCreateClientVpnEndpointOperationBody(context: ExecutionContext, input: CreateClientVpnEndpointRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val AUTHENTICATIONOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Authentication"), FormUrlFlattened)
    val CLIENTCIDRBLOCK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ClientCidrBlock"))
    val CLIENTCONNECTOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("ClientConnectOptions"))
    val CLIENTLOGINBANNEROPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("ClientLoginBannerOptions"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ClientToken"))
    val CONNECTIONLOGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("ConnectionLogOptions"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Description"))
    val DNSSERVERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("DnsServers"), FormUrlFlattened)
    val DRYRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("DryRun"))
    val SECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("SecurityGroupId"), FormUrlFlattened)
    val SELFSERVICEPORTAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SelfServicePortal"))
    val SERVERCERTIFICATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ServerCertificateArn"))
    val SESSIONTIMEOUTHOURS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("SessionTimeoutHours"))
    val SPLITTUNNEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("SplitTunnel"))
    val TAGSPECIFICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("TagSpecification"), FormUrlFlattened)
    val TRANSPORTPROTOCOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TransportProtocol"))
    val VPCID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("VpcId"))
    val VPNPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("VpnPort"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("CreateClientVpnEndpointRequest"))
        trait(QueryLiteral("Action", "CreateClientVpnEndpoint"))
        trait(QueryLiteral("Version", "2016-11-15"))
        field(AUTHENTICATIONOPTIONS_DESCRIPTOR)
        field(CLIENTCIDRBLOCK_DESCRIPTOR)
        field(CLIENTCONNECTOPTIONS_DESCRIPTOR)
        field(CLIENTLOGINBANNEROPTIONS_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CONNECTIONLOGOPTIONS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DNSSERVERS_DESCRIPTOR)
        field(DRYRUN_DESCRIPTOR)
        field(SECURITYGROUPIDS_DESCRIPTOR)
        field(SELFSERVICEPORTAL_DESCRIPTOR)
        field(SERVERCERTIFICATEARN_DESCRIPTOR)
        field(SESSIONTIMEOUTHOURS_DESCRIPTOR)
        field(SPLITTUNNEL_DESCRIPTOR)
        field(TAGSPECIFICATIONS_DESCRIPTOR)
        field(TRANSPORTPROTOCOL_DESCRIPTOR)
        field(VPCID_DESCRIPTOR)
        field(VPNPORT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.authenticationOptions != null) {
            listField(AUTHENTICATIONOPTIONS_DESCRIPTOR) {
                for (el0 in input.authenticationOptions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeClientVpnAuthenticationRequestDocument))
                }
            }
        }
        input.clientCidrBlock?.let { field(CLIENTCIDRBLOCK_DESCRIPTOR, it) }
        input.clientConnectOptions?.let { field(CLIENTCONNECTOPTIONS_DESCRIPTOR, it, ::serializeClientConnectOptionsDocument) }
        input.clientLoginBannerOptions?.let { field(CLIENTLOGINBANNEROPTIONS_DESCRIPTOR, it, ::serializeClientLoginBannerOptionsDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.connectionLogOptions?.let { field(CONNECTIONLOGOPTIONS_DESCRIPTOR, it, ::serializeConnectionLogOptionsDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.dnsServers != null) {
            listField(DNSSERVERS_DESCRIPTOR) {
                for (el0 in input.dnsServers) {
                    serializeString(el0)
                }
            }
        }
        input.dryRun?.let { field(DRYRUN_DESCRIPTOR, it) }
        if (input.securityGroupIds != null) {
            listField(SECURITYGROUPIDS_DESCRIPTOR) {
                for (el0 in input.securityGroupIds) {
                    serializeString(el0)
                }
            }
        }
        input.selfServicePortal?.let { field(SELFSERVICEPORTAL_DESCRIPTOR, it.value) }
        input.serverCertificateArn?.let { field(SERVERCERTIFICATEARN_DESCRIPTOR, it) }
        input.sessionTimeoutHours?.let { field(SESSIONTIMEOUTHOURS_DESCRIPTOR, it) }
        input.splitTunnel?.let { field(SPLITTUNNEL_DESCRIPTOR, it) }
        if (input.tagSpecifications != null) {
            listField(TAGSPECIFICATIONS_DESCRIPTOR) {
                for (el0 in input.tagSpecifications) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagSpecificationDocument))
                }
            }
        }
        input.transportProtocol?.let { field(TRANSPORTPROTOCOL_DESCRIPTOR, it.value) }
        input.vpcId?.let { field(VPCID_DESCRIPTOR, it) }
        input.vpnPort?.let { field(VPNPORT_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
