// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseEc2QueryErrorResponse
import aws.sdk.kotlin.services.ec2.model.DescribeSpotFleetRequestHistoryResponse
import aws.sdk.kotlin.services.ec2.model.Ec2Exception
import aws.sdk.kotlin.services.ec2.model.HistoryRecord
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeSpotFleetRequestHistoryOperationDeserializer: HttpDeserialize<DescribeSpotFleetRequestHistoryResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeSpotFleetRequestHistoryResponse {
        if (!response.status.isSuccess()) {
            throwDescribeSpotFleetRequestHistoryError(context, response)
        }
        val builder = DescribeSpotFleetRequestHistoryResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeSpotFleetRequestHistoryOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeSpotFleetRequestHistoryError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseEc2QueryErrorResponse(payload)
    } catch (ex: Exception) {
        throw Ec2Exception("Failed to parse response as 'ec2Query' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> Ec2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeSpotFleetRequestHistoryOperationBody(builder: DescribeSpotFleetRequestHistoryResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val HISTORYRECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("historyRecordSet"), XmlCollectionName("item"))
    val LASTEVALUATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("lastEvaluatedTime"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("nextToken"))
    val SPOTFLEETREQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("spotFleetRequestId"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("startTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://ec2.amazonaws.com/doc/2016-11-15"))
        trait(XmlSerialName("DescribeSpotFleetRequestHistoryResult"))
        field(HISTORYRECORDS_DESCRIPTOR)
        field(LASTEVALUATEDTIME_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SPOTFLEETREQUESTID_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HISTORYRECORDS_DESCRIPTOR.index -> builder.historyRecords =
                    deserializer.deserializeList(HISTORYRECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<HistoryRecord>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeHistoryRecordDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LASTEVALUATEDTIME_DESCRIPTOR.index -> builder.lastEvaluatedTime = deserializeString().let { Instant.fromIso8601(it) }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SPOTFLEETREQUESTID_DESCRIPTOR.index -> builder.spotFleetRequestId = deserializeString()
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromIso8601(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
