// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.services.ec2.model.DiskImage
import aws.sdk.kotlin.services.ec2.model.ImportInstanceLaunchSpecification
import aws.sdk.kotlin.services.ec2.model.ImportInstanceRequest
import aws.sdk.kotlin.services.ec2.model.PlatformValues
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlFlattened
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ImportInstanceOperationSerializer: HttpSerialize<ImportInstanceRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ImportInstanceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeImportInstanceOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeImportInstanceOperationBody(context: ExecutionContext, input: ImportInstanceRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Description"))
    val DISKIMAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("DiskImage"), FormUrlFlattened)
    val DRYRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("DryRun"))
    val LAUNCHSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("LaunchSpecification"))
    val PLATFORM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Platform"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("ImportInstanceRequest"))
        trait(QueryLiteral("Action", "ImportInstance"))
        trait(QueryLiteral("Version", "2016-11-15"))
        field(DESCRIPTION_DESCRIPTOR)
        field(DISKIMAGES_DESCRIPTOR)
        field(DRYRUN_DESCRIPTOR)
        field(LAUNCHSPECIFICATION_DESCRIPTOR)
        field(PLATFORM_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.diskImages != null) {
            listField(DISKIMAGES_DESCRIPTOR) {
                for (el0 in input.diskImages) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeDiskImageDocument))
                }
            }
        }
        input.dryRun?.let { field(DRYRUN_DESCRIPTOR, it) }
        input.launchSpecification?.let { field(LAUNCHSPECIFICATION_DESCRIPTOR, it, ::serializeImportInstanceLaunchSpecificationDocument) }
        input.platform?.let { field(PLATFORM_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
