// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.services.ec2.model.ReportInstanceReasonCodes
import aws.sdk.kotlin.services.ec2.model.ReportInstanceStatusRequest
import aws.sdk.kotlin.services.ec2.model.ReportStatusType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlFlattened
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ReportInstanceStatusOperationSerializer: HttpSerialize<ReportInstanceStatusRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ReportInstanceStatusRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeReportInstanceStatusOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeReportInstanceStatusOperationBody(context: ExecutionContext, input: ReportInstanceStatusRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Description"))
    val DRYRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("DryRun"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, FormUrlSerialName("EndTime"))
    val INSTANCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("InstanceId"), FormUrlFlattened)
    val REASONCODES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("ReasonCode"), FormUrlFlattened)
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, FormUrlSerialName("StartTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("ReportInstanceStatusRequest"))
        trait(QueryLiteral("Action", "ReportInstanceStatus"))
        trait(QueryLiteral("Version", "2016-11-15"))
        field(DESCRIPTION_DESCRIPTOR)
        field(DRYRUN_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(INSTANCES_DESCRIPTOR)
        field(REASONCODES_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.dryRun?.let { field(DRYRUN_DESCRIPTOR, it) }
        input.endTime?.let { field(ENDTIME_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        if (input.instances != null) {
            listField(INSTANCES_DESCRIPTOR) {
                for (el0 in input.instances) {
                    serializeString(el0)
                }
            }
        }
        if (input.reasonCodes != null) {
            listField(REASONCODES_DESCRIPTOR) {
                for (el0 in input.reasonCodes) {
                    serializeString(el0.value)
                }
            }
        }
        input.startTime?.let { field(STARTTIME_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        input.status?.let { field(STATUS_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
