// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.ec2.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.ec2.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>Amazon Elastic Compute Cloud</fullname>
 * Amazon Elastic Compute Cloud (Amazon EC2) provides secure and resizable computing capacity in the AWS Cloud.
 * Using Amazon EC2 eliminates the need to invest in hardware up front, so you can develop and deploy applications
 * faster. Amazon Virtual Private Cloud (Amazon VPC) enables you to provision a logically isolated section of the
 * AWS Cloud where you can launch AWS resources in a virtual network that you've defined. Amazon Elastic Block Store
 * (Amazon EBS) provides block level storage volumes for use with EC2 instances. EBS volumes are highly available
 * and reliable storage volumes that can be attached to any running instance and used like a hard drive.
 * To learn more, see the following resources:
 * Amazon EC2: <a href="http://aws.amazon.com/ec2">AmazonEC2 product page, <a href="http://aws.amazon.com/documentation/ec2">Amazon EC2 documentation
 * Amazon EBS: <a href="http://aws.amazon.com/ebs">Amazon EBS product page, <a href="http://aws.amazon.com/documentation/ebs">Amazon EBS documentation
 * Amazon VPC: <a href="http://aws.amazon.com/vpc">Amazon VPC product page, <a href="http://aws.amazon.com/documentation/vpc">Amazon VPC documentation
 * AWS VPN: <a href="http://aws.amazon.com/vpn">AWS VPN product page, <a href="http://aws.amazon.com/documentation/vpn">AWS VPN documentation
 */
interface Ec2Client : SdkClient {

    override val serviceName: String
        get() = "EC2"
    /**
     * Ec2Client's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): Ec2Client {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultEc2Client(config)
        }

        operator fun invoke(config: Config): Ec2Client = DefaultEc2Client(config)

        /**
         * Construct a [Ec2Client] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): Ec2Client {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return Ec2Client(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: AwsEndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder = apply { this.idempotencyTokenProvider = idempotencyTokenProvider }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Accepts the Convertible Reserved Instance exchange quote described in the GetReservedInstancesExchangeQuote call.
     */
    suspend fun acceptReservedInstancesExchangeQuote(input: AcceptReservedInstancesExchangeQuoteRequest): AcceptReservedInstancesExchangeQuoteResponse

    /**
     * Accepts the Convertible Reserved Instance exchange quote described in the GetReservedInstancesExchangeQuote call.
     */
    suspend fun acceptReservedInstancesExchangeQuote(block: AcceptReservedInstancesExchangeQuoteRequest.DslBuilder.() -> Unit) = acceptReservedInstancesExchangeQuote(AcceptReservedInstancesExchangeQuoteRequest.builder().apply(block).build())

    /**
     * Accepts a request to associate subnets with a transit gateway multicast domain.
     */
    suspend fun acceptTransitGatewayMulticastDomainAssociations(input: AcceptTransitGatewayMulticastDomainAssociationsRequest): AcceptTransitGatewayMulticastDomainAssociationsResponse

    /**
     * Accepts a request to associate subnets with a transit gateway multicast domain.
     */
    suspend fun acceptTransitGatewayMulticastDomainAssociations(block: AcceptTransitGatewayMulticastDomainAssociationsRequest.DslBuilder.() -> Unit) = acceptTransitGatewayMulticastDomainAssociations(AcceptTransitGatewayMulticastDomainAssociationsRequest.builder().apply(block).build())

    /**
     * Accepts a transit gateway peering attachment request. The peering attachment must be
     * in the pendingAcceptance state.
     */
    suspend fun acceptTransitGatewayPeeringAttachment(input: AcceptTransitGatewayPeeringAttachmentRequest): AcceptTransitGatewayPeeringAttachmentResponse

    /**
     * Accepts a transit gateway peering attachment request. The peering attachment must be
     * in the pendingAcceptance state.
     */
    suspend fun acceptTransitGatewayPeeringAttachment(block: AcceptTransitGatewayPeeringAttachmentRequest.DslBuilder.() -> Unit) = acceptTransitGatewayPeeringAttachment(AcceptTransitGatewayPeeringAttachmentRequest.builder().apply(block).build())

    /**
     * Accepts a request to attach a VPC to a transit gateway.
     * The VPC attachment must be in the pendingAcceptance state.
     * Use DescribeTransitGatewayVpcAttachments to view your pending VPC attachment requests.
     * Use RejectTransitGatewayVpcAttachment to reject a VPC attachment request.
     */
    suspend fun acceptTransitGatewayVpcAttachment(input: AcceptTransitGatewayVpcAttachmentRequest): AcceptTransitGatewayVpcAttachmentResponse

    /**
     * Accepts a request to attach a VPC to a transit gateway.
     * The VPC attachment must be in the pendingAcceptance state.
     * Use DescribeTransitGatewayVpcAttachments to view your pending VPC attachment requests.
     * Use RejectTransitGatewayVpcAttachment to reject a VPC attachment request.
     */
    suspend fun acceptTransitGatewayVpcAttachment(block: AcceptTransitGatewayVpcAttachmentRequest.DslBuilder.() -> Unit) = acceptTransitGatewayVpcAttachment(AcceptTransitGatewayVpcAttachmentRequest.builder().apply(block).build())

    /**
     * Accepts one or more interface VPC endpoint connection requests to your VPC endpoint
     * service.
     */
    suspend fun acceptVpcEndpointConnections(input: AcceptVpcEndpointConnectionsRequest): AcceptVpcEndpointConnectionsResponse

    /**
     * Accepts one or more interface VPC endpoint connection requests to your VPC endpoint
     * service.
     */
    suspend fun acceptVpcEndpointConnections(block: AcceptVpcEndpointConnectionsRequest.DslBuilder.() -> Unit) = acceptVpcEndpointConnections(AcceptVpcEndpointConnectionsRequest.builder().apply(block).build())

    /**
     * Accept a VPC peering connection request. To accept a request, the VPC peering connection must
     * be in the pending-acceptance state, and you must be the owner of the peer VPC.
     * Use DescribeVpcPeeringConnections to view your outstanding VPC
     * peering connection requests.
     * For an inter-Region VPC peering connection request, you must accept the VPC peering
     * connection in the Region of the accepter VPC.
     */
    suspend fun acceptVpcPeeringConnection(input: AcceptVpcPeeringConnectionRequest): AcceptVpcPeeringConnectionResponse

    /**
     * Accept a VPC peering connection request. To accept a request, the VPC peering connection must
     * be in the pending-acceptance state, and you must be the owner of the peer VPC.
     * Use DescribeVpcPeeringConnections to view your outstanding VPC
     * peering connection requests.
     * For an inter-Region VPC peering connection request, you must accept the VPC peering
     * connection in the Region of the accepter VPC.
     */
    suspend fun acceptVpcPeeringConnection(block: AcceptVpcPeeringConnectionRequest.DslBuilder.() -> Unit) = acceptVpcPeeringConnection(AcceptVpcPeeringConnectionRequest.builder().apply(block).build())

    /**
     * Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP).
     * You can perform this operation at most once every 10 seconds, even if you specify different
     * address ranges each time.
     * We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise
     * it from Amazon Web Services. To minimize down time, you can configure your Amazon Web Services resources to use an address from a
     * BYOIP CIDR before it is advertised, and then simultaneously stop advertising it from the current
     * location and start advertising it through Amazon Web Services.
     * It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services
     * because of BGP propagation delays.
     * To stop advertising the BYOIP CIDR, use WithdrawByoipCidr.
     */
    suspend fun advertiseByoipCidr(input: AdvertiseByoipCidrRequest): AdvertiseByoipCidrResponse

    /**
     * Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP).
     * You can perform this operation at most once every 10 seconds, even if you specify different
     * address ranges each time.
     * We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise
     * it from Amazon Web Services. To minimize down time, you can configure your Amazon Web Services resources to use an address from a
     * BYOIP CIDR before it is advertised, and then simultaneously stop advertising it from the current
     * location and start advertising it through Amazon Web Services.
     * It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services
     * because of BGP propagation delays.
     * To stop advertising the BYOIP CIDR, use WithdrawByoipCidr.
     */
    suspend fun advertiseByoipCidr(block: AdvertiseByoipCidrRequest.DslBuilder.() -> Unit) = advertiseByoipCidr(AdvertiseByoipCidrRequest.builder().apply(block).build())

    /**
     * Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address you can associate
     * it with an instance or network interface. After you release an Elastic IP address, it is released to the IP address
     * pool and can be allocated to a different Amazon Web Services account.
     * You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool created
     * from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon Web Services resources using bring your own
     * IP addresses (BYOIP). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP) in the Amazon Elastic Compute Cloud User Guide.
     * &#91;EC2-VPC&#93; If you release an Elastic IP address, you might be able to recover it. You cannot recover an
     * Elastic IP address that you released after it is allocated to another Amazon Web Services account. You cannot recover an Elastic IP
     * address for EC2-Classic. To attempt to recover an Elastic IP address that you released, specify it in this operation.
     * An Elastic IP address is for use either in the EC2-Classic platform or in a VPC. By default, you can allocate
     * 5 Elastic IP addresses for EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per Region.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.
     * You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance).
     */
    suspend fun allocateAddress(input: AllocateAddressRequest): AllocateAddressResponse

    /**
     * Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address you can associate
     * it with an instance or network interface. After you release an Elastic IP address, it is released to the IP address
     * pool and can be allocated to a different Amazon Web Services account.
     * You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool created
     * from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon Web Services resources using bring your own
     * IP addresses (BYOIP). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP) in the Amazon Elastic Compute Cloud User Guide.
     * &#91;EC2-VPC&#93; If you release an Elastic IP address, you might be able to recover it. You cannot recover an
     * Elastic IP address that you released after it is allocated to another Amazon Web Services account. You cannot recover an Elastic IP
     * address for EC2-Classic. To attempt to recover an Elastic IP address that you released, specify it in this operation.
     * An Elastic IP address is for use either in the EC2-Classic platform or in a VPC. By default, you can allocate
     * 5 Elastic IP addresses for EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per Region.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.
     * You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance).
     */
    suspend fun allocateAddress(block: AllocateAddressRequest.DslBuilder.() -> Unit) = allocateAddress(AllocateAddressRequest.builder().apply(block).build())

    /**
     * Allocates a Dedicated Host to your account. At a minimum, specify the supported instance
     * type or instance family, the Availability Zone in which to allocate the host, and the number of
     * hosts to allocate.
     */
    suspend fun allocateHosts(input: AllocateHostsRequest): AllocateHostsResponse

    /**
     * Allocates a Dedicated Host to your account. At a minimum, specify the supported instance
     * type or instance family, the Availability Zone in which to allocate the host, and the number of
     * hosts to allocate.
     */
    suspend fun allocateHosts(block: AllocateHostsRequest.DslBuilder.() -> Unit) = allocateHosts(AllocateHostsRequest.builder().apply(block).build())

    /**
     * Applies a security group to the association between the target network and the Client VPN endpoint. This action replaces the existing
     * security groups with the specified security groups.
     */
    suspend fun applySecurityGroupsToClientVpnTargetNetwork(input: ApplySecurityGroupsToClientVpnTargetNetworkRequest): ApplySecurityGroupsToClientVpnTargetNetworkResponse

    /**
     * Applies a security group to the association between the target network and the Client VPN endpoint. This action replaces the existing
     * security groups with the specified security groups.
     */
    suspend fun applySecurityGroupsToClientVpnTargetNetwork(block: ApplySecurityGroupsToClientVpnTargetNetworkRequest.DslBuilder.() -> Unit) = applySecurityGroupsToClientVpnTargetNetwork(ApplySecurityGroupsToClientVpnTargetNetworkRequest.builder().apply(block).build())

    /**
     * Assigns one or more IPv6 addresses to the specified network interface. You can
     * specify one or more specific IPv6 addresses, or you can specify the number of IPv6
     * addresses to be automatically assigned from within the subnet's IPv6 CIDR block range.
     * You can assign as many IPv6 addresses to a network interface as you can assign private
     * IPv4 addresses, and the limit varies per instance type. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per Network Interface Per Instance Type
     * in the Amazon Elastic Compute Cloud User Guide.
     * You must specify either the IPv6 addresses or the IPv6 address count in the request.
     * You can optionally use Prefix Delegation on the network interface. You must specify
     * either the IPV6 Prefix Delegation prefixes, or the IPv6 Prefix Delegation count. For
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html">
     * Assigning prefixes to Amazon EC2 network interfaces in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun assignIpv6Addresses(input: AssignIpv6AddressesRequest): AssignIpv6AddressesResponse

    /**
     * Assigns one or more IPv6 addresses to the specified network interface. You can
     * specify one or more specific IPv6 addresses, or you can specify the number of IPv6
     * addresses to be automatically assigned from within the subnet's IPv6 CIDR block range.
     * You can assign as many IPv6 addresses to a network interface as you can assign private
     * IPv4 addresses, and the limit varies per instance type. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per Network Interface Per Instance Type
     * in the Amazon Elastic Compute Cloud User Guide.
     * You must specify either the IPv6 addresses or the IPv6 address count in the request.
     * You can optionally use Prefix Delegation on the network interface. You must specify
     * either the IPV6 Prefix Delegation prefixes, or the IPv6 Prefix Delegation count. For
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html">
     * Assigning prefixes to Amazon EC2 network interfaces in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun assignIpv6Addresses(block: AssignIpv6AddressesRequest.DslBuilder.() -> Unit) = assignIpv6Addresses(AssignIpv6AddressesRequest.builder().apply(block).build())

    /**
     * Assigns one or more secondary private IP addresses to the specified network interface.
     * You can specify one or more specific secondary IP addresses, or you can specify the number
     * of secondary IP addresses to be automatically assigned within the subnet's CIDR block range.
     * The number of secondary IP addresses that you can assign to an instance varies by instance type.
     * For information about instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types in the Amazon Elastic Compute Cloud User Guide. For more information about
     * Elastic IP addresses, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.
     * When you move a secondary private IP address to another network interface, any Elastic IP address
     * that is associated with the IP address is also moved.
     * Remapping an IP address is an asynchronous operation. When you move an IP address from one network
     * interface to another, check network/interfaces/macs/mac/local-ipv4s in the instance
     * metadata to confirm that the remapping is complete.
     * You must specify either the IP addresses or the IP address count in the request.
     * You can optionally use Prefix Delegation on the network interface. You must specify
     * either the IPv4 Prefix Delegation prefixes, or the IPv4 Prefix Delegation count. For
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html">
     * Assigning prefixes to Amazon EC2 network interfaces in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun assignPrivateIpAddresses(input: AssignPrivateIpAddressesRequest): AssignPrivateIpAddressesResponse

    /**
     * Assigns one or more secondary private IP addresses to the specified network interface.
     * You can specify one or more specific secondary IP addresses, or you can specify the number
     * of secondary IP addresses to be automatically assigned within the subnet's CIDR block range.
     * The number of secondary IP addresses that you can assign to an instance varies by instance type.
     * For information about instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types in the Amazon Elastic Compute Cloud User Guide. For more information about
     * Elastic IP addresses, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.
     * When you move a secondary private IP address to another network interface, any Elastic IP address
     * that is associated with the IP address is also moved.
     * Remapping an IP address is an asynchronous operation. When you move an IP address from one network
     * interface to another, check network/interfaces/macs/mac/local-ipv4s in the instance
     * metadata to confirm that the remapping is complete.
     * You must specify either the IP addresses or the IP address count in the request.
     * You can optionally use Prefix Delegation on the network interface. You must specify
     * either the IPv4 Prefix Delegation prefixes, or the IPv4 Prefix Delegation count. For
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html">
     * Assigning prefixes to Amazon EC2 network interfaces in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun assignPrivateIpAddresses(block: AssignPrivateIpAddressesRequest.DslBuilder.() -> Unit) = assignPrivateIpAddresses(AssignPrivateIpAddressesRequest.builder().apply(block).build())

    /**
     * Associates an Elastic IP address, or carrier IP address (for instances that are in
     * subnets in Wavelength Zones) with an instance or a network interface. Before you can use an
     * Elastic IP address, you must allocate it to your account.
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.
     * &#91;EC2-Classic, VPC in an EC2-VPC-only account&#93; If the Elastic IP address is already
     * associated with a different instance, it is disassociated from that instance and associated
     * with the specified instance. If you associate an Elastic IP address with an instance that has
     * an existing Elastic IP address, the existing address is disassociated from the instance, but
     * remains allocated to your account.
     * &#91;VPC in an EC2-Classic account&#93; If you don't specify a private IP address, the Elastic
     * IP address is associated with the primary IP address. If the Elastic IP address is already
     * associated with a different instance or a network interface, you get an error unless you allow
     * reassociation. You cannot associate an Elastic IP address with an instance or network
     * interface that has an existing Elastic IP address.
     * &#91;Subnets in Wavelength Zones&#93; You can associate an IP address from the telecommunication
     * carrier to the instance or network interface.
     * You cannot associate an Elastic IP address with an interface in a different network border group.
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2
     * doesn't return an error, and you may be charged for each time the Elastic IP address is
     * remapped to the same instance. For more information, see the Elastic IP
     * Addresses section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon EC2
     * Pricing.
     */
    suspend fun associateAddress(input: AssociateAddressRequest): AssociateAddressResponse

    /**
     * Associates an Elastic IP address, or carrier IP address (for instances that are in
     * subnets in Wavelength Zones) with an instance or a network interface. Before you can use an
     * Elastic IP address, you must allocate it to your account.
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.
     * &#91;EC2-Classic, VPC in an EC2-VPC-only account&#93; If the Elastic IP address is already
     * associated with a different instance, it is disassociated from that instance and associated
     * with the specified instance. If you associate an Elastic IP address with an instance that has
     * an existing Elastic IP address, the existing address is disassociated from the instance, but
     * remains allocated to your account.
     * &#91;VPC in an EC2-Classic account&#93; If you don't specify a private IP address, the Elastic
     * IP address is associated with the primary IP address. If the Elastic IP address is already
     * associated with a different instance or a network interface, you get an error unless you allow
     * reassociation. You cannot associate an Elastic IP address with an instance or network
     * interface that has an existing Elastic IP address.
     * &#91;Subnets in Wavelength Zones&#93; You can associate an IP address from the telecommunication
     * carrier to the instance or network interface.
     * You cannot associate an Elastic IP address with an interface in a different network border group.
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2
     * doesn't return an error, and you may be charged for each time the Elastic IP address is
     * remapped to the same instance. For more information, see the Elastic IP
     * Addresses section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon EC2
     * Pricing.
     */
    suspend fun associateAddress(block: AssociateAddressRequest.DslBuilder.() -> Unit) = associateAddress(AssociateAddressRequest.builder().apply(block).build())

    /**
     * Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy.
     * If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the specified subnet must be in the same VPC. To specify a subnet that's in a different VPC, you must first modify the Client VPN endpoint (ModifyClientVpnEndpoint) and change the VPC that's associated with it.
     */
    suspend fun associateClientVpnTargetNetwork(input: AssociateClientVpnTargetNetworkRequest): AssociateClientVpnTargetNetworkResponse

    /**
     * Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy.
     * If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the specified subnet must be in the same VPC. To specify a subnet that's in a different VPC, you must first modify the Client VPN endpoint (ModifyClientVpnEndpoint) and change the VPC that's associated with it.
     */
    suspend fun associateClientVpnTargetNetwork(block: AssociateClientVpnTargetNetworkRequest.DslBuilder.() -> Unit) = associateClientVpnTargetNetwork(AssociateClientVpnTargetNetworkRequest.builder().apply(block).build())

    /**
     * Associates a set of DHCP options (that you've previously created) with the specified VPC, or associates no DHCP options with the VPC.
     * After you associate the options with the VPC, any existing instances and all new instances that you launch in that VPC use the options. You don't need to restart or relaunch the instances. They automatically pick up the changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly renew the lease using the operating system on the instance.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets
     * in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun associateDhcpOptions(input: AssociateDhcpOptionsRequest): AssociateDhcpOptionsResponse

    /**
     * Associates a set of DHCP options (that you've previously created) with the specified VPC, or associates no DHCP options with the VPC.
     * After you associate the options with the VPC, any existing instances and all new instances that you launch in that VPC use the options. You don't need to restart or relaunch the instances. They automatically pick up the changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly renew the lease using the operating system on the instance.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets
     * in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun associateDhcpOptions(block: AssociateDhcpOptionsRequest.DslBuilder.() -> Unit) = associateDhcpOptions(AssociateDhcpOptionsRequest.builder().apply(block).build())

    /**
     * Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate.
     * This enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more
     * information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html">Certificate Manager for Nitro Enclaves in the Amazon Web Services Nitro Enclaves
     * User Guide.
     * When the IAM role is associated with the ACM certificate, the certificate, certificate chain, and encrypted
     * private key are placed in an Amazon S3 bucket that only the associated IAM role can access. The private key of the certificate
     * is encrypted with an Amazon Web Services managed key that has an attached attestation-based key policy.
     * To enable the IAM role to access the Amazon S3 object, you must grant it permission to call s3:GetObject
     * on the Amazon S3 bucket returned by the command. To enable the IAM role to access the KMS key,
     * you must grant it permission to call kms:Decrypt on the KMS key returned by the command.
     * For more information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy">
     * Grant the role permission to access the certificate and encryption key in the
     * Amazon Web Services Nitro Enclaves User Guide.
     */
    suspend fun associateEnclaveCertificateIamRole(input: AssociateEnclaveCertificateIamRoleRequest): AssociateEnclaveCertificateIamRoleResponse

    /**
     * Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate.
     * This enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more
     * information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html">Certificate Manager for Nitro Enclaves in the Amazon Web Services Nitro Enclaves
     * User Guide.
     * When the IAM role is associated with the ACM certificate, the certificate, certificate chain, and encrypted
     * private key are placed in an Amazon S3 bucket that only the associated IAM role can access. The private key of the certificate
     * is encrypted with an Amazon Web Services managed key that has an attached attestation-based key policy.
     * To enable the IAM role to access the Amazon S3 object, you must grant it permission to call s3:GetObject
     * on the Amazon S3 bucket returned by the command. To enable the IAM role to access the KMS key,
     * you must grant it permission to call kms:Decrypt on the KMS key returned by the command.
     * For more information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy">
     * Grant the role permission to access the certificate and encryption key in the
     * Amazon Web Services Nitro Enclaves User Guide.
     */
    suspend fun associateEnclaveCertificateIamRole(block: AssociateEnclaveCertificateIamRoleRequest.DslBuilder.() -> Unit) = associateEnclaveCertificateIamRole(AssociateEnclaveCertificateIamRoleRequest.builder().apply(block).build())

    /**
     * Associates an IAM instance profile with a running or stopped instance. You cannot
     * associate more than one IAM instance profile with an instance.
     */
    suspend fun associateIamInstanceProfile(input: AssociateIamInstanceProfileRequest): AssociateIamInstanceProfileResponse

    /**
     * Associates an IAM instance profile with a running or stopped instance. You cannot
     * associate more than one IAM instance profile with an instance.
     */
    suspend fun associateIamInstanceProfile(block: AssociateIamInstanceProfileRequest.DslBuilder.() -> Unit) = associateIamInstanceProfile(AssociateIamInstanceProfileRequest.builder().apply(block).build())

    /**
     * Associates one or more targets with an event window. Only one type of target (instance IDs,
     * Dedicated Host IDs, or tags) can be specified with an event window.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    suspend fun associateInstanceEventWindow(input: AssociateInstanceEventWindowRequest): AssociateInstanceEventWindowResponse

    /**
     * Associates one or more targets with an event window. Only one type of target (instance IDs,
     * Dedicated Host IDs, or tags) can be specified with an event window.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    suspend fun associateInstanceEventWindow(block: AssociateInstanceEventWindowRequest.DslBuilder.() -> Unit) = associateInstanceEventWindow(AssociateInstanceEventWindowRequest.builder().apply(block).build())

    /**
     * Associates a subnet in your VPC or an internet gateway or virtual private gateway
     * attached to your VPC with a route table in your VPC. This association causes traffic
     * from the subnet or gateway to be routed according to the routes in the route table. The
     * action returns an association ID, which you need in order to disassociate the route
     * table later. A route table can be associated with multiple subnets.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun associateRouteTable(input: AssociateRouteTableRequest): AssociateRouteTableResponse

    /**
     * Associates a subnet in your VPC or an internet gateway or virtual private gateway
     * attached to your VPC with a route table in your VPC. This association causes traffic
     * from the subnet or gateway to be routed according to the routes in the route table. The
     * action returns an association ID, which you need in order to disassociate the route
     * table later. A route table can be associated with multiple subnets.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun associateRouteTable(block: AssociateRouteTableRequest.DslBuilder.() -> Unit) = associateRouteTable(AssociateRouteTableRequest.builder().apply(block).build())

    /**
     * Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR
     * block with your subnet. An IPv6 CIDR block must have a prefix length of /64.
     */
    suspend fun associateSubnetCidrBlock(input: AssociateSubnetCidrBlockRequest): AssociateSubnetCidrBlockResponse

    /**
     * Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR
     * block with your subnet. An IPv6 CIDR block must have a prefix length of /64.
     */
    suspend fun associateSubnetCidrBlock(block: AssociateSubnetCidrBlockRequest.DslBuilder.() -> Unit) = associateSubnetCidrBlock(AssociateSubnetCidrBlockRequest.builder().apply(block).build())

    /**
     * Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast domain.
     * The transit gateway attachment must be in the available state before you can add a resource. Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html">DescribeTransitGatewayAttachments
     * to see the state of the attachment.
     */
    suspend fun associateTransitGatewayMulticastDomain(input: AssociateTransitGatewayMulticastDomainRequest): AssociateTransitGatewayMulticastDomainResponse

    /**
     * Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast domain.
     * The transit gateway attachment must be in the available state before you can add a resource. Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html">DescribeTransitGatewayAttachments
     * to see the state of the attachment.
     */
    suspend fun associateTransitGatewayMulticastDomain(block: AssociateTransitGatewayMulticastDomainRequest.DslBuilder.() -> Unit) = associateTransitGatewayMulticastDomain(AssociateTransitGatewayMulticastDomainRequest.builder().apply(block).build())

    /**
     * Associates the specified attachment with the specified transit gateway route table. You can
     * associate only one route table with an attachment.
     */
    suspend fun associateTransitGatewayRouteTable(input: AssociateTransitGatewayRouteTableRequest): AssociateTransitGatewayRouteTableResponse

    /**
     * Associates the specified attachment with the specified transit gateway route table. You can
     * associate only one route table with an attachment.
     */
    suspend fun associateTransitGatewayRouteTable(block: AssociateTransitGatewayRouteTableRequest.DslBuilder.() -> Unit) = associateTransitGatewayRouteTable(AssociateTransitGatewayRouteTableRequest.builder().apply(block).build())

    /**
     * This API action is currently in limited preview only.
     * If you are interested in using this feature, contact your account manager.
     * Associates a branch network interface with a trunk network interface.
     * Before you create the association, run the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html">create-network-interface command and set
     * --interface-type to trunk. You must also create a network interface for each branch network interface that you want to associate with the trunk network interface.
     */
    suspend fun associateTrunkInterface(input: AssociateTrunkInterfaceRequest): AssociateTrunkInterfaceResponse

    /**
     * This API action is currently in limited preview only.
     * If you are interested in using this feature, contact your account manager.
     * Associates a branch network interface with a trunk network interface.
     * Before you create the association, run the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html">create-network-interface command and set
     * --interface-type to trunk. You must also create a network interface for each branch network interface that you want to associate with the trunk network interface.
     */
    suspend fun associateTrunkInterface(block: AssociateTrunkInterfaceRequest.DslBuilder.() -> Unit) = associateTrunkInterface(AssociateTrunkInterfaceRequest.builder().apply(block).build())

    /**
     * Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block,
     * an Amazon-provided IPv6 CIDR block, or an IPv6 CIDR block from an IPv6 address pool that
     * you provisioned through bring your own IP addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP). The IPv6 CIDR block size is fixed
     * at /56.
     * You must specify one of the following in the request: an IPv4 CIDR block, an IPv6
     * pool, or an Amazon-provided IPv6 CIDR block.
     * For more information about associating CIDR blocks with your VPC and applicable
     * restrictions, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#VPC_Sizing">VPC and subnet sizing in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun associateVpcCidrBlock(input: AssociateVpcCidrBlockRequest): AssociateVpcCidrBlockResponse

    /**
     * Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block,
     * an Amazon-provided IPv6 CIDR block, or an IPv6 CIDR block from an IPv6 address pool that
     * you provisioned through bring your own IP addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP). The IPv6 CIDR block size is fixed
     * at /56.
     * You must specify one of the following in the request: an IPv4 CIDR block, an IPv6
     * pool, or an Amazon-provided IPv6 CIDR block.
     * For more information about associating CIDR blocks with your VPC and applicable
     * restrictions, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#VPC_Sizing">VPC and subnet sizing in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun associateVpcCidrBlock(block: AssociateVpcCidrBlockRequest.DslBuilder.() -> Unit) = associateVpcCidrBlock(AssociateVpcCidrBlockRequest.builder().apply(block).build())

    /**
     * Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC's
     * security groups. You cannot link an EC2-Classic instance to more than one VPC at a time. You
     * can only link an instance that's in the running state. An instance is
     * automatically unlinked from a VPC when it's stopped - you can link it to the VPC again when
     * you restart it.
     * After you've linked an instance, you cannot change the VPC security groups that are associated with it. To change the security groups, you must first unlink the instance, and then link it again.
     * Linking your instance to a VPC is sometimes referred to as attaching your instance.
     */
    suspend fun attachClassicLinkVpc(input: AttachClassicLinkVpcRequest): AttachClassicLinkVpcResponse

    /**
     * Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC's
     * security groups. You cannot link an EC2-Classic instance to more than one VPC at a time. You
     * can only link an instance that's in the running state. An instance is
     * automatically unlinked from a VPC when it's stopped - you can link it to the VPC again when
     * you restart it.
     * After you've linked an instance, you cannot change the VPC security groups that are associated with it. To change the security groups, you must first unlink the instance, and then link it again.
     * Linking your instance to a VPC is sometimes referred to as attaching your instance.
     */
    suspend fun attachClassicLinkVpc(block: AttachClassicLinkVpcRequest.DslBuilder.() -> Unit) = attachClassicLinkVpc(AttachClassicLinkVpcRequest.builder().apply(block).build())

    /**
     * Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet and
     * the VPC. For more information about your VPC and internet gateway, see the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon Virtual Private Cloud User Guide.
     */
    suspend fun attachInternetGateway(input: AttachInternetGatewayRequest): AttachInternetGatewayResponse

    /**
     * Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet and
     * the VPC. For more information about your VPC and internet gateway, see the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon Virtual Private Cloud User Guide.
     */
    suspend fun attachInternetGateway(block: AttachInternetGatewayRequest.DslBuilder.() -> Unit) = attachInternetGateway(AttachInternetGatewayRequest.builder().apply(block).build())

    /**
     * Attaches a network interface to an instance.
     */
    suspend fun attachNetworkInterface(input: AttachNetworkInterfaceRequest): AttachNetworkInterfaceResponse

    /**
     * Attaches a network interface to an instance.
     */
    suspend fun attachNetworkInterface(block: AttachNetworkInterfaceRequest.DslBuilder.() -> Unit) = attachNetworkInterface(AttachNetworkInterfaceRequest.builder().apply(block).build())

    /**
     * Attaches an EBS volume to a running or stopped instance and exposes it to the instance
     * with the specified device name.
     * Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
     * After you attach an EBS volume, you must make it available. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-using-volumes.html">Make an EBS volume available for use.
     * If a volume has an Amazon Web Services Marketplace product code:
     * The volume can be attached only to a stopped instance.
     * Amazon Web Services Marketplace product codes are copied from the volume to the instance.
     * You must be subscribed to the product.
     * The instance type and operating system of the instance must support the product. For
     * example, you can't detach a volume from a Windows instance and attach it to a Linux
     * instance.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html">Attach an Amazon EBS volume to an instance in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun attachVolume(input: AttachVolumeRequest): AttachVolumeResponse

    /**
     * Attaches an EBS volume to a running or stopped instance and exposes it to the instance
     * with the specified device name.
     * Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
     * After you attach an EBS volume, you must make it available. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-using-volumes.html">Make an EBS volume available for use.
     * If a volume has an Amazon Web Services Marketplace product code:
     * The volume can be attached only to a stopped instance.
     * Amazon Web Services Marketplace product codes are copied from the volume to the instance.
     * You must be subscribed to the product.
     * The instance type and operating system of the instance must support the product. For
     * example, you can't detach a volume from a Windows instance and attach it to a Linux
     * instance.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html">Attach an Amazon EBS volume to an instance in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun attachVolume(block: AttachVolumeRequest.DslBuilder.() -> Unit) = attachVolume(AttachVolumeRequest.builder().apply(block).build())

    /**
     * Attaches a virtual private gateway to a VPC. You can attach one virtual private
     * gateway to one VPC at a time.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    suspend fun attachVpnGateway(input: AttachVpnGatewayRequest): AttachVpnGatewayResponse

    /**
     * Attaches a virtual private gateway to a VPC. You can attach one virtual private
     * gateway to one VPC at a time.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    suspend fun attachVpnGateway(block: AttachVpnGatewayRequest.DslBuilder.() -> Unit) = attachVpnGateway(AttachVpnGatewayRequest.builder().apply(block).build())

    /**
     * Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as
     * firewall rules that grant access to networks. You must configure ingress authorization rules to
     * enable clients to access resources in Amazon Web Services or on-premises networks.
     */
    suspend fun authorizeClientVpnIngress(input: AuthorizeClientVpnIngressRequest): AuthorizeClientVpnIngressResponse

    /**
     * Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as
     * firewall rules that grant access to networks. You must configure ingress authorization rules to
     * enable clients to access resources in Amazon Web Services or on-premises networks.
     */
    suspend fun authorizeClientVpnIngress(block: AuthorizeClientVpnIngressRequest.DslBuilder.() -> Unit) = authorizeClientVpnIngress(AuthorizeClientVpnIngressRequest.builder().apply(block).build())

    /**
     * &#91;VPC only&#93; Adds the specified outbound (egress) rules to a security group for use with a VPC.
     * An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 CIDR address
     * ranges, or to the instances that are associated with the specified destination security groups.
     * You specify a protocol for each rule (for example, TCP).
     * For the TCP and UDP protocols, you must also specify the destination port or port range.
     * For the ICMP protocol, you must also specify the ICMP type and code.
     * You can use -1 for the type or code to mean all types or all codes.
     * Rule changes are propagated to affected instances as quickly as possible. However, a small delay might occur.
     * For information about VPC security group quotas, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas.
     */
    suspend fun authorizeSecurityGroupEgress(input: AuthorizeSecurityGroupEgressRequest): AuthorizeSecurityGroupEgressResponse

    /**
     * &#91;VPC only&#93; Adds the specified outbound (egress) rules to a security group for use with a VPC.
     * An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 CIDR address
     * ranges, or to the instances that are associated with the specified destination security groups.
     * You specify a protocol for each rule (for example, TCP).
     * For the TCP and UDP protocols, you must also specify the destination port or port range.
     * For the ICMP protocol, you must also specify the ICMP type and code.
     * You can use -1 for the type or code to mean all types or all codes.
     * Rule changes are propagated to affected instances as quickly as possible. However, a small delay might occur.
     * For information about VPC security group quotas, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas.
     */
    suspend fun authorizeSecurityGroupEgress(block: AuthorizeSecurityGroupEgressRequest.DslBuilder.() -> Unit) = authorizeSecurityGroupEgress(AuthorizeSecurityGroupEgressRequest.builder().apply(block).build())

    /**
     * Adds the specified inbound (ingress) rules to a security group.
     * An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 CIDR
     * address range, or from the instances that are associated with the specified destination security
     * groups.
     * You specify a protocol for each rule (for example, TCP).
     * For TCP and UDP, you must also specify the destination port or port range.
     * For ICMP/ICMPv6, you must also specify the ICMP/ICMPv6 type and code.
     * You can use -1 to mean all types or all codes.
     * Rule changes are propagated to instances within the security group as quickly as possible.
     * However, a small delay might occur.
     * For more information about VPC security group quotas, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas.
     */
    suspend fun authorizeSecurityGroupIngress(input: AuthorizeSecurityGroupIngressRequest): AuthorizeSecurityGroupIngressResponse

    /**
     * Adds the specified inbound (ingress) rules to a security group.
     * An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 CIDR
     * address range, or from the instances that are associated with the specified destination security
     * groups.
     * You specify a protocol for each rule (for example, TCP).
     * For TCP and UDP, you must also specify the destination port or port range.
     * For ICMP/ICMPv6, you must also specify the ICMP/ICMPv6 type and code.
     * You can use -1 to mean all types or all codes.
     * Rule changes are propagated to instances within the security group as quickly as possible.
     * However, a small delay might occur.
     * For more information about VPC security group quotas, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas.
     */
    suspend fun authorizeSecurityGroupIngress(block: AuthorizeSecurityGroupIngressRequest.DslBuilder.() -> Unit) = authorizeSecurityGroupIngress(AuthorizeSecurityGroupIngressRequest.builder().apply(block).build())

    /**
     * Bundles an Amazon instance store-backed Windows instance.
     * During bundling, only the root device volume (C:\) is bundled. Data on other instance store volumes is not preserved.
     * This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS.
     */
    suspend fun bundleInstance(input: BundleInstanceRequest): BundleInstanceResponse

    /**
     * Bundles an Amazon instance store-backed Windows instance.
     * During bundling, only the root device volume (C:\) is bundled. Data on other instance store volumes is not preserved.
     * This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS.
     */
    suspend fun bundleInstance(block: BundleInstanceRequest.DslBuilder.() -> Unit) = bundleInstance(BundleInstanceRequest.builder().apply(block).build())

    /**
     * Cancels a bundling operation for an instance store-backed Windows instance.
     */
    suspend fun cancelBundleTask(input: CancelBundleTaskRequest): CancelBundleTaskResponse

    /**
     * Cancels a bundling operation for an instance store-backed Windows instance.
     */
    suspend fun cancelBundleTask(block: CancelBundleTaskRequest.DslBuilder.() -> Unit) = cancelBundleTask(CancelBundleTaskRequest.builder().apply(block).build())

    /**
     * Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity Reservation's state to
     * cancelled.
     * Instances running in the reserved capacity continue running until you stop them. Stopped
     * instances that target the Capacity Reservation can no longer launch. Modify these instances to either
     * target a different Capacity Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation
     * that has matching attributes and sufficient capacity.
     */
    suspend fun cancelCapacityReservation(input: CancelCapacityReservationRequest): CancelCapacityReservationResponse

    /**
     * Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity Reservation's state to
     * cancelled.
     * Instances running in the reserved capacity continue running until you stop them. Stopped
     * instances that target the Capacity Reservation can no longer launch. Modify these instances to either
     * target a different Capacity Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation
     * that has matching attributes and sufficient capacity.
     */
    suspend fun cancelCapacityReservation(block: CancelCapacityReservationRequest.DslBuilder.() -> Unit) = cancelCapacityReservation(CancelCapacityReservationRequest.builder().apply(block).build())

    /**
     * Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation
     * Fleet, the following happens:
     * The Capacity Reservation Fleet's status changes to cancelled.
     * The individual Capacity Reservations in the Fleet are cancelled. Instances running
     * in the Capacity Reservations at the time of cancelling the Fleet continue to run in
     * shared capacity.
     * The Fleet stops creating new Capacity Reservations.
     */
    suspend fun cancelCapacityReservationFleets(input: CancelCapacityReservationFleetsRequest): CancelCapacityReservationFleetsResponse

    /**
     * Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation
     * Fleet, the following happens:
     * The Capacity Reservation Fleet's status changes to cancelled.
     * The individual Capacity Reservations in the Fleet are cancelled. Instances running
     * in the Capacity Reservations at the time of cancelling the Fleet continue to run in
     * shared capacity.
     * The Fleet stops creating new Capacity Reservations.
     */
    suspend fun cancelCapacityReservationFleets(block: CancelCapacityReservationFleetsRequest.DslBuilder.() -> Unit) = cancelCapacityReservationFleets(CancelCapacityReservationFleetsRequest.builder().apply(block).build())

    /**
     * Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all
     * artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or is
     * in the process of transferring the final disk image, the command fails and returns an exception.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html">Importing a Virtual Machine Using the Amazon
     * EC2 CLI.
     */
    suspend fun cancelConversionTask(input: CancelConversionTaskRequest): CancelConversionTaskResponse

    /**
     * Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all
     * artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or is
     * in the process of transferring the final disk image, the command fails and returns an exception.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html">Importing a Virtual Machine Using the Amazon
     * EC2 CLI.
     */
    suspend fun cancelConversionTask(block: CancelConversionTaskRequest.DslBuilder.() -> Unit) = cancelConversionTask(CancelConversionTaskRequest.builder().apply(block).build())

    /**
     * Cancels an active export task. The request removes all artifacts of the export, including any partially-created
     * Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the
     * command fails and returns an error.
     */
    suspend fun cancelExportTask(input: CancelExportTaskRequest): CancelExportTaskResponse

    /**
     * Cancels an active export task. The request removes all artifacts of the export, including any partially-created
     * Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the
     * command fails and returns an error.
     */
    suspend fun cancelExportTask(block: CancelExportTaskRequest.DslBuilder.() -> Unit) = cancelExportTask(CancelExportTaskRequest.builder().apply(block).build())

    /**
     * Cancels an in-process import virtual machine or import snapshot task.
     */
    suspend fun cancelImportTask(input: CancelImportTaskRequest): CancelImportTaskResponse

    /**
     * Cancels an in-process import virtual machine or import snapshot task.
     */
    suspend fun cancelImportTask(block: CancelImportTaskRequest.DslBuilder.() -> Unit) = cancelImportTask(CancelImportTaskRequest.builder().apply(block).build())

    /**
     * Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace
     * in the Amazon EC2 User Guide.
     */
    suspend fun cancelReservedInstancesListing(input: CancelReservedInstancesListingRequest): CancelReservedInstancesListingResponse

    /**
     * Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace
     * in the Amazon EC2 User Guide.
     */
    suspend fun cancelReservedInstancesListing(block: CancelReservedInstancesListingRequest.DslBuilder.() -> Unit) = cancelReservedInstancesListing(CancelReservedInstancesListingRequest.builder().apply(block).build())

    /**
     * Cancels the specified Spot Fleet requests.
     * After you cancel a Spot Fleet request, the Spot Fleet launches no new Spot Instances.
     * You must specify whether the Spot Fleet should also terminate its Spot Instances. If you
     * terminate the instances, the Spot Fleet request enters the
     * cancelled_terminating state. Otherwise, the Spot Fleet request enters
     * the cancelled_running state and the instances continue to run until they
     * are interrupted or you terminate them manually.
     */
    suspend fun cancelSpotFleetRequests(input: CancelSpotFleetRequestsRequest): CancelSpotFleetRequestsResponse

    /**
     * Cancels the specified Spot Fleet requests.
     * After you cancel a Spot Fleet request, the Spot Fleet launches no new Spot Instances.
     * You must specify whether the Spot Fleet should also terminate its Spot Instances. If you
     * terminate the instances, the Spot Fleet request enters the
     * cancelled_terminating state. Otherwise, the Spot Fleet request enters
     * the cancelled_running state and the instances continue to run until they
     * are interrupted or you terminate them manually.
     */
    suspend fun cancelSpotFleetRequests(block: CancelSpotFleetRequestsRequest.DslBuilder.() -> Unit) = cancelSpotFleetRequests(CancelSpotFleetRequestsRequest.builder().apply(block).build())

    /**
     * Cancels one or more Spot Instance requests.
     * Canceling a Spot Instance request does not terminate running Spot Instances
     * associated with the request.
     */
    suspend fun cancelSpotInstanceRequests(input: CancelSpotInstanceRequestsRequest): CancelSpotInstanceRequestsResponse

    /**
     * Cancels one or more Spot Instance requests.
     * Canceling a Spot Instance request does not terminate running Spot Instances
     * associated with the request.
     */
    suspend fun cancelSpotInstanceRequests(block: CancelSpotInstanceRequestsRequest.DslBuilder.() -> Unit) = cancelSpotInstanceRequests(CancelSpotInstanceRequestsRequest.builder().apply(block).build())

    /**
     * Determines whether a product code is associated with an instance. This action can only
     * be used by the owner of the product code. It is useful when a product code owner must
     * verify whether another user's instance is eligible for support.
     */
    suspend fun confirmProductInstance(input: ConfirmProductInstanceRequest): ConfirmProductInstanceResponse

    /**
     * Determines whether a product code is associated with an instance. This action can only
     * be used by the owner of the product code. It is useful when a product code owner must
     * verify whether another user's instance is eligible for support.
     */
    suspend fun confirmProductInstance(block: ConfirmProductInstanceRequest.DslBuilder.() -> Unit) = confirmProductInstance(ConfirmProductInstanceRequest.builder().apply(block).build())

    /**
     * Copies the specified Amazon FPGA Image (AFI) to the current Region.
     */
    suspend fun copyFpgaImage(input: CopyFpgaImageRequest): CopyFpgaImageResponse

    /**
     * Copies the specified Amazon FPGA Image (AFI) to the current Region.
     */
    suspend fun copyFpgaImage(block: CopyFpgaImageRequest.DslBuilder.() -> Unit) = copyFpgaImage(CopyFpgaImageRequest.builder().apply(block).build())

    /**
     * Initiates the copy of an AMI. You can copy an AMI from one Region to another, or from a
     * Region to an Outpost. You can't copy an AMI from an Outpost to a Region, from one Outpost
     * to another, or within the same Outpost. To copy an AMI to another partition, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html">CreateStoreImageTask.
     * To copy an AMI from one Region to another, specify the source Region using the
     * SourceRegion parameter, and specify the
     * destination Region using its endpoint. Copies of encrypted backing snapshots for
     * the AMI are encrypted. Copies of unencrypted backing snapshots remain unencrypted,
     * unless you set Encrypted during the copy operation. You cannot
     * create an unencrypted copy of an encrypted backing snapshot.
     * To copy an AMI from a Region to an Outpost, specify the source Region using the
     * SourceRegion parameter, and specify the
     * ARN of the destination Outpost using DestinationOutpostArn.
     * Backing snapshots copied to an Outpost are encrypted by default using the default
     * encryption key for the Region, or a different key that you specify in the request using
     * KmsKeyId. Outposts do not support unencrypted
     * snapshots. For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami">
     * Amazon EBS local snapshots on Outposts in the Amazon Elastic Compute Cloud User Guide.
     * For more information about the prerequisites and limits when copying an AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html">Copying an AMI
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun copyImage(input: CopyImageRequest): CopyImageResponse

    /**
     * Initiates the copy of an AMI. You can copy an AMI from one Region to another, or from a
     * Region to an Outpost. You can't copy an AMI from an Outpost to a Region, from one Outpost
     * to another, or within the same Outpost. To copy an AMI to another partition, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html">CreateStoreImageTask.
     * To copy an AMI from one Region to another, specify the source Region using the
     * SourceRegion parameter, and specify the
     * destination Region using its endpoint. Copies of encrypted backing snapshots for
     * the AMI are encrypted. Copies of unencrypted backing snapshots remain unencrypted,
     * unless you set Encrypted during the copy operation. You cannot
     * create an unencrypted copy of an encrypted backing snapshot.
     * To copy an AMI from a Region to an Outpost, specify the source Region using the
     * SourceRegion parameter, and specify the
     * ARN of the destination Outpost using DestinationOutpostArn.
     * Backing snapshots copied to an Outpost are encrypted by default using the default
     * encryption key for the Region, or a different key that you specify in the request using
     * KmsKeyId. Outposts do not support unencrypted
     * snapshots. For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami">
     * Amazon EBS local snapshots on Outposts in the Amazon Elastic Compute Cloud User Guide.
     * For more information about the prerequisites and limits when copying an AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html">Copying an AMI
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun copyImage(block: CopyImageRequest.DslBuilder.() -> Unit) = copyImage(CopyImageRequest.builder().apply(block).build())

    /**
     * Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy a
     * snapshot within the same Region, from one Region to another, or from a Region to an Outpost.
     * You can't copy a snapshot from an Outpost to a Region, from one Outpost to another, or within
     * the same Outpost.
     * You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs).
     * When copying snapshots to a Region, copies of encrypted EBS snapshots remain encrypted.
     * Copies of unencrypted snapshots remain unencrypted, unless you enable encryption for the
     * snapshot copy operation. By default, encrypted snapshot copies use the default Key Management Service (KMS)
     * KMS key; however, you can specify a different KMS key. To copy an encrypted
     * snapshot that has been shared from another account, you must have permissions for the KMS key
     * used to encrypt the snapshot.
     * Snapshots copied to an Outpost are encrypted by default using the default
     * encryption key for the Region, or a different key that you specify in the request using
     * KmsKeyId. Outposts do not support unencrypted
     * snapshots. For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami">
     * Amazon EBS local snapshots on Outposts in the Amazon Elastic Compute Cloud User Guide.
     * Snapshots created by copying another snapshot have an arbitrary volume ID that should not
     * be used for any purpose.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html">Copy an Amazon EBS snapshot in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun copySnapshot(input: CopySnapshotRequest): CopySnapshotResponse

    /**
     * Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy a
     * snapshot within the same Region, from one Region to another, or from a Region to an Outpost.
     * You can't copy a snapshot from an Outpost to a Region, from one Outpost to another, or within
     * the same Outpost.
     * You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs).
     * When copying snapshots to a Region, copies of encrypted EBS snapshots remain encrypted.
     * Copies of unencrypted snapshots remain unencrypted, unless you enable encryption for the
     * snapshot copy operation. By default, encrypted snapshot copies use the default Key Management Service (KMS)
     * KMS key; however, you can specify a different KMS key. To copy an encrypted
     * snapshot that has been shared from another account, you must have permissions for the KMS key
     * used to encrypt the snapshot.
     * Snapshots copied to an Outpost are encrypted by default using the default
     * encryption key for the Region, or a different key that you specify in the request using
     * KmsKeyId. Outposts do not support unencrypted
     * snapshots. For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami">
     * Amazon EBS local snapshots on Outposts in the Amazon Elastic Compute Cloud User Guide.
     * Snapshots created by copying another snapshot have an arbitrary volume ID that should not
     * be used for any purpose.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html">Copy an Amazon EBS snapshot in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun copySnapshot(block: CopySnapshotRequest.DslBuilder.() -> Unit) = copySnapshot(CopySnapshotRequest.builder().apply(block).build())

    /**
     * Creates a new Capacity Reservation with the specified attributes.
     * Capacity Reservations enable you to reserve capacity for your Amazon EC2 instances in a specific Availability Zone for any duration. This
     * gives you the flexibility to selectively add capacity reservations and still get the Regional RI discounts for that usage.
     * By creating Capacity Reservations, you ensure that you always have access to Amazon EC2 capacity when you need it, for as long as you need it.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">Capacity Reservations in the Amazon EC2 User Guide.
     * Your request to create a Capacity Reservation could fail if Amazon EC2 does not have sufficient capacity to
     * fulfill the request. If your request fails due to Amazon EC2 capacity constraints, either try
     * again at a later time, try in a different Availability Zone, or request a smaller
     * capacity reservation. If your application is flexible across instance types and sizes,
     * try to create a Capacity Reservation with different instance attributes.
     * Your request could also fail if the requested quantity exceeds your On-Demand Instance
     * limit for the selected instance type. If your request fails due to limit constraints,
     * increase your On-Demand Instance limit for the required instance type and try again. For
     * more information about increasing your instance limits, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 Service
     * Quotas in the Amazon EC2 User Guide.
     */
    suspend fun createCapacityReservation(input: CreateCapacityReservationRequest): CreateCapacityReservationResponse

    /**
     * Creates a new Capacity Reservation with the specified attributes.
     * Capacity Reservations enable you to reserve capacity for your Amazon EC2 instances in a specific Availability Zone for any duration. This
     * gives you the flexibility to selectively add capacity reservations and still get the Regional RI discounts for that usage.
     * By creating Capacity Reservations, you ensure that you always have access to Amazon EC2 capacity when you need it, for as long as you need it.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">Capacity Reservations in the Amazon EC2 User Guide.
     * Your request to create a Capacity Reservation could fail if Amazon EC2 does not have sufficient capacity to
     * fulfill the request. If your request fails due to Amazon EC2 capacity constraints, either try
     * again at a later time, try in a different Availability Zone, or request a smaller
     * capacity reservation. If your application is flexible across instance types and sizes,
     * try to create a Capacity Reservation with different instance attributes.
     * Your request could also fail if the requested quantity exceeds your On-Demand Instance
     * limit for the selected instance type. If your request fails due to limit constraints,
     * increase your On-Demand Instance limit for the required instance type and try again. For
     * more information about increasing your instance limits, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 Service
     * Quotas in the Amazon EC2 User Guide.
     */
    suspend fun createCapacityReservation(block: CreateCapacityReservationRequest.DslBuilder.() -> Unit) = createCapacityReservation(CreateCapacityReservationRequest.builder().apply(block).build())

    /**
     * Creates a Capacity Reservation Fleet. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet">Create a Capacity
     * Reservation Fleet in the Amazon EC2 User Guide.
     */
    suspend fun createCapacityReservationFleet(input: CreateCapacityReservationFleetRequest): CreateCapacityReservationFleetResponse

    /**
     * Creates a Capacity Reservation Fleet. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet">Create a Capacity
     * Reservation Fleet in the Amazon EC2 User Guide.
     */
    suspend fun createCapacityReservationFleet(block: CreateCapacityReservationFleetRequest.DslBuilder.() -> Unit) = createCapacityReservationFleet(CreateCapacityReservationFleetRequest.builder().apply(block).build())

    /**
     * Creates a carrier gateway.   For more information about carrier gateways, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway">Carrier gateways in the Amazon Web Services Wavelength Developer Guide.
     */
    suspend fun createCarrierGateway(input: CreateCarrierGatewayRequest): CreateCarrierGatewayResponse

    /**
     * Creates a carrier gateway.   For more information about carrier gateways, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway">Carrier gateways in the Amazon Web Services Wavelength Developer Guide.
     */
    suspend fun createCarrierGateway(block: CreateCarrierGatewayRequest.DslBuilder.() -> Unit) = createCarrierGateway(CreateCarrierGatewayRequest.builder().apply(block).build())

    /**
     * Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to
     * enable and manage client VPN sessions. It is the destination endpoint at which all client VPN sessions
     * are terminated.
     */
    suspend fun createClientVpnEndpoint(input: CreateClientVpnEndpointRequest): CreateClientVpnEndpointResponse

    /**
     * Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to
     * enable and manage client VPN sessions. It is the destination endpoint at which all client VPN sessions
     * are terminated.
     */
    suspend fun createClientVpnEndpoint(block: CreateClientVpnEndpointRequest.DslBuilder.() -> Unit) = createClientVpnEndpoint(CreateClientVpnEndpointRequest.builder().apply(block).build())

    /**
     * Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the
     * available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc resources or networks.
     */
    suspend fun createClientVpnRoute(input: CreateClientVpnRouteRequest): CreateClientVpnRouteResponse

    /**
     * Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the
     * available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc resources or networks.
     */
    suspend fun createClientVpnRoute(block: CreateClientVpnRouteRequest.DslBuilder.() -> Unit) = createClientVpnRoute(CreateClientVpnRouteRequest.builder().apply(block).build())

    /**
     * Provides information to Amazon Web Services about your VPN customer gateway device. The
     * customer gateway is the appliance at your end of the VPN connection. (The device on the
     * Amazon Web Services side of the VPN connection is the virtual private gateway.) You
     * must provide the internet-routable IP address of the customer gateway's external
     * interface. The IP address must be static and can be behind a device performing network
     * address translation (NAT).
     * For devices that use Border Gateway Protocol (BGP), you can also provide the device's
     * BGP Autonomous System Number (ASN). You can use an existing ASN assigned to your
     * network. If you don't have an ASN already, you can use a private ASN (in the 64512 -
     * 65534 range).
     * Amazon EC2 supports all 4-byte ASN numbers in the range of 1 - 2147483647, with
     * the exception of the following:
     * 7224 - reserved in the us-east-1 Region
     * 9059 - reserved in the eu-west-1 Region
     * 17943 - reserved in the ap-southeast-1 Region
     * 10124 - reserved in the ap-northeast-1 Region
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     * To create more than one customer gateway with the same VPN type, IP address, and
     * BGP ASN, specify a unique device name for each customer gateway. Identical requests
     * return information about the existing customer gateway and do not create new
     * customer gateways.
     */
    suspend fun createCustomerGateway(input: CreateCustomerGatewayRequest): CreateCustomerGatewayResponse

    /**
     * Provides information to Amazon Web Services about your VPN customer gateway device. The
     * customer gateway is the appliance at your end of the VPN connection. (The device on the
     * Amazon Web Services side of the VPN connection is the virtual private gateway.) You
     * must provide the internet-routable IP address of the customer gateway's external
     * interface. The IP address must be static and can be behind a device performing network
     * address translation (NAT).
     * For devices that use Border Gateway Protocol (BGP), you can also provide the device's
     * BGP Autonomous System Number (ASN). You can use an existing ASN assigned to your
     * network. If you don't have an ASN already, you can use a private ASN (in the 64512 -
     * 65534 range).
     * Amazon EC2 supports all 4-byte ASN numbers in the range of 1 - 2147483647, with
     * the exception of the following:
     * 7224 - reserved in the us-east-1 Region
     * 9059 - reserved in the eu-west-1 Region
     * 17943 - reserved in the ap-southeast-1 Region
     * 10124 - reserved in the ap-northeast-1 Region
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     * To create more than one customer gateway with the same VPN type, IP address, and
     * BGP ASN, specify a unique device name for each customer gateway. Identical requests
     * return information about the existing customer gateway and do not create new
     * customer gateways.
     */
    suspend fun createCustomerGateway(block: CreateCustomerGatewayRequest.DslBuilder.() -> Unit) = createCustomerGateway(CreateCustomerGatewayRequest.builder().apply(block).build())

    /**
     * Creates a default subnet with a size /20 IPv4 CIDR block in the
     * specified Availability Zone in your default VPC. You can have only one default subnet
     * per Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet">Creating a default
     * subnet in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createDefaultSubnet(input: CreateDefaultSubnetRequest): CreateDefaultSubnetResponse

    /**
     * Creates a default subnet with a size /20 IPv4 CIDR block in the
     * specified Availability Zone in your default VPC. You can have only one default subnet
     * per Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet">Creating a default
     * subnet in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createDefaultSubnet(block: CreateDefaultSubnetRequest.DslBuilder.() -> Unit) = createDefaultSubnet(CreateDefaultSubnetRequest.builder().apply(block).build())

    /**
     * Creates a default VPC with a size /16 IPv4 CIDR block and a default subnet
     * in each Availability Zone. For more information about the components of a default VPC,
     * see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html">Default VPC and
     * default subnets in the Amazon Virtual Private Cloud User Guide. You cannot
     * specify the components of the default VPC yourself.
     * If you deleted your previous default VPC, you can create a default VPC. You cannot have
     * more than one default VPC per Region.
     * If your account supports EC2-Classic, you cannot use this action to create a default VPC
     * in a Region that supports EC2-Classic. If you want a default VPC in a Region that
     * supports EC2-Classic, see "I really want a default VPC for my existing EC2 account. Is
     * that possible?" in the <a href="http://aws.amazon.com/vpc/faqs/#Default_VPCs">Default VPCs
     * FAQ.
     */
    suspend fun createDefaultVpc(input: CreateDefaultVpcRequest): CreateDefaultVpcResponse

    /**
     * Creates a default VPC with a size /16 IPv4 CIDR block and a default subnet
     * in each Availability Zone. For more information about the components of a default VPC,
     * see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html">Default VPC and
     * default subnets in the Amazon Virtual Private Cloud User Guide. You cannot
     * specify the components of the default VPC yourself.
     * If you deleted your previous default VPC, you can create a default VPC. You cannot have
     * more than one default VPC per Region.
     * If your account supports EC2-Classic, you cannot use this action to create a default VPC
     * in a Region that supports EC2-Classic. If you want a default VPC in a Region that
     * supports EC2-Classic, see "I really want a default VPC for my existing EC2 account. Is
     * that possible?" in the <a href="http://aws.amazon.com/vpc/faqs/#Default_VPCs">Default VPCs
     * FAQ.
     */
    suspend fun createDefaultVpc(block: CreateDefaultVpcRequest.DslBuilder.() -> Unit) = createDefaultVpc(CreateDefaultVpcRequest.builder().apply(block).build())

    /**
     * Creates a set of DHCP options for your VPC. After creating the set, you must
     * associate it with the VPC, causing all existing and new instances that you launch in
     * the VPC to use this set of DHCP options. The following are the individual DHCP
     * options you can specify. For more information about the options, see <a href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132.
     * domain-name-servers - The IP addresses of up to four domain name
     * servers, or AmazonProvidedDNS. The default DHCP option set specifies
     * AmazonProvidedDNS. If specifying more than one domain name server, specify the
     * IP addresses in a single parameter, separated by commas. To have your instance
     * receive a custom DNS hostname as specified in domain-name, you must
     * set domain-name-servers to a custom DNS server.
     * domain-name - If you're using AmazonProvidedDNS in
     * us-east-1, specify ec2.internal. If you're using
     * AmazonProvidedDNS in another Region, specify
     * region.compute.internal (for example,
     * ap-northeast-1.compute.internal). Otherwise, specify a domain
     * name (for example, ExampleCompany.com). This value is used to complete
     * unqualified DNS hostnames. Important: Some
     * Linux operating systems accept multiple domain names separated by spaces.
     * However, Windows and other Linux operating systems treat the value as a single
     * domain, which results in unexpected behavior. If your DHCP options set is
     * associated with a VPC that has instances with multiple operating systems,
     * specify only one domain name.
     * ntp-servers - The IP addresses of up to four Network Time Protocol (NTP)
     * servers.
     * netbios-name-servers - The IP addresses of up to four NetBIOS name
     * servers.
     * netbios-node-type - The NetBIOS node type (1, 2, 4, or 8). We recommend that
     * you specify 2 (broadcast and multicast are not currently supported). For more information
     * about these node types, see <a href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132.
     * Your VPC automatically starts out with a set of DHCP options that includes only a DNS
     * server that we provide (AmazonProvidedDNS). If you create a set of options, and if your
     * VPC has an internet gateway, make sure to set the domain-name-servers
     * option either to AmazonProvidedDNS or to a domain name server of your
     * choice. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createDhcpOptions(input: CreateDhcpOptionsRequest): CreateDhcpOptionsResponse

    /**
     * Creates a set of DHCP options for your VPC. After creating the set, you must
     * associate it with the VPC, causing all existing and new instances that you launch in
     * the VPC to use this set of DHCP options. The following are the individual DHCP
     * options you can specify. For more information about the options, see <a href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132.
     * domain-name-servers - The IP addresses of up to four domain name
     * servers, or AmazonProvidedDNS. The default DHCP option set specifies
     * AmazonProvidedDNS. If specifying more than one domain name server, specify the
     * IP addresses in a single parameter, separated by commas. To have your instance
     * receive a custom DNS hostname as specified in domain-name, you must
     * set domain-name-servers to a custom DNS server.
     * domain-name - If you're using AmazonProvidedDNS in
     * us-east-1, specify ec2.internal. If you're using
     * AmazonProvidedDNS in another Region, specify
     * region.compute.internal (for example,
     * ap-northeast-1.compute.internal). Otherwise, specify a domain
     * name (for example, ExampleCompany.com). This value is used to complete
     * unqualified DNS hostnames. Important: Some
     * Linux operating systems accept multiple domain names separated by spaces.
     * However, Windows and other Linux operating systems treat the value as a single
     * domain, which results in unexpected behavior. If your DHCP options set is
     * associated with a VPC that has instances with multiple operating systems,
     * specify only one domain name.
     * ntp-servers - The IP addresses of up to four Network Time Protocol (NTP)
     * servers.
     * netbios-name-servers - The IP addresses of up to four NetBIOS name
     * servers.
     * netbios-node-type - The NetBIOS node type (1, 2, 4, or 8). We recommend that
     * you specify 2 (broadcast and multicast are not currently supported). For more information
     * about these node types, see <a href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132.
     * Your VPC automatically starts out with a set of DHCP options that includes only a DNS
     * server that we provide (AmazonProvidedDNS). If you create a set of options, and if your
     * VPC has an internet gateway, make sure to set the domain-name-servers
     * option either to AmazonProvidedDNS or to a domain name server of your
     * choice. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createDhcpOptions(block: CreateDhcpOptionsRequest.DslBuilder.() -> Unit) = createDhcpOptions(CreateDhcpOptionsRequest.builder().apply(block).build())

    /**
     * &#91;IPv6 only&#93; Creates an egress-only internet gateway for your VPC. An egress-only
     * internet gateway is used to enable outbound communication over IPv6 from instances in
     * your VPC to the internet, and prevents hosts outside of your VPC from initiating an IPv6
     * connection with your instance.
     */
    suspend fun createEgressOnlyInternetGateway(input: CreateEgressOnlyInternetGatewayRequest): CreateEgressOnlyInternetGatewayResponse

    /**
     * &#91;IPv6 only&#93; Creates an egress-only internet gateway for your VPC. An egress-only
     * internet gateway is used to enable outbound communication over IPv6 from instances in
     * your VPC to the internet, and prevents hosts outside of your VPC from initiating an IPv6
     * connection with your instance.
     */
    suspend fun createEgressOnlyInternetGateway(block: CreateEgressOnlyInternetGatewayRequest.DslBuilder.() -> Unit) = createEgressOnlyInternetGateway(CreateEgressOnlyInternetGatewayRequest.builder().apply(block).build())

    /**
     * Launches an EC2 Fleet.
     * You can create a single EC2 Fleet that includes multiple launch specifications that vary by
     * instance type, AMI, Availability Zone, or subnet.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html">Launching an EC2 Fleet in the Amazon EC2 User Guide.
     */
    suspend fun createFleet(input: CreateFleetRequest): CreateFleetResponse

    /**
     * Launches an EC2 Fleet.
     * You can create a single EC2 Fleet that includes multiple launch specifications that vary by
     * instance type, AMI, Availability Zone, or subnet.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html">Launching an EC2 Fleet in the Amazon EC2 User Guide.
     */
    suspend fun createFleet(block: CreateFleetRequest.DslBuilder.() -> Unit) = createFleet(CreateFleetRequest.builder().apply(block).build())

    /**
     * Creates one or more flow logs to capture information about IP traffic for a specific network interface,
     * subnet, or VPC.
     * Flow log data for a monitored network interface is recorded as flow log records, which are log events
     * consisting of fields that describe the traffic flow. For more information, see
     * <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records
     * in the Amazon Virtual Private Cloud User Guide.
     * When publishing to CloudWatch Logs, flow log records are published to a log group, and each network
     * interface has a unique log stream in the log group. When publishing to Amazon S3, flow log records for all
     * of the monitored network interfaces are published to a single log file object that is stored in the specified
     * bucket.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html">VPC Flow Logs in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createFlowLogs(input: CreateFlowLogsRequest): CreateFlowLogsResponse

    /**
     * Creates one or more flow logs to capture information about IP traffic for a specific network interface,
     * subnet, or VPC.
     * Flow log data for a monitored network interface is recorded as flow log records, which are log events
     * consisting of fields that describe the traffic flow. For more information, see
     * <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records
     * in the Amazon Virtual Private Cloud User Guide.
     * When publishing to CloudWatch Logs, flow log records are published to a log group, and each network
     * interface has a unique log stream in the log group. When publishing to Amazon S3, flow log records for all
     * of the monitored network interfaces are published to a single log file object that is stored in the specified
     * bucket.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html">VPC Flow Logs in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createFlowLogs(block: CreateFlowLogsRequest.DslBuilder.() -> Unit) = createFlowLogs(CreateFlowLogsRequest.builder().apply(block).build())

    /**
     * Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).
     * The create operation is asynchronous. To verify that the AFI is ready for use,
     * check the output logs.
     * An AFI contains the FPGA bitstream that is ready to download to an FPGA.
     * You can securely deploy an AFI on multiple FPGA-accelerated instances.
     * For more information, see the <a href="https://github.com/aws/aws-fpga/">Amazon Web Services FPGA Hardware Development Kit.
     */
    suspend fun createFpgaImage(input: CreateFpgaImageRequest): CreateFpgaImageResponse

    /**
     * Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).
     * The create operation is asynchronous. To verify that the AFI is ready for use,
     * check the output logs.
     * An AFI contains the FPGA bitstream that is ready to download to an FPGA.
     * You can securely deploy an AFI on multiple FPGA-accelerated instances.
     * For more information, see the <a href="https://github.com/aws/aws-fpga/">Amazon Web Services FPGA Hardware Development Kit.
     */
    suspend fun createFpgaImage(block: CreateFpgaImageRequest.DslBuilder.() -> Unit) = createFpgaImage(CreateFpgaImageRequest.builder().apply(block).build())

    /**
     * Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance
     * that is either running or stopped.
     * If you customized your instance with instance store volumes or Amazon EBS volumes in addition to the root device volume, the
     * new AMI contains block device mapping information for those volumes. When you launch an instance from this new AMI,
     * the instance automatically launches with those additional volumes.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating Amazon EBS-Backed Linux AMIs
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createImage(input: CreateImageRequest): CreateImageResponse

    /**
     * Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance
     * that is either running or stopped.
     * If you customized your instance with instance store volumes or Amazon EBS volumes in addition to the root device volume, the
     * new AMI contains block device mapping information for those volumes. When you launch an instance from this new AMI,
     * the instance automatically launches with those additional volumes.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating Amazon EBS-Backed Linux AMIs
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createImage(block: CreateImageRequest.DslBuilder.() -> Unit) = createImage(CreateImageRequest.builder().apply(block).build())

    /**
     * Creates an event window in which scheduled events for the associated Amazon EC2 instances can
     * run.
     * You can define either a set of time ranges or a cron expression when creating the event
     * window, but not both. All event window times are in UTC.
     * You can create up to 200 event windows per Amazon Web Services Region.
     * When you create the event window, targets (instance IDs, Dedicated Host IDs, or tags)
     * are not yet associated with it. To ensure that the event window can be used, you must
     * associate one or more targets with it by using the AssociateInstanceEventWindow API.
     * Event windows are applicable only for scheduled events that stop, reboot, or
     * terminate instances.
     * Event windows are not applicable for:
     * Expedited scheduled events and network maintenance events.
     * Unscheduled maintenance such as AutoRecovery and unplanned reboots.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    suspend fun createInstanceEventWindow(input: CreateInstanceEventWindowRequest): CreateInstanceEventWindowResponse

    /**
     * Creates an event window in which scheduled events for the associated Amazon EC2 instances can
     * run.
     * You can define either a set of time ranges or a cron expression when creating the event
     * window, but not both. All event window times are in UTC.
     * You can create up to 200 event windows per Amazon Web Services Region.
     * When you create the event window, targets (instance IDs, Dedicated Host IDs, or tags)
     * are not yet associated with it. To ensure that the event window can be used, you must
     * associate one or more targets with it by using the AssociateInstanceEventWindow API.
     * Event windows are applicable only for scheduled events that stop, reboot, or
     * terminate instances.
     * Event windows are not applicable for:
     * Expedited scheduled events and network maintenance events.
     * Unscheduled maintenance such as AutoRecovery and unplanned reboots.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    suspend fun createInstanceEventWindow(block: CreateInstanceEventWindowRequest.DslBuilder.() -> Unit) = createInstanceEventWindow(CreateInstanceEventWindowRequest.builder().apply(block).build())

    /**
     * Exports a running or stopped instance to an Amazon S3 bucket.
     * For information about the supported operating systems, image formats, and known limitations
     * for the types of instances you can export, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html">Exporting an instance as a VM Using VM Import/Export
     * in the VM Import/Export User Guide.
     */
    suspend fun createInstanceExportTask(input: CreateInstanceExportTaskRequest): CreateInstanceExportTaskResponse

    /**
     * Exports a running or stopped instance to an Amazon S3 bucket.
     * For information about the supported operating systems, image formats, and known limitations
     * for the types of instances you can export, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html">Exporting an instance as a VM Using VM Import/Export
     * in the VM Import/Export User Guide.
     */
    suspend fun createInstanceExportTask(block: CreateInstanceExportTaskRequest.DslBuilder.() -> Unit) = createInstanceExportTask(CreateInstanceExportTaskRequest.builder().apply(block).build())

    /**
     * Creates an internet gateway for use with a VPC. After creating the internet gateway,
     * you attach it to a VPC using AttachInternetGateway.
     * For more information about your VPC and internet gateway, see the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createInternetGateway(input: CreateInternetGatewayRequest): CreateInternetGatewayResponse

    /**
     * Creates an internet gateway for use with a VPC. After creating the internet gateway,
     * you attach it to a VPC using AttachInternetGateway.
     * For more information about your VPC and internet gateway, see the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createInternetGateway(block: CreateInternetGatewayRequest.DslBuilder.() -> Unit) = createInternetGateway(CreateInternetGatewayRequest.builder().apply(block).build())

    /**
     * Creates an ED25519 or 2048-bit RSA key pair with the specified name. Amazon EC2 stores the public
     * key and displays the private key for you to save to a file. The private key is returned
     * as an unencrypted PEM encoded PKCS#1 private key. If a key with the specified name
     * already exists, Amazon EC2 returns an error.
     * The key pair returned to you is available only in the Amazon Web Services Region in which you create it.
     * If you prefer, you can create your own key pair using a third-party tool and upload it
     * to any Region using ImportKeyPair.
     * You can have up to 5,000 key pairs per Amazon Web Services Region.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createKeyPair(input: CreateKeyPairRequest): CreateKeyPairResponse

    /**
     * Creates an ED25519 or 2048-bit RSA key pair with the specified name. Amazon EC2 stores the public
     * key and displays the private key for you to save to a file. The private key is returned
     * as an unencrypted PEM encoded PKCS#1 private key. If a key with the specified name
     * already exists, Amazon EC2 returns an error.
     * The key pair returned to you is available only in the Amazon Web Services Region in which you create it.
     * If you prefer, you can create your own key pair using a third-party tool and upload it
     * to any Region using ImportKeyPair.
     * You can have up to 5,000 key pairs per Amazon Web Services Region.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createKeyPair(block: CreateKeyPairRequest.DslBuilder.() -> Unit) = createKeyPair(CreateKeyPairRequest.builder().apply(block).build())

    /**
     * Creates a launch template. A launch template contains the parameters to launch an
     * instance. When you launch an instance using RunInstances, you can
     * specify a launch template instead of providing the launch parameters in the request. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launching an instance from a
     * launch template in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createLaunchTemplate(input: CreateLaunchTemplateRequest): CreateLaunchTemplateResponse

    /**
     * Creates a launch template. A launch template contains the parameters to launch an
     * instance. When you launch an instance using RunInstances, you can
     * specify a launch template instead of providing the launch parameters in the request. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launching an instance from a
     * launch template in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createLaunchTemplate(block: CreateLaunchTemplateRequest.DslBuilder.() -> Unit) = createLaunchTemplate(CreateLaunchTemplateRequest.builder().apply(block).build())

    /**
     * Creates a new version for a launch template. You can specify an existing version of
     * launch template from which to base the new version.
     * Launch template versions are numbered in the order in which they are created. You
     * cannot specify, change, or replace the numbering of launch template versions.
     * For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions">Managing launch template versionsin the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createLaunchTemplateVersion(input: CreateLaunchTemplateVersionRequest): CreateLaunchTemplateVersionResponse

    /**
     * Creates a new version for a launch template. You can specify an existing version of
     * launch template from which to base the new version.
     * Launch template versions are numbered in the order in which they are created. You
     * cannot specify, change, or replace the numbering of launch template versions.
     * For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions">Managing launch template versionsin the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createLaunchTemplateVersion(block: CreateLaunchTemplateVersionRequest.DslBuilder.() -> Unit) = createLaunchTemplateVersion(CreateLaunchTemplateVersionRequest.builder().apply(block).build())

    /**
     * Creates a static route for the specified local gateway route table.
     */
    suspend fun createLocalGatewayRoute(input: CreateLocalGatewayRouteRequest): CreateLocalGatewayRouteResponse

    /**
     * Creates a static route for the specified local gateway route table.
     */
    suspend fun createLocalGatewayRoute(block: CreateLocalGatewayRouteRequest.DslBuilder.() -> Unit) = createLocalGatewayRoute(CreateLocalGatewayRouteRequest.builder().apply(block).build())

    /**
     * Associates the specified VPC with the specified local gateway route table.
     */
    suspend fun createLocalGatewayRouteTableVpcAssociation(input: CreateLocalGatewayRouteTableVpcAssociationRequest): CreateLocalGatewayRouteTableVpcAssociationResponse

    /**
     * Associates the specified VPC with the specified local gateway route table.
     */
    suspend fun createLocalGatewayRouteTableVpcAssociation(block: CreateLocalGatewayRouteTableVpcAssociationRequest.DslBuilder.() -> Unit) = createLocalGatewayRouteTableVpcAssociation(CreateLocalGatewayRouteTableVpcAssociationRequest.builder().apply(block).build())

    /**
     * Creates a managed prefix list. You can specify one or more entries for the prefix list.
     * Each entry consists of a CIDR block and an optional description.
     */
    suspend fun createManagedPrefixList(input: CreateManagedPrefixListRequest): CreateManagedPrefixListResponse

    /**
     * Creates a managed prefix list. You can specify one or more entries for the prefix list.
     * Each entry consists of a CIDR block and an optional description.
     */
    suspend fun createManagedPrefixList(block: CreateManagedPrefixListRequest.DslBuilder.() -> Unit) = createManagedPrefixList(CreateManagedPrefixListRequest.builder().apply(block).build())

    /**
     * Creates a NAT gateway in the specified subnet. This action creates a network interface
     * in the specified subnet with a private IP address from the IP address range of the
     * subnet. You can create either a public NAT gateway or a private NAT gateway.
     * With a public NAT gateway, internet-bound traffic from a private subnet can be routed
     * to the NAT gateway, so that instances in a private subnet can connect to the internet.
     * With a private NAT gateway, private communication is routed across VPCs and on-premises
     * networks through a transit gateway or virtual private gateway. Common use cases include
     * running large workloads behind a small pool of allowlisted IPv4 addresses, preserving
     * private IPv4 addresses, and communicating between overlapping networks.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">NAT gateways in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createNatGateway(input: CreateNatGatewayRequest): CreateNatGatewayResponse

    /**
     * Creates a NAT gateway in the specified subnet. This action creates a network interface
     * in the specified subnet with a private IP address from the IP address range of the
     * subnet. You can create either a public NAT gateway or a private NAT gateway.
     * With a public NAT gateway, internet-bound traffic from a private subnet can be routed
     * to the NAT gateway, so that instances in a private subnet can connect to the internet.
     * With a private NAT gateway, private communication is routed across VPCs and on-premises
     * networks through a transit gateway or virtual private gateway. Common use cases include
     * running large workloads behind a small pool of allowlisted IPv4 addresses, preserving
     * private IPv4 addresses, and communicating between overlapping networks.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">NAT gateways in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createNatGateway(block: CreateNatGatewayRequest.DslBuilder.() -> Unit) = createNatGateway(CreateNatGatewayRequest.builder().apply(block).build())

    /**
     * Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security groups) for the instances in your VPC.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createNetworkAcl(input: CreateNetworkAclRequest): CreateNetworkAclResponse

    /**
     * Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security groups) for the instances in your VPC.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createNetworkAcl(block: CreateNetworkAclRequest.DslBuilder.() -> Unit) = createNetworkAcl(CreateNetworkAclRequest.builder().apply(block).build())

    /**
     * Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered ingress rules
     * and a separate set of numbered egress rules. When determining whether a packet should be allowed in or out of a subnet associated
     * with the ACL, we process the entries in the ACL according to the rule numbers, in ascending order. Each network ACL has a set of
     * ingress rules and a separate set of egress rules.
     * We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them one right after the
     * other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing ones without having to renumber the rules.
     * After you add an entry, you can't modify it; you must either replace it, or create an entry and delete the old one.
     * For more information about network ACLs, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createNetworkAclEntry(input: CreateNetworkAclEntryRequest): CreateNetworkAclEntryResponse

    /**
     * Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered ingress rules
     * and a separate set of numbered egress rules. When determining whether a packet should be allowed in or out of a subnet associated
     * with the ACL, we process the entries in the ACL according to the rule numbers, in ascending order. Each network ACL has a set of
     * ingress rules and a separate set of egress rules.
     * We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them one right after the
     * other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing ones without having to renumber the rules.
     * After you add an entry, you can't modify it; you must either replace it, or create an entry and delete the old one.
     * For more information about network ACLs, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createNetworkAclEntry(block: CreateNetworkAclEntryRequest.DslBuilder.() -> Unit) = createNetworkAclEntry(CreateNetworkAclEntryRequest.builder().apply(block).build())

    /**
     * Creates a path to analyze for reachability.
     * Reachability Analyzer enables you to analyze and debug network reachability between
     * two resources in your virtual private cloud (VPC). For more information, see
     * <a href="https://docs.aws.amazon.com/vpc/latest/reachability/">What is Reachability Analyzer.
     */
    suspend fun createNetworkInsightsPath(input: CreateNetworkInsightsPathRequest): CreateNetworkInsightsPathResponse

    /**
     * Creates a path to analyze for reachability.
     * Reachability Analyzer enables you to analyze and debug network reachability between
     * two resources in your virtual private cloud (VPC). For more information, see
     * <a href="https://docs.aws.amazon.com/vpc/latest/reachability/">What is Reachability Analyzer.
     */
    suspend fun createNetworkInsightsPath(block: CreateNetworkInsightsPathRequest.DslBuilder.() -> Unit) = createNetworkInsightsPath(CreateNetworkInsightsPathRequest.builder().apply(block).build())

    /**
     * Creates a network interface in the specified subnet.
     * For more information about network interfaces, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic Network Interfaces
     * in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createNetworkInterface(input: CreateNetworkInterfaceRequest): CreateNetworkInterfaceResponse

    /**
     * Creates a network interface in the specified subnet.
     * For more information about network interfaces, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic Network Interfaces
     * in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createNetworkInterface(block: CreateNetworkInterfaceRequest.DslBuilder.() -> Unit) = createNetworkInterface(CreateNetworkInterfaceRequest.builder().apply(block).build())

    /**
     * Grants an Amazon Web Services-authorized account permission to attach the specified network interface to
     * an instance in their account.
     * You can grant permission to a single Amazon Web Services account only, and only one account at a time.
     */
    suspend fun createNetworkInterfacePermission(input: CreateNetworkInterfacePermissionRequest): CreateNetworkInterfacePermissionResponse

    /**
     * Grants an Amazon Web Services-authorized account permission to attach the specified network interface to
     * an instance in their account.
     * You can grant permission to a single Amazon Web Services account only, and only one account at a time.
     */
    suspend fun createNetworkInterfacePermission(block: CreateNetworkInterfacePermissionRequest.DslBuilder.() -> Unit) = createNetworkInterfacePermission(CreateNetworkInterfacePermissionRequest.builder().apply(block).build())

    /**
     * Creates a placement group in which to launch instances. The strategy of the placement
     * group determines how the instances are organized within the group.
     * A cluster placement group is a logical grouping of instances within a
     * single Availability Zone that benefit from low network latency, high network throughput.
     * A spread placement group places instances on distinct hardware. A
     * partition placement group places groups of instances in different
     * partitions, where instances in one partition do not share the same hardware with
     * instances in another partition.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups in the
     * Amazon EC2 User Guide.
     */
    suspend fun createPlacementGroup(input: CreatePlacementGroupRequest): CreatePlacementGroupResponse

    /**
     * Creates a placement group in which to launch instances. The strategy of the placement
     * group determines how the instances are organized within the group.
     * A cluster placement group is a logical grouping of instances within a
     * single Availability Zone that benefit from low network latency, high network throughput.
     * A spread placement group places instances on distinct hardware. A
     * partition placement group places groups of instances in different
     * partitions, where instances in one partition do not share the same hardware with
     * instances in another partition.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups in the
     * Amazon EC2 User Guide.
     */
    suspend fun createPlacementGroup(block: CreatePlacementGroupRequest.DslBuilder.() -> Unit) = createPlacementGroup(CreatePlacementGroupRequest.builder().apply(block).build())

    /**
     * Creates a root volume replacement task for an Amazon EC2 instance. The root volume
     * can either be restored to its initial launch state, or it can be restored using a
     * specific snapshot.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-restoring-volume.html#replace-root">Replace a root volume in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createReplaceRootVolumeTask(input: CreateReplaceRootVolumeTaskRequest): CreateReplaceRootVolumeTaskResponse

    /**
     * Creates a root volume replacement task for an Amazon EC2 instance. The root volume
     * can either be restored to its initial launch state, or it can be restored using a
     * specific snapshot.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-restoring-volume.html#replace-root">Replace a root volume in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createReplaceRootVolumeTask(block: CreateReplaceRootVolumeTaskRequest.DslBuilder.() -> Unit) = createReplaceRootVolumeTask(CreateReplaceRootVolumeTaskRequest.builder().apply(block).build())

    /**
     * Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance
     * Marketplace. You can submit one Standard Reserved Instance listing at a time. To get a list of your
     * Standard Reserved Instances, you can use the DescribeReservedInstances operation.
     * Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace.
     * Convertible Reserved Instances cannot be sold.
     * The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances.
     * To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance
     * Marketplace. After completing the registration process, you can create a Reserved Instance
     * Marketplace listing of some or all of your Standard Reserved Instances, and specify the upfront price
     * to receive for them. Your Standard Reserved Instance listings then become available for purchase. To
     * view the details of your Standard Reserved Instance listing, you can use the
     * DescribeReservedInstancesListings operation.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace in the
     * Amazon EC2 User Guide.
     */
    suspend fun createReservedInstancesListing(input: CreateReservedInstancesListingRequest): CreateReservedInstancesListingResponse

    /**
     * Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance
     * Marketplace. You can submit one Standard Reserved Instance listing at a time. To get a list of your
     * Standard Reserved Instances, you can use the DescribeReservedInstances operation.
     * Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace.
     * Convertible Reserved Instances cannot be sold.
     * The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances.
     * To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance
     * Marketplace. After completing the registration process, you can create a Reserved Instance
     * Marketplace listing of some or all of your Standard Reserved Instances, and specify the upfront price
     * to receive for them. Your Standard Reserved Instance listings then become available for purchase. To
     * view the details of your Standard Reserved Instance listing, you can use the
     * DescribeReservedInstancesListings operation.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace in the
     * Amazon EC2 User Guide.
     */
    suspend fun createReservedInstancesListing(block: CreateReservedInstancesListingRequest.DslBuilder.() -> Unit) = createReservedInstancesListing(CreateReservedInstancesListingRequest.builder().apply(block).build())

    /**
     * Starts a task that restores an AMI from an Amazon S3 object that was previously created by using
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html">CreateStoreImageTask.
     * To use this API, you must have the required permissions. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions for storing and restoring AMIs using Amazon S3 in the
     * Amazon Elastic Compute Cloud User Guide.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3 in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createRestoreImageTask(input: CreateRestoreImageTaskRequest): CreateRestoreImageTaskResponse

    /**
     * Starts a task that restores an AMI from an Amazon S3 object that was previously created by using
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html">CreateStoreImageTask.
     * To use this API, you must have the required permissions. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions for storing and restoring AMIs using Amazon S3 in the
     * Amazon Elastic Compute Cloud User Guide.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3 in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createRestoreImageTask(block: CreateRestoreImageTaskRequest.DslBuilder.() -> Unit) = createRestoreImageTask(CreateRestoreImageTaskRequest.builder().apply(block).build())

    /**
     * Creates a route in a route table within a VPC.
     * You must specify one of the following targets: internet gateway or virtual private
     * gateway, NAT instance, NAT gateway, VPC peering connection, network interface, egress-only internet gateway, or transit gateway.
     * When determining how to route traffic, we use the route with the most specific match.
     * For example, traffic is destined for the IPv4 address 192.0.2.3, and the
     * route table includes the following two IPv4 routes:
     * 192.0.2.0/24 (goes to some target A)
     * 192.0.2.0/28 (goes to some target B)
     * Both routes apply to the traffic destined for 192.0.2.3. However, the second route
     * in the list covers a smaller number of IP addresses and is therefore more specific,
     * so we use that route to determine where to target the traffic.
     * For more information about route tables, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createRoute(input: CreateRouteRequest): CreateRouteResponse

    /**
     * Creates a route in a route table within a VPC.
     * You must specify one of the following targets: internet gateway or virtual private
     * gateway, NAT instance, NAT gateway, VPC peering connection, network interface, egress-only internet gateway, or transit gateway.
     * When determining how to route traffic, we use the route with the most specific match.
     * For example, traffic is destined for the IPv4 address 192.0.2.3, and the
     * route table includes the following two IPv4 routes:
     * 192.0.2.0/24 (goes to some target A)
     * 192.0.2.0/28 (goes to some target B)
     * Both routes apply to the traffic destined for 192.0.2.3. However, the second route
     * in the list covers a smaller number of IP addresses and is therefore more specific,
     * so we use that route to determine where to target the traffic.
     * For more information about route tables, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createRoute(block: CreateRouteRequest.DslBuilder.() -> Unit) = createRoute(CreateRouteRequest.builder().apply(block).build())

    /**
     * Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the table with a subnet.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createRouteTable(input: CreateRouteTableRequest): CreateRouteTableResponse

    /**
     * Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the table with a subnet.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createRouteTable(block: CreateRouteTableRequest.DslBuilder.() -> Unit) = createRouteTable(CreateRouteTableRequest.builder().apply(block).build())

    /**
     * Creates a security group.
     * A security group acts as a virtual firewall for your instance to control inbound and outbound traffic.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 security groups in
     * the Amazon Elastic Compute Cloud User Guide and
     * <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security groups for your VPC in the
     * Amazon Virtual Private Cloud User Guide.
     * When you create a security group, you specify a friendly name of your choice. You can have a security group for use in EC2-Classic with the same name as a security group for use in a VPC. However, you can't have two security groups for use in EC2-Classic with the same name or two security groups for use in a VPC with the same name.
     * You have a default security group for use in EC2-Classic and a default security group for use in your VPC. If you don't specify a security group when you launch an instance, the instance is launched into the appropriate default security group. A default security group includes a default rule that grants instances unrestricted network access to each other.
     * You can add or remove rules from your security groups using
     * AuthorizeSecurityGroupIngress,
     * AuthorizeSecurityGroupEgress,
     * RevokeSecurityGroupIngress, and
     * RevokeSecurityGroupEgress.
     * For more information about VPC security group limits, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits.
     */
    suspend fun createSecurityGroup(input: CreateSecurityGroupRequest): CreateSecurityGroupResponse

    /**
     * Creates a security group.
     * A security group acts as a virtual firewall for your instance to control inbound and outbound traffic.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 security groups in
     * the Amazon Elastic Compute Cloud User Guide and
     * <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security groups for your VPC in the
     * Amazon Virtual Private Cloud User Guide.
     * When you create a security group, you specify a friendly name of your choice. You can have a security group for use in EC2-Classic with the same name as a security group for use in a VPC. However, you can't have two security groups for use in EC2-Classic with the same name or two security groups for use in a VPC with the same name.
     * You have a default security group for use in EC2-Classic and a default security group for use in your VPC. If you don't specify a security group when you launch an instance, the instance is launched into the appropriate default security group. A default security group includes a default rule that grants instances unrestricted network access to each other.
     * You can add or remove rules from your security groups using
     * AuthorizeSecurityGroupIngress,
     * AuthorizeSecurityGroupEgress,
     * RevokeSecurityGroupIngress, and
     * RevokeSecurityGroupEgress.
     * For more information about VPC security group limits, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits.
     */
    suspend fun createSecurityGroup(block: CreateSecurityGroupRequest.DslBuilder.() -> Unit) = createSecurityGroup(CreateSecurityGroupRequest.builder().apply(block).build())

    /**
     * Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for
     * backups, to make copies of EBS volumes, and to save data before shutting down an
     * instance.
     * You can create snapshots of volumes in a Region and volumes on an Outpost. If you
     * create a snapshot of a volume in a Region, the snapshot must be stored in the same
     * Region as the volume. If you create a snapshot of a volume on an Outpost, the snapshot
     * can be stored on the same Outpost as the volume, or in the Region for that Outpost.
     * When a snapshot is created, any Amazon Web Services Marketplace product codes that are associated with the
     * source volume are propagated to the snapshot.
     * You can take a snapshot of an attached volume that is in use. However, snapshots only
     * capture data that has been written to your Amazon EBS volume at the time the snapshot command is
     * issued; this might exclude any data that has been cached by any applications or the operating
     * system. If you can pause any file systems on the volume long enough to take a snapshot, your
     * snapshot should be complete. However, if you cannot pause all file writes to the volume, you
     * should unmount the volume from within the instance, issue the snapshot command, and then
     * remount the volume to ensure a consistent and complete snapshot. You may remount and use your
     * volume while the snapshot status is pending.
     * To create a snapshot for Amazon EBS volumes that serve as root devices, you should stop the
     * instance before taking the snapshot.
     * Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that
     * are created from encrypted snapshots are also automatically encrypted. Your encrypted volumes
     * and any associated snapshots always remain protected.
     * You can tag your snapshots during creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2
     * resources in the Amazon Elastic Compute Cloud User Guide.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html">Amazon Elastic Block Store and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse

    /**
     * Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for
     * backups, to make copies of EBS volumes, and to save data before shutting down an
     * instance.
     * You can create snapshots of volumes in a Region and volumes on an Outpost. If you
     * create a snapshot of a volume in a Region, the snapshot must be stored in the same
     * Region as the volume. If you create a snapshot of a volume on an Outpost, the snapshot
     * can be stored on the same Outpost as the volume, or in the Region for that Outpost.
     * When a snapshot is created, any Amazon Web Services Marketplace product codes that are associated with the
     * source volume are propagated to the snapshot.
     * You can take a snapshot of an attached volume that is in use. However, snapshots only
     * capture data that has been written to your Amazon EBS volume at the time the snapshot command is
     * issued; this might exclude any data that has been cached by any applications or the operating
     * system. If you can pause any file systems on the volume long enough to take a snapshot, your
     * snapshot should be complete. However, if you cannot pause all file writes to the volume, you
     * should unmount the volume from within the instance, issue the snapshot command, and then
     * remount the volume to ensure a consistent and complete snapshot. You may remount and use your
     * volume while the snapshot status is pending.
     * To create a snapshot for Amazon EBS volumes that serve as root devices, you should stop the
     * instance before taking the snapshot.
     * Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that
     * are created from encrypted snapshots are also automatically encrypted. Your encrypted volumes
     * and any associated snapshots always remain protected.
     * You can tag your snapshots during creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2
     * resources in the Amazon Elastic Compute Cloud User Guide.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html">Amazon Elastic Block Store and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createSnapshot(block: CreateSnapshotRequest.DslBuilder.() -> Unit) = createSnapshot(CreateSnapshotRequest.builder().apply(block).build())

    /**
     * Creates crash-consistent snapshots of multiple EBS volumes and stores the data in S3.
     * Volumes are chosen by specifying an instance. Any attached volumes will produce one snapshot
     * each that is crash-consistent across the instance. Boot volumes can be excluded by changing the
     * parameters.
     * You can create multi-volume snapshots of instances in a Region and instances on an
     * Outpost. If you create snapshots from an instance in a Region, the snapshots must be stored
     * in the same Region as the instance. If you create snapshots from an instance on an Outpost,
     * the snapshots can be stored on the same Outpost as the instance, or in the Region for that
     * Outpost.
     */
    suspend fun createSnapshots(input: CreateSnapshotsRequest): CreateSnapshotsResponse

    /**
     * Creates crash-consistent snapshots of multiple EBS volumes and stores the data in S3.
     * Volumes are chosen by specifying an instance. Any attached volumes will produce one snapshot
     * each that is crash-consistent across the instance. Boot volumes can be excluded by changing the
     * parameters.
     * You can create multi-volume snapshots of instances in a Region and instances on an
     * Outpost. If you create snapshots from an instance in a Region, the snapshots must be stored
     * in the same Region as the instance. If you create snapshots from an instance on an Outpost,
     * the snapshots can be stored on the same Outpost as the instance, or in the Region for that
     * Outpost.
     */
    suspend fun createSnapshots(block: CreateSnapshotsRequest.DslBuilder.() -> Unit) = createSnapshots(CreateSnapshotsRequest.builder().apply(block).build())

    /**
     * Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs.
     * You can create one data feed per Amazon Web Services account. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed
     * in the Amazon EC2 User Guide for Linux Instances.
     */
    suspend fun createSpotDatafeedSubscription(input: CreateSpotDatafeedSubscriptionRequest): CreateSpotDatafeedSubscriptionResponse

    /**
     * Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs.
     * You can create one data feed per Amazon Web Services account. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed
     * in the Amazon EC2 User Guide for Linux Instances.
     */
    suspend fun createSpotDatafeedSubscription(block: CreateSpotDatafeedSubscriptionRequest.DslBuilder.() -> Unit) = createSpotDatafeedSubscription(CreateSpotDatafeedSubscriptionRequest.builder().apply(block).build())

    /**
     * Stores an AMI as a single object in an Amazon S3 bucket.
     * To use this API, you must have the required permissions. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions for storing and restoring AMIs using Amazon S3 in the
     * Amazon Elastic Compute Cloud User Guide.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3 in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createStoreImageTask(input: CreateStoreImageTaskRequest): CreateStoreImageTaskResponse

    /**
     * Stores an AMI as a single object in an Amazon S3 bucket.
     * To use this API, you must have the required permissions. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions for storing and restoring AMIs using Amazon S3 in the
     * Amazon Elastic Compute Cloud User Guide.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3 in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createStoreImageTask(block: CreateStoreImageTaskRequest.DslBuilder.() -> Unit) = createStoreImageTask(CreateStoreImageTaskRequest.builder().apply(block).build())

    /**
     * Creates a subnet in a specified VPC.
     * You must specify an IPv4 CIDR block for the subnet. After you create a subnet, you
     * can't change its CIDR block. The allowed block size is between a /16 netmask (65,536 IP
     * addresses) and /28 netmask (16 IP addresses). The CIDR block must not overlap with the
     * CIDR block of an existing subnet in the VPC.
     * If you've associated an IPv6 CIDR block with your VPC, you can create a subnet with an
     * IPv6 CIDR block that uses a /64 prefix length.
     * Amazon Web Services reserves both the first four and the last IPv4 address in each subnet's CIDR
     * block. They're not available for use.
     * If you add more than one subnet to a VPC, they're set up in a star topology with a
     * logical router in the middle.
     * When you stop an instance in a subnet, it retains its private IPv4 address. It's
     * therefore possible to have a subnet with no running instances (they're all stopped), but
     * no remaining IP addresses available.
     * For more information about subnets, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and subnets in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createSubnet(input: CreateSubnetRequest): CreateSubnetResponse

    /**
     * Creates a subnet in a specified VPC.
     * You must specify an IPv4 CIDR block for the subnet. After you create a subnet, you
     * can't change its CIDR block. The allowed block size is between a /16 netmask (65,536 IP
     * addresses) and /28 netmask (16 IP addresses). The CIDR block must not overlap with the
     * CIDR block of an existing subnet in the VPC.
     * If you've associated an IPv6 CIDR block with your VPC, you can create a subnet with an
     * IPv6 CIDR block that uses a /64 prefix length.
     * Amazon Web Services reserves both the first four and the last IPv4 address in each subnet's CIDR
     * block. They're not available for use.
     * If you add more than one subnet to a VPC, they're set up in a star topology with a
     * logical router in the middle.
     * When you stop an instance in a subnet, it retains its private IPv4 address. It's
     * therefore possible to have a subnet with no running instances (they're all stopped), but
     * no remaining IP addresses available.
     * For more information about subnets, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and subnets in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createSubnet(block: CreateSubnetRequest.DslBuilder.() -> Unit) = createSubnet(CreateSubnetRequest.builder().apply(block).build())

    /**
     * Creates a subnet CIDR reservation. For information about subnet CIDR reservations, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html">Subnet CIDR reservations in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createSubnetCidrReservation(input: CreateSubnetCidrReservationRequest): CreateSubnetCidrReservationResponse

    /**
     * Creates a subnet CIDR reservation. For information about subnet CIDR reservations, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html">Subnet CIDR reservations in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createSubnetCidrReservation(block: CreateSubnetCidrReservationRequest.DslBuilder.() -> Unit) = createSubnetCidrReservation(CreateSubnetCidrReservationRequest.builder().apply(block).build())

    /**
     * Adds or overwrites only the specified tags for the specified Amazon EC2 resource or
     * resources. When you specify an existing tag key, the value is overwritten with
     * the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and
     * optional value. Tag keys must be unique per resource.
     * For more information about tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources in the
     * Amazon Elastic Compute Cloud User Guide. For more information about
     * creating IAM policies that control users' access to resources based on tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html">Supported
     * Resource-Level Permissions for Amazon EC2 API Actions in the Amazon
     * Elastic Compute Cloud User Guide.
     */
    suspend fun createTags(input: CreateTagsRequest): CreateTagsResponse

    /**
     * Adds or overwrites only the specified tags for the specified Amazon EC2 resource or
     * resources. When you specify an existing tag key, the value is overwritten with
     * the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and
     * optional value. Tag keys must be unique per resource.
     * For more information about tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources in the
     * Amazon Elastic Compute Cloud User Guide. For more information about
     * creating IAM policies that control users' access to resources based on tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html">Supported
     * Resource-Level Permissions for Amazon EC2 API Actions in the Amazon
     * Elastic Compute Cloud User Guide.
     */
    suspend fun createTags(block: CreateTagsRequest.DslBuilder.() -> Unit) = createTags(CreateTagsRequest.builder().apply(block).build())

    /**
     * Creates a Traffic Mirror filter.
     * A Traffic Mirror filter is a set of rules that defines the traffic to mirror.
     * By default, no traffic is mirrored. To mirror traffic, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm">CreateTrafficMirrorFilterRule to add Traffic Mirror rules to the filter. The rules you
     * add define what traffic gets mirrored. You can also use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html">ModifyTrafficMirrorFilterNetworkServices to mirror supported network services.
     */
    suspend fun createTrafficMirrorFilter(input: CreateTrafficMirrorFilterRequest): CreateTrafficMirrorFilterResponse

    /**
     * Creates a Traffic Mirror filter.
     * A Traffic Mirror filter is a set of rules that defines the traffic to mirror.
     * By default, no traffic is mirrored. To mirror traffic, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm">CreateTrafficMirrorFilterRule to add Traffic Mirror rules to the filter. The rules you
     * add define what traffic gets mirrored. You can also use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html">ModifyTrafficMirrorFilterNetworkServices to mirror supported network services.
     */
    suspend fun createTrafficMirrorFilter(block: CreateTrafficMirrorFilterRequest.DslBuilder.() -> Unit) = createTrafficMirrorFilter(CreateTrafficMirrorFilterRequest.builder().apply(block).build())

    /**
     * Creates a Traffic Mirror filter rule.
     * A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror.
     * You need the Traffic Mirror filter ID when you create the rule.
     */
    suspend fun createTrafficMirrorFilterRule(input: CreateTrafficMirrorFilterRuleRequest): CreateTrafficMirrorFilterRuleResponse

    /**
     * Creates a Traffic Mirror filter rule.
     * A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror.
     * You need the Traffic Mirror filter ID when you create the rule.
     */
    suspend fun createTrafficMirrorFilterRule(block: CreateTrafficMirrorFilterRuleRequest.DslBuilder.() -> Unit) = createTrafficMirrorFilterRule(CreateTrafficMirrorFilterRuleRequest.builder().apply(block).build())

    /**
     * Creates a Traffic Mirror session.
     * A Traffic Mirror session actively copies packets from a Traffic Mirror source to a Traffic Mirror target. Create a filter, and then assign it
     * to the session to define a subset of the traffic to mirror, for example all TCP
     * traffic.
     * The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in a different VPC connected via VPC peering or a transit gateway.
     * By default, no traffic is mirrored. Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.htm">CreateTrafficMirrorFilter to
     * create filter rules that specify the traffic to mirror.
     */
    suspend fun createTrafficMirrorSession(input: CreateTrafficMirrorSessionRequest): CreateTrafficMirrorSessionResponse

    /**
     * Creates a Traffic Mirror session.
     * A Traffic Mirror session actively copies packets from a Traffic Mirror source to a Traffic Mirror target. Create a filter, and then assign it
     * to the session to define a subset of the traffic to mirror, for example all TCP
     * traffic.
     * The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in a different VPC connected via VPC peering or a transit gateway.
     * By default, no traffic is mirrored. Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.htm">CreateTrafficMirrorFilter to
     * create filter rules that specify the traffic to mirror.
     */
    suspend fun createTrafficMirrorSession(block: CreateTrafficMirrorSessionRequest.DslBuilder.() -> Unit) = createTrafficMirrorSession(CreateTrafficMirrorSessionRequest.builder().apply(block).build())

    /**
     * Creates a target for your Traffic Mirror session.
     * A Traffic Mirror target is the destination for mirrored traffic. The Traffic Mirror source and
     * the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in
     * different VPCs connected via VPC peering or a transit gateway.
     * A Traffic Mirror target can be a network interface, or a Network Load Balancer.
     * To use the target in a Traffic Mirror session, use  <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm">CreateTrafficMirrorSession.
     */
    suspend fun createTrafficMirrorTarget(input: CreateTrafficMirrorTargetRequest): CreateTrafficMirrorTargetResponse

    /**
     * Creates a target for your Traffic Mirror session.
     * A Traffic Mirror target is the destination for mirrored traffic. The Traffic Mirror source and
     * the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in
     * different VPCs connected via VPC peering or a transit gateway.
     * A Traffic Mirror target can be a network interface, or a Network Load Balancer.
     * To use the target in a Traffic Mirror session, use  <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm">CreateTrafficMirrorSession.
     */
    suspend fun createTrafficMirrorTarget(block: CreateTrafficMirrorTargetRequest.DslBuilder.() -> Unit) = createTrafficMirrorTarget(CreateTrafficMirrorTargetRequest.builder().apply(block).build())

    /**
     * Creates a transit gateway.
     * You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks.
     * After the transit gateway enters the available state, you can attach your VPCs and VPN
     * connections to the transit gateway.
     * To attach your VPCs, use CreateTransitGatewayVpcAttachment.
     * To attach a VPN connection, use CreateCustomerGateway to create a customer
     * gateway and specify the ID of the customer gateway and the ID of the transit gateway in a call to
     * CreateVpnConnection.
     * When you create a transit gateway, we create a default transit gateway route table and use it as the default association route table
     * and the default propagation route table. You can use CreateTransitGatewayRouteTable to create
     * additional transit gateway route tables. If you disable automatic route propagation, we do not create a default transit gateway route table.
     * You can use EnableTransitGatewayRouteTablePropagation to propagate routes from a resource
     * attachment to a transit gateway route table. If you disable automatic associations, you can use AssociateTransitGatewayRouteTable to associate a resource attachment with a transit gateway route table.
     */
    suspend fun createTransitGateway(input: CreateTransitGatewayRequest): CreateTransitGatewayResponse

    /**
     * Creates a transit gateway.
     * You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks.
     * After the transit gateway enters the available state, you can attach your VPCs and VPN
     * connections to the transit gateway.
     * To attach your VPCs, use CreateTransitGatewayVpcAttachment.
     * To attach a VPN connection, use CreateCustomerGateway to create a customer
     * gateway and specify the ID of the customer gateway and the ID of the transit gateway in a call to
     * CreateVpnConnection.
     * When you create a transit gateway, we create a default transit gateway route table and use it as the default association route table
     * and the default propagation route table. You can use CreateTransitGatewayRouteTable to create
     * additional transit gateway route tables. If you disable automatic route propagation, we do not create a default transit gateway route table.
     * You can use EnableTransitGatewayRouteTablePropagation to propagate routes from a resource
     * attachment to a transit gateway route table. If you disable automatic associations, you can use AssociateTransitGatewayRouteTable to associate a resource attachment with a transit gateway route table.
     */
    suspend fun createTransitGateway(block: CreateTransitGatewayRequest.DslBuilder.() -> Unit) = createTransitGateway(CreateTransitGatewayRequest.builder().apply(block).build())

    /**
     * Creates a Connect attachment from a specified transit gateway attachment. A Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection between a transit gateway and an appliance.
     * A Connect attachment uses an existing VPC or Amazon Web Services Direct Connect attachment as the underlying transport mechanism.
     */
    suspend fun createTransitGatewayConnect(input: CreateTransitGatewayConnectRequest): CreateTransitGatewayConnectResponse

    /**
     * Creates a Connect attachment from a specified transit gateway attachment. A Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection between a transit gateway and an appliance.
     * A Connect attachment uses an existing VPC or Amazon Web Services Direct Connect attachment as the underlying transport mechanism.
     */
    suspend fun createTransitGatewayConnect(block: CreateTransitGatewayConnectRequest.DslBuilder.() -> Unit) = createTransitGatewayConnect(CreateTransitGatewayConnectRequest.builder().apply(block).build())

    /**
     * Creates a Connect peer for a specified transit gateway Connect attachment between a
     * transit gateway and an appliance.
     * The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer">Connect peers in the Transit Gateways Guide.
     */
    suspend fun createTransitGatewayConnectPeer(input: CreateTransitGatewayConnectPeerRequest): CreateTransitGatewayConnectPeerResponse

    /**
     * Creates a Connect peer for a specified transit gateway Connect attachment between a
     * transit gateway and an appliance.
     * The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer">Connect peers in the Transit Gateways Guide.
     */
    suspend fun createTransitGatewayConnectPeer(block: CreateTransitGatewayConnectPeerRequest.DslBuilder.() -> Unit) = createTransitGatewayConnectPeer(CreateTransitGatewayConnectPeerRequest.builder().apply(block).build())

    /**
     * Creates a multicast domain using the specified transit gateway.
     * The transit gateway  must be in the available state before you create a domain. Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html">DescribeTransitGateways to see the state of transit gateway.
     */
    suspend fun createTransitGatewayMulticastDomain(input: CreateTransitGatewayMulticastDomainRequest): CreateTransitGatewayMulticastDomainResponse

    /**
     * Creates a multicast domain using the specified transit gateway.
     * The transit gateway  must be in the available state before you create a domain. Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html">DescribeTransitGateways to see the state of transit gateway.
     */
    suspend fun createTransitGatewayMulticastDomain(block: CreateTransitGatewayMulticastDomainRequest.DslBuilder.() -> Unit) = createTransitGatewayMulticastDomain(CreateTransitGatewayMulticastDomainRequest.builder().apply(block).build())

    /**
     * Requests a transit gateway peering attachment between the specified transit gateway
     * (requester) and a peer transit gateway (accepter). The transit gateways must be in
     * different Regions. The peer transit gateway can be in your account or a different
     * Amazon Web Services account.
     * After you create the peering attachment, the owner of the accepter transit gateway
     * must accept the attachment request.
     */
    suspend fun createTransitGatewayPeeringAttachment(input: CreateTransitGatewayPeeringAttachmentRequest): CreateTransitGatewayPeeringAttachmentResponse

    /**
     * Requests a transit gateway peering attachment between the specified transit gateway
     * (requester) and a peer transit gateway (accepter). The transit gateways must be in
     * different Regions. The peer transit gateway can be in your account or a different
     * Amazon Web Services account.
     * After you create the peering attachment, the owner of the accepter transit gateway
     * must accept the attachment request.
     */
    suspend fun createTransitGatewayPeeringAttachment(block: CreateTransitGatewayPeeringAttachmentRequest.DslBuilder.() -> Unit) = createTransitGatewayPeeringAttachment(CreateTransitGatewayPeeringAttachmentRequest.builder().apply(block).build())

    /**
     * Creates a reference (route) to a prefix list in a specified transit gateway route table.
     */
    suspend fun createTransitGatewayPrefixListReference(input: CreateTransitGatewayPrefixListReferenceRequest): CreateTransitGatewayPrefixListReferenceResponse

    /**
     * Creates a reference (route) to a prefix list in a specified transit gateway route table.
     */
    suspend fun createTransitGatewayPrefixListReference(block: CreateTransitGatewayPrefixListReferenceRequest.DslBuilder.() -> Unit) = createTransitGatewayPrefixListReference(CreateTransitGatewayPrefixListReferenceRequest.builder().apply(block).build())

    /**
     * Creates a static route for the specified transit gateway route table.
     */
    suspend fun createTransitGatewayRoute(input: CreateTransitGatewayRouteRequest): CreateTransitGatewayRouteResponse

    /**
     * Creates a static route for the specified transit gateway route table.
     */
    suspend fun createTransitGatewayRoute(block: CreateTransitGatewayRouteRequest.DslBuilder.() -> Unit) = createTransitGatewayRoute(CreateTransitGatewayRouteRequest.builder().apply(block).build())

    /**
     * Creates a route table for the specified transit gateway.
     */
    suspend fun createTransitGatewayRouteTable(input: CreateTransitGatewayRouteTableRequest): CreateTransitGatewayRouteTableResponse

    /**
     * Creates a route table for the specified transit gateway.
     */
    suspend fun createTransitGatewayRouteTable(block: CreateTransitGatewayRouteTableRequest.DslBuilder.() -> Unit) = createTransitGatewayRouteTable(CreateTransitGatewayRouteTableRequest.builder().apply(block).build())

    /**
     * Attaches the specified VPC to the specified transit gateway.
     * If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC that is already attached,
     * the new VPC CIDR range is not propagated to the default propagation route table.
     * To send VPC traffic to an attached transit gateway, add a route to the VPC route table using CreateRoute.
     */
    suspend fun createTransitGatewayVpcAttachment(input: CreateTransitGatewayVpcAttachmentRequest): CreateTransitGatewayVpcAttachmentResponse

    /**
     * Attaches the specified VPC to the specified transit gateway.
     * If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC that is already attached,
     * the new VPC CIDR range is not propagated to the default propagation route table.
     * To send VPC traffic to an attached transit gateway, add a route to the VPC route table using CreateRoute.
     */
    suspend fun createTransitGatewayVpcAttachment(block: CreateTransitGatewayVpcAttachmentRequest.DslBuilder.() -> Unit) = createTransitGatewayVpcAttachment(CreateTransitGatewayVpcAttachmentRequest.builder().apply(block).build())

    /**
     * Creates an EBS volume that can be attached to an instance in the same Availability Zone.
     * You can create a new empty volume or restore a volume from an EBS snapshot.
     * Any Amazon Web Services Marketplace product codes from the snapshot are propagated to the volume.
     * You can create encrypted volumes. Encrypted volumes must be attached to instances that
     * support Amazon EBS encryption. Volumes that are created from encrypted snapshots are also automatically
     * encrypted. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption
     * in the Amazon Elastic Compute Cloud User Guide.
     * You can tag your volumes during creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2
     * resources in the Amazon Elastic Compute Cloud User Guide.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html">Create an Amazon EBS volume in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createVolume(input: CreateVolumeRequest): CreateVolumeResponse

    /**
     * Creates an EBS volume that can be attached to an instance in the same Availability Zone.
     * You can create a new empty volume or restore a volume from an EBS snapshot.
     * Any Amazon Web Services Marketplace product codes from the snapshot are propagated to the volume.
     * You can create encrypted volumes. Encrypted volumes must be attached to instances that
     * support Amazon EBS encryption. Volumes that are created from encrypted snapshots are also automatically
     * encrypted. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption
     * in the Amazon Elastic Compute Cloud User Guide.
     * You can tag your volumes during creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2
     * resources in the Amazon Elastic Compute Cloud User Guide.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html">Create an Amazon EBS volume in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createVolume(block: CreateVolumeRequest.DslBuilder.() -> Unit) = createVolume(CreateVolumeRequest.builder().apply(block).build())

    /**
     * Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you can create
     * uses a /28 netmask (16 IPv4 addresses), and the largest uses a /16 netmask (65,536 IPv4
     * addresses). For more information about how large to make your VPC, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and
     * subnets in the Amazon Virtual Private Cloud User Guide.
     * You can optionally request an IPv6 CIDR block for the VPC. You can request an Amazon-provided
     * IPv6 CIDR block from Amazon's pool of IPv6 addresses, or an IPv6 CIDR block from an IPv6 address
     * pool that you provisioned through bring your own IP addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP).
     * By default, each instance you launch in the VPC has the default DHCP options, which
     * include only a default DNS server that we provide (AmazonProvidedDNS). For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets in the Amazon Virtual Private Cloud User Guide.
     * You can specify the instance tenancy value for the VPC when you create it. You can't change
     * this value for the VPC after you create it. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createVpc(input: CreateVpcRequest): CreateVpcResponse

    /**
     * Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you can create
     * uses a /28 netmask (16 IPv4 addresses), and the largest uses a /16 netmask (65,536 IPv4
     * addresses). For more information about how large to make your VPC, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and
     * subnets in the Amazon Virtual Private Cloud User Guide.
     * You can optionally request an IPv6 CIDR block for the VPC. You can request an Amazon-provided
     * IPv6 CIDR block from Amazon's pool of IPv6 addresses, or an IPv6 CIDR block from an IPv6 address
     * pool that you provisioned through bring your own IP addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP).
     * By default, each instance you launch in the VPC has the default DHCP options, which
     * include only a default DNS server that we provide (AmazonProvidedDNS). For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets in the Amazon Virtual Private Cloud User Guide.
     * You can specify the instance tenancy value for the VPC when you create it. You can't change
     * this value for the VPC after you create it. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun createVpc(block: CreateVpcRequest.DslBuilder.() -> Unit) = createVpc(CreateVpcRequest.builder().apply(block).build())

    /**
     * Creates a VPC endpoint for a specified service. An endpoint enables you to create a
     * private connection between your VPC and the service. The service may be provided by Amazon Web Services,
     * an Amazon Web Services Marketplace Partner, or another Amazon Web Services account. For more information,
     * see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints.html">VPC Endpoints in the
     * Amazon Virtual Private Cloud User Guide.
     * A gateway endpoint serves as a target for a route in your route table for
     * traffic destined for the Amazon Web Service. You can specify an endpoint policy to attach
     * to the endpoint, which will control access to the service from your VPC. You can also
     * specify the VPC route tables that use the endpoint.
     * An interface endpoint is a network interface in your subnet that
     * serves as an endpoint for communicating with the specified service. You can specify the
     * subnets in which to create an endpoint, and the security groups to associate with the
     * endpoint network interface.
     * A GatewayLoadBalancer endpoint is a network interface in your subnet that serves an endpoint for communicating with a Gateway Load Balancer that you've configured as a VPC endpoint service.
     * Use DescribeVpcEndpointServices to get a list of supported
     * services.
     */
    suspend fun createVpcEndpoint(input: CreateVpcEndpointRequest): CreateVpcEndpointResponse

    /**
     * Creates a VPC endpoint for a specified service. An endpoint enables you to create a
     * private connection between your VPC and the service. The service may be provided by Amazon Web Services,
     * an Amazon Web Services Marketplace Partner, or another Amazon Web Services account. For more information,
     * see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints.html">VPC Endpoints in the
     * Amazon Virtual Private Cloud User Guide.
     * A gateway endpoint serves as a target for a route in your route table for
     * traffic destined for the Amazon Web Service. You can specify an endpoint policy to attach
     * to the endpoint, which will control access to the service from your VPC. You can also
     * specify the VPC route tables that use the endpoint.
     * An interface endpoint is a network interface in your subnet that
     * serves as an endpoint for communicating with the specified service. You can specify the
     * subnets in which to create an endpoint, and the security groups to associate with the
     * endpoint network interface.
     * A GatewayLoadBalancer endpoint is a network interface in your subnet that serves an endpoint for communicating with a Gateway Load Balancer that you've configured as a VPC endpoint service.
     * Use DescribeVpcEndpointServices to get a list of supported
     * services.
     */
    suspend fun createVpcEndpoint(block: CreateVpcEndpointRequest.DslBuilder.() -> Unit) = createVpcEndpoint(CreateVpcEndpointRequest.builder().apply(block).build())

    /**
     * Creates a connection notification for a specified VPC endpoint or VPC endpoint
     * service. A connection notification notifies you of specific endpoint events. You must
     * create an SNS topic to receive notifications. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Create a Topic in
     * the Amazon Simple Notification Service Developer Guide.
     * You can create a connection notification for interface endpoints only.
     */
    suspend fun createVpcEndpointConnectionNotification(input: CreateVpcEndpointConnectionNotificationRequest): CreateVpcEndpointConnectionNotificationResponse

    /**
     * Creates a connection notification for a specified VPC endpoint or VPC endpoint
     * service. A connection notification notifies you of specific endpoint events. You must
     * create an SNS topic to receive notifications. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Create a Topic in
     * the Amazon Simple Notification Service Developer Guide.
     * You can create a connection notification for interface endpoints only.
     */
    suspend fun createVpcEndpointConnectionNotification(block: CreateVpcEndpointConnectionNotificationRequest.DslBuilder.() -> Unit) = createVpcEndpointConnectionNotification(CreateVpcEndpointConnectionNotificationRequest.builder().apply(block).build())

    /**
     * Creates a VPC endpoint service configuration to which service consumers (Amazon Web Services accounts,
     * IAM users, and IAM roles) can connect.
     * To create an endpoint service configuration, you must first create one of the
     * following for your service:
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/introduction.html">Network Load Balancer. Service consumers connect to your service using an
     * interface endpoint.
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/introduction.html">Gateway Load Balancer. Service consumers connect to your service using a
     * Gateway Load Balancer endpoint.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html">VPC Endpoint Services in the
     * Amazon Virtual Private Cloud User Guide.
     * If you set the private DNS name, you must prove that you own the private DNS domain
     * name. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html">VPC Endpoint Service
     * Private DNS Name Verification in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createVpcEndpointServiceConfiguration(input: CreateVpcEndpointServiceConfigurationRequest): CreateVpcEndpointServiceConfigurationResponse

    /**
     * Creates a VPC endpoint service configuration to which service consumers (Amazon Web Services accounts,
     * IAM users, and IAM roles) can connect.
     * To create an endpoint service configuration, you must first create one of the
     * following for your service:
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/introduction.html">Network Load Balancer. Service consumers connect to your service using an
     * interface endpoint.
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/introduction.html">Gateway Load Balancer. Service consumers connect to your service using a
     * Gateway Load Balancer endpoint.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html">VPC Endpoint Services in the
     * Amazon Virtual Private Cloud User Guide.
     * If you set the private DNS name, you must prove that you own the private DNS domain
     * name. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html">VPC Endpoint Service
     * Private DNS Name Verification in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun createVpcEndpointServiceConfiguration(block: CreateVpcEndpointServiceConfigurationRequest.DslBuilder.() -> Unit) = createVpcEndpointServiceConfiguration(CreateVpcEndpointServiceConfigurationRequest.builder().apply(block).build())

    /**
     * Requests a VPC peering connection between two VPCs: a requester VPC that you own and
     * an accepter VPC with which to create the connection. The accepter VPC can belong to
     * another Amazon Web Services account and can be in a different Region to the requester VPC.
     * The requester VPC and accepter VPC cannot have overlapping CIDR blocks.
     * Limitations and rules apply to a VPC peering connection. For more information, see
     * the <a href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations">limitations section in the VPC Peering Guide.
     * The owner of the accepter VPC must accept the peering request to activate the peering
     * connection. The VPC peering connection request expires after 7 days, after which it
     * cannot be accepted or rejected.
     * If you create a VPC peering connection request between VPCs with overlapping CIDR
     * blocks, the VPC peering connection has a status of failed.
     */
    suspend fun createVpcPeeringConnection(input: CreateVpcPeeringConnectionRequest): CreateVpcPeeringConnectionResponse

    /**
     * Requests a VPC peering connection between two VPCs: a requester VPC that you own and
     * an accepter VPC with which to create the connection. The accepter VPC can belong to
     * another Amazon Web Services account and can be in a different Region to the requester VPC.
     * The requester VPC and accepter VPC cannot have overlapping CIDR blocks.
     * Limitations and rules apply to a VPC peering connection. For more information, see
     * the <a href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations">limitations section in the VPC Peering Guide.
     * The owner of the accepter VPC must accept the peering request to activate the peering
     * connection. The VPC peering connection request expires after 7 days, after which it
     * cannot be accepted or rejected.
     * If you create a VPC peering connection request between VPCs with overlapping CIDR
     * blocks, the VPC peering connection has a status of failed.
     */
    suspend fun createVpcPeeringConnection(block: CreateVpcPeeringConnectionRequest.DslBuilder.() -> Unit) = createVpcPeeringConnection(CreateVpcPeeringConnectionRequest.builder().apply(block).build())

    /**
     * Creates a VPN connection between an existing virtual private gateway or transit
     * gateway and a customer gateway. The supported connection type is
     * ipsec.1.
     * The response includes information that you need to give to your network administrator
     * to configure your customer gateway.
     * We strongly recommend that you use HTTPS when calling this operation because the
     * response contains sensitive cryptographic information for configuring your customer
     * gateway device.
     * If you decide to shut down your VPN connection for any reason and later create a new
     * VPN connection, you must reconfigure your customer gateway with the new information
     * returned from this call.
     * This is an idempotent operation. If you perform the operation more than once, Amazon
     * EC2 doesn't return an error.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    suspend fun createVpnConnection(input: CreateVpnConnectionRequest): CreateVpnConnectionResponse

    /**
     * Creates a VPN connection between an existing virtual private gateway or transit
     * gateway and a customer gateway. The supported connection type is
     * ipsec.1.
     * The response includes information that you need to give to your network administrator
     * to configure your customer gateway.
     * We strongly recommend that you use HTTPS when calling this operation because the
     * response contains sensitive cryptographic information for configuring your customer
     * gateway device.
     * If you decide to shut down your VPN connection for any reason and later create a new
     * VPN connection, you must reconfigure your customer gateway with the new information
     * returned from this call.
     * This is an idempotent operation. If you perform the operation more than once, Amazon
     * EC2 doesn't return an error.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    suspend fun createVpnConnection(block: CreateVpnConnectionRequest.DslBuilder.() -> Unit) = createVpnConnection(CreateVpnConnectionRequest.builder().apply(block).build())

    /**
     * Creates a static route associated with a VPN connection between an existing virtual
     * private gateway and a VPN customer gateway. The static route allows traffic to be routed
     * from the virtual private gateway to the VPN customer gateway.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    suspend fun createVpnConnectionRoute(input: CreateVpnConnectionRouteRequest): CreateVpnConnectionRouteResponse

    /**
     * Creates a static route associated with a VPN connection between an existing virtual
     * private gateway and a VPN customer gateway. The static route allows traffic to be routed
     * from the virtual private gateway to the VPN customer gateway.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    suspend fun createVpnConnectionRoute(block: CreateVpnConnectionRouteRequest.DslBuilder.() -> Unit) = createVpnConnectionRoute(CreateVpnConnectionRouteRequest.builder().apply(block).build())

    /**
     * Creates a virtual private gateway. A virtual private gateway is the endpoint on the
     * VPC side of your VPN connection. You can create a virtual private gateway before
     * creating the VPC itself.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    suspend fun createVpnGateway(input: CreateVpnGatewayRequest): CreateVpnGatewayResponse

    /**
     * Creates a virtual private gateway. A virtual private gateway is the endpoint on the
     * VPC side of your VPN connection. You can create a virtual private gateway before
     * creating the VPC itself.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    suspend fun createVpnGateway(block: CreateVpnGatewayRequest.DslBuilder.() -> Unit) = createVpnGateway(CreateVpnGatewayRequest.builder().apply(block).build())

    /**
     * Deletes a carrier gateway.
     * If you do not delete the route that contains the carrier gateway as the
     * Target, the route is a blackhole route. For information about how to delete a route, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html">DeleteRoute.
     */
    suspend fun deleteCarrierGateway(input: DeleteCarrierGatewayRequest): DeleteCarrierGatewayResponse

    /**
     * Deletes a carrier gateway.
     * If you do not delete the route that contains the carrier gateway as the
     * Target, the route is a blackhole route. For information about how to delete a route, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html">DeleteRoute.
     */
    suspend fun deleteCarrierGateway(block: DeleteCarrierGatewayRequest.DslBuilder.() -> Unit) = deleteCarrierGateway(DeleteCarrierGatewayRequest.builder().apply(block).build())

    /**
     * Deletes the specified Client VPN endpoint. You must disassociate all target networks before you
     * can delete a Client VPN endpoint.
     */
    suspend fun deleteClientVpnEndpoint(input: DeleteClientVpnEndpointRequest): DeleteClientVpnEndpointResponse

    /**
     * Deletes the specified Client VPN endpoint. You must disassociate all target networks before you
     * can delete a Client VPN endpoint.
     */
    suspend fun deleteClientVpnEndpoint(block: DeleteClientVpnEndpointRequest.DslBuilder.() -> Unit) = deleteClientVpnEndpoint(DeleteClientVpnEndpointRequest.builder().apply(block).build())

    /**
     * Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using
     * the CreateClientVpnRoute action. You cannot delete routes that were
     * automatically added when associating a subnet. To remove routes that have been automatically added,
     * disassociate the target subnet from the Client VPN endpoint.
     */
    suspend fun deleteClientVpnRoute(input: DeleteClientVpnRouteRequest): DeleteClientVpnRouteResponse

    /**
     * Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using
     * the CreateClientVpnRoute action. You cannot delete routes that were
     * automatically added when associating a subnet. To remove routes that have been automatically added,
     * disassociate the target subnet from the Client VPN endpoint.
     */
    suspend fun deleteClientVpnRoute(block: DeleteClientVpnRouteRequest.DslBuilder.() -> Unit) = deleteClientVpnRoute(DeleteClientVpnRouteRequest.builder().apply(block).build())

    /**
     * Deletes the specified customer gateway. You must delete the VPN connection before you
     * can delete the customer gateway.
     */
    suspend fun deleteCustomerGateway(input: DeleteCustomerGatewayRequest): DeleteCustomerGatewayResponse

    /**
     * Deletes the specified customer gateway. You must delete the VPN connection before you
     * can delete the customer gateway.
     */
    suspend fun deleteCustomerGateway(block: DeleteCustomerGatewayRequest.DslBuilder.() -> Unit) = deleteCustomerGateway(DeleteCustomerGatewayRequest.builder().apply(block).build())

    /**
     * Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of options with the VPC.
     */
    suspend fun deleteDhcpOptions(input: DeleteDhcpOptionsRequest): DeleteDhcpOptionsResponse

    /**
     * Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of options with the VPC.
     */
    suspend fun deleteDhcpOptions(block: DeleteDhcpOptionsRequest.DslBuilder.() -> Unit) = deleteDhcpOptions(DeleteDhcpOptionsRequest.builder().apply(block).build())

    /**
     * Deletes an egress-only internet gateway.
     */
    suspend fun deleteEgressOnlyInternetGateway(input: DeleteEgressOnlyInternetGatewayRequest): DeleteEgressOnlyInternetGatewayResponse

    /**
     * Deletes an egress-only internet gateway.
     */
    suspend fun deleteEgressOnlyInternetGateway(block: DeleteEgressOnlyInternetGatewayRequest.DslBuilder.() -> Unit) = deleteEgressOnlyInternetGateway(DeleteEgressOnlyInternetGatewayRequest.builder().apply(block).build())

    /**
     * Deletes the specified EC2 Fleet.
     * After you delete an EC2 Fleet, it launches no new instances.
     * You must specify whether a deleted EC2 Fleet should also terminate its instances. If you
     * choose to terminate the instances, the EC2 Fleet enters the deleted_terminating
     * state. Otherwise, the EC2 Fleet enters the deleted_running state, and the instances
     * continue to run until they are interrupted or you terminate them manually.
     * For instant fleets, EC2 Fleet must terminate the instances when the fleet is
     * deleted. A deleted instant fleet with running instances is not
     * supported.
     * <p class="title">
     * Restrictions
     * You can delete up to 25 instant fleets in a single request. If you exceed this
     * number, no instant fleets are deleted and an error is returned. There is no
     * restriction on the number of fleets of type maintain or request that can be deleted
     * in a single request.
     * Up to 1000 instances can be terminated in a single request to delete
     * instant fleets.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#delete-fleet">Deleting an EC2
     * Fleet in the Amazon EC2 User Guide.
     */
    suspend fun deleteFleets(input: DeleteFleetsRequest): DeleteFleetsResponse

    /**
     * Deletes the specified EC2 Fleet.
     * After you delete an EC2 Fleet, it launches no new instances.
     * You must specify whether a deleted EC2 Fleet should also terminate its instances. If you
     * choose to terminate the instances, the EC2 Fleet enters the deleted_terminating
     * state. Otherwise, the EC2 Fleet enters the deleted_running state, and the instances
     * continue to run until they are interrupted or you terminate them manually.
     * For instant fleets, EC2 Fleet must terminate the instances when the fleet is
     * deleted. A deleted instant fleet with running instances is not
     * supported.
     * <p class="title">
     * Restrictions
     * You can delete up to 25 instant fleets in a single request. If you exceed this
     * number, no instant fleets are deleted and an error is returned. There is no
     * restriction on the number of fleets of type maintain or request that can be deleted
     * in a single request.
     * Up to 1000 instances can be terminated in a single request to delete
     * instant fleets.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#delete-fleet">Deleting an EC2
     * Fleet in the Amazon EC2 User Guide.
     */
    suspend fun deleteFleets(block: DeleteFleetsRequest.DslBuilder.() -> Unit) = deleteFleets(DeleteFleetsRequest.builder().apply(block).build())

    /**
     * Deletes one or more flow logs.
     */
    suspend fun deleteFlowLogs(input: DeleteFlowLogsRequest): DeleteFlowLogsResponse

    /**
     * Deletes one or more flow logs.
     */
    suspend fun deleteFlowLogs(block: DeleteFlowLogsRequest.DslBuilder.() -> Unit) = deleteFlowLogs(DeleteFlowLogsRequest.builder().apply(block).build())

    /**
     * Deletes the specified Amazon FPGA Image (AFI).
     */
    suspend fun deleteFpgaImage(input: DeleteFpgaImageRequest): DeleteFpgaImageResponse

    /**
     * Deletes the specified Amazon FPGA Image (AFI).
     */
    suspend fun deleteFpgaImage(block: DeleteFpgaImageRequest.DslBuilder.() -> Unit) = deleteFpgaImage(DeleteFpgaImageRequest.builder().apply(block).build())

    /**
     * Deletes the specified event window.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    suspend fun deleteInstanceEventWindow(input: DeleteInstanceEventWindowRequest): DeleteInstanceEventWindowResponse

    /**
     * Deletes the specified event window.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    suspend fun deleteInstanceEventWindow(block: DeleteInstanceEventWindowRequest.DslBuilder.() -> Unit) = deleteInstanceEventWindow(DeleteInstanceEventWindowRequest.builder().apply(block).build())

    /**
     * Deletes the specified internet gateway. You must detach the internet gateway from the
     * VPC before you can delete it.
     */
    suspend fun deleteInternetGateway(input: DeleteInternetGatewayRequest): DeleteInternetGatewayResponse

    /**
     * Deletes the specified internet gateway. You must detach the internet gateway from the
     * VPC before you can delete it.
     */
    suspend fun deleteInternetGateway(block: DeleteInternetGatewayRequest.DslBuilder.() -> Unit) = deleteInternetGateway(DeleteInternetGatewayRequest.builder().apply(block).build())

    /**
     * Deletes the specified key pair, by removing the public key from Amazon EC2.
     */
    suspend fun deleteKeyPair(input: DeleteKeyPairRequest): DeleteKeyPairResponse

    /**
     * Deletes the specified key pair, by removing the public key from Amazon EC2.
     */
    suspend fun deleteKeyPair(block: DeleteKeyPairRequest.DslBuilder.() -> Unit) = deleteKeyPair(DeleteKeyPairRequest.builder().apply(block).build())

    /**
     * Deletes a launch template. Deleting a launch template deletes all of its versions.
     */
    suspend fun deleteLaunchTemplate(input: DeleteLaunchTemplateRequest): DeleteLaunchTemplateResponse

    /**
     * Deletes a launch template. Deleting a launch template deletes all of its versions.
     */
    suspend fun deleteLaunchTemplate(block: DeleteLaunchTemplateRequest.DslBuilder.() -> Unit) = deleteLaunchTemplate(DeleteLaunchTemplateRequest.builder().apply(block).build())

    /**
     * Deletes one or more versions of a launch template. You cannot delete the default
     * version of a launch template; you must first assign a different version as the default.
     * If the default version is the only version for the launch template, you must delete the
     * entire launch template using DeleteLaunchTemplate.
     */
    suspend fun deleteLaunchTemplateVersions(input: DeleteLaunchTemplateVersionsRequest): DeleteLaunchTemplateVersionsResponse

    /**
     * Deletes one or more versions of a launch template. You cannot delete the default
     * version of a launch template; you must first assign a different version as the default.
     * If the default version is the only version for the launch template, you must delete the
     * entire launch template using DeleteLaunchTemplate.
     */
    suspend fun deleteLaunchTemplateVersions(block: DeleteLaunchTemplateVersionsRequest.DslBuilder.() -> Unit) = deleteLaunchTemplateVersions(DeleteLaunchTemplateVersionsRequest.builder().apply(block).build())

    /**
     * Deletes the specified route from the specified local gateway route table.
     */
    suspend fun deleteLocalGatewayRoute(input: DeleteLocalGatewayRouteRequest): DeleteLocalGatewayRouteResponse

    /**
     * Deletes the specified route from the specified local gateway route table.
     */
    suspend fun deleteLocalGatewayRoute(block: DeleteLocalGatewayRouteRequest.DslBuilder.() -> Unit) = deleteLocalGatewayRoute(DeleteLocalGatewayRouteRequest.builder().apply(block).build())

    /**
     * Deletes the specified association between a VPC and local gateway route table.
     */
    suspend fun deleteLocalGatewayRouteTableVpcAssociation(input: DeleteLocalGatewayRouteTableVpcAssociationRequest): DeleteLocalGatewayRouteTableVpcAssociationResponse

    /**
     * Deletes the specified association between a VPC and local gateway route table.
     */
    suspend fun deleteLocalGatewayRouteTableVpcAssociation(block: DeleteLocalGatewayRouteTableVpcAssociationRequest.DslBuilder.() -> Unit) = deleteLocalGatewayRouteTableVpcAssociation(DeleteLocalGatewayRouteTableVpcAssociationRequest.builder().apply(block).build())

    /**
     * Deletes the specified managed prefix list. You must first remove all references to the prefix list in your resources.
     */
    suspend fun deleteManagedPrefixList(input: DeleteManagedPrefixListRequest): DeleteManagedPrefixListResponse

    /**
     * Deletes the specified managed prefix list. You must first remove all references to the prefix list in your resources.
     */
    suspend fun deleteManagedPrefixList(block: DeleteManagedPrefixListRequest.DslBuilder.() -> Unit) = deleteManagedPrefixList(DeleteManagedPrefixListRequest.builder().apply(block).build())

    /**
     * Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates its Elastic IP address,
     * but does not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway
     * routes in your route tables.
     */
    suspend fun deleteNatGateway(input: DeleteNatGatewayRequest): DeleteNatGatewayResponse

    /**
     * Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates its Elastic IP address,
     * but does not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway
     * routes in your route tables.
     */
    suspend fun deleteNatGateway(block: DeleteNatGatewayRequest.DslBuilder.() -> Unit) = deleteNatGateway(DeleteNatGatewayRequest.builder().apply(block).build())

    /**
     * Deletes the specified network ACL. You can't delete the ACL if it's associated with any subnets. You can't delete the default network ACL.
     */
    suspend fun deleteNetworkAcl(input: DeleteNetworkAclRequest): DeleteNetworkAclResponse

    /**
     * Deletes the specified network ACL. You can't delete the ACL if it's associated with any subnets. You can't delete the default network ACL.
     */
    suspend fun deleteNetworkAcl(block: DeleteNetworkAclRequest.DslBuilder.() -> Unit) = deleteNetworkAcl(DeleteNetworkAclRequest.builder().apply(block).build())

    /**
     * Deletes the specified ingress or egress entry (rule) from the specified network ACL.
     */
    suspend fun deleteNetworkAclEntry(input: DeleteNetworkAclEntryRequest): DeleteNetworkAclEntryResponse

    /**
     * Deletes the specified ingress or egress entry (rule) from the specified network ACL.
     */
    suspend fun deleteNetworkAclEntry(block: DeleteNetworkAclEntryRequest.DslBuilder.() -> Unit) = deleteNetworkAclEntry(DeleteNetworkAclEntryRequest.builder().apply(block).build())

    /**
     * Deletes the specified network insights analysis.
     */
    suspend fun deleteNetworkInsightsAnalysis(input: DeleteNetworkInsightsAnalysisRequest): DeleteNetworkInsightsAnalysisResponse

    /**
     * Deletes the specified network insights analysis.
     */
    suspend fun deleteNetworkInsightsAnalysis(block: DeleteNetworkInsightsAnalysisRequest.DslBuilder.() -> Unit) = deleteNetworkInsightsAnalysis(DeleteNetworkInsightsAnalysisRequest.builder().apply(block).build())

    /**
     * Deletes the specified path.
     */
    suspend fun deleteNetworkInsightsPath(input: DeleteNetworkInsightsPathRequest): DeleteNetworkInsightsPathResponse

    /**
     * Deletes the specified path.
     */
    suspend fun deleteNetworkInsightsPath(block: DeleteNetworkInsightsPathRequest.DslBuilder.() -> Unit) = deleteNetworkInsightsPath(DeleteNetworkInsightsPathRequest.builder().apply(block).build())

    /**
     * Deletes the specified network interface. You must detach the network interface before you can delete it.
     */
    suspend fun deleteNetworkInterface(input: DeleteNetworkInterfaceRequest): DeleteNetworkInterfaceResponse

    /**
     * Deletes the specified network interface. You must detach the network interface before you can delete it.
     */
    suspend fun deleteNetworkInterface(block: DeleteNetworkInterfaceRequest.DslBuilder.() -> Unit) = deleteNetworkInterface(DeleteNetworkInterfaceRequest.builder().apply(block).build())

    /**
     * Deletes a permission for a network interface. By default, you cannot delete the
     * permission if the account for which you're removing the permission has attached the
     * network interface to an instance. However, you can force delete the permission,
     * regardless of any attachment.
     */
    suspend fun deleteNetworkInterfacePermission(input: DeleteNetworkInterfacePermissionRequest): DeleteNetworkInterfacePermissionResponse

    /**
     * Deletes a permission for a network interface. By default, you cannot delete the
     * permission if the account for which you're removing the permission has attached the
     * network interface to an instance. However, you can force delete the permission,
     * regardless of any attachment.
     */
    suspend fun deleteNetworkInterfacePermission(block: DeleteNetworkInterfacePermissionRequest.DslBuilder.() -> Unit) = deleteNetworkInterfacePermission(DeleteNetworkInterfacePermissionRequest.builder().apply(block).build())

    /**
     * Deletes the specified placement group. You must terminate all instances in the
     * placement group before you can delete the placement group. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups in the Amazon EC2 User Guide.
     */
    suspend fun deletePlacementGroup(input: DeletePlacementGroupRequest): DeletePlacementGroupResponse

    /**
     * Deletes the specified placement group. You must terminate all instances in the
     * placement group before you can delete the placement group. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups in the Amazon EC2 User Guide.
     */
    suspend fun deletePlacementGroup(block: DeletePlacementGroupRequest.DslBuilder.() -> Unit) = deletePlacementGroup(DeletePlacementGroupRequest.builder().apply(block).build())

    /**
     * Deletes the queued purchases for the specified Reserved Instances.
     */
    suspend fun deleteQueuedReservedInstances(input: DeleteQueuedReservedInstancesRequest): DeleteQueuedReservedInstancesResponse

    /**
     * Deletes the queued purchases for the specified Reserved Instances.
     */
    suspend fun deleteQueuedReservedInstances(block: DeleteQueuedReservedInstancesRequest.DslBuilder.() -> Unit) = deleteQueuedReservedInstances(DeleteQueuedReservedInstancesRequest.builder().apply(block).build())

    /**
     * Deletes the specified route from the specified route table.
     */
    suspend fun deleteRoute(input: DeleteRouteRequest): DeleteRouteResponse

    /**
     * Deletes the specified route from the specified route table.
     */
    suspend fun deleteRoute(block: DeleteRouteRequest.DslBuilder.() -> Unit) = deleteRoute(DeleteRouteRequest.builder().apply(block).build())

    /**
     * Deletes the specified route table. You must disassociate the route table from any subnets before you can delete it. You can't delete the main route table.
     */
    suspend fun deleteRouteTable(input: DeleteRouteTableRequest): DeleteRouteTableResponse

    /**
     * Deletes the specified route table. You must disassociate the route table from any subnets before you can delete it. You can't delete the main route table.
     */
    suspend fun deleteRouteTable(block: DeleteRouteTableRequest.DslBuilder.() -> Unit) = deleteRouteTable(DeleteRouteTableRequest.builder().apply(block).build())

    /**
     * Deletes a security group.
     * If you attempt to delete a security group that is associated with an instance, or is
     * referenced by another security group, the operation fails with
     * InvalidGroup.InUse in EC2-Classic or
     * DependencyViolation in EC2-VPC.
     */
    suspend fun deleteSecurityGroup(input: DeleteSecurityGroupRequest): DeleteSecurityGroupResponse

    /**
     * Deletes a security group.
     * If you attempt to delete a security group that is associated with an instance, or is
     * referenced by another security group, the operation fails with
     * InvalidGroup.InUse in EC2-Classic or
     * DependencyViolation in EC2-VPC.
     */
    suspend fun deleteSecurityGroup(block: DeleteSecurityGroupRequest.DslBuilder.() -> Unit) = deleteSecurityGroup(DeleteSecurityGroupRequest.builder().apply(block).build())

    /**
     * Deletes the specified snapshot.
     * When you make periodic snapshots of a volume, the snapshots are incremental, and only the
     * blocks on the device that have changed since your last snapshot are saved in the new snapshot.
     * When you delete a snapshot, only the data not needed for any other snapshot is removed. So
     * regardless of which prior snapshots have been deleted, all active snapshots will have access
     * to all the information needed to restore the volume.
     * You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI.
     * You must first de-register the AMI before you can delete the snapshot.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-snapshot.html">Delete an Amazon EBS snapshot in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun deleteSnapshot(input: DeleteSnapshotRequest): DeleteSnapshotResponse

    /**
     * Deletes the specified snapshot.
     * When you make periodic snapshots of a volume, the snapshots are incremental, and only the
     * blocks on the device that have changed since your last snapshot are saved in the new snapshot.
     * When you delete a snapshot, only the data not needed for any other snapshot is removed. So
     * regardless of which prior snapshots have been deleted, all active snapshots will have access
     * to all the information needed to restore the volume.
     * You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI.
     * You must first de-register the AMI before you can delete the snapshot.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-snapshot.html">Delete an Amazon EBS snapshot in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun deleteSnapshot(block: DeleteSnapshotRequest.DslBuilder.() -> Unit) = deleteSnapshot(DeleteSnapshotRequest.builder().apply(block).build())

    /**
     * Deletes the data feed for Spot Instances.
     */
    suspend fun deleteSpotDatafeedSubscription(input: DeleteSpotDatafeedSubscriptionRequest): DeleteSpotDatafeedSubscriptionResponse

    /**
     * Deletes the data feed for Spot Instances.
     */
    suspend fun deleteSpotDatafeedSubscription(block: DeleteSpotDatafeedSubscriptionRequest.DslBuilder.() -> Unit) = deleteSpotDatafeedSubscription(DeleteSpotDatafeedSubscriptionRequest.builder().apply(block).build())

    /**
     * Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the subnet.
     */
    suspend fun deleteSubnet(input: DeleteSubnetRequest): DeleteSubnetResponse

    /**
     * Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the subnet.
     */
    suspend fun deleteSubnet(block: DeleteSubnetRequest.DslBuilder.() -> Unit) = deleteSubnet(DeleteSubnetRequest.builder().apply(block).build())

    /**
     * Deletes a subnet CIDR reservation.
     */
    suspend fun deleteSubnetCidrReservation(input: DeleteSubnetCidrReservationRequest): DeleteSubnetCidrReservationResponse

    /**
     * Deletes a subnet CIDR reservation.
     */
    suspend fun deleteSubnetCidrReservation(block: DeleteSubnetCidrReservationRequest.DslBuilder.() -> Unit) = deleteSubnetCidrReservation(DeleteSubnetCidrReservationRequest.builder().apply(block).build())

    /**
     * Deletes the specified set of tags from the specified set of resources.
     * To list the current tags, use DescribeTags. For more information about tags, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse

    /**
     * Deletes the specified set of tags from the specified set of resources.
     * To list the current tags, use DescribeTags. For more information about tags, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun deleteTags(block: DeleteTagsRequest.DslBuilder.() -> Unit) = deleteTags(DeleteTagsRequest.builder().apply(block).build())

    /**
     * Deletes the specified Traffic Mirror filter.
     * You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror session.
     */
    suspend fun deleteTrafficMirrorFilter(input: DeleteTrafficMirrorFilterRequest): DeleteTrafficMirrorFilterResponse

    /**
     * Deletes the specified Traffic Mirror filter.
     * You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror session.
     */
    suspend fun deleteTrafficMirrorFilter(block: DeleteTrafficMirrorFilterRequest.DslBuilder.() -> Unit) = deleteTrafficMirrorFilter(DeleteTrafficMirrorFilterRequest.builder().apply(block).build())

    /**
     * Deletes the specified Traffic Mirror rule.
     */
    suspend fun deleteTrafficMirrorFilterRule(input: DeleteTrafficMirrorFilterRuleRequest): DeleteTrafficMirrorFilterRuleResponse

    /**
     * Deletes the specified Traffic Mirror rule.
     */
    suspend fun deleteTrafficMirrorFilterRule(block: DeleteTrafficMirrorFilterRuleRequest.DslBuilder.() -> Unit) = deleteTrafficMirrorFilterRule(DeleteTrafficMirrorFilterRuleRequest.builder().apply(block).build())

    /**
     * Deletes the specified Traffic Mirror session.
     */
    suspend fun deleteTrafficMirrorSession(input: DeleteTrafficMirrorSessionRequest): DeleteTrafficMirrorSessionResponse

    /**
     * Deletes the specified Traffic Mirror session.
     */
    suspend fun deleteTrafficMirrorSession(block: DeleteTrafficMirrorSessionRequest.DslBuilder.() -> Unit) = deleteTrafficMirrorSession(DeleteTrafficMirrorSessionRequest.builder().apply(block).build())

    /**
     * Deletes the specified Traffic Mirror target.
     * You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror session.
     */
    suspend fun deleteTrafficMirrorTarget(input: DeleteTrafficMirrorTargetRequest): DeleteTrafficMirrorTargetResponse

    /**
     * Deletes the specified Traffic Mirror target.
     * You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror session.
     */
    suspend fun deleteTrafficMirrorTarget(block: DeleteTrafficMirrorTargetRequest.DslBuilder.() -> Unit) = deleteTrafficMirrorTarget(DeleteTrafficMirrorTargetRequest.builder().apply(block).build())

    /**
     * Deletes the specified transit gateway.
     */
    suspend fun deleteTransitGateway(input: DeleteTransitGatewayRequest): DeleteTransitGatewayResponse

    /**
     * Deletes the specified transit gateway.
     */
    suspend fun deleteTransitGateway(block: DeleteTransitGatewayRequest.DslBuilder.() -> Unit) = deleteTransitGateway(DeleteTransitGatewayRequest.builder().apply(block).build())

    /**
     * Deletes the specified Connect attachment. You must first delete any Connect peers for
     * the attachment.
     */
    suspend fun deleteTransitGatewayConnect(input: DeleteTransitGatewayConnectRequest): DeleteTransitGatewayConnectResponse

    /**
     * Deletes the specified Connect attachment. You must first delete any Connect peers for
     * the attachment.
     */
    suspend fun deleteTransitGatewayConnect(block: DeleteTransitGatewayConnectRequest.DslBuilder.() -> Unit) = deleteTransitGatewayConnect(DeleteTransitGatewayConnectRequest.builder().apply(block).build())

    /**
     * Deletes the specified Connect peer.
     */
    suspend fun deleteTransitGatewayConnectPeer(input: DeleteTransitGatewayConnectPeerRequest): DeleteTransitGatewayConnectPeerResponse

    /**
     * Deletes the specified Connect peer.
     */
    suspend fun deleteTransitGatewayConnectPeer(block: DeleteTransitGatewayConnectPeerRequest.DslBuilder.() -> Unit) = deleteTransitGatewayConnectPeer(DeleteTransitGatewayConnectPeerRequest.builder().apply(block).build())

    /**
     * Deletes the specified transit gateway multicast domain.
     */
    suspend fun deleteTransitGatewayMulticastDomain(input: DeleteTransitGatewayMulticastDomainRequest): DeleteTransitGatewayMulticastDomainResponse

    /**
     * Deletes the specified transit gateway multicast domain.
     */
    suspend fun deleteTransitGatewayMulticastDomain(block: DeleteTransitGatewayMulticastDomainRequest.DslBuilder.() -> Unit) = deleteTransitGatewayMulticastDomain(DeleteTransitGatewayMulticastDomainRequest.builder().apply(block).build())

    /**
     * Deletes a transit gateway peering attachment.
     */
    suspend fun deleteTransitGatewayPeeringAttachment(input: DeleteTransitGatewayPeeringAttachmentRequest): DeleteTransitGatewayPeeringAttachmentResponse

    /**
     * Deletes a transit gateway peering attachment.
     */
    suspend fun deleteTransitGatewayPeeringAttachment(block: DeleteTransitGatewayPeeringAttachmentRequest.DslBuilder.() -> Unit) = deleteTransitGatewayPeeringAttachment(DeleteTransitGatewayPeeringAttachmentRequest.builder().apply(block).build())

    /**
     * Deletes a reference (route) to a prefix list in a specified transit gateway route table.
     */
    suspend fun deleteTransitGatewayPrefixListReference(input: DeleteTransitGatewayPrefixListReferenceRequest): DeleteTransitGatewayPrefixListReferenceResponse

    /**
     * Deletes a reference (route) to a prefix list in a specified transit gateway route table.
     */
    suspend fun deleteTransitGatewayPrefixListReference(block: DeleteTransitGatewayPrefixListReferenceRequest.DslBuilder.() -> Unit) = deleteTransitGatewayPrefixListReference(DeleteTransitGatewayPrefixListReferenceRequest.builder().apply(block).build())

    /**
     * Deletes the specified route from the specified transit gateway route table.
     */
    suspend fun deleteTransitGatewayRoute(input: DeleteTransitGatewayRouteRequest): DeleteTransitGatewayRouteResponse

    /**
     * Deletes the specified route from the specified transit gateway route table.
     */
    suspend fun deleteTransitGatewayRoute(block: DeleteTransitGatewayRouteRequest.DslBuilder.() -> Unit) = deleteTransitGatewayRoute(DeleteTransitGatewayRouteRequest.builder().apply(block).build())

    /**
     * Deletes the specified transit gateway route table. You must disassociate the route table from any
     * transit gateway route tables before you can delete it.
     */
    suspend fun deleteTransitGatewayRouteTable(input: DeleteTransitGatewayRouteTableRequest): DeleteTransitGatewayRouteTableResponse

    /**
     * Deletes the specified transit gateway route table. You must disassociate the route table from any
     * transit gateway route tables before you can delete it.
     */
    suspend fun deleteTransitGatewayRouteTable(block: DeleteTransitGatewayRouteTableRequest.DslBuilder.() -> Unit) = deleteTransitGatewayRouteTable(DeleteTransitGatewayRouteTableRequest.builder().apply(block).build())

    /**
     * Deletes the specified VPC attachment.
     */
    suspend fun deleteTransitGatewayVpcAttachment(input: DeleteTransitGatewayVpcAttachmentRequest): DeleteTransitGatewayVpcAttachmentResponse

    /**
     * Deletes the specified VPC attachment.
     */
    suspend fun deleteTransitGatewayVpcAttachment(block: DeleteTransitGatewayVpcAttachmentRequest.DslBuilder.() -> Unit) = deleteTransitGatewayVpcAttachment(DeleteTransitGatewayVpcAttachmentRequest.builder().apply(block).build())

    /**
     * Deletes the specified EBS volume. The volume must be in the available state
     * (not attached to an instance).
     * The volume can remain in the deleting state for several minutes.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html">Delete an Amazon EBS volume in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun deleteVolume(input: DeleteVolumeRequest): DeleteVolumeResponse

    /**
     * Deletes the specified EBS volume. The volume must be in the available state
     * (not attached to an instance).
     * The volume can remain in the deleting state for several minutes.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html">Delete an Amazon EBS volume in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun deleteVolume(block: DeleteVolumeRequest.DslBuilder.() -> Unit) = deleteVolume(DeleteVolumeRequest.builder().apply(block).build())

    /**
     * Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC before you can delete it. For example, you must terminate all instances running in the VPC, delete all security groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except the default one), and so on.
     */
    suspend fun deleteVpc(input: DeleteVpcRequest): DeleteVpcResponse

    /**
     * Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC before you can delete it. For example, you must terminate all instances running in the VPC, delete all security groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except the default one), and so on.
     */
    suspend fun deleteVpc(block: DeleteVpcRequest.DslBuilder.() -> Unit) = deleteVpc(DeleteVpcRequest.builder().apply(block).build())

    /**
     * Deletes one or more VPC endpoint connection notifications.
     */
    suspend fun deleteVpcEndpointConnectionNotifications(input: DeleteVpcEndpointConnectionNotificationsRequest): DeleteVpcEndpointConnectionNotificationsResponse

    /**
     * Deletes one or more VPC endpoint connection notifications.
     */
    suspend fun deleteVpcEndpointConnectionNotifications(block: DeleteVpcEndpointConnectionNotificationsRequest.DslBuilder.() -> Unit) = deleteVpcEndpointConnectionNotifications(DeleteVpcEndpointConnectionNotificationsRequest.builder().apply(block).build())

    /**
     * Deletes one or more VPC endpoint service configurations in your account. Before you
     * delete the endpoint service configuration, you must reject any Available or
     * PendingAcceptance interface endpoint connections that are attached to
     * the service.
     */
    suspend fun deleteVpcEndpointServiceConfigurations(input: DeleteVpcEndpointServiceConfigurationsRequest): DeleteVpcEndpointServiceConfigurationsResponse

    /**
     * Deletes one or more VPC endpoint service configurations in your account. Before you
     * delete the endpoint service configuration, you must reject any Available or
     * PendingAcceptance interface endpoint connections that are attached to
     * the service.
     */
    suspend fun deleteVpcEndpointServiceConfigurations(block: DeleteVpcEndpointServiceConfigurationsRequest.DslBuilder.() -> Unit) = deleteVpcEndpointServiceConfigurations(DeleteVpcEndpointServiceConfigurationsRequest.builder().apply(block).build())

    /**
     * Deletes one or more specified VPC endpoints. You can delete any of the following types of VPC endpoints.
     * Gateway endpoint,
     * Gateway Load Balancer endpoint,
     * Interface endpoint
     * The following rules apply when you delete a VPC endpoint:
     * When you delete a gateway endpoint, we delete the endpoint routes in the route tables that are associated with the endpoint.
     * When you delete a Gateway Load Balancer endpoint, we delete the endpoint network interfaces.
     * You can only delete Gateway Load Balancer endpoints when the routes that are associated with the endpoint are deleted.
     * When you delete an interface endpoint, we delete the  endpoint network interfaces.
     */
    suspend fun deleteVpcEndpoints(input: DeleteVpcEndpointsRequest): DeleteVpcEndpointsResponse

    /**
     * Deletes one or more specified VPC endpoints. You can delete any of the following types of VPC endpoints.
     * Gateway endpoint,
     * Gateway Load Balancer endpoint,
     * Interface endpoint
     * The following rules apply when you delete a VPC endpoint:
     * When you delete a gateway endpoint, we delete the endpoint routes in the route tables that are associated with the endpoint.
     * When you delete a Gateway Load Balancer endpoint, we delete the endpoint network interfaces.
     * You can only delete Gateway Load Balancer endpoints when the routes that are associated with the endpoint are deleted.
     * When you delete an interface endpoint, we delete the  endpoint network interfaces.
     */
    suspend fun deleteVpcEndpoints(block: DeleteVpcEndpointsRequest.DslBuilder.() -> Unit) = deleteVpcEndpoints(DeleteVpcEndpointsRequest.builder().apply(block).build())

    /**
     * Deletes a VPC peering connection. Either the owner of the requester VPC or the owner
     * of the accepter VPC can delete the VPC peering connection if it's in the
     * active state. The owner of the requester VPC can delete a VPC peering
     * connection in the pending-acceptance state. You cannot delete a VPC peering
     * connection that's in the failed state.
     */
    suspend fun deleteVpcPeeringConnection(input: DeleteVpcPeeringConnectionRequest): DeleteVpcPeeringConnectionResponse

    /**
     * Deletes a VPC peering connection. Either the owner of the requester VPC or the owner
     * of the accepter VPC can delete the VPC peering connection if it's in the
     * active state. The owner of the requester VPC can delete a VPC peering
     * connection in the pending-acceptance state. You cannot delete a VPC peering
     * connection that's in the failed state.
     */
    suspend fun deleteVpcPeeringConnection(block: DeleteVpcPeeringConnectionRequest.DslBuilder.() -> Unit) = deleteVpcPeeringConnection(DeleteVpcPeeringConnectionRequest.builder().apply(block).build())

    /**
     * Deletes the specified VPN connection.
     * If you're deleting the VPC and its associated components, we recommend that you detach
     * the virtual private gateway from the VPC and delete the VPC before deleting the VPN
     * connection. If you believe that the tunnel credentials for your VPN connection have been
     * compromised, you can delete the VPN connection and create a new one that has new keys,
     * without needing to delete the VPC or virtual private gateway. If you create a new VPN
     * connection, you must reconfigure the customer gateway device using the new configuration
     * information returned with the new VPN connection ID.
     * For certificate-based authentication, delete all Certificate Manager (ACM) private
     * certificates used for the Amazon Web Services-side tunnel endpoints for the VPN
     * connection before deleting the VPN connection.
     */
    suspend fun deleteVpnConnection(input: DeleteVpnConnectionRequest): DeleteVpnConnectionResponse

    /**
     * Deletes the specified VPN connection.
     * If you're deleting the VPC and its associated components, we recommend that you detach
     * the virtual private gateway from the VPC and delete the VPC before deleting the VPN
     * connection. If you believe that the tunnel credentials for your VPN connection have been
     * compromised, you can delete the VPN connection and create a new one that has new keys,
     * without needing to delete the VPC or virtual private gateway. If you create a new VPN
     * connection, you must reconfigure the customer gateway device using the new configuration
     * information returned with the new VPN connection ID.
     * For certificate-based authentication, delete all Certificate Manager (ACM) private
     * certificates used for the Amazon Web Services-side tunnel endpoints for the VPN
     * connection before deleting the VPN connection.
     */
    suspend fun deleteVpnConnection(block: DeleteVpnConnectionRequest.DslBuilder.() -> Unit) = deleteVpnConnection(DeleteVpnConnectionRequest.builder().apply(block).build())

    /**
     * Deletes the specified static route associated with a VPN connection between an
     * existing virtual private gateway and a VPN customer gateway. The static route allows
     * traffic to be routed from the virtual private gateway to the VPN customer
     * gateway.
     */
    suspend fun deleteVpnConnectionRoute(input: DeleteVpnConnectionRouteRequest): DeleteVpnConnectionRouteResponse

    /**
     * Deletes the specified static route associated with a VPN connection between an
     * existing virtual private gateway and a VPN customer gateway. The static route allows
     * traffic to be routed from the virtual private gateway to the VPN customer
     * gateway.
     */
    suspend fun deleteVpnConnectionRoute(block: DeleteVpnConnectionRouteRequest.DslBuilder.() -> Unit) = deleteVpnConnectionRoute(DeleteVpnConnectionRouteRequest.builder().apply(block).build())

    /**
     * Deletes the specified virtual private gateway. You must first detach the virtual
     * private gateway from the VPC. Note that you don't need to delete the virtual private
     * gateway if you plan to delete and recreate the VPN connection between your VPC and your
     * network.
     */
    suspend fun deleteVpnGateway(input: DeleteVpnGatewayRequest): DeleteVpnGatewayResponse

    /**
     * Deletes the specified virtual private gateway. You must first detach the virtual
     * private gateway from the VPC. Note that you don't need to delete the virtual private
     * gateway if you plan to delete and recreate the VPN connection between your VPC and your
     * network.
     */
    suspend fun deleteVpnGateway(block: DeleteVpnGatewayRequest.DslBuilder.() -> Unit) = deleteVpnGateway(DeleteVpnGatewayRequest.builder().apply(block).build())

    /**
     * Releases the specified address range that you provisioned for use with your Amazon Web Services resources
     * through bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * Before you can release an address range, you must stop advertising it using WithdrawByoipCidr and you must not have any IP addresses allocated from its
     * address range.
     */
    suspend fun deprovisionByoipCidr(input: DeprovisionByoipCidrRequest): DeprovisionByoipCidrResponse

    /**
     * Releases the specified address range that you provisioned for use with your Amazon Web Services resources
     * through bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * Before you can release an address range, you must stop advertising it using WithdrawByoipCidr and you must not have any IP addresses allocated from its
     * address range.
     */
    suspend fun deprovisionByoipCidr(block: DeprovisionByoipCidrRequest.DslBuilder.() -> Unit) = deprovisionByoipCidr(DeprovisionByoipCidrRequest.builder().apply(block).build())

    /**
     * Deregisters the specified AMI. After you deregister an AMI, it can't be used to launch
     * new instances; however, it doesn't affect any instances that you've already launched
     * from the AMI. You'll continue to incur usage costs for those instances until you
     * terminate them.
     * When you deregister an Amazon EBS-backed AMI, it doesn't affect the snapshot that was
     * created for the root volume of the instance during the AMI creation process. When you
     * deregister an instance store-backed AMI, it doesn't affect the files that you uploaded
     * to Amazon S3 when you created the AMI.
     */
    suspend fun deregisterImage(input: DeregisterImageRequest): DeregisterImageResponse

    /**
     * Deregisters the specified AMI. After you deregister an AMI, it can't be used to launch
     * new instances; however, it doesn't affect any instances that you've already launched
     * from the AMI. You'll continue to incur usage costs for those instances until you
     * terminate them.
     * When you deregister an Amazon EBS-backed AMI, it doesn't affect the snapshot that was
     * created for the root volume of the instance during the AMI creation process. When you
     * deregister an instance store-backed AMI, it doesn't affect the files that you uploaded
     * to Amazon S3 when you created the AMI.
     */
    suspend fun deregisterImage(block: DeregisterImageRequest.DslBuilder.() -> Unit) = deregisterImage(DeregisterImageRequest.builder().apply(block).build())

    /**
     * c
     * Deregisters tag keys to prevent tags that have the specified tag keys from being included
     * in scheduled event notifications for resources in the Region.
     */
    suspend fun deregisterInstanceEventNotificationAttributes(input: DeregisterInstanceEventNotificationAttributesRequest): DeregisterInstanceEventNotificationAttributesResponse

    /**
     * c
     * Deregisters tag keys to prevent tags that have the specified tag keys from being included
     * in scheduled event notifications for resources in the Region.
     */
    suspend fun deregisterInstanceEventNotificationAttributes(block: DeregisterInstanceEventNotificationAttributesRequest.DslBuilder.() -> Unit) = deregisterInstanceEventNotificationAttributes(DeregisterInstanceEventNotificationAttributesRequest.builder().apply(block).build())

    /**
     * Deregisters the specified members (network interfaces) from the  transit gateway multicast group.
     */
    suspend fun deregisterTransitGatewayMulticastGroupMembers(input: DeregisterTransitGatewayMulticastGroupMembersRequest): DeregisterTransitGatewayMulticastGroupMembersResponse

    /**
     * Deregisters the specified members (network interfaces) from the  transit gateway multicast group.
     */
    suspend fun deregisterTransitGatewayMulticastGroupMembers(block: DeregisterTransitGatewayMulticastGroupMembersRequest.DslBuilder.() -> Unit) = deregisterTransitGatewayMulticastGroupMembers(DeregisterTransitGatewayMulticastGroupMembersRequest.builder().apply(block).build())

    /**
     * Deregisters the specified sources (network interfaces) from the  transit gateway multicast group.
     */
    suspend fun deregisterTransitGatewayMulticastGroupSources(input: DeregisterTransitGatewayMulticastGroupSourcesRequest): DeregisterTransitGatewayMulticastGroupSourcesResponse

    /**
     * Deregisters the specified sources (network interfaces) from the  transit gateway multicast group.
     */
    suspend fun deregisterTransitGatewayMulticastGroupSources(block: DeregisterTransitGatewayMulticastGroupSourcesRequest.DslBuilder.() -> Unit) = deregisterTransitGatewayMulticastGroupSources(DeregisterTransitGatewayMulticastGroupSourcesRequest.builder().apply(block).build())

    /**
     * Describes attributes of your AWS account. The following are the supported account attributes:
     * supported-platforms: Indicates whether your account can launch instances
     * into EC2-Classic and EC2-VPC, or only into EC2-VPC.
     * default-vpc: The ID of the default VPC for your account, or
     * none.
     * max-instances: This attribute is no longer supported. The returned
     * value does not reflect your actual vCPU limit for running On-Demand Instances.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits">On-Demand Instance Limits in the
     * Amazon Elastic Compute Cloud User Guide.
     * vpc-max-security-groups-per-interface: The maximum number of security groups
     * that you can assign to a network interface.
     * max-elastic-ips: The maximum number of Elastic IP addresses that you can
     * allocate for use with EC2-Classic.
     * vpc-max-elastic-ips: The maximum number of Elastic IP addresses that you can
     * allocate for use with EC2-VPC.
     */
    suspend fun describeAccountAttributes(input: DescribeAccountAttributesRequest): DescribeAccountAttributesResponse

    /**
     * Describes attributes of your AWS account. The following are the supported account attributes:
     * supported-platforms: Indicates whether your account can launch instances
     * into EC2-Classic and EC2-VPC, or only into EC2-VPC.
     * default-vpc: The ID of the default VPC for your account, or
     * none.
     * max-instances: This attribute is no longer supported. The returned
     * value does not reflect your actual vCPU limit for running On-Demand Instances.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits">On-Demand Instance Limits in the
     * Amazon Elastic Compute Cloud User Guide.
     * vpc-max-security-groups-per-interface: The maximum number of security groups
     * that you can assign to a network interface.
     * max-elastic-ips: The maximum number of Elastic IP addresses that you can
     * allocate for use with EC2-Classic.
     * vpc-max-elastic-ips: The maximum number of Elastic IP addresses that you can
     * allocate for use with EC2-VPC.
     */
    suspend fun describeAccountAttributes(block: DescribeAccountAttributesRequest.DslBuilder.() -> Unit) = describeAccountAttributes(DescribeAccountAttributesRequest.builder().apply(block).build())

    /**
     * Describes the specified Elastic IP addresses or all of your Elastic IP addresses.
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeAddresses(input: DescribeAddressesRequest): DescribeAddressesResponse

    /**
     * Describes the specified Elastic IP addresses or all of your Elastic IP addresses.
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeAddresses(block: DescribeAddressesRequest.DslBuilder.() -> Unit) = describeAddresses(DescribeAddressesRequest.builder().apply(block).build())

    /**
     * Describes the attributes of the specified Elastic IP addresses. For requirements, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS">Using reverse DNS for email applications.
     */
    suspend fun describeAddressesAttribute(input: DescribeAddressesAttributeRequest): DescribeAddressesAttributeResponse

    /**
     * Describes the attributes of the specified Elastic IP addresses. For requirements, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS">Using reverse DNS for email applications.
     */
    suspend fun describeAddressesAttribute(block: DescribeAddressesAttributeRequest.DslBuilder.() -> Unit) = describeAddressesAttribute(DescribeAddressesAttributeRequest.builder().apply(block).build())

    /**
     * Describes the longer ID format settings for all resource types in a specific
     * Region. This request is useful for performing a quick audit to determine whether a
     * specific Region is fully opted in for longer IDs (17-character IDs).
     * This request only returns information about resource types that support longer IDs.
     * The following resource types support longer IDs: bundle |
     * conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | instance | internet-gateway |
     * network-acl | network-acl-association |
     * network-interface | network-interface-attachment |
     * prefix-list | reservation | route-table |
     * route-table-association | security-group |
     * snapshot | subnet |
     * subnet-cidr-block-association | volume | vpc |
     * vpc-cidr-block-association | vpc-endpoint |
     * vpc-peering-connection | vpn-connection | vpn-gateway.
     */
    suspend fun describeAggregateIdFormat(input: DescribeAggregateIdFormatRequest): DescribeAggregateIdFormatResponse

    /**
     * Describes the longer ID format settings for all resource types in a specific
     * Region. This request is useful for performing a quick audit to determine whether a
     * specific Region is fully opted in for longer IDs (17-character IDs).
     * This request only returns information about resource types that support longer IDs.
     * The following resource types support longer IDs: bundle |
     * conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | instance | internet-gateway |
     * network-acl | network-acl-association |
     * network-interface | network-interface-attachment |
     * prefix-list | reservation | route-table |
     * route-table-association | security-group |
     * snapshot | subnet |
     * subnet-cidr-block-association | volume | vpc |
     * vpc-cidr-block-association | vpc-endpoint |
     * vpc-peering-connection | vpn-connection | vpn-gateway.
     */
    suspend fun describeAggregateIdFormat(block: DescribeAggregateIdFormatRequest.DslBuilder.() -> Unit) = describeAggregateIdFormat(DescribeAggregateIdFormatRequest.builder().apply(block).build())

    /**
     * Describes the Availability Zones, Local Zones, and Wavelength Zones that are available to
     * you. If there is an event impacting a zone, you can use this request to view the state and any
     * provided messages for that zone.
     * For more information about Availability Zones, Local Zones, and Wavelength Zones, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html">Regions and zones
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeAvailabilityZones(input: DescribeAvailabilityZonesRequest): DescribeAvailabilityZonesResponse

    /**
     * Describes the Availability Zones, Local Zones, and Wavelength Zones that are available to
     * you. If there is an event impacting a zone, you can use this request to view the state and any
     * provided messages for that zone.
     * For more information about Availability Zones, Local Zones, and Wavelength Zones, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html">Regions and zones
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeAvailabilityZones(block: DescribeAvailabilityZonesRequest.DslBuilder.() -> Unit) = describeAvailabilityZones(DescribeAvailabilityZonesRequest.builder().apply(block).build())

    /**
     * Describes the specified bundle tasks or all of your bundle tasks.
     * Completed bundle tasks are listed for only a limited time. If your bundle task is no longer in the list, you can still register an AMI from it. Just use RegisterImage with the Amazon S3 bucket name and image manifest name you provided to the bundle task.
     */
    suspend fun describeBundleTasks(input: DescribeBundleTasksRequest): DescribeBundleTasksResponse

    /**
     * Describes the specified bundle tasks or all of your bundle tasks.
     * Completed bundle tasks are listed for only a limited time. If your bundle task is no longer in the list, you can still register an AMI from it. Just use RegisterImage with the Amazon S3 bucket name and image manifest name you provided to the bundle task.
     */
    suspend fun describeBundleTasks(block: DescribeBundleTasksRequest.DslBuilder.() -> Unit) = describeBundleTasks(DescribeBundleTasksRequest.builder().apply(block).build())

    /**
     * Describes the IP address ranges that were specified in calls to ProvisionByoipCidr.
     * To describe the address pools that were created when you provisioned the address
     * ranges, use DescribePublicIpv4Pools or DescribeIpv6Pools.
     */
    suspend fun describeByoipCidrs(input: DescribeByoipCidrsRequest): DescribeByoipCidrsResponse

    /**
     * Describes the IP address ranges that were specified in calls to ProvisionByoipCidr.
     * To describe the address pools that were created when you provisioned the address
     * ranges, use DescribePublicIpv4Pools or DescribeIpv6Pools.
     */
    suspend fun describeByoipCidrs(block: DescribeByoipCidrsRequest.DslBuilder.() -> Unit) = describeByoipCidrs(DescribeByoipCidrsRequest.builder().apply(block).build())

    /**
     * Describes one or more Capacity Reservation Fleets.
     */
    suspend fun describeCapacityReservationFleets(input: DescribeCapacityReservationFleetsRequest): DescribeCapacityReservationFleetsResponse

    /**
     * Describes one or more Capacity Reservation Fleets.
     */
    suspend fun describeCapacityReservationFleets(block: DescribeCapacityReservationFleetsRequest.DslBuilder.() -> Unit) = describeCapacityReservationFleets(DescribeCapacityReservationFleetsRequest.builder().apply(block).build())

    /**
     * Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the
     * Amazon Web Services Region that you're currently using.
     */
    suspend fun describeCapacityReservations(input: DescribeCapacityReservationsRequest): DescribeCapacityReservationsResponse

    /**
     * Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the
     * Amazon Web Services Region that you're currently using.
     */
    suspend fun describeCapacityReservations(block: DescribeCapacityReservationsRequest.DslBuilder.() -> Unit) = describeCapacityReservations(DescribeCapacityReservationsRequest.builder().apply(block).build())

    /**
     * Describes one or more of your carrier gateways.
     */
    suspend fun describeCarrierGateways(input: DescribeCarrierGatewaysRequest): DescribeCarrierGatewaysResponse

    /**
     * Describes one or more of your carrier gateways.
     */
    suspend fun describeCarrierGateways(block: DescribeCarrierGatewaysRequest.DslBuilder.() -> Unit) = describeCarrierGateways(DescribeCarrierGatewaysRequest.builder().apply(block).build())

    /**
     * Describes one or more of your linked EC2-Classic instances. This request only returns
     * information about EC2-Classic instances linked to a VPC through ClassicLink. You cannot
     * use this request to return information about other instances.
     */
    suspend fun describeClassicLinkInstances(input: DescribeClassicLinkInstancesRequest): DescribeClassicLinkInstancesResponse

    /**
     * Describes one or more of your linked EC2-Classic instances. This request only returns
     * information about EC2-Classic instances linked to a VPC through ClassicLink. You cannot
     * use this request to return information about other instances.
     */
    suspend fun describeClassicLinkInstances(block: DescribeClassicLinkInstancesRequest.DslBuilder.() -> Unit) = describeClassicLinkInstances(DescribeClassicLinkInstancesRequest.builder().apply(block).build())

    /**
     * Describes the authorization rules for a specified Client VPN endpoint.
     */
    suspend fun describeClientVpnAuthorizationRules(input: DescribeClientVpnAuthorizationRulesRequest): DescribeClientVpnAuthorizationRulesResponse

    /**
     * Describes the authorization rules for a specified Client VPN endpoint.
     */
    suspend fun describeClientVpnAuthorizationRules(block: DescribeClientVpnAuthorizationRulesRequest.DslBuilder.() -> Unit) = describeClientVpnAuthorizationRules(DescribeClientVpnAuthorizationRulesRequest.builder().apply(block).build())

    /**
     * Describes active client connections and connections that have been terminated within the last 60
     * minutes for the specified Client VPN endpoint.
     */
    suspend fun describeClientVpnConnections(input: DescribeClientVpnConnectionsRequest): DescribeClientVpnConnectionsResponse

    /**
     * Describes active client connections and connections that have been terminated within the last 60
     * minutes for the specified Client VPN endpoint.
     */
    suspend fun describeClientVpnConnections(block: DescribeClientVpnConnectionsRequest.DslBuilder.() -> Unit) = describeClientVpnConnections(DescribeClientVpnConnectionsRequest.builder().apply(block).build())

    /**
     * Describes one or more Client VPN endpoints in the account.
     */
    suspend fun describeClientVpnEndpoints(input: DescribeClientVpnEndpointsRequest): DescribeClientVpnEndpointsResponse

    /**
     * Describes one or more Client VPN endpoints in the account.
     */
    suspend fun describeClientVpnEndpoints(block: DescribeClientVpnEndpointsRequest.DslBuilder.() -> Unit) = describeClientVpnEndpoints(DescribeClientVpnEndpointsRequest.builder().apply(block).build())

    /**
     * Describes the routes for the specified Client VPN endpoint.
     */
    suspend fun describeClientVpnRoutes(input: DescribeClientVpnRoutesRequest): DescribeClientVpnRoutesResponse

    /**
     * Describes the routes for the specified Client VPN endpoint.
     */
    suspend fun describeClientVpnRoutes(block: DescribeClientVpnRoutesRequest.DslBuilder.() -> Unit) = describeClientVpnRoutes(DescribeClientVpnRoutesRequest.builder().apply(block).build())

    /**
     * Describes the target networks associated with the specified Client VPN endpoint.
     */
    suspend fun describeClientVpnTargetNetworks(input: DescribeClientVpnTargetNetworksRequest): DescribeClientVpnTargetNetworksResponse

    /**
     * Describes the target networks associated with the specified Client VPN endpoint.
     */
    suspend fun describeClientVpnTargetNetworks(block: DescribeClientVpnTargetNetworksRequest.DslBuilder.() -> Unit) = describeClientVpnTargetNetworks(DescribeClientVpnTargetNetworksRequest.builder().apply(block).build())

    /**
     * Describes the specified customer-owned address pools or all of your customer-owned address pools.
     */
    suspend fun describeCoipPools(input: DescribeCoipPoolsRequest): DescribeCoipPoolsResponse

    /**
     * Describes the specified customer-owned address pools or all of your customer-owned address pools.
     */
    suspend fun describeCoipPools(block: DescribeCoipPoolsRequest.DslBuilder.() -> Unit) = describeCoipPools(DescribeCoipPoolsRequest.builder().apply(block).build())

    /**
     * Describes the specified conversion tasks or all your conversion tasks. For more information, see the
     * <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/">VM Import/Export User Guide.
     * For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest.
     */
    suspend fun describeConversionTasks(input: DescribeConversionTasksRequest): DescribeConversionTasksResponse

    /**
     * Describes the specified conversion tasks or all your conversion tasks. For more information, see the
     * <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/">VM Import/Export User Guide.
     * For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest.
     */
    suspend fun describeConversionTasks(block: DescribeConversionTasksRequest.DslBuilder.() -> Unit) = describeConversionTasks(DescribeConversionTasksRequest.builder().apply(block).build())

    /**
     * Describes one or more of your VPN customer gateways.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    suspend fun describeCustomerGateways(input: DescribeCustomerGatewaysRequest): DescribeCustomerGatewaysResponse

    /**
     * Describes one or more of your VPN customer gateways.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    suspend fun describeCustomerGateways(block: DescribeCustomerGatewaysRequest.DslBuilder.() -> Unit) = describeCustomerGateways(DescribeCustomerGatewaysRequest.builder().apply(block).build())

    /**
     * Describes one or more of your DHCP options sets.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun describeDhcpOptions(input: DescribeDhcpOptionsRequest): DescribeDhcpOptionsResponse

    /**
     * Describes one or more of your DHCP options sets.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun describeDhcpOptions(block: DescribeDhcpOptionsRequest.DslBuilder.() -> Unit) = describeDhcpOptions(DescribeDhcpOptionsRequest.builder().apply(block).build())

    /**
     * Describes one or more of your egress-only internet gateways.
     */
    suspend fun describeEgressOnlyInternetGateways(input: DescribeEgressOnlyInternetGatewaysRequest): DescribeEgressOnlyInternetGatewaysResponse

    /**
     * Describes one or more of your egress-only internet gateways.
     */
    suspend fun describeEgressOnlyInternetGateways(block: DescribeEgressOnlyInternetGatewaysRequest.DslBuilder.() -> Unit) = describeEgressOnlyInternetGateways(DescribeEgressOnlyInternetGatewaysRequest.builder().apply(block).build())

    /**
     * Describes the Elastic Graphics accelerator associated with your instances. For more information
     * about Elastic Graphics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon Elastic Graphics.
     */
    suspend fun describeElasticGpus(input: DescribeElasticGpusRequest): DescribeElasticGpusResponse

    /**
     * Describes the Elastic Graphics accelerator associated with your instances. For more information
     * about Elastic Graphics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon Elastic Graphics.
     */
    suspend fun describeElasticGpus(block: DescribeElasticGpusRequest.DslBuilder.() -> Unit) = describeElasticGpus(DescribeElasticGpusRequest.builder().apply(block).build())

    /**
     * Describes the specified export image tasks or all of your export image tasks.
     */
    suspend fun describeExportImageTasks(input: DescribeExportImageTasksRequest): DescribeExportImageTasksResponse

    /**
     * Describes the specified export image tasks or all of your export image tasks.
     */
    suspend fun describeExportImageTasks(block: DescribeExportImageTasksRequest.DslBuilder.() -> Unit) = describeExportImageTasks(DescribeExportImageTasksRequest.builder().apply(block).build())

    /**
     * Describes the specified export instance tasks or all of your export instance tasks.
     */
    suspend fun describeExportTasks(input: DescribeExportTasksRequest): DescribeExportTasksResponse

    /**
     * Describes the specified export instance tasks or all of your export instance tasks.
     */
    suspend fun describeExportTasks(block: DescribeExportTasksRequest.DslBuilder.() -> Unit) = describeExportTasks(DescribeExportTasksRequest.builder().apply(block).build())

    /**
     * Describes the state of fast snapshot restores for your snapshots.
     */
    suspend fun describeFastSnapshotRestores(input: DescribeFastSnapshotRestoresRequest): DescribeFastSnapshotRestoresResponse

    /**
     * Describes the state of fast snapshot restores for your snapshots.
     */
    suspend fun describeFastSnapshotRestores(block: DescribeFastSnapshotRestoresRequest.DslBuilder.() -> Unit) = describeFastSnapshotRestores(DescribeFastSnapshotRestoresRequest.builder().apply(block).build())

    /**
     * Describes the events for the specified EC2 Fleet during the specified time.
     * EC2 Fleet events are delayed by up to 30 seconds before they can be described. This ensures
     * that you can query by the last evaluated time and not miss a recorded event. EC2 Fleet events
     * are available for 48 hours.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/fleet-monitor.html">Monitor fleet events using Amazon EventBridge in the
     * Amazon EC2 User Guide.
     */
    suspend fun describeFleetHistory(input: DescribeFleetHistoryRequest): DescribeFleetHistoryResponse

    /**
     * Describes the events for the specified EC2 Fleet during the specified time.
     * EC2 Fleet events are delayed by up to 30 seconds before they can be described. This ensures
     * that you can query by the last evaluated time and not miss a recorded event. EC2 Fleet events
     * are available for 48 hours.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/fleet-monitor.html">Monitor fleet events using Amazon EventBridge in the
     * Amazon EC2 User Guide.
     */
    suspend fun describeFleetHistory(block: DescribeFleetHistoryRequest.DslBuilder.() -> Unit) = describeFleetHistory(DescribeFleetHistoryRequest.builder().apply(block).build())

    /**
     * Describes the running instances for the specified EC2 Fleet.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html#monitor-ec2-fleet">Monitoring your EC2 Fleet in the Amazon EC2 User Guide.
     */
    suspend fun describeFleetInstances(input: DescribeFleetInstancesRequest): DescribeFleetInstancesResponse

    /**
     * Describes the running instances for the specified EC2 Fleet.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html#monitor-ec2-fleet">Monitoring your EC2 Fleet in the Amazon EC2 User Guide.
     */
    suspend fun describeFleetInstances(block: DescribeFleetInstancesRequest.DslBuilder.() -> Unit) = describeFleetInstances(DescribeFleetInstancesRequest.builder().apply(block).build())

    /**
     * Describes the specified EC2 Fleets or all of your EC2 Fleets.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html#monitor-ec2-fleet">Monitoring your EC2 Fleet in the Amazon EC2 User Guide.
     */
    suspend fun describeFleets(input: DescribeFleetsRequest): DescribeFleetsResponse

    /**
     * Describes the specified EC2 Fleets or all of your EC2 Fleets.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html#monitor-ec2-fleet">Monitoring your EC2 Fleet in the Amazon EC2 User Guide.
     */
    suspend fun describeFleets(block: DescribeFleetsRequest.DslBuilder.() -> Unit) = describeFleets(DescribeFleetsRequest.builder().apply(block).build())

    /**
     * Describes one or more flow logs. To view the information in your flow logs (the log
     * streams for the network interfaces), you must use the CloudWatch Logs console or the CloudWatch Logs
     * API.
     */
    suspend fun describeFlowLogs(input: DescribeFlowLogsRequest): DescribeFlowLogsResponse

    /**
     * Describes one or more flow logs. To view the information in your flow logs (the log
     * streams for the network interfaces), you must use the CloudWatch Logs console or the CloudWatch Logs
     * API.
     */
    suspend fun describeFlowLogs(block: DescribeFlowLogsRequest.DslBuilder.() -> Unit) = describeFlowLogs(DescribeFlowLogsRequest.builder().apply(block).build())

    /**
     * Describes the specified attribute of the specified Amazon FPGA Image (AFI).
     */
    suspend fun describeFpgaImageAttribute(input: DescribeFpgaImageAttributeRequest): DescribeFpgaImageAttributeResponse

    /**
     * Describes the specified attribute of the specified Amazon FPGA Image (AFI).
     */
    suspend fun describeFpgaImageAttribute(block: DescribeFpgaImageAttributeRequest.DslBuilder.() -> Unit) = describeFpgaImageAttribute(DescribeFpgaImageAttributeRequest.builder().apply(block).build())

    /**
     * Describes the Amazon FPGA Images (AFIs) available to you. These include public AFIs,
     * private AFIs that you own, and AFIs owned by other Amazon Web Services accounts for which you have load
     * permissions.
     */
    suspend fun describeFpgaImages(input: DescribeFpgaImagesRequest): DescribeFpgaImagesResponse

    /**
     * Describes the Amazon FPGA Images (AFIs) available to you. These include public AFIs,
     * private AFIs that you own, and AFIs owned by other Amazon Web Services accounts for which you have load
     * permissions.
     */
    suspend fun describeFpgaImages(block: DescribeFpgaImagesRequest.DslBuilder.() -> Unit) = describeFpgaImages(DescribeFpgaImagesRequest.builder().apply(block).build())

    /**
     * Describes the Dedicated Host reservations that are available to purchase.
     * The results describe all of the Dedicated Host reservation offerings, including
     * offerings that might not match the instance family and Region of your Dedicated Hosts.
     * When purchasing an offering, ensure that the instance family and Region of the offering
     * matches that of the Dedicated Hosts with which it is to be associated. For more
     * information about supported instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html">Dedicated Hosts
     * in the Amazon EC2 User Guide.
     */
    suspend fun describeHostReservationOfferings(input: DescribeHostReservationOfferingsRequest): DescribeHostReservationOfferingsResponse

    /**
     * Describes the Dedicated Host reservations that are available to purchase.
     * The results describe all of the Dedicated Host reservation offerings, including
     * offerings that might not match the instance family and Region of your Dedicated Hosts.
     * When purchasing an offering, ensure that the instance family and Region of the offering
     * matches that of the Dedicated Hosts with which it is to be associated. For more
     * information about supported instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html">Dedicated Hosts
     * in the Amazon EC2 User Guide.
     */
    suspend fun describeHostReservationOfferings(block: DescribeHostReservationOfferingsRequest.DslBuilder.() -> Unit) = describeHostReservationOfferings(DescribeHostReservationOfferingsRequest.builder().apply(block).build())

    /**
     * Describes reservations that are associated with Dedicated Hosts in your
     * account.
     */
    suspend fun describeHostReservations(input: DescribeHostReservationsRequest): DescribeHostReservationsResponse

    /**
     * Describes reservations that are associated with Dedicated Hosts in your
     * account.
     */
    suspend fun describeHostReservations(block: DescribeHostReservationsRequest.DslBuilder.() -> Unit) = describeHostReservations(DescribeHostReservationsRequest.builder().apply(block).build())

    /**
     * Describes the specified Dedicated Hosts or all your Dedicated Hosts.
     * The results describe only the Dedicated Hosts in the Region you're currently using.
     * All listed instances consume capacity on your Dedicated Host. Dedicated Hosts that have
     * recently been released are listed with the state released.
     */
    suspend fun describeHosts(input: DescribeHostsRequest): DescribeHostsResponse

    /**
     * Describes the specified Dedicated Hosts or all your Dedicated Hosts.
     * The results describe only the Dedicated Hosts in the Region you're currently using.
     * All listed instances consume capacity on your Dedicated Host. Dedicated Hosts that have
     * recently been released are listed with the state released.
     */
    suspend fun describeHosts(block: DescribeHostsRequest.DslBuilder.() -> Unit) = describeHosts(DescribeHostsRequest.builder().apply(block).build())

    /**
     * Describes your IAM instance profile associations.
     */
    suspend fun describeIamInstanceProfileAssociations(input: DescribeIamInstanceProfileAssociationsRequest): DescribeIamInstanceProfileAssociationsResponse

    /**
     * Describes your IAM instance profile associations.
     */
    suspend fun describeIamInstanceProfileAssociations(block: DescribeIamInstanceProfileAssociationsRequest.DslBuilder.() -> Unit) = describeIamInstanceProfileAssociations(DescribeIamInstanceProfileAssociationsRequest.builder().apply(block).build())

    /**
     * Describes the ID format settings for your resources on a per-Region basis, for example, to view which resource types are enabled for longer IDs. This request only returns information about resource types whose ID formats can be modified; it does not return information about other resource types.
     * The following resource types support longer IDs: bundle |
     * conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | instance | internet-gateway |
     * network-acl | network-acl-association |
     * network-interface | network-interface-attachment |
     * prefix-list | reservation | route-table |
     * route-table-association | security-group |
     * snapshot | subnet |
     * subnet-cidr-block-association | volume | vpc
     * | vpc-cidr-block-association | vpc-endpoint |
     * vpc-peering-connection | vpn-connection | vpn-gateway.
     * These settings apply to the IAM user who makes the request; they do not apply to the entire
     * Amazon Web Services account. By default, an IAM user defaults to the same settings as the root user, unless
     * they explicitly override the settings by running the ModifyIdFormat command. Resources
     * created with longer IDs are visible to all IAM users, regardless of these settings and
     * provided that they have permission to use the relevant Describe command for the
     * resource type.
     */
    suspend fun describeIdFormat(input: DescribeIdFormatRequest): DescribeIdFormatResponse

    /**
     * Describes the ID format settings for your resources on a per-Region basis, for example, to view which resource types are enabled for longer IDs. This request only returns information about resource types whose ID formats can be modified; it does not return information about other resource types.
     * The following resource types support longer IDs: bundle |
     * conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | instance | internet-gateway |
     * network-acl | network-acl-association |
     * network-interface | network-interface-attachment |
     * prefix-list | reservation | route-table |
     * route-table-association | security-group |
     * snapshot | subnet |
     * subnet-cidr-block-association | volume | vpc
     * | vpc-cidr-block-association | vpc-endpoint |
     * vpc-peering-connection | vpn-connection | vpn-gateway.
     * These settings apply to the IAM user who makes the request; they do not apply to the entire
     * Amazon Web Services account. By default, an IAM user defaults to the same settings as the root user, unless
     * they explicitly override the settings by running the ModifyIdFormat command. Resources
     * created with longer IDs are visible to all IAM users, regardless of these settings and
     * provided that they have permission to use the relevant Describe command for the
     * resource type.
     */
    suspend fun describeIdFormat(block: DescribeIdFormatRequest.DslBuilder.() -> Unit) = describeIdFormat(DescribeIdFormatRequest.builder().apply(block).build())

    /**
     * Describes the ID format settings for resources for the specified IAM user, IAM role, or root
     * user. For example, you can view the resource types that are enabled for longer IDs. This request only
     * returns information about resource types whose ID formats can be modified; it does not return
     * information about other resource types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs in the Amazon Elastic Compute Cloud User Guide.
     * The following resource types support longer IDs: bundle |
     * conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | instance | internet-gateway |
     * network-acl | network-acl-association |
     * network-interface | network-interface-attachment |
     * prefix-list | reservation | route-table |
     * route-table-association | security-group |
     * snapshot | subnet |
     * subnet-cidr-block-association | volume | vpc
     * | vpc-cidr-block-association | vpc-endpoint |
     * vpc-peering-connection | vpn-connection | vpn-gateway.
     * These settings apply to the principal specified in the request. They do not apply to the
     * principal that makes the request.
     */
    suspend fun describeIdentityIdFormat(input: DescribeIdentityIdFormatRequest): DescribeIdentityIdFormatResponse

    /**
     * Describes the ID format settings for resources for the specified IAM user, IAM role, or root
     * user. For example, you can view the resource types that are enabled for longer IDs. This request only
     * returns information about resource types whose ID formats can be modified; it does not return
     * information about other resource types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs in the Amazon Elastic Compute Cloud User Guide.
     * The following resource types support longer IDs: bundle |
     * conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | instance | internet-gateway |
     * network-acl | network-acl-association |
     * network-interface | network-interface-attachment |
     * prefix-list | reservation | route-table |
     * route-table-association | security-group |
     * snapshot | subnet |
     * subnet-cidr-block-association | volume | vpc
     * | vpc-cidr-block-association | vpc-endpoint |
     * vpc-peering-connection | vpn-connection | vpn-gateway.
     * These settings apply to the principal specified in the request. They do not apply to the
     * principal that makes the request.
     */
    suspend fun describeIdentityIdFormat(block: DescribeIdentityIdFormatRequest.DslBuilder.() -> Unit) = describeIdentityIdFormat(DescribeIdentityIdFormatRequest.builder().apply(block).build())

    /**
     * Describes the specified attribute of the specified AMI. You can specify only one attribute at a time.
     */
    suspend fun describeImageAttribute(input: DescribeImageAttributeRequest): DescribeImageAttributeResponse

    /**
     * Describes the specified attribute of the specified AMI. You can specify only one attribute at a time.
     */
    suspend fun describeImageAttribute(block: DescribeImageAttributeRequest.DslBuilder.() -> Unit) = describeImageAttribute(DescribeImageAttributeRequest.builder().apply(block).build())

    /**
     * Describes the specified images (AMIs, AKIs, and ARIs) available to you or all of the images available to you.
     * The images available to you include public images, private images that you own, and private images owned by other
     * Amazon Web Services accounts for which you have explicit launch permissions.
     * Recently deregistered images appear in the returned results for a short interval and then
     * return empty results. After all instances that reference a deregistered AMI are terminated,
     * specifying the ID of the image will eventually return an error indicating that the AMI ID
     * cannot be found.
     */
    suspend fun describeImages(input: DescribeImagesRequest): DescribeImagesResponse

    /**
     * Describes the specified images (AMIs, AKIs, and ARIs) available to you or all of the images available to you.
     * The images available to you include public images, private images that you own, and private images owned by other
     * Amazon Web Services accounts for which you have explicit launch permissions.
     * Recently deregistered images appear in the returned results for a short interval and then
     * return empty results. After all instances that reference a deregistered AMI are terminated,
     * specifying the ID of the image will eventually return an error indicating that the AMI ID
     * cannot be found.
     */
    suspend fun describeImages(block: DescribeImagesRequest.DslBuilder.() -> Unit) = describeImages(DescribeImagesRequest.builder().apply(block).build())

    /**
     * Displays details about an import virtual machine or import snapshot tasks that are already created.
     */
    suspend fun describeImportImageTasks(input: DescribeImportImageTasksRequest): DescribeImportImageTasksResponse

    /**
     * Displays details about an import virtual machine or import snapshot tasks that are already created.
     */
    suspend fun describeImportImageTasks(block: DescribeImportImageTasksRequest.DslBuilder.() -> Unit) = describeImportImageTasks(DescribeImportImageTasksRequest.builder().apply(block).build())

    /**
     * Describes your import snapshot tasks.
     */
    suspend fun describeImportSnapshotTasks(input: DescribeImportSnapshotTasksRequest): DescribeImportSnapshotTasksResponse

    /**
     * Describes your import snapshot tasks.
     */
    suspend fun describeImportSnapshotTasks(block: DescribeImportSnapshotTasksRequest.DslBuilder.() -> Unit) = describeImportSnapshotTasks(DescribeImportSnapshotTasksRequest.builder().apply(block).build())

    /**
     * Describes the specified attribute of the specified instance. You can specify only one
     * attribute at a time. Valid attribute values are: instanceType |
     * kernel | ramdisk | userData |
     * disableApiTermination | instanceInitiatedShutdownBehavior
     * | rootDeviceName | blockDeviceMapping |
     * productCodes | sourceDestCheck | groupSet |
     * ebsOptimized | sriovNetSupport
     */
    suspend fun describeInstanceAttribute(input: DescribeInstanceAttributeRequest): DescribeInstanceAttributeResponse

    /**
     * Describes the specified attribute of the specified instance. You can specify only one
     * attribute at a time. Valid attribute values are: instanceType |
     * kernel | ramdisk | userData |
     * disableApiTermination | instanceInitiatedShutdownBehavior
     * | rootDeviceName | blockDeviceMapping |
     * productCodes | sourceDestCheck | groupSet |
     * ebsOptimized | sriovNetSupport
     */
    suspend fun describeInstanceAttribute(block: DescribeInstanceAttributeRequest.DslBuilder.() -> Unit) = describeInstanceAttribute(DescribeInstanceAttributeRequest.builder().apply(block).build())

    /**
     * Describes the credit option for CPU usage of the specified burstable performance
     * instances. The credit options are standard and
     * unlimited.
     * If you do not specify an instance ID, Amazon EC2 returns burstable performance
     * instances with the unlimited credit option, as well as instances that were
     * previously configured as T2, T3, and T3a with the unlimited credit option.
     * For example, if you resize a T2 instance, while it is configured as
     * unlimited, to an M4 instance, Amazon EC2 returns the M4
     * instance.
     * If you specify one or more instance IDs, Amazon EC2 returns the credit option
     * (standard or unlimited) of those instances. If you specify
     * an instance ID that is not valid, such as an instance that is not a burstable
     * performance instance, an error is returned.
     * Recently terminated instances might appear in the returned results. This interval is
     * usually less than one hour.
     * If an Availability Zone is experiencing a service disruption and you specify instance
     * IDs in the affected zone, or do not specify any instance IDs at all, the call fails. If
     * you specify only instance IDs in an unaffected zone, the call works normally.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * performance instances in the Amazon EC2 User Guide.
     */
    suspend fun describeInstanceCreditSpecifications(input: DescribeInstanceCreditSpecificationsRequest): DescribeInstanceCreditSpecificationsResponse

    /**
     * Describes the credit option for CPU usage of the specified burstable performance
     * instances. The credit options are standard and
     * unlimited.
     * If you do not specify an instance ID, Amazon EC2 returns burstable performance
     * instances with the unlimited credit option, as well as instances that were
     * previously configured as T2, T3, and T3a with the unlimited credit option.
     * For example, if you resize a T2 instance, while it is configured as
     * unlimited, to an M4 instance, Amazon EC2 returns the M4
     * instance.
     * If you specify one or more instance IDs, Amazon EC2 returns the credit option
     * (standard or unlimited) of those instances. If you specify
     * an instance ID that is not valid, such as an instance that is not a burstable
     * performance instance, an error is returned.
     * Recently terminated instances might appear in the returned results. This interval is
     * usually less than one hour.
     * If an Availability Zone is experiencing a service disruption and you specify instance
     * IDs in the affected zone, or do not specify any instance IDs at all, the call fails. If
     * you specify only instance IDs in an unaffected zone, the call works normally.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * performance instances in the Amazon EC2 User Guide.
     */
    suspend fun describeInstanceCreditSpecifications(block: DescribeInstanceCreditSpecificationsRequest.DslBuilder.() -> Unit) = describeInstanceCreditSpecifications(DescribeInstanceCreditSpecificationsRequest.builder().apply(block).build())

    /**
     * Describes the tag keys that are registered to appear in scheduled event notifications for
     * resources in the current Region.
     */
    suspend fun describeInstanceEventNotificationAttributes(input: DescribeInstanceEventNotificationAttributesRequest): DescribeInstanceEventNotificationAttributesResponse

    /**
     * Describes the tag keys that are registered to appear in scheduled event notifications for
     * resources in the current Region.
     */
    suspend fun describeInstanceEventNotificationAttributes(block: DescribeInstanceEventNotificationAttributesRequest.DslBuilder.() -> Unit) = describeInstanceEventNotificationAttributes(DescribeInstanceEventNotificationAttributesRequest.builder().apply(block).build())

    /**
     * Describes the specified event windows or all event windows.
     * If you specify event window IDs, the output includes information for only the specified
     * event windows. If you specify filters, the output includes information for only those event
     * windows that meet the filter criteria. If you do not specify event windows IDs or filters,
     * the output includes information for all event windows, which can affect performance. We
     * recommend that you use pagination to ensure that the operation returns quickly and
     * successfully.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    suspend fun describeInstanceEventWindows(input: DescribeInstanceEventWindowsRequest): DescribeInstanceEventWindowsResponse

    /**
     * Describes the specified event windows or all event windows.
     * If you specify event window IDs, the output includes information for only the specified
     * event windows. If you specify filters, the output includes information for only those event
     * windows that meet the filter criteria. If you do not specify event windows IDs or filters,
     * the output includes information for all event windows, which can affect performance. We
     * recommend that you use pagination to ensure that the operation returns quickly and
     * successfully.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    suspend fun describeInstanceEventWindows(block: DescribeInstanceEventWindowsRequest.DslBuilder.() -> Unit) = describeInstanceEventWindows(DescribeInstanceEventWindowsRequest.builder().apply(block).build())

    /**
     * Describes the status of the specified instances or all of your instances. By default,
     * only running instances are described, unless you specifically indicate to return the
     * status of all instances.
     * Instance status includes the following components:
     * Status checks - Amazon EC2 performs status
     * checks on running EC2 instances to identify hardware and software issues. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html">Status checks for your instances and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html">Troubleshooting
     * instances with failed status checks in the Amazon EC2 User Guide.
     * Scheduled events - Amazon EC2 can schedule
     * events (such as reboot, stop, or terminate) for your instances related to
     * hardware issues, software updates, or system maintenance. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html">Scheduled events for your instances in the Amazon EC2 User Guide.
     * Instance state - You can manage your instances
     * from the moment you launch them through their termination. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance
     * lifecycle in the Amazon EC2 User Guide.
     */
    suspend fun describeInstanceStatus(input: DescribeInstanceStatusRequest): DescribeInstanceStatusResponse

    /**
     * Describes the status of the specified instances or all of your instances. By default,
     * only running instances are described, unless you specifically indicate to return the
     * status of all instances.
     * Instance status includes the following components:
     * Status checks - Amazon EC2 performs status
     * checks on running EC2 instances to identify hardware and software issues. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html">Status checks for your instances and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html">Troubleshooting
     * instances with failed status checks in the Amazon EC2 User Guide.
     * Scheduled events - Amazon EC2 can schedule
     * events (such as reboot, stop, or terminate) for your instances related to
     * hardware issues, software updates, or system maintenance. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html">Scheduled events for your instances in the Amazon EC2 User Guide.
     * Instance state - You can manage your instances
     * from the moment you launch them through their termination. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance
     * lifecycle in the Amazon EC2 User Guide.
     */
    suspend fun describeInstanceStatus(block: DescribeInstanceStatusRequest.DslBuilder.() -> Unit) = describeInstanceStatus(DescribeInstanceStatusRequest.builder().apply(block).build())

    /**
     * Returns a list of all instance types offered. The results can be filtered by location (Region or Availability
     * Zone). If no location is specified, the instance types offered in the current Region are returned.
     */
    suspend fun describeInstanceTypeOfferings(input: DescribeInstanceTypeOfferingsRequest): DescribeInstanceTypeOfferingsResponse

    /**
     * Returns a list of all instance types offered. The results can be filtered by location (Region or Availability
     * Zone). If no location is specified, the instance types offered in the current Region are returned.
     */
    suspend fun describeInstanceTypeOfferings(block: DescribeInstanceTypeOfferingsRequest.DslBuilder.() -> Unit) = describeInstanceTypeOfferings(DescribeInstanceTypeOfferingsRequest.builder().apply(block).build())

    /**
     * Describes the details of the instance types that are offered in a location. The results can be filtered by the
     * attributes of the instance types.
     */
    suspend fun describeInstanceTypes(input: DescribeInstanceTypesRequest): DescribeInstanceTypesResponse

    /**
     * Describes the details of the instance types that are offered in a location. The results can be filtered by the
     * attributes of the instance types.
     */
    suspend fun describeInstanceTypes(block: DescribeInstanceTypesRequest.DslBuilder.() -> Unit) = describeInstanceTypes(DescribeInstanceTypesRequest.builder().apply(block).build())

    /**
     * Describes the specified instances or all instances.
     * If you specify instance IDs, the output includes information for only the specified instances.
     * If you specify filters, the output includes information for only those instances that meet the filter criteria.
     * If you do not specify instance IDs or filters, the output includes information for all instances,
     * which can affect performance. We recommend that you use pagination to ensure that the operation
     * returns quickly and successfully.
     * If you specify an instance ID that is not valid, an error is returned. If you
     * specify an instance that you do not own, it is not included in the output.
     * Recently terminated instances might appear in the returned results. This interval is
     * usually less than one hour.
     * If you describe instances in the rare case where an Availability Zone is experiencing
     * a service disruption and you specify instance IDs that are in the affected zone, or do
     * not specify any instance IDs at all, the call fails. If you describe instances and
     * specify only instance IDs that are in an unaffected zone, the call works
     * normally.
     */
    suspend fun describeInstances(input: DescribeInstancesRequest): DescribeInstancesResponse

    /**
     * Describes the specified instances or all instances.
     * If you specify instance IDs, the output includes information for only the specified instances.
     * If you specify filters, the output includes information for only those instances that meet the filter criteria.
     * If you do not specify instance IDs or filters, the output includes information for all instances,
     * which can affect performance. We recommend that you use pagination to ensure that the operation
     * returns quickly and successfully.
     * If you specify an instance ID that is not valid, an error is returned. If you
     * specify an instance that you do not own, it is not included in the output.
     * Recently terminated instances might appear in the returned results. This interval is
     * usually less than one hour.
     * If you describe instances in the rare case where an Availability Zone is experiencing
     * a service disruption and you specify instance IDs that are in the affected zone, or do
     * not specify any instance IDs at all, the call fails. If you describe instances and
     * specify only instance IDs that are in an unaffected zone, the call works
     * normally.
     */
    suspend fun describeInstances(block: DescribeInstancesRequest.DslBuilder.() -> Unit) = describeInstances(DescribeInstancesRequest.builder().apply(block).build())

    /**
     * Describes one or more of your internet gateways.
     */
    suspend fun describeInternetGateways(input: DescribeInternetGatewaysRequest): DescribeInternetGatewaysResponse

    /**
     * Describes one or more of your internet gateways.
     */
    suspend fun describeInternetGateways(block: DescribeInternetGatewaysRequest.DslBuilder.() -> Unit) = describeInternetGateways(DescribeInternetGatewaysRequest.builder().apply(block).build())

    /**
     * Describes your IPv6 address pools.
     */
    suspend fun describeIpv6Pools(input: DescribeIpv6PoolsRequest): DescribeIpv6PoolsResponse

    /**
     * Describes your IPv6 address pools.
     */
    suspend fun describeIpv6Pools(block: DescribeIpv6PoolsRequest.DslBuilder.() -> Unit) = describeIpv6Pools(DescribeIpv6PoolsRequest.builder().apply(block).build())

    /**
     * Describes the specified key pairs or all of your key pairs.
     * For more information about key pairs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeKeyPairs(input: DescribeKeyPairsRequest): DescribeKeyPairsResponse

    /**
     * Describes the specified key pairs or all of your key pairs.
     * For more information about key pairs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeKeyPairs(block: DescribeKeyPairsRequest.DslBuilder.() -> Unit) = describeKeyPairs(DescribeKeyPairsRequest.builder().apply(block).build())

    /**
     * Describes one or more versions of a specified launch template. You can describe all
     * versions, individual versions, or a range of versions. You can also describe all the
     * latest versions or all the default versions of all the launch templates in your
     * account.
     */
    suspend fun describeLaunchTemplateVersions(input: DescribeLaunchTemplateVersionsRequest): DescribeLaunchTemplateVersionsResponse

    /**
     * Describes one or more versions of a specified launch template. You can describe all
     * versions, individual versions, or a range of versions. You can also describe all the
     * latest versions or all the default versions of all the launch templates in your
     * account.
     */
    suspend fun describeLaunchTemplateVersions(block: DescribeLaunchTemplateVersionsRequest.DslBuilder.() -> Unit) = describeLaunchTemplateVersions(DescribeLaunchTemplateVersionsRequest.builder().apply(block).build())

    /**
     * Describes one or more launch templates.
     */
    suspend fun describeLaunchTemplates(input: DescribeLaunchTemplatesRequest): DescribeLaunchTemplatesResponse

    /**
     * Describes one or more launch templates.
     */
    suspend fun describeLaunchTemplates(block: DescribeLaunchTemplatesRequest.DslBuilder.() -> Unit) = describeLaunchTemplates(DescribeLaunchTemplatesRequest.builder().apply(block).build())

    /**
     * Describes the associations between virtual interface groups and local gateway route tables.
     */
    suspend fun describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(input: DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest): DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse

    /**
     * Describes the associations between virtual interface groups and local gateway route tables.
     */
    suspend fun describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(block: DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest.DslBuilder.() -> Unit) = describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest.builder().apply(block).build())

    /**
     * Describes the specified associations between VPCs and local gateway route tables.
     */
    suspend fun describeLocalGatewayRouteTableVpcAssociations(input: DescribeLocalGatewayRouteTableVpcAssociationsRequest): DescribeLocalGatewayRouteTableVpcAssociationsResponse

    /**
     * Describes the specified associations between VPCs and local gateway route tables.
     */
    suspend fun describeLocalGatewayRouteTableVpcAssociations(block: DescribeLocalGatewayRouteTableVpcAssociationsRequest.DslBuilder.() -> Unit) = describeLocalGatewayRouteTableVpcAssociations(DescribeLocalGatewayRouteTableVpcAssociationsRequest.builder().apply(block).build())

    /**
     * Describes one or more local gateway route tables. By default, all local gateway route tables are described.
     * Alternatively, you can filter the results.
     */
    suspend fun describeLocalGatewayRouteTables(input: DescribeLocalGatewayRouteTablesRequest): DescribeLocalGatewayRouteTablesResponse

    /**
     * Describes one or more local gateway route tables. By default, all local gateway route tables are described.
     * Alternatively, you can filter the results.
     */
    suspend fun describeLocalGatewayRouteTables(block: DescribeLocalGatewayRouteTablesRequest.DslBuilder.() -> Unit) = describeLocalGatewayRouteTables(DescribeLocalGatewayRouteTablesRequest.builder().apply(block).build())

    /**
     * Describes the specified local gateway virtual interface groups.
     */
    suspend fun describeLocalGatewayVirtualInterfaceGroups(input: DescribeLocalGatewayVirtualInterfaceGroupsRequest): DescribeLocalGatewayVirtualInterfaceGroupsResponse

    /**
     * Describes the specified local gateway virtual interface groups.
     */
    suspend fun describeLocalGatewayVirtualInterfaceGroups(block: DescribeLocalGatewayVirtualInterfaceGroupsRequest.DslBuilder.() -> Unit) = describeLocalGatewayVirtualInterfaceGroups(DescribeLocalGatewayVirtualInterfaceGroupsRequest.builder().apply(block).build())

    /**
     * Describes the specified local gateway virtual interfaces.
     */
    suspend fun describeLocalGatewayVirtualInterfaces(input: DescribeLocalGatewayVirtualInterfacesRequest): DescribeLocalGatewayVirtualInterfacesResponse

    /**
     * Describes the specified local gateway virtual interfaces.
     */
    suspend fun describeLocalGatewayVirtualInterfaces(block: DescribeLocalGatewayVirtualInterfacesRequest.DslBuilder.() -> Unit) = describeLocalGatewayVirtualInterfaces(DescribeLocalGatewayVirtualInterfacesRequest.builder().apply(block).build())

    /**
     * Describes one or more local gateways. By default, all local gateways are described.
     * Alternatively, you can filter the results.
     */
    suspend fun describeLocalGateways(input: DescribeLocalGatewaysRequest): DescribeLocalGatewaysResponse

    /**
     * Describes one or more local gateways. By default, all local gateways are described.
     * Alternatively, you can filter the results.
     */
    suspend fun describeLocalGateways(block: DescribeLocalGatewaysRequest.DslBuilder.() -> Unit) = describeLocalGateways(DescribeLocalGatewaysRequest.builder().apply(block).build())

    /**
     * Describes your managed prefix lists and any Amazon Web Services-managed prefix lists.
     * To view the entries for your prefix list, use GetManagedPrefixListEntries.
     */
    suspend fun describeManagedPrefixLists(input: DescribeManagedPrefixListsRequest): DescribeManagedPrefixListsResponse

    /**
     * Describes your managed prefix lists and any Amazon Web Services-managed prefix lists.
     * To view the entries for your prefix list, use GetManagedPrefixListEntries.
     */
    suspend fun describeManagedPrefixLists(block: DescribeManagedPrefixListsRequest.DslBuilder.() -> Unit) = describeManagedPrefixLists(DescribeManagedPrefixListsRequest.builder().apply(block).build())

    /**
     * Describes your Elastic IP addresses that are being moved to the EC2-VPC platform, or that are being restored to the EC2-Classic platform. This request does not return information about any other Elastic IP addresses in your account.
     */
    suspend fun describeMovingAddresses(input: DescribeMovingAddressesRequest): DescribeMovingAddressesResponse

    /**
     * Describes your Elastic IP addresses that are being moved to the EC2-VPC platform, or that are being restored to the EC2-Classic platform. This request does not return information about any other Elastic IP addresses in your account.
     */
    suspend fun describeMovingAddresses(block: DescribeMovingAddressesRequest.DslBuilder.() -> Unit) = describeMovingAddresses(DescribeMovingAddressesRequest.builder().apply(block).build())

    /**
     * Describes one or more of your NAT gateways.
     */
    suspend fun describeNatGateways(input: DescribeNatGatewaysRequest): DescribeNatGatewaysResponse

    /**
     * Describes one or more of your NAT gateways.
     */
    suspend fun describeNatGateways(block: DescribeNatGatewaysRequest.DslBuilder.() -> Unit) = describeNatGateways(DescribeNatGatewaysRequest.builder().apply(block).build())

    /**
     * Describes one or more of your network ACLs.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun describeNetworkAcls(input: DescribeNetworkAclsRequest): DescribeNetworkAclsResponse

    /**
     * Describes one or more of your network ACLs.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun describeNetworkAcls(block: DescribeNetworkAclsRequest.DslBuilder.() -> Unit) = describeNetworkAcls(DescribeNetworkAclsRequest.builder().apply(block).build())

    /**
     * Describes one or more of your network insights analyses.
     */
    suspend fun describeNetworkInsightsAnalyses(input: DescribeNetworkInsightsAnalysesRequest): DescribeNetworkInsightsAnalysesResponse

    /**
     * Describes one or more of your network insights analyses.
     */
    suspend fun describeNetworkInsightsAnalyses(block: DescribeNetworkInsightsAnalysesRequest.DslBuilder.() -> Unit) = describeNetworkInsightsAnalyses(DescribeNetworkInsightsAnalysesRequest.builder().apply(block).build())

    /**
     * Describes one or more of your paths.
     */
    suspend fun describeNetworkInsightsPaths(input: DescribeNetworkInsightsPathsRequest): DescribeNetworkInsightsPathsResponse

    /**
     * Describes one or more of your paths.
     */
    suspend fun describeNetworkInsightsPaths(block: DescribeNetworkInsightsPathsRequest.DslBuilder.() -> Unit) = describeNetworkInsightsPaths(DescribeNetworkInsightsPathsRequest.builder().apply(block).build())

    /**
     * Describes a network interface attribute. You can specify only one attribute at a time.
     */
    suspend fun describeNetworkInterfaceAttribute(input: DescribeNetworkInterfaceAttributeRequest): DescribeNetworkInterfaceAttributeResponse

    /**
     * Describes a network interface attribute. You can specify only one attribute at a time.
     */
    suspend fun describeNetworkInterfaceAttribute(block: DescribeNetworkInterfaceAttributeRequest.DslBuilder.() -> Unit) = describeNetworkInterfaceAttribute(DescribeNetworkInterfaceAttributeRequest.builder().apply(block).build())

    /**
     * Describes the permissions for your network interfaces.
     */
    suspend fun describeNetworkInterfacePermissions(input: DescribeNetworkInterfacePermissionsRequest): DescribeNetworkInterfacePermissionsResponse

    /**
     * Describes the permissions for your network interfaces.
     */
    suspend fun describeNetworkInterfacePermissions(block: DescribeNetworkInterfacePermissionsRequest.DslBuilder.() -> Unit) = describeNetworkInterfacePermissions(DescribeNetworkInterfacePermissionsRequest.builder().apply(block).build())

    /**
     * Describes one or more of your network interfaces.
     */
    suspend fun describeNetworkInterfaces(input: DescribeNetworkInterfacesRequest): DescribeNetworkInterfacesResponse

    /**
     * Describes one or more of your network interfaces.
     */
    suspend fun describeNetworkInterfaces(block: DescribeNetworkInterfacesRequest.DslBuilder.() -> Unit) = describeNetworkInterfaces(DescribeNetworkInterfacesRequest.builder().apply(block).build())

    /**
     * Describes the specified placement groups or all of your placement groups. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups in the
     * Amazon EC2 User Guide.
     */
    suspend fun describePlacementGroups(input: DescribePlacementGroupsRequest): DescribePlacementGroupsResponse

    /**
     * Describes the specified placement groups or all of your placement groups. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups in the
     * Amazon EC2 User Guide.
     */
    suspend fun describePlacementGroups(block: DescribePlacementGroupsRequest.DslBuilder.() -> Unit) = describePlacementGroups(DescribePlacementGroupsRequest.builder().apply(block).build())

    /**
     * Describes available Amazon Web Services services in a prefix list format, which includes the prefix list
     * name and prefix list ID of the service and the IP address range for the service.
     * We recommend that you use DescribeManagedPrefixLists instead.
     */
    suspend fun describePrefixLists(input: DescribePrefixListsRequest): DescribePrefixListsResponse

    /**
     * Describes available Amazon Web Services services in a prefix list format, which includes the prefix list
     * name and prefix list ID of the service and the IP address range for the service.
     * We recommend that you use DescribeManagedPrefixLists instead.
     */
    suspend fun describePrefixLists(block: DescribePrefixListsRequest.DslBuilder.() -> Unit) = describePrefixLists(DescribePrefixListsRequest.builder().apply(block).build())

    /**
     * Describes the ID format settings for the root user and all IAM roles and IAM users
     * that have explicitly specified a longer ID (17-character ID) preference.
     * By default, all IAM roles and IAM users default to the same ID settings as the root user, unless they
     * explicitly override the settings. This request is useful for identifying those IAM users and IAM roles
     * that have overridden the default ID settings.
     * The following resource types support longer IDs: bundle |
     * conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | instance | internet-gateway |
     * network-acl | network-acl-association |
     * network-interface | network-interface-attachment |
     * prefix-list | reservation | route-table |
     * route-table-association | security-group |
     * snapshot | subnet |
     * subnet-cidr-block-association | volume | vpc
     * | vpc-cidr-block-association | vpc-endpoint |
     * vpc-peering-connection | vpn-connection | vpn-gateway.
     */
    suspend fun describePrincipalIdFormat(input: DescribePrincipalIdFormatRequest): DescribePrincipalIdFormatResponse

    /**
     * Describes the ID format settings for the root user and all IAM roles and IAM users
     * that have explicitly specified a longer ID (17-character ID) preference.
     * By default, all IAM roles and IAM users default to the same ID settings as the root user, unless they
     * explicitly override the settings. This request is useful for identifying those IAM users and IAM roles
     * that have overridden the default ID settings.
     * The following resource types support longer IDs: bundle |
     * conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | instance | internet-gateway |
     * network-acl | network-acl-association |
     * network-interface | network-interface-attachment |
     * prefix-list | reservation | route-table |
     * route-table-association | security-group |
     * snapshot | subnet |
     * subnet-cidr-block-association | volume | vpc
     * | vpc-cidr-block-association | vpc-endpoint |
     * vpc-peering-connection | vpn-connection | vpn-gateway.
     */
    suspend fun describePrincipalIdFormat(block: DescribePrincipalIdFormatRequest.DslBuilder.() -> Unit) = describePrincipalIdFormat(DescribePrincipalIdFormatRequest.builder().apply(block).build())

    /**
     * Describes the specified IPv4 address pools.
     */
    suspend fun describePublicIpv4Pools(input: DescribePublicIpv4PoolsRequest): DescribePublicIpv4PoolsResponse

    /**
     * Describes the specified IPv4 address pools.
     */
    suspend fun describePublicIpv4Pools(block: DescribePublicIpv4PoolsRequest.DslBuilder.() -> Unit) = describePublicIpv4Pools(DescribePublicIpv4PoolsRequest.builder().apply(block).build())

    /**
     * Describes the Regions that are enabled for your account, or all Regions.
     * For a list of the Regions supported by Amazon EC2, see <a href="https://docs.aws.amazon.com/general/latest/gr/ec2-service.html">
     * Amazon Elastic Compute Cloud endpoints and quotas.
     * For information about enabling and disabling Regions for your account, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html">Managing Amazon Web Services Regions in the Amazon Web Services General Reference.
     */
    suspend fun describeRegions(input: DescribeRegionsRequest): DescribeRegionsResponse

    /**
     * Describes the Regions that are enabled for your account, or all Regions.
     * For a list of the Regions supported by Amazon EC2, see <a href="https://docs.aws.amazon.com/general/latest/gr/ec2-service.html">
     * Amazon Elastic Compute Cloud endpoints and quotas.
     * For information about enabling and disabling Regions for your account, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html">Managing Amazon Web Services Regions in the Amazon Web Services General Reference.
     */
    suspend fun describeRegions(block: DescribeRegionsRequest.DslBuilder.() -> Unit) = describeRegions(DescribeRegionsRequest.builder().apply(block).build())

    /**
     * Describes a root volume replacement task. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-restoring-volume.html#replace-root">Replace a root volume in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeReplaceRootVolumeTasks(input: DescribeReplaceRootVolumeTasksRequest): DescribeReplaceRootVolumeTasksResponse

    /**
     * Describes a root volume replacement task. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-restoring-volume.html#replace-root">Replace a root volume in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeReplaceRootVolumeTasks(block: DescribeReplaceRootVolumeTasksRequest.DslBuilder.() -> Unit) = describeReplaceRootVolumeTasks(DescribeReplaceRootVolumeTasksRequest.builder().apply(block).build())

    /**
     * Describes one or more of the Reserved Instances that you purchased.
     * For more information about Reserved Instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved
     * Instances in the Amazon EC2 User Guide.
     */
    suspend fun describeReservedInstances(input: DescribeReservedInstancesRequest): DescribeReservedInstancesResponse

    /**
     * Describes one or more of the Reserved Instances that you purchased.
     * For more information about Reserved Instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved
     * Instances in the Amazon EC2 User Guide.
     */
    suspend fun describeReservedInstances(block: DescribeReservedInstancesRequest.DslBuilder.() -> Unit) = describeReservedInstances(DescribeReservedInstancesRequest.builder().apply(block).build())

    /**
     * Describes your account's Reserved Instance listings in the Reserved Instance Marketplace.
     * The Reserved Instance Marketplace matches sellers who want to resell Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances.
     * As a seller, you choose to list some or all of your Reserved Instances, and you specify the upfront price to receive for them. Your Reserved Instances are then listed in the Reserved Instance Marketplace and are available for purchase.
     * As a buyer, you specify the configuration of the Reserved Instance to purchase, and the Marketplace matches what you're searching for with what's available. The Marketplace first sells the lowest priced Reserved Instances to you, and continues to sell available Reserved Instance listings to you until your demand is met. You are charged based on the total price of all of the listings that you purchase.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace
     * in the Amazon EC2 User Guide.
     */
    suspend fun describeReservedInstancesListings(input: DescribeReservedInstancesListingsRequest): DescribeReservedInstancesListingsResponse

    /**
     * Describes your account's Reserved Instance listings in the Reserved Instance Marketplace.
     * The Reserved Instance Marketplace matches sellers who want to resell Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances.
     * As a seller, you choose to list some or all of your Reserved Instances, and you specify the upfront price to receive for them. Your Reserved Instances are then listed in the Reserved Instance Marketplace and are available for purchase.
     * As a buyer, you specify the configuration of the Reserved Instance to purchase, and the Marketplace matches what you're searching for with what's available. The Marketplace first sells the lowest priced Reserved Instances to you, and continues to sell available Reserved Instance listings to you until your demand is met. You are charged based on the total price of all of the listings that you purchase.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace
     * in the Amazon EC2 User Guide.
     */
    suspend fun describeReservedInstancesListings(block: DescribeReservedInstancesListingsRequest.DslBuilder.() -> Unit) = describeReservedInstancesListings(DescribeReservedInstancesListingsRequest.builder().apply(block).build())

    /**
     * Describes the modifications made to your Reserved Instances. If no parameter is specified, information about all your Reserved Instances modification requests is returned. If a modification ID is specified, only information about the specific modification is returned.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying Reserved Instances in the Amazon EC2 User Guide.
     */
    suspend fun describeReservedInstancesModifications(input: DescribeReservedInstancesModificationsRequest): DescribeReservedInstancesModificationsResponse

    /**
     * Describes the modifications made to your Reserved Instances. If no parameter is specified, information about all your Reserved Instances modification requests is returned. If a modification ID is specified, only information about the specific modification is returned.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying Reserved Instances in the Amazon EC2 User Guide.
     */
    suspend fun describeReservedInstancesModifications(block: DescribeReservedInstancesModificationsRequest.DslBuilder.() -> Unit) = describeReservedInstancesModifications(DescribeReservedInstancesModificationsRequest.builder().apply(block).build())

    /**
     * Describes Reserved Instance offerings that are available for purchase. With Reserved Instances, you purchase the right to launch instances for a period of time. During that time period, you do not receive insufficient capacity errors, and you pay a lower usage rate than the rate charged for On-Demand instances for the actual time used.
     * If you have listed your own Reserved Instances for sale in the Reserved Instance Marketplace, they will be excluded from these results. This is to ensure that you do not purchase your own Reserved Instances.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace
     * in the Amazon EC2 User Guide.
     */
    suspend fun describeReservedInstancesOfferings(input: DescribeReservedInstancesOfferingsRequest): DescribeReservedInstancesOfferingsResponse

    /**
     * Describes Reserved Instance offerings that are available for purchase. With Reserved Instances, you purchase the right to launch instances for a period of time. During that time period, you do not receive insufficient capacity errors, and you pay a lower usage rate than the rate charged for On-Demand instances for the actual time used.
     * If you have listed your own Reserved Instances for sale in the Reserved Instance Marketplace, they will be excluded from these results. This is to ensure that you do not purchase your own Reserved Instances.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace
     * in the Amazon EC2 User Guide.
     */
    suspend fun describeReservedInstancesOfferings(block: DescribeReservedInstancesOfferingsRequest.DslBuilder.() -> Unit) = describeReservedInstancesOfferings(DescribeReservedInstancesOfferingsRequest.builder().apply(block).build())

    /**
     * Describes one or more of your route tables.
     * Each subnet in your VPC must be associated with a route table. If a subnet is not explicitly associated with any route table, it is implicitly associated with the main route table. This command does not return the subnet ID for implicit associations.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun describeRouteTables(input: DescribeRouteTablesRequest): DescribeRouteTablesResponse

    /**
     * Describes one or more of your route tables.
     * Each subnet in your VPC must be associated with a route table. If a subnet is not explicitly associated with any route table, it is implicitly associated with the main route table. This command does not return the subnet ID for implicit associations.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun describeRouteTables(block: DescribeRouteTablesRequest.DslBuilder.() -> Unit) = describeRouteTables(DescribeRouteTablesRequest.builder().apply(block).build())

    /**
     * Finds available schedules that meet the specified criteria.
     * You can search for an available schedule no more than 3 months in advance. You must meet the minimum required duration of 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours.
     * After you find a schedule that meets your needs, call PurchaseScheduledInstances
     * to purchase Scheduled Instances with that schedule.
     */
    suspend fun describeScheduledInstanceAvailability(input: DescribeScheduledInstanceAvailabilityRequest): DescribeScheduledInstanceAvailabilityResponse

    /**
     * Finds available schedules that meet the specified criteria.
     * You can search for an available schedule no more than 3 months in advance. You must meet the minimum required duration of 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours.
     * After you find a schedule that meets your needs, call PurchaseScheduledInstances
     * to purchase Scheduled Instances with that schedule.
     */
    suspend fun describeScheduledInstanceAvailability(block: DescribeScheduledInstanceAvailabilityRequest.DslBuilder.() -> Unit) = describeScheduledInstanceAvailability(DescribeScheduledInstanceAvailabilityRequest.builder().apply(block).build())

    /**
     * Describes the specified Scheduled Instances or all your Scheduled Instances.
     */
    suspend fun describeScheduledInstances(input: DescribeScheduledInstancesRequest): DescribeScheduledInstancesResponse

    /**
     * Describes the specified Scheduled Instances or all your Scheduled Instances.
     */
    suspend fun describeScheduledInstances(block: DescribeScheduledInstancesRequest.DslBuilder.() -> Unit) = describeScheduledInstances(DescribeScheduledInstancesRequest.builder().apply(block).build())

    /**
     * &#91;VPC only&#93; Describes the VPCs on the other side of a VPC peering connection that are referencing the security groups you've specified in this request.
     */
    suspend fun describeSecurityGroupReferences(input: DescribeSecurityGroupReferencesRequest): DescribeSecurityGroupReferencesResponse

    /**
     * &#91;VPC only&#93; Describes the VPCs on the other side of a VPC peering connection that are referencing the security groups you've specified in this request.
     */
    suspend fun describeSecurityGroupReferences(block: DescribeSecurityGroupReferencesRequest.DslBuilder.() -> Unit) = describeSecurityGroupReferences(DescribeSecurityGroupReferencesRequest.builder().apply(block).build())

    /**
     * Describes one or more of your security group rules.
     */
    suspend fun describeSecurityGroupRules(input: DescribeSecurityGroupRulesRequest): DescribeSecurityGroupRulesResponse

    /**
     * Describes one or more of your security group rules.
     */
    suspend fun describeSecurityGroupRules(block: DescribeSecurityGroupRulesRequest.DslBuilder.() -> Unit) = describeSecurityGroupRules(DescribeSecurityGroupRulesRequest.builder().apply(block).build())

    /**
     * Describes the specified security groups or all of your security groups.
     * A security group is for use with instances either in the EC2-Classic platform
     * or in a specific VPC. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 security groups in
     * the Amazon Elastic Compute Cloud User Guide and
     * <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security groups for your VPC in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun describeSecurityGroups(input: DescribeSecurityGroupsRequest): DescribeSecurityGroupsResponse

    /**
     * Describes the specified security groups or all of your security groups.
     * A security group is for use with instances either in the EC2-Classic platform
     * or in a specific VPC. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 security groups in
     * the Amazon Elastic Compute Cloud User Guide and
     * <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security groups for your VPC in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun describeSecurityGroups(block: DescribeSecurityGroupsRequest.DslBuilder.() -> Unit) = describeSecurityGroups(DescribeSecurityGroupsRequest.builder().apply(block).build())

    /**
     * Describes the specified attribute of the specified snapshot. You can specify only one
     * attribute at a time.
     * For more information about EBS snapshots, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html">Amazon EBS snapshots in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeSnapshotAttribute(input: DescribeSnapshotAttributeRequest): DescribeSnapshotAttributeResponse

    /**
     * Describes the specified attribute of the specified snapshot. You can specify only one
     * attribute at a time.
     * For more information about EBS snapshots, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html">Amazon EBS snapshots in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeSnapshotAttribute(block: DescribeSnapshotAttributeRequest.DslBuilder.() -> Unit) = describeSnapshotAttribute(DescribeSnapshotAttributeRequest.builder().apply(block).build())

    /**
     * Describes the specified EBS snapshots available to you or all of the EBS snapshots
     * available to you.
     * The snapshots available to you include public snapshots, private snapshots that you own,
     * and private snapshots owned by other Amazon Web Services accounts for which you have explicit create volume
     * permissions.
     * The create volume permissions fall into the following categories:
     * public: The owner of the snapshot granted create volume
     * permissions for the snapshot to the all group. All Amazon Web Services accounts have create
     * volume permissions for these snapshots.
     * explicit: The owner of the snapshot granted create volume
     * permissions to a specific Amazon Web Services account.
     * implicit: An Amazon Web Services account has implicit create volume permissions
     * for all snapshots it owns.
     * The list of snapshots returned can be filtered by specifying snapshot IDs, snapshot
     * owners, or Amazon Web Services accounts with create volume permissions. If no options are specified,
     * Amazon EC2 returns all snapshots for which you have create volume permissions.
     * If you specify one or more snapshot IDs, only snapshots that have the specified IDs are
     * returned. If you specify an invalid snapshot ID, an error is returned. If you specify a
     * snapshot ID for which you do not have access, it is not included in the returned
     * results.
     * If you specify one or more snapshot owners using the OwnerIds option, only
     * snapshots from the specified owners and for which you have access are returned. The results
     * can include the Amazon Web Services account IDs of the specified owners, amazon for snapshots
     * owned by Amazon, or self for snapshots that you own.
     * If you specify a list of restorable users, only snapshots with create snapshot permissions
     * for those users are returned. You can specify Amazon Web Services account IDs (if you own the snapshots),
     * self for snapshots for which you own or have explicit permissions, or
     * all for public snapshots.
     * If you are describing a long list of snapshots, we recommend that you paginate the output to make the
     * list more manageable. The MaxResults parameter sets the maximum number of results
     * returned in a single page. If the list of results exceeds your MaxResults value,
     * then that number of results is returned along with a NextToken value that can be
     * passed to a subsequent DescribeSnapshots request to retrieve the remaining
     * results.
     * To get the state of fast snapshot restores for a snapshot, use DescribeFastSnapshotRestores.
     * For more information about EBS snapshots, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html">Amazon EBS snapshots in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeSnapshots(input: DescribeSnapshotsRequest): DescribeSnapshotsResponse

    /**
     * Describes the specified EBS snapshots available to you or all of the EBS snapshots
     * available to you.
     * The snapshots available to you include public snapshots, private snapshots that you own,
     * and private snapshots owned by other Amazon Web Services accounts for which you have explicit create volume
     * permissions.
     * The create volume permissions fall into the following categories:
     * public: The owner of the snapshot granted create volume
     * permissions for the snapshot to the all group. All Amazon Web Services accounts have create
     * volume permissions for these snapshots.
     * explicit: The owner of the snapshot granted create volume
     * permissions to a specific Amazon Web Services account.
     * implicit: An Amazon Web Services account has implicit create volume permissions
     * for all snapshots it owns.
     * The list of snapshots returned can be filtered by specifying snapshot IDs, snapshot
     * owners, or Amazon Web Services accounts with create volume permissions. If no options are specified,
     * Amazon EC2 returns all snapshots for which you have create volume permissions.
     * If you specify one or more snapshot IDs, only snapshots that have the specified IDs are
     * returned. If you specify an invalid snapshot ID, an error is returned. If you specify a
     * snapshot ID for which you do not have access, it is not included in the returned
     * results.
     * If you specify one or more snapshot owners using the OwnerIds option, only
     * snapshots from the specified owners and for which you have access are returned. The results
     * can include the Amazon Web Services account IDs of the specified owners, amazon for snapshots
     * owned by Amazon, or self for snapshots that you own.
     * If you specify a list of restorable users, only snapshots with create snapshot permissions
     * for those users are returned. You can specify Amazon Web Services account IDs (if you own the snapshots),
     * self for snapshots for which you own or have explicit permissions, or
     * all for public snapshots.
     * If you are describing a long list of snapshots, we recommend that you paginate the output to make the
     * list more manageable. The MaxResults parameter sets the maximum number of results
     * returned in a single page. If the list of results exceeds your MaxResults value,
     * then that number of results is returned along with a NextToken value that can be
     * passed to a subsequent DescribeSnapshots request to retrieve the remaining
     * results.
     * To get the state of fast snapshot restores for a snapshot, use DescribeFastSnapshotRestores.
     * For more information about EBS snapshots, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html">Amazon EBS snapshots in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeSnapshots(block: DescribeSnapshotsRequest.DslBuilder.() -> Unit) = describeSnapshots(DescribeSnapshotsRequest.builder().apply(block).build())

    /**
     * Describes the data feed for Spot Instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot
     * Instance data feed in the Amazon EC2 User Guide for Linux Instances.
     */
    suspend fun describeSpotDatafeedSubscription(input: DescribeSpotDatafeedSubscriptionRequest): DescribeSpotDatafeedSubscriptionResponse

    /**
     * Describes the data feed for Spot Instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot
     * Instance data feed in the Amazon EC2 User Guide for Linux Instances.
     */
    suspend fun describeSpotDatafeedSubscription(block: DescribeSpotDatafeedSubscriptionRequest.DslBuilder.() -> Unit) = describeSpotDatafeedSubscription(DescribeSpotDatafeedSubscriptionRequest.builder().apply(block).build())

    /**
     * Describes the running instances for the specified Spot Fleet.
     */
    suspend fun describeSpotFleetInstances(input: DescribeSpotFleetInstancesRequest): DescribeSpotFleetInstancesResponse

    /**
     * Describes the running instances for the specified Spot Fleet.
     */
    suspend fun describeSpotFleetInstances(block: DescribeSpotFleetInstancesRequest.DslBuilder.() -> Unit) = describeSpotFleetInstances(DescribeSpotFleetInstancesRequest.builder().apply(block).build())

    /**
     * Describes the events for the specified Spot Fleet request during the specified
     * time.
     * Spot Fleet events are delayed by up to 30 seconds before they can be described. This
     * ensures that you can query by the last evaluated time and not miss a recorded event.
     * Spot Fleet events are available for 48 hours.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/fleet-monitor.html">Monitor fleet events using Amazon
     * EventBridge in the Amazon EC2 User Guide for Linux Instances.
     */
    suspend fun describeSpotFleetRequestHistory(input: DescribeSpotFleetRequestHistoryRequest): DescribeSpotFleetRequestHistoryResponse

    /**
     * Describes the events for the specified Spot Fleet request during the specified
     * time.
     * Spot Fleet events are delayed by up to 30 seconds before they can be described. This
     * ensures that you can query by the last evaluated time and not miss a recorded event.
     * Spot Fleet events are available for 48 hours.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/fleet-monitor.html">Monitor fleet events using Amazon
     * EventBridge in the Amazon EC2 User Guide for Linux Instances.
     */
    suspend fun describeSpotFleetRequestHistory(block: DescribeSpotFleetRequestHistoryRequest.DslBuilder.() -> Unit) = describeSpotFleetRequestHistory(DescribeSpotFleetRequestHistoryRequest.builder().apply(block).build())

    /**
     * Describes your Spot Fleet requests.
     * Spot Fleet requests are deleted 48 hours after they are canceled and their instances
     * are terminated.
     */
    suspend fun describeSpotFleetRequests(input: DescribeSpotFleetRequestsRequest): DescribeSpotFleetRequestsResponse

    /**
     * Describes your Spot Fleet requests.
     * Spot Fleet requests are deleted 48 hours after they are canceled and their instances
     * are terminated.
     */
    suspend fun describeSpotFleetRequests(block: DescribeSpotFleetRequestsRequest.DslBuilder.() -> Unit) = describeSpotFleetRequests(DescribeSpotFleetRequestsRequest.builder().apply(block).build())

    /**
     * Describes the specified Spot Instance requests.
     * You can use DescribeSpotInstanceRequests to find a running Spot Instance by
     * examining the response. If the status of the Spot Instance is fulfilled, the
     * instance ID appears in the response and contains the identifier of the instance.
     * Alternatively, you can use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances">DescribeInstances
     * with a filter to look for instances where the instance lifecycle is
     * spot.
     * We recommend that you set MaxResults to a value between 5 and 1000 to
     * limit the number of results returned. This paginates the output, which makes the list
     * more manageable and returns the results faster. If the list of results exceeds your
     * MaxResults value, then that number of results is returned along with a
     * NextToken value that can be passed to a subsequent
     * DescribeSpotInstanceRequests request to retrieve the remaining
     * results.
     * Spot Instance requests are deleted four hours after they are canceled and their instances are
     * terminated.
     */
    suspend fun describeSpotInstanceRequests(input: DescribeSpotInstanceRequestsRequest): DescribeSpotInstanceRequestsResponse

    /**
     * Describes the specified Spot Instance requests.
     * You can use DescribeSpotInstanceRequests to find a running Spot Instance by
     * examining the response. If the status of the Spot Instance is fulfilled, the
     * instance ID appears in the response and contains the identifier of the instance.
     * Alternatively, you can use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances">DescribeInstances
     * with a filter to look for instances where the instance lifecycle is
     * spot.
     * We recommend that you set MaxResults to a value between 5 and 1000 to
     * limit the number of results returned. This paginates the output, which makes the list
     * more manageable and returns the results faster. If the list of results exceeds your
     * MaxResults value, then that number of results is returned along with a
     * NextToken value that can be passed to a subsequent
     * DescribeSpotInstanceRequests request to retrieve the remaining
     * results.
     * Spot Instance requests are deleted four hours after they are canceled and their instances are
     * terminated.
     */
    suspend fun describeSpotInstanceRequests(block: DescribeSpotInstanceRequestsRequest.DslBuilder.() -> Unit) = describeSpotInstanceRequests(DescribeSpotInstanceRequestsRequest.builder().apply(block).build())

    /**
     * Describes the Spot price history. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances-history.html">Spot Instance pricing history in the
     * Amazon EC2 User Guide for Linux Instances.
     * When you specify a start and end time, the operation returns the prices of the
     * instance types within that time range. It also returns the last price change before the
     * start time, which is the effective price as of the start time.
     */
    suspend fun describeSpotPriceHistory(input: DescribeSpotPriceHistoryRequest): DescribeSpotPriceHistoryResponse

    /**
     * Describes the Spot price history. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances-history.html">Spot Instance pricing history in the
     * Amazon EC2 User Guide for Linux Instances.
     * When you specify a start and end time, the operation returns the prices of the
     * instance types within that time range. It also returns the last price change before the
     * start time, which is the effective price as of the start time.
     */
    suspend fun describeSpotPriceHistory(block: DescribeSpotPriceHistoryRequest.DslBuilder.() -> Unit) = describeSpotPriceHistory(DescribeSpotPriceHistoryRequest.builder().apply(block).build())

    /**
     * &#91;VPC only&#93; Describes the stale security group rules for security groups in a specified VPC. Rules are stale when they reference a deleted security group in a peer VPC, or a security group in a peer VPC for which the VPC peering connection has been deleted.
     */
    suspend fun describeStaleSecurityGroups(input: DescribeStaleSecurityGroupsRequest): DescribeStaleSecurityGroupsResponse

    /**
     * &#91;VPC only&#93; Describes the stale security group rules for security groups in a specified VPC. Rules are stale when they reference a deleted security group in a peer VPC, or a security group in a peer VPC for which the VPC peering connection has been deleted.
     */
    suspend fun describeStaleSecurityGroups(block: DescribeStaleSecurityGroupsRequest.DslBuilder.() -> Unit) = describeStaleSecurityGroups(DescribeStaleSecurityGroupsRequest.builder().apply(block).build())

    /**
     * Describes the progress of the AMI store tasks. You can describe the store tasks for
     * specified AMIs. If you don't specify the AMIs, you get a paginated list of store tasks from
     * the last 31 days.
     * For each AMI task, the response indicates if the task is InProgress,
     * Completed, or Failed. For tasks InProgress, the
     * response shows the estimated progress as a percentage.
     * Tasks are listed in reverse chronological order. Currently, only tasks from the past 31
     * days can be viewed.
     * To use this API, you must have the required permissions. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions for storing and restoring AMIs using Amazon S3 in the
     * Amazon Elastic Compute Cloud User Guide.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3 in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeStoreImageTasks(input: DescribeStoreImageTasksRequest): DescribeStoreImageTasksResponse

    /**
     * Describes the progress of the AMI store tasks. You can describe the store tasks for
     * specified AMIs. If you don't specify the AMIs, you get a paginated list of store tasks from
     * the last 31 days.
     * For each AMI task, the response indicates if the task is InProgress,
     * Completed, or Failed. For tasks InProgress, the
     * response shows the estimated progress as a percentage.
     * Tasks are listed in reverse chronological order. Currently, only tasks from the past 31
     * days can be viewed.
     * To use this API, you must have the required permissions. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions for storing and restoring AMIs using Amazon S3 in the
     * Amazon Elastic Compute Cloud User Guide.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3 in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeStoreImageTasks(block: DescribeStoreImageTasksRequest.DslBuilder.() -> Unit) = describeStoreImageTasks(DescribeStoreImageTasksRequest.builder().apply(block).build())

    /**
     * Describes one or more of your subnets.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and subnets in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun describeSubnets(input: DescribeSubnetsRequest): DescribeSubnetsResponse

    /**
     * Describes one or more of your subnets.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and subnets in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun describeSubnets(block: DescribeSubnetsRequest.DslBuilder.() -> Unit) = describeSubnets(DescribeSubnetsRequest.builder().apply(block).build())

    /**
     * Describes the specified tags for your EC2 resources.
     * For more information about tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse

    /**
     * Describes the specified tags for your EC2 resources.
     * For more information about tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeTags(block: DescribeTagsRequest.DslBuilder.() -> Unit) = describeTags(DescribeTagsRequest.builder().apply(block).build())

    /**
     * Describes one or more Traffic Mirror filters.
     */
    suspend fun describeTrafficMirrorFilters(input: DescribeTrafficMirrorFiltersRequest): DescribeTrafficMirrorFiltersResponse

    /**
     * Describes one or more Traffic Mirror filters.
     */
    suspend fun describeTrafficMirrorFilters(block: DescribeTrafficMirrorFiltersRequest.DslBuilder.() -> Unit) = describeTrafficMirrorFilters(DescribeTrafficMirrorFiltersRequest.builder().apply(block).build())

    /**
     * Describes one or more Traffic Mirror sessions. By default, all Traffic Mirror sessions are described. Alternatively, you can filter the results.
     */
    suspend fun describeTrafficMirrorSessions(input: DescribeTrafficMirrorSessionsRequest): DescribeTrafficMirrorSessionsResponse

    /**
     * Describes one or more Traffic Mirror sessions. By default, all Traffic Mirror sessions are described. Alternatively, you can filter the results.
     */
    suspend fun describeTrafficMirrorSessions(block: DescribeTrafficMirrorSessionsRequest.DslBuilder.() -> Unit) = describeTrafficMirrorSessions(DescribeTrafficMirrorSessionsRequest.builder().apply(block).build())

    /**
     * Information about one or more Traffic Mirror targets.
     */
    suspend fun describeTrafficMirrorTargets(input: DescribeTrafficMirrorTargetsRequest): DescribeTrafficMirrorTargetsResponse

    /**
     * Information about one or more Traffic Mirror targets.
     */
    suspend fun describeTrafficMirrorTargets(block: DescribeTrafficMirrorTargetsRequest.DslBuilder.() -> Unit) = describeTrafficMirrorTargets(DescribeTrafficMirrorTargetsRequest.builder().apply(block).build())

    /**
     * Describes one or more attachments between resources and transit gateways. By default, all attachments are described.
     * Alternatively, you can filter the results by attachment ID, attachment state, resource ID, or resource owner.
     */
    suspend fun describeTransitGatewayAttachments(input: DescribeTransitGatewayAttachmentsRequest): DescribeTransitGatewayAttachmentsResponse

    /**
     * Describes one or more attachments between resources and transit gateways. By default, all attachments are described.
     * Alternatively, you can filter the results by attachment ID, attachment state, resource ID, or resource owner.
     */
    suspend fun describeTransitGatewayAttachments(block: DescribeTransitGatewayAttachmentsRequest.DslBuilder.() -> Unit) = describeTransitGatewayAttachments(DescribeTransitGatewayAttachmentsRequest.builder().apply(block).build())

    /**
     * Describes one or more Connect peers.
     */
    suspend fun describeTransitGatewayConnectPeers(input: DescribeTransitGatewayConnectPeersRequest): DescribeTransitGatewayConnectPeersResponse

    /**
     * Describes one or more Connect peers.
     */
    suspend fun describeTransitGatewayConnectPeers(block: DescribeTransitGatewayConnectPeersRequest.DslBuilder.() -> Unit) = describeTransitGatewayConnectPeers(DescribeTransitGatewayConnectPeersRequest.builder().apply(block).build())

    /**
     * Describes one or more Connect attachments.
     */
    suspend fun describeTransitGatewayConnects(input: DescribeTransitGatewayConnectsRequest): DescribeTransitGatewayConnectsResponse

    /**
     * Describes one or more Connect attachments.
     */
    suspend fun describeTransitGatewayConnects(block: DescribeTransitGatewayConnectsRequest.DslBuilder.() -> Unit) = describeTransitGatewayConnects(DescribeTransitGatewayConnectsRequest.builder().apply(block).build())

    /**
     * Describes one or more transit gateway multicast domains.
     */
    suspend fun describeTransitGatewayMulticastDomains(input: DescribeTransitGatewayMulticastDomainsRequest): DescribeTransitGatewayMulticastDomainsResponse

    /**
     * Describes one or more transit gateway multicast domains.
     */
    suspend fun describeTransitGatewayMulticastDomains(block: DescribeTransitGatewayMulticastDomainsRequest.DslBuilder.() -> Unit) = describeTransitGatewayMulticastDomains(DescribeTransitGatewayMulticastDomainsRequest.builder().apply(block).build())

    /**
     * Describes your transit gateway peering attachments.
     */
    suspend fun describeTransitGatewayPeeringAttachments(input: DescribeTransitGatewayPeeringAttachmentsRequest): DescribeTransitGatewayPeeringAttachmentsResponse

    /**
     * Describes your transit gateway peering attachments.
     */
    suspend fun describeTransitGatewayPeeringAttachments(block: DescribeTransitGatewayPeeringAttachmentsRequest.DslBuilder.() -> Unit) = describeTransitGatewayPeeringAttachments(DescribeTransitGatewayPeeringAttachmentsRequest.builder().apply(block).build())

    /**
     * Describes one or more transit gateway route tables. By default, all transit gateway route tables are described.
     * Alternatively, you can filter the results.
     */
    suspend fun describeTransitGatewayRouteTables(input: DescribeTransitGatewayRouteTablesRequest): DescribeTransitGatewayRouteTablesResponse

    /**
     * Describes one or more transit gateway route tables. By default, all transit gateway route tables are described.
     * Alternatively, you can filter the results.
     */
    suspend fun describeTransitGatewayRouteTables(block: DescribeTransitGatewayRouteTablesRequest.DslBuilder.() -> Unit) = describeTransitGatewayRouteTables(DescribeTransitGatewayRouteTablesRequest.builder().apply(block).build())

    /**
     * Describes one or more VPC attachments. By default, all VPC attachments are described.
     * Alternatively, you can filter the results.
     */
    suspend fun describeTransitGatewayVpcAttachments(input: DescribeTransitGatewayVpcAttachmentsRequest): DescribeTransitGatewayVpcAttachmentsResponse

    /**
     * Describes one or more VPC attachments. By default, all VPC attachments are described.
     * Alternatively, you can filter the results.
     */
    suspend fun describeTransitGatewayVpcAttachments(block: DescribeTransitGatewayVpcAttachmentsRequest.DslBuilder.() -> Unit) = describeTransitGatewayVpcAttachments(DescribeTransitGatewayVpcAttachmentsRequest.builder().apply(block).build())

    /**
     * Describes one or more transit gateways. By default, all transit gateways are described. Alternatively, you can
     * filter the results.
     */
    suspend fun describeTransitGateways(input: DescribeTransitGatewaysRequest): DescribeTransitGatewaysResponse

    /**
     * Describes one or more transit gateways. By default, all transit gateways are described. Alternatively, you can
     * filter the results.
     */
    suspend fun describeTransitGateways(block: DescribeTransitGatewaysRequest.DslBuilder.() -> Unit) = describeTransitGateways(DescribeTransitGatewaysRequest.builder().apply(block).build())

    /**
     * This API action is currently in limited preview only.
     * If you are interested in using this feature, contact your account manager.
     * Describes one or more network interface trunk associations.
     */
    suspend fun describeTrunkInterfaceAssociations(input: DescribeTrunkInterfaceAssociationsRequest): DescribeTrunkInterfaceAssociationsResponse

    /**
     * This API action is currently in limited preview only.
     * If you are interested in using this feature, contact your account manager.
     * Describes one or more network interface trunk associations.
     */
    suspend fun describeTrunkInterfaceAssociations(block: DescribeTrunkInterfaceAssociationsRequest.DslBuilder.() -> Unit) = describeTrunkInterfaceAssociations(DescribeTrunkInterfaceAssociationsRequest.builder().apply(block).build())

    /**
     * Describes the specified attribute of the specified volume. You can specify only one
     * attribute at a time.
     * For more information about EBS volumes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html">Amazon EBS volumes in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeVolumeAttribute(input: DescribeVolumeAttributeRequest): DescribeVolumeAttributeResponse

    /**
     * Describes the specified attribute of the specified volume. You can specify only one
     * attribute at a time.
     * For more information about EBS volumes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html">Amazon EBS volumes in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeVolumeAttribute(block: DescribeVolumeAttributeRequest.DslBuilder.() -> Unit) = describeVolumeAttribute(DescribeVolumeAttributeRequest.builder().apply(block).build())

    /**
     * Describes the status of the specified volumes. Volume status provides the result of the
     * checks performed on your volumes to determine events that can impair the performance of your
     * volumes. The performance of a volume can be affected if an issue occurs on the volume's
     * underlying host. If the volume's underlying host experiences a power outage or system issue,
     * after the system is restored, there could be data inconsistencies on the volume. Volume events
     * notify you if this occurs. Volume actions notify you if any action needs to be taken in
     * response to the event.
     * The DescribeVolumeStatus operation provides the following information about
     * the specified volumes:
     * Status: Reflects the current status of the volume. The possible
     * values are ok, impaired , warning, or
     * insufficient-data. If all checks pass, the overall status of the volume is
     * ok. If the check fails, the overall status is impaired. If the
     * status is insufficient-data, then the checks might still be taking place on your
     * volume at the time. We recommend that you retry the request. For more information about volume
     * status, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-status.html">Monitor the status of your volumes in the
     * Amazon Elastic Compute Cloud User Guide.
     * Events: Reflect the cause of a volume status and might require you to
     * take action. For example, if your volume returns an impaired status, then the
     * volume event might be potential-data-inconsistency. This means that your volume
     * has been affected by an issue with the underlying host, has all I/O operations disabled, and
     * might have inconsistent data.
     * Actions: Reflect the actions you might have to take in response to an
     * event. For example, if the status of the volume is impaired and the volume event
     * shows potential-data-inconsistency, then the action shows
     * enable-volume-io. This means that you may want to enable the I/O operations for
     * the volume by calling the EnableVolumeIO action and then check the volume
     * for data consistency.
     * Volume status is based on the volume status checks, and does not reflect the volume state.
     * Therefore, volume status does not indicate volumes in the error state (for
     * example, when a volume is incapable of accepting I/O.)
     */
    suspend fun describeVolumeStatus(input: DescribeVolumeStatusRequest): DescribeVolumeStatusResponse

    /**
     * Describes the status of the specified volumes. Volume status provides the result of the
     * checks performed on your volumes to determine events that can impair the performance of your
     * volumes. The performance of a volume can be affected if an issue occurs on the volume's
     * underlying host. If the volume's underlying host experiences a power outage or system issue,
     * after the system is restored, there could be data inconsistencies on the volume. Volume events
     * notify you if this occurs. Volume actions notify you if any action needs to be taken in
     * response to the event.
     * The DescribeVolumeStatus operation provides the following information about
     * the specified volumes:
     * Status: Reflects the current status of the volume. The possible
     * values are ok, impaired , warning, or
     * insufficient-data. If all checks pass, the overall status of the volume is
     * ok. If the check fails, the overall status is impaired. If the
     * status is insufficient-data, then the checks might still be taking place on your
     * volume at the time. We recommend that you retry the request. For more information about volume
     * status, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-status.html">Monitor the status of your volumes in the
     * Amazon Elastic Compute Cloud User Guide.
     * Events: Reflect the cause of a volume status and might require you to
     * take action. For example, if your volume returns an impaired status, then the
     * volume event might be potential-data-inconsistency. This means that your volume
     * has been affected by an issue with the underlying host, has all I/O operations disabled, and
     * might have inconsistent data.
     * Actions: Reflect the actions you might have to take in response to an
     * event. For example, if the status of the volume is impaired and the volume event
     * shows potential-data-inconsistency, then the action shows
     * enable-volume-io. This means that you may want to enable the I/O operations for
     * the volume by calling the EnableVolumeIO action and then check the volume
     * for data consistency.
     * Volume status is based on the volume status checks, and does not reflect the volume state.
     * Therefore, volume status does not indicate volumes in the error state (for
     * example, when a volume is incapable of accepting I/O.)
     */
    suspend fun describeVolumeStatus(block: DescribeVolumeStatusRequest.DslBuilder.() -> Unit) = describeVolumeStatus(DescribeVolumeStatusRequest.builder().apply(block).build())

    /**
     * Describes the specified EBS volumes or all of your EBS volumes.
     * If you are describing a long list of volumes, we recommend that you paginate the output to make the list
     * more manageable. The MaxResults parameter sets the maximum number of results
     * returned in a single page. If the list of results exceeds your MaxResults value,
     * then that number of results is returned along with a NextToken value that can be
     * passed to a subsequent DescribeVolumes request to retrieve the remaining
     * results.
     * For more information about EBS volumes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html">Amazon EBS volumes in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeVolumes(input: DescribeVolumesRequest): DescribeVolumesResponse

    /**
     * Describes the specified EBS volumes or all of your EBS volumes.
     * If you are describing a long list of volumes, we recommend that you paginate the output to make the list
     * more manageable. The MaxResults parameter sets the maximum number of results
     * returned in a single page. If the list of results exceeds your MaxResults value,
     * then that number of results is returned along with a NextToken value that can be
     * passed to a subsequent DescribeVolumes request to retrieve the remaining
     * results.
     * For more information about EBS volumes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html">Amazon EBS volumes in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeVolumes(block: DescribeVolumesRequest.DslBuilder.() -> Unit) = describeVolumes(DescribeVolumesRequest.builder().apply(block).build())

    /**
     * Describes the most recent volume modification request for the specified EBS volumes.
     * If a volume has never been modified, some information in the output will be null.
     * If a volume has been modified more than once, the output includes only the most
     * recent modification request.
     * You can also use CloudWatch Events to check the status of a modification to an EBS
     * volume. For information about CloudWatch Events, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/">Amazon CloudWatch Events User Guide. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-modifications.html">Monitor the progress of volume modifications in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeVolumesModifications(input: DescribeVolumesModificationsRequest): DescribeVolumesModificationsResponse

    /**
     * Describes the most recent volume modification request for the specified EBS volumes.
     * If a volume has never been modified, some information in the output will be null.
     * If a volume has been modified more than once, the output includes only the most
     * recent modification request.
     * You can also use CloudWatch Events to check the status of a modification to an EBS
     * volume. For information about CloudWatch Events, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/">Amazon CloudWatch Events User Guide. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-modifications.html">Monitor the progress of volume modifications in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeVolumesModifications(block: DescribeVolumesModificationsRequest.DslBuilder.() -> Unit) = describeVolumesModifications(DescribeVolumesModificationsRequest.builder().apply(block).build())

    /**
     * Describes the specified attribute of the specified VPC. You can specify only one attribute at a time.
     */
    suspend fun describeVpcAttribute(input: DescribeVpcAttributeRequest): DescribeVpcAttributeResponse

    /**
     * Describes the specified attribute of the specified VPC. You can specify only one attribute at a time.
     */
    suspend fun describeVpcAttribute(block: DescribeVpcAttributeRequest.DslBuilder.() -> Unit) = describeVpcAttribute(DescribeVpcAttributeRequest.builder().apply(block).build())

    /**
     * Describes the ClassicLink status of one or more VPCs.
     */
    suspend fun describeVpcClassicLink(input: DescribeVpcClassicLinkRequest): DescribeVpcClassicLinkResponse

    /**
     * Describes the ClassicLink status of one or more VPCs.
     */
    suspend fun describeVpcClassicLink(block: DescribeVpcClassicLinkRequest.DslBuilder.() -> Unit) = describeVpcClassicLink(DescribeVpcClassicLinkRequest.builder().apply(block).build())

    /**
     * Describes the ClassicLink DNS support status of one or more VPCs. If enabled, the DNS
     * hostname of a linked EC2-Classic instance resolves to its private IP address when
     * addressed from an instance in the VPC to which it's linked. Similarly, the DNS hostname
     * of an instance in a VPC resolves to its private IP address when addressed from a linked
     * EC2-Classic instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeVpcClassicLinkDnsSupport(input: DescribeVpcClassicLinkDnsSupportRequest): DescribeVpcClassicLinkDnsSupportResponse

    /**
     * Describes the ClassicLink DNS support status of one or more VPCs. If enabled, the DNS
     * hostname of a linked EC2-Classic instance resolves to its private IP address when
     * addressed from an instance in the VPC to which it's linked. Similarly, the DNS hostname
     * of an instance in a VPC resolves to its private IP address when addressed from a linked
     * EC2-Classic instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun describeVpcClassicLinkDnsSupport(block: DescribeVpcClassicLinkDnsSupportRequest.DslBuilder.() -> Unit) = describeVpcClassicLinkDnsSupport(DescribeVpcClassicLinkDnsSupportRequest.builder().apply(block).build())

    /**
     * Describes the connection notifications for VPC endpoints and VPC endpoint
     * services.
     */
    suspend fun describeVpcEndpointConnectionNotifications(input: DescribeVpcEndpointConnectionNotificationsRequest): DescribeVpcEndpointConnectionNotificationsResponse

    /**
     * Describes the connection notifications for VPC endpoints and VPC endpoint
     * services.
     */
    suspend fun describeVpcEndpointConnectionNotifications(block: DescribeVpcEndpointConnectionNotificationsRequest.DslBuilder.() -> Unit) = describeVpcEndpointConnectionNotifications(DescribeVpcEndpointConnectionNotificationsRequest.builder().apply(block).build())

    /**
     * Describes the VPC endpoint connections to your VPC endpoint services, including any
     * endpoints that are pending your acceptance.
     */
    suspend fun describeVpcEndpointConnections(input: DescribeVpcEndpointConnectionsRequest): DescribeVpcEndpointConnectionsResponse

    /**
     * Describes the VPC endpoint connections to your VPC endpoint services, including any
     * endpoints that are pending your acceptance.
     */
    suspend fun describeVpcEndpointConnections(block: DescribeVpcEndpointConnectionsRequest.DslBuilder.() -> Unit) = describeVpcEndpointConnections(DescribeVpcEndpointConnectionsRequest.builder().apply(block).build())

    /**
     * Describes the VPC endpoint service configurations in your account (your services).
     */
    suspend fun describeVpcEndpointServiceConfigurations(input: DescribeVpcEndpointServiceConfigurationsRequest): DescribeVpcEndpointServiceConfigurationsResponse

    /**
     * Describes the VPC endpoint service configurations in your account (your services).
     */
    suspend fun describeVpcEndpointServiceConfigurations(block: DescribeVpcEndpointServiceConfigurationsRequest.DslBuilder.() -> Unit) = describeVpcEndpointServiceConfigurations(DescribeVpcEndpointServiceConfigurationsRequest.builder().apply(block).build())

    /**
     * Describes the principals (service consumers) that are permitted to discover your VPC
     * endpoint service.
     */
    suspend fun describeVpcEndpointServicePermissions(input: DescribeVpcEndpointServicePermissionsRequest): DescribeVpcEndpointServicePermissionsResponse

    /**
     * Describes the principals (service consumers) that are permitted to discover your VPC
     * endpoint service.
     */
    suspend fun describeVpcEndpointServicePermissions(block: DescribeVpcEndpointServicePermissionsRequest.DslBuilder.() -> Unit) = describeVpcEndpointServicePermissions(DescribeVpcEndpointServicePermissionsRequest.builder().apply(block).build())

    /**
     * Describes available services to which you can create a VPC endpoint.
     * When the service provider and the consumer have different accounts in multiple
     * Availability Zones, and the consumer views the VPC endpoint service information, the
     * response only includes the common Availability Zones. For example, when the service
     * provider account uses us-east-1a and us-east-1c and the
     * consumer uses us-east-1a and us-east-1b, the response includes
     * the VPC endpoint services in the common Availability Zone,
     * us-east-1a.
     */
    suspend fun describeVpcEndpointServices(input: DescribeVpcEndpointServicesRequest): DescribeVpcEndpointServicesResponse

    /**
     * Describes available services to which you can create a VPC endpoint.
     * When the service provider and the consumer have different accounts in multiple
     * Availability Zones, and the consumer views the VPC endpoint service information, the
     * response only includes the common Availability Zones. For example, when the service
     * provider account uses us-east-1a and us-east-1c and the
     * consumer uses us-east-1a and us-east-1b, the response includes
     * the VPC endpoint services in the common Availability Zone,
     * us-east-1a.
     */
    suspend fun describeVpcEndpointServices(block: DescribeVpcEndpointServicesRequest.DslBuilder.() -> Unit) = describeVpcEndpointServices(DescribeVpcEndpointServicesRequest.builder().apply(block).build())

    /**
     * Describes one or more of your VPC endpoints.
     */
    suspend fun describeVpcEndpoints(input: DescribeVpcEndpointsRequest): DescribeVpcEndpointsResponse

    /**
     * Describes one or more of your VPC endpoints.
     */
    suspend fun describeVpcEndpoints(block: DescribeVpcEndpointsRequest.DslBuilder.() -> Unit) = describeVpcEndpoints(DescribeVpcEndpointsRequest.builder().apply(block).build())

    /**
     * Describes one or more of your VPC peering connections.
     */
    suspend fun describeVpcPeeringConnections(input: DescribeVpcPeeringConnectionsRequest): DescribeVpcPeeringConnectionsResponse

    /**
     * Describes one or more of your VPC peering connections.
     */
    suspend fun describeVpcPeeringConnections(block: DescribeVpcPeeringConnectionsRequest.DslBuilder.() -> Unit) = describeVpcPeeringConnections(DescribeVpcPeeringConnectionsRequest.builder().apply(block).build())

    /**
     * Describes one or more of your VPCs.
     */
    suspend fun describeVpcs(input: DescribeVpcsRequest): DescribeVpcsResponse

    /**
     * Describes one or more of your VPCs.
     */
    suspend fun describeVpcs(block: DescribeVpcsRequest.DslBuilder.() -> Unit) = describeVpcs(DescribeVpcsRequest.builder().apply(block).build())

    /**
     * Describes one or more of your VPN connections.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    suspend fun describeVpnConnections(input: DescribeVpnConnectionsRequest): DescribeVpnConnectionsResponse

    /**
     * Describes one or more of your VPN connections.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    suspend fun describeVpnConnections(block: DescribeVpnConnectionsRequest.DslBuilder.() -> Unit) = describeVpnConnections(DescribeVpnConnectionsRequest.builder().apply(block).build())

    /**
     * Describes one or more of your virtual private gateways.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    suspend fun describeVpnGateways(input: DescribeVpnGatewaysRequest): DescribeVpnGatewaysResponse

    /**
     * Describes one or more of your virtual private gateways.
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN
     * User Guide.
     */
    suspend fun describeVpnGateways(block: DescribeVpnGatewaysRequest.DslBuilder.() -> Unit) = describeVpnGateways(DescribeVpnGatewaysRequest.builder().apply(block).build())

    /**
     * Unlinks (detaches) a linked EC2-Classic instance from a VPC. After the instance has been unlinked, the VPC security groups are no longer associated with it. An instance is automatically unlinked from a VPC when it's stopped.
     */
    suspend fun detachClassicLinkVpc(input: DetachClassicLinkVpcRequest): DetachClassicLinkVpcResponse

    /**
     * Unlinks (detaches) a linked EC2-Classic instance from a VPC. After the instance has been unlinked, the VPC security groups are no longer associated with it. An instance is automatically unlinked from a VPC when it's stopped.
     */
    suspend fun detachClassicLinkVpc(block: DetachClassicLinkVpcRequest.DslBuilder.() -> Unit) = detachClassicLinkVpc(DetachClassicLinkVpcRequest.builder().apply(block).build())

    /**
     * Detaches an internet gateway from a VPC, disabling connectivity between the internet
     * and the VPC. The VPC must not contain any running instances with Elastic IP addresses or
     * public IPv4 addresses.
     */
    suspend fun detachInternetGateway(input: DetachInternetGatewayRequest): DetachInternetGatewayResponse

    /**
     * Detaches an internet gateway from a VPC, disabling connectivity between the internet
     * and the VPC. The VPC must not contain any running instances with Elastic IP addresses or
     * public IPv4 addresses.
     */
    suspend fun detachInternetGateway(block: DetachInternetGatewayRequest.DslBuilder.() -> Unit) = detachInternetGateway(DetachInternetGatewayRequest.builder().apply(block).build())

    /**
     * Detaches a network interface from an instance.
     */
    suspend fun detachNetworkInterface(input: DetachNetworkInterfaceRequest): DetachNetworkInterfaceResponse

    /**
     * Detaches a network interface from an instance.
     */
    suspend fun detachNetworkInterface(block: DetachNetworkInterfaceRequest.DslBuilder.() -> Unit) = detachNetworkInterface(DetachNetworkInterfaceRequest.builder().apply(block).build())

    /**
     * Detaches an EBS volume from an instance. Make sure to unmount any file systems on the
     * device within your operating system before detaching the volume. Failure to do so can result
     * in the volume becoming stuck in the busy state while detaching. If this happens,
     * detachment can be delayed indefinitely until you unmount the volume, force detachment, reboot
     * the instance, or all three. If an EBS volume is the root device of an instance, it can't be
     * detached while the instance is running. To detach the root volume, stop the instance
     * first.
     * When a volume with an Amazon Web Services Marketplace product code is detached from an instance, the
     * product code is no longer associated with the instance.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-detaching-volume.html">Detach an Amazon EBS volume in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun detachVolume(input: DetachVolumeRequest): DetachVolumeResponse

    /**
     * Detaches an EBS volume from an instance. Make sure to unmount any file systems on the
     * device within your operating system before detaching the volume. Failure to do so can result
     * in the volume becoming stuck in the busy state while detaching. If this happens,
     * detachment can be delayed indefinitely until you unmount the volume, force detachment, reboot
     * the instance, or all three. If an EBS volume is the root device of an instance, it can't be
     * detached while the instance is running. To detach the root volume, stop the instance
     * first.
     * When a volume with an Amazon Web Services Marketplace product code is detached from an instance, the
     * product code is no longer associated with the instance.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-detaching-volume.html">Detach an Amazon EBS volume in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun detachVolume(block: DetachVolumeRequest.DslBuilder.() -> Unit) = detachVolume(DetachVolumeRequest.builder().apply(block).build())

    /**
     * Detaches a virtual private gateway from a VPC. You do this if you're planning to turn
     * off the VPC and not use it anymore. You can confirm a virtual private gateway has been
     * completely detached from a VPC by describing the virtual private gateway (any
     * attachments to the virtual private gateway are also described).
     * You must wait for the attachment's state to switch to detached before you
     * can delete the VPC or attach a different VPC to the virtual private gateway.
     */
    suspend fun detachVpnGateway(input: DetachVpnGatewayRequest): DetachVpnGatewayResponse

    /**
     * Detaches a virtual private gateway from a VPC. You do this if you're planning to turn
     * off the VPC and not use it anymore. You can confirm a virtual private gateway has been
     * completely detached from a VPC by describing the virtual private gateway (any
     * attachments to the virtual private gateway are also described).
     * You must wait for the attachment's state to switch to detached before you
     * can delete the VPC or attach a different VPC to the virtual private gateway.
     */
    suspend fun detachVpnGateway(block: DetachVpnGatewayRequest.DslBuilder.() -> Unit) = detachVpnGateway(DetachVpnGatewayRequest.builder().apply(block).build())

    /**
     * Disables EBS encryption by default for your account in the current Region.
     * After you disable encryption by default, you can still create encrypted volumes by
     * enabling encryption when you create each volume.
     * Disabling encryption by default does not change the encryption status of your
     * existing volumes.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun disableEbsEncryptionByDefault(input: DisableEbsEncryptionByDefaultRequest): DisableEbsEncryptionByDefaultResponse

    /**
     * Disables EBS encryption by default for your account in the current Region.
     * After you disable encryption by default, you can still create encrypted volumes by
     * enabling encryption when you create each volume.
     * Disabling encryption by default does not change the encryption status of your
     * existing volumes.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun disableEbsEncryptionByDefault(block: DisableEbsEncryptionByDefaultRequest.DslBuilder.() -> Unit) = disableEbsEncryptionByDefault(DisableEbsEncryptionByDefaultRequest.builder().apply(block).build())

    /**
     * Disables fast snapshot restores for the specified snapshots in the specified Availability Zones.
     */
    suspend fun disableFastSnapshotRestores(input: DisableFastSnapshotRestoresRequest): DisableFastSnapshotRestoresResponse

    /**
     * Disables fast snapshot restores for the specified snapshots in the specified Availability Zones.
     */
    suspend fun disableFastSnapshotRestores(block: DisableFastSnapshotRestoresRequest.DslBuilder.() -> Unit) = disableFastSnapshotRestores(DisableFastSnapshotRestoresRequest.builder().apply(block).build())

    /**
     * Cancels the deprecation of the specified AMI.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-deprecate.html">Deprecate an AMI in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun disableImageDeprecation(input: DisableImageDeprecationRequest): DisableImageDeprecationResponse

    /**
     * Cancels the deprecation of the specified AMI.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-deprecate.html">Deprecate an AMI in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun disableImageDeprecation(block: DisableImageDeprecationRequest.DslBuilder.() -> Unit) = disableImageDeprecation(DisableImageDeprecationRequest.builder().apply(block).build())

    /**
     * Disables access to the EC2 serial console of all instances for your account. By default,
     * access to the EC2 serial console is disabled for your account. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configure-access-to-serial-console.html#serial-console-account-access">Manage account access to the EC2 serial console in the Amazon EC2
     * User Guide.
     */
    suspend fun disableSerialConsoleAccess(input: DisableSerialConsoleAccessRequest): DisableSerialConsoleAccessResponse

    /**
     * Disables access to the EC2 serial console of all instances for your account. By default,
     * access to the EC2 serial console is disabled for your account. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configure-access-to-serial-console.html#serial-console-account-access">Manage account access to the EC2 serial console in the Amazon EC2
     * User Guide.
     */
    suspend fun disableSerialConsoleAccess(block: DisableSerialConsoleAccessRequest.DslBuilder.() -> Unit) = disableSerialConsoleAccess(DisableSerialConsoleAccessRequest.builder().apply(block).build())

    /**
     * Disables the specified resource attachment from propagating routes to the specified
     * propagation route table.
     */
    suspend fun disableTransitGatewayRouteTablePropagation(input: DisableTransitGatewayRouteTablePropagationRequest): DisableTransitGatewayRouteTablePropagationResponse

    /**
     * Disables the specified resource attachment from propagating routes to the specified
     * propagation route table.
     */
    suspend fun disableTransitGatewayRouteTablePropagation(block: DisableTransitGatewayRouteTablePropagationRequest.DslBuilder.() -> Unit) = disableTransitGatewayRouteTablePropagation(DisableTransitGatewayRouteTablePropagationRequest.builder().apply(block).build())

    /**
     * Disables a virtual private gateway (VGW) from propagating routes to a specified route
     * table of a VPC.
     */
    suspend fun disableVgwRoutePropagation(input: DisableVgwRoutePropagationRequest): DisableVgwRoutePropagationResponse

    /**
     * Disables a virtual private gateway (VGW) from propagating routes to a specified route
     * table of a VPC.
     */
    suspend fun disableVgwRoutePropagation(block: DisableVgwRoutePropagationRequest.DslBuilder.() -> Unit) = disableVgwRoutePropagation(DisableVgwRoutePropagationRequest.builder().apply(block).build())

    /**
     * Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC that has EC2-Classic instances linked to it.
     */
    suspend fun disableVpcClassicLink(input: DisableVpcClassicLinkRequest): DisableVpcClassicLinkResponse

    /**
     * Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC that has EC2-Classic instances linked to it.
     */
    suspend fun disableVpcClassicLink(block: DisableVpcClassicLinkRequest.DslBuilder.() -> Unit) = disableVpcClassicLink(DisableVpcClassicLinkRequest.builder().apply(block).build())

    /**
     * Disables ClassicLink DNS support for a VPC. If disabled, DNS hostnames resolve to
     * public IP addresses when addressed between a linked EC2-Classic instance and instances
     * in the VPC to which it's linked. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink in the
     * Amazon Elastic Compute Cloud User Guide.
     * You must specify a VPC ID in the request.
     */
    suspend fun disableVpcClassicLinkDnsSupport(input: DisableVpcClassicLinkDnsSupportRequest): DisableVpcClassicLinkDnsSupportResponse

    /**
     * Disables ClassicLink DNS support for a VPC. If disabled, DNS hostnames resolve to
     * public IP addresses when addressed between a linked EC2-Classic instance and instances
     * in the VPC to which it's linked. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink in the
     * Amazon Elastic Compute Cloud User Guide.
     * You must specify a VPC ID in the request.
     */
    suspend fun disableVpcClassicLinkDnsSupport(block: DisableVpcClassicLinkDnsSupportRequest.DslBuilder.() -> Unit) = disableVpcClassicLinkDnsSupport(DisableVpcClassicLinkDnsSupportRequest.builder().apply(block).build())

    /**
     * Disassociates an Elastic IP address from the instance or network interface it's associated with.
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
     * Addresses in the Amazon Elastic Compute Cloud User Guide.
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.
     */
    suspend fun disassociateAddress(input: DisassociateAddressRequest): DisassociateAddressResponse

    /**
     * Disassociates an Elastic IP address from the instance or network interface it's associated with.
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
     * Addresses in the Amazon Elastic Compute Cloud User Guide.
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.
     */
    suspend fun disassociateAddress(block: DisassociateAddressRequest.DslBuilder.() -> Unit) = disassociateAddress(DisassociateAddressRequest.builder().apply(block).build())

    /**
     * Disassociates a target network from the specified Client VPN endpoint. When you disassociate the
     * last target network from a Client VPN, the following happens:
     * The route that was automatically added for the VPC is deleted
     * All active client connections are terminated
     * New client connections are disallowed
     * The Client VPN endpoint's status changes to pending-associate
     */
    suspend fun disassociateClientVpnTargetNetwork(input: DisassociateClientVpnTargetNetworkRequest): DisassociateClientVpnTargetNetworkResponse

    /**
     * Disassociates a target network from the specified Client VPN endpoint. When you disassociate the
     * last target network from a Client VPN, the following happens:
     * The route that was automatically added for the VPC is deleted
     * All active client connections are terminated
     * New client connections are disallowed
     * The Client VPN endpoint's status changes to pending-associate
     */
    suspend fun disassociateClientVpnTargetNetwork(block: DisassociateClientVpnTargetNetworkRequest.DslBuilder.() -> Unit) = disassociateClientVpnTargetNetwork(DisassociateClientVpnTargetNetworkRequest.builder().apply(block).build())

    /**
     * Disassociates an IAM role from an Certificate Manager (ACM) certificate. Disassociating an IAM role
     * from an ACM certificate removes the Amazon S3 object that contains the certificate, certificate chain, and
     * encrypted private key from the Amazon S3 bucket. It also revokes the IAM role's permission to use the
     * KMS key used to encrypt the private key. This effectively revokes the role's permission
     * to use the certificate.
     */
    suspend fun disassociateEnclaveCertificateIamRole(input: DisassociateEnclaveCertificateIamRoleRequest): DisassociateEnclaveCertificateIamRoleResponse

    /**
     * Disassociates an IAM role from an Certificate Manager (ACM) certificate. Disassociating an IAM role
     * from an ACM certificate removes the Amazon S3 object that contains the certificate, certificate chain, and
     * encrypted private key from the Amazon S3 bucket. It also revokes the IAM role's permission to use the
     * KMS key used to encrypt the private key. This effectively revokes the role's permission
     * to use the certificate.
     */
    suspend fun disassociateEnclaveCertificateIamRole(block: DisassociateEnclaveCertificateIamRoleRequest.DslBuilder.() -> Unit) = disassociateEnclaveCertificateIamRole(DisassociateEnclaveCertificateIamRoleRequest.builder().apply(block).build())

    /**
     * Disassociates an IAM instance profile from a running or stopped instance.
     * Use DescribeIamInstanceProfileAssociations to get the association
     * ID.
     */
    suspend fun disassociateIamInstanceProfile(input: DisassociateIamInstanceProfileRequest): DisassociateIamInstanceProfileResponse

    /**
     * Disassociates an IAM instance profile from a running or stopped instance.
     * Use DescribeIamInstanceProfileAssociations to get the association
     * ID.
     */
    suspend fun disassociateIamInstanceProfile(block: DisassociateIamInstanceProfileRequest.DslBuilder.() -> Unit) = disassociateIamInstanceProfile(DisassociateIamInstanceProfileRequest.builder().apply(block).build())

    /**
     * Disassociates one or more targets from an event window.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    suspend fun disassociateInstanceEventWindow(input: DisassociateInstanceEventWindowRequest): DisassociateInstanceEventWindowResponse

    /**
     * Disassociates one or more targets from an event window.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    suspend fun disassociateInstanceEventWindow(block: DisassociateInstanceEventWindowRequest.DslBuilder.() -> Unit) = disassociateInstanceEventWindow(DisassociateInstanceEventWindowRequest.builder().apply(block).build())

    /**
     * Disassociates a subnet or gateway from a route table.
     * After you perform this action, the subnet no longer uses the routes in the route table.
     * Instead, it uses the routes in the VPC's main route table. For more information
     * about route tables, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun disassociateRouteTable(input: DisassociateRouteTableRequest): DisassociateRouteTableResponse

    /**
     * Disassociates a subnet or gateway from a route table.
     * After you perform this action, the subnet no longer uses the routes in the route table.
     * Instead, it uses the routes in the VPC's main route table. For more information
     * about route tables, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun disassociateRouteTable(block: DisassociateRouteTableRequest.DslBuilder.() -> Unit) = disassociateRouteTable(DisassociateRouteTableRequest.builder().apply(block).build())

    /**
     * Disassociates a CIDR block from a subnet. Currently, you can disassociate an IPv6 CIDR block only. You must detach or delete all gateways and resources that are associated with the CIDR block before you can disassociate it.
     */
    suspend fun disassociateSubnetCidrBlock(input: DisassociateSubnetCidrBlockRequest): DisassociateSubnetCidrBlockResponse

    /**
     * Disassociates a CIDR block from a subnet. Currently, you can disassociate an IPv6 CIDR block only. You must detach or delete all gateways and resources that are associated with the CIDR block before you can disassociate it.
     */
    suspend fun disassociateSubnetCidrBlock(block: DisassociateSubnetCidrBlockRequest.DslBuilder.() -> Unit) = disassociateSubnetCidrBlock(DisassociateSubnetCidrBlockRequest.builder().apply(block).build())

    /**
     * Disassociates the specified subnets from the transit gateway multicast domain.
     */
    suspend fun disassociateTransitGatewayMulticastDomain(input: DisassociateTransitGatewayMulticastDomainRequest): DisassociateTransitGatewayMulticastDomainResponse

    /**
     * Disassociates the specified subnets from the transit gateway multicast domain.
     */
    suspend fun disassociateTransitGatewayMulticastDomain(block: DisassociateTransitGatewayMulticastDomainRequest.DslBuilder.() -> Unit) = disassociateTransitGatewayMulticastDomain(DisassociateTransitGatewayMulticastDomainRequest.builder().apply(block).build())

    /**
     * Disassociates a resource attachment from a transit gateway route table.
     */
    suspend fun disassociateTransitGatewayRouteTable(input: DisassociateTransitGatewayRouteTableRequest): DisassociateTransitGatewayRouteTableResponse

    /**
     * Disassociates a resource attachment from a transit gateway route table.
     */
    suspend fun disassociateTransitGatewayRouteTable(block: DisassociateTransitGatewayRouteTableRequest.DslBuilder.() -> Unit) = disassociateTransitGatewayRouteTable(DisassociateTransitGatewayRouteTableRequest.builder().apply(block).build())

    /**
     * This API action is currently in limited preview only.
     * If you are interested in using this feature, contact your account manager.
     * Removes an association between a branch network interface with a trunk network interface.
     */
    suspend fun disassociateTrunkInterface(input: DisassociateTrunkInterfaceRequest): DisassociateTrunkInterfaceResponse

    /**
     * This API action is currently in limited preview only.
     * If you are interested in using this feature, contact your account manager.
     * Removes an association between a branch network interface with a trunk network interface.
     */
    suspend fun disassociateTrunkInterface(block: DisassociateTrunkInterfaceRequest.DslBuilder.() -> Unit) = disassociateTrunkInterface(DisassociateTrunkInterfaceRequest.builder().apply(block).build())

    /**
     * Disassociates a CIDR block from a VPC. To disassociate the CIDR block, you must
     * specify its association ID. You can get the association ID by using
     * DescribeVpcs. You must detach or delete all gateways and resources that
     * are associated with the CIDR block before you can disassociate it.
     * You cannot disassociate the CIDR block with which you originally created the VPC (the
     * primary CIDR block).
     */
    suspend fun disassociateVpcCidrBlock(input: DisassociateVpcCidrBlockRequest): DisassociateVpcCidrBlockResponse

    /**
     * Disassociates a CIDR block from a VPC. To disassociate the CIDR block, you must
     * specify its association ID. You can get the association ID by using
     * DescribeVpcs. You must detach or delete all gateways and resources that
     * are associated with the CIDR block before you can disassociate it.
     * You cannot disassociate the CIDR block with which you originally created the VPC (the
     * primary CIDR block).
     */
    suspend fun disassociateVpcCidrBlock(block: DisassociateVpcCidrBlockRequest.DslBuilder.() -> Unit) = disassociateVpcCidrBlock(DisassociateVpcCidrBlockRequest.builder().apply(block).build())

    /**
     * Enables EBS encryption by default for your account in the current Region.
     * After you enable encryption by default, the EBS volumes that you create are
     * always encrypted, either using the default KMS key or the KMS key that you specified
     * when you created each volume. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption in the
     * Amazon Elastic Compute Cloud User Guide.
     * You can specify the default KMS key for encryption by default using ModifyEbsDefaultKmsKeyId
     * or ResetEbsDefaultKmsKeyId.
     * Enabling encryption by default has no effect on the encryption status of your
     * existing volumes.
     * After you enable encryption by default, you can no longer launch instances
     * using instance types that do not support encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported
     * instance types.
     */
    suspend fun enableEbsEncryptionByDefault(input: EnableEbsEncryptionByDefaultRequest): EnableEbsEncryptionByDefaultResponse

    /**
     * Enables EBS encryption by default for your account in the current Region.
     * After you enable encryption by default, the EBS volumes that you create are
     * always encrypted, either using the default KMS key or the KMS key that you specified
     * when you created each volume. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption in the
     * Amazon Elastic Compute Cloud User Guide.
     * You can specify the default KMS key for encryption by default using ModifyEbsDefaultKmsKeyId
     * or ResetEbsDefaultKmsKeyId.
     * Enabling encryption by default has no effect on the encryption status of your
     * existing volumes.
     * After you enable encryption by default, you can no longer launch instances
     * using instance types that do not support encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported
     * instance types.
     */
    suspend fun enableEbsEncryptionByDefault(block: EnableEbsEncryptionByDefaultRequest.DslBuilder.() -> Unit) = enableEbsEncryptionByDefault(EnableEbsEncryptionByDefaultRequest.builder().apply(block).build())

    /**
     * Enables fast snapshot restores for the specified snapshots in the specified Availability Zones.
     * You get the full benefit of fast snapshot restores after they enter the enabled state.
     * To get the current state of fast snapshot restores, use DescribeFastSnapshotRestores.
     * To disable fast snapshot restores, use DisableFastSnapshotRestores.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-fast-snapshot-restore.html">Amazon EBS fast snapshot
     * restore in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun enableFastSnapshotRestores(input: EnableFastSnapshotRestoresRequest): EnableFastSnapshotRestoresResponse

    /**
     * Enables fast snapshot restores for the specified snapshots in the specified Availability Zones.
     * You get the full benefit of fast snapshot restores after they enter the enabled state.
     * To get the current state of fast snapshot restores, use DescribeFastSnapshotRestores.
     * To disable fast snapshot restores, use DisableFastSnapshotRestores.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-fast-snapshot-restore.html">Amazon EBS fast snapshot
     * restore in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun enableFastSnapshotRestores(block: EnableFastSnapshotRestoresRequest.DslBuilder.() -> Unit) = enableFastSnapshotRestores(EnableFastSnapshotRestoresRequest.builder().apply(block).build())

    /**
     * Enables deprecation of the specified AMI at the specified date and time.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-deprecate.html">Deprecate an AMI in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun enableImageDeprecation(input: EnableImageDeprecationRequest): EnableImageDeprecationResponse

    /**
     * Enables deprecation of the specified AMI at the specified date and time.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-deprecate.html">Deprecate an AMI in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun enableImageDeprecation(block: EnableImageDeprecationRequest.DslBuilder.() -> Unit) = enableImageDeprecation(EnableImageDeprecationRequest.builder().apply(block).build())

    /**
     * Enables access to the EC2 serial console of all instances for your account. By default,
     * access to the EC2 serial console is disabled for your account. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configure-access-to-serial-console.html#serial-console-account-access">Manage account access to the EC2 serial console
     * in the Amazon EC2 User Guide.
     */
    suspend fun enableSerialConsoleAccess(input: EnableSerialConsoleAccessRequest): EnableSerialConsoleAccessResponse

    /**
     * Enables access to the EC2 serial console of all instances for your account. By default,
     * access to the EC2 serial console is disabled for your account. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configure-access-to-serial-console.html#serial-console-account-access">Manage account access to the EC2 serial console
     * in the Amazon EC2 User Guide.
     */
    suspend fun enableSerialConsoleAccess(block: EnableSerialConsoleAccessRequest.DslBuilder.() -> Unit) = enableSerialConsoleAccess(EnableSerialConsoleAccessRequest.builder().apply(block).build())

    /**
     * Enables the specified attachment to propagate routes to the specified
     * propagation route table.
     */
    suspend fun enableTransitGatewayRouteTablePropagation(input: EnableTransitGatewayRouteTablePropagationRequest): EnableTransitGatewayRouteTablePropagationResponse

    /**
     * Enables the specified attachment to propagate routes to the specified
     * propagation route table.
     */
    suspend fun enableTransitGatewayRouteTablePropagation(block: EnableTransitGatewayRouteTablePropagationRequest.DslBuilder.() -> Unit) = enableTransitGatewayRouteTablePropagation(EnableTransitGatewayRouteTablePropagationRequest.builder().apply(block).build())

    /**
     * Enables a virtual private gateway (VGW) to propagate routes to the specified route
     * table of a VPC.
     */
    suspend fun enableVgwRoutePropagation(input: EnableVgwRoutePropagationRequest): EnableVgwRoutePropagationResponse

    /**
     * Enables a virtual private gateway (VGW) to propagate routes to the specified route
     * table of a VPC.
     */
    suspend fun enableVgwRoutePropagation(block: EnableVgwRoutePropagationRequest.DslBuilder.() -> Unit) = enableVgwRoutePropagation(EnableVgwRoutePropagationRequest.builder().apply(block).build())

    /**
     * Enables I/O operations for a volume that had I/O operations disabled because the data on
     * the volume was potentially inconsistent.
     */
    suspend fun enableVolumeIo(input: EnableVolumeIoRequest): EnableVolumeIoResponse

    /**
     * Enables I/O operations for a volume that had I/O operations disabled because the data on
     * the volume was potentially inconsistent.
     */
    suspend fun enableVolumeIo(block: EnableVolumeIoRequest.DslBuilder.() -> Unit) = enableVolumeIo(EnableVolumeIoRequest.builder().apply(block).build())

    /**
     * Enables a VPC for ClassicLink. You can then link EC2-Classic instances to your
     * ClassicLink-enabled VPC to allow communication over private IP addresses. You cannot
     * enable your VPC for ClassicLink if any of your VPC route tables have existing routes for
     * address ranges within the 10.0.0.0/8 IP address range, excluding local
     * routes for VPCs in the 10.0.0.0/16 and 10.1.0.0/16 IP address
     * ranges. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun enableVpcClassicLink(input: EnableVpcClassicLinkRequest): EnableVpcClassicLinkResponse

    /**
     * Enables a VPC for ClassicLink. You can then link EC2-Classic instances to your
     * ClassicLink-enabled VPC to allow communication over private IP addresses. You cannot
     * enable your VPC for ClassicLink if any of your VPC route tables have existing routes for
     * address ranges within the 10.0.0.0/8 IP address range, excluding local
     * routes for VPCs in the 10.0.0.0/16 and 10.1.0.0/16 IP address
     * ranges. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun enableVpcClassicLink(block: EnableVpcClassicLinkRequest.DslBuilder.() -> Unit) = enableVpcClassicLink(EnableVpcClassicLinkRequest.builder().apply(block).build())

    /**
     * Enables a VPC to support DNS hostname resolution for ClassicLink. If enabled, the DNS
     * hostname of a linked EC2-Classic instance resolves to its private IP address when
     * addressed from an instance in the VPC to which it's linked. Similarly, the DNS hostname
     * of an instance in a VPC resolves to its private IP address when addressed from a linked
     * EC2-Classic instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink in the
     * Amazon Elastic Compute Cloud User Guide.
     * You must specify a VPC ID in the request.
     */
    suspend fun enableVpcClassicLinkDnsSupport(input: EnableVpcClassicLinkDnsSupportRequest): EnableVpcClassicLinkDnsSupportResponse

    /**
     * Enables a VPC to support DNS hostname resolution for ClassicLink. If enabled, the DNS
     * hostname of a linked EC2-Classic instance resolves to its private IP address when
     * addressed from an instance in the VPC to which it's linked. Similarly, the DNS hostname
     * of an instance in a VPC resolves to its private IP address when addressed from a linked
     * EC2-Classic instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink in the
     * Amazon Elastic Compute Cloud User Guide.
     * You must specify a VPC ID in the request.
     */
    suspend fun enableVpcClassicLinkDnsSupport(block: EnableVpcClassicLinkDnsSupportRequest.DslBuilder.() -> Unit) = enableVpcClassicLinkDnsSupport(EnableVpcClassicLinkDnsSupportRequest.builder().apply(block).build())

    /**
     * Downloads the client certificate revocation list for the specified Client VPN endpoint.
     */
    suspend fun exportClientVpnClientCertificateRevocationList(input: ExportClientVpnClientCertificateRevocationListRequest): ExportClientVpnClientCertificateRevocationListResponse

    /**
     * Downloads the client certificate revocation list for the specified Client VPN endpoint.
     */
    suspend fun exportClientVpnClientCertificateRevocationList(block: ExportClientVpnClientCertificateRevocationListRequest.DslBuilder.() -> Unit) = exportClientVpnClientCertificateRevocationList(ExportClientVpnClientCertificateRevocationListRequest.builder().apply(block).build())

    /**
     * Downloads the contents of the Client VPN endpoint configuration file for the specified Client VPN endpoint. The Client VPN endpoint configuration
     * file includes the Client VPN endpoint and certificate information clients need to establish a connection
     * with the Client VPN endpoint.
     */
    suspend fun exportClientVpnClientConfiguration(input: ExportClientVpnClientConfigurationRequest): ExportClientVpnClientConfigurationResponse

    /**
     * Downloads the contents of the Client VPN endpoint configuration file for the specified Client VPN endpoint. The Client VPN endpoint configuration
     * file includes the Client VPN endpoint and certificate information clients need to establish a connection
     * with the Client VPN endpoint.
     */
    suspend fun exportClientVpnClientConfiguration(block: ExportClientVpnClientConfigurationRequest.DslBuilder.() -> Unit) = exportClientVpnClientConfiguration(ExportClientVpnClientConfigurationRequest.builder().apply(block).build())

    /**
     * Exports an Amazon Machine Image (AMI) to a VM file. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport_image.html">Exporting a VM
     * directly from an Amazon Machine Image (AMI) in the
     * VM Import/Export User Guide.
     */
    suspend fun exportImage(input: ExportImageRequest): ExportImageResponse

    /**
     * Exports an Amazon Machine Image (AMI) to a VM file. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport_image.html">Exporting a VM
     * directly from an Amazon Machine Image (AMI) in the
     * VM Import/Export User Guide.
     */
    suspend fun exportImage(block: ExportImageRequest.DslBuilder.() -> Unit) = exportImage(ExportImageRequest.builder().apply(block).build())

    /**
     * Exports routes from the specified transit gateway route table to the specified S3 bucket.
     * By default, all routes are exported. Alternatively, you can filter by CIDR range.
     * The routes are saved to the specified bucket in a JSON file. For more information, see
     * <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-route-tables.html#tgw-export-route-tables">Export Route Tables
     * to Amazon S3 in Transit Gateways.
     */
    suspend fun exportTransitGatewayRoutes(input: ExportTransitGatewayRoutesRequest): ExportTransitGatewayRoutesResponse

    /**
     * Exports routes from the specified transit gateway route table to the specified S3 bucket.
     * By default, all routes are exported. Alternatively, you can filter by CIDR range.
     * The routes are saved to the specified bucket in a JSON file. For more information, see
     * <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-route-tables.html#tgw-export-route-tables">Export Route Tables
     * to Amazon S3 in Transit Gateways.
     */
    suspend fun exportTransitGatewayRoutes(block: ExportTransitGatewayRoutesRequest.DslBuilder.() -> Unit) = exportTransitGatewayRoutes(ExportTransitGatewayRoutesRequest.builder().apply(block).build())

    /**
     * Returns the IAM roles that are associated with the specified ACM (ACM) certificate.
     * It also returns the name of the Amazon S3 bucket and the Amazon S3 object key where the certificate,
     * certificate chain, and encrypted private key bundle are stored, and the ARN of the KMS key
     * that's used to encrypt the private key.
     */
    suspend fun getAssociatedEnclaveCertificateIamRoles(input: GetAssociatedEnclaveCertificateIamRolesRequest): GetAssociatedEnclaveCertificateIamRolesResponse

    /**
     * Returns the IAM roles that are associated with the specified ACM (ACM) certificate.
     * It also returns the name of the Amazon S3 bucket and the Amazon S3 object key where the certificate,
     * certificate chain, and encrypted private key bundle are stored, and the ARN of the KMS key
     * that's used to encrypt the private key.
     */
    suspend fun getAssociatedEnclaveCertificateIamRoles(block: GetAssociatedEnclaveCertificateIamRolesRequest.DslBuilder.() -> Unit) = getAssociatedEnclaveCertificateIamRoles(GetAssociatedEnclaveCertificateIamRolesRequest.builder().apply(block).build())

    /**
     * Gets information about the IPv6 CIDR block associations for a specified IPv6 address pool.
     */
    suspend fun getAssociatedIpv6PoolCidrs(input: GetAssociatedIpv6PoolCidrsRequest): GetAssociatedIpv6PoolCidrsResponse

    /**
     * Gets information about the IPv6 CIDR block associations for a specified IPv6 address pool.
     */
    suspend fun getAssociatedIpv6PoolCidrs(block: GetAssociatedIpv6PoolCidrsRequest.DslBuilder.() -> Unit) = getAssociatedIpv6PoolCidrs(GetAssociatedIpv6PoolCidrsRequest.builder().apply(block).build())

    /**
     * Gets usage information about a Capacity Reservation. If the Capacity Reservation is shared, it shows usage information for the Capacity Reservation owner
     * and each Amazon Web Services account that is currently using the shared capacity. If the Capacity Reservation is not shared, it shows only
     * the Capacity Reservation owner's usage.
     */
    suspend fun getCapacityReservationUsage(input: GetCapacityReservationUsageRequest): GetCapacityReservationUsageResponse

    /**
     * Gets usage information about a Capacity Reservation. If the Capacity Reservation is shared, it shows usage information for the Capacity Reservation owner
     * and each Amazon Web Services account that is currently using the shared capacity. If the Capacity Reservation is not shared, it shows only
     * the Capacity Reservation owner's usage.
     */
    suspend fun getCapacityReservationUsage(block: GetCapacityReservationUsageRequest.DslBuilder.() -> Unit) = getCapacityReservationUsage(GetCapacityReservationUsageRequest.builder().apply(block).build())

    /**
     * Describes the allocations from the specified customer-owned address pool.
     */
    suspend fun getCoipPoolUsage(input: GetCoipPoolUsageRequest): GetCoipPoolUsageResponse

    /**
     * Describes the allocations from the specified customer-owned address pool.
     */
    suspend fun getCoipPoolUsage(block: GetCoipPoolUsageRequest.DslBuilder.() -> Unit) = getCoipPoolUsage(GetCoipPoolUsageRequest.builder().apply(block).build())

    /**
     * Gets the console output for the specified instance. For Linux instances, the instance
     * console output displays the exact console output that would normally be displayed on a
     * physical monitor attached to a computer. For Windows instances, the instance console
     * output includes the last three system event log errors.
     * By default, the console output returns buffered information that was posted shortly
     * after an instance transition state (start, stop, reboot, or terminate). This information
     * is available for at least one hour after the most recent post. Only the most recent 64
     * KB of console output is available.
     * You can optionally retrieve the latest serial console output at any time during the
     * instance lifecycle. This option is supported on instance types that use the Nitro
     * hypervisor.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html#instance-console-console-output">Instance
     * console output in the Amazon EC2 User Guide.
     */
    suspend fun getConsoleOutput(input: GetConsoleOutputRequest): GetConsoleOutputResponse

    /**
     * Gets the console output for the specified instance. For Linux instances, the instance
     * console output displays the exact console output that would normally be displayed on a
     * physical monitor attached to a computer. For Windows instances, the instance console
     * output includes the last three system event log errors.
     * By default, the console output returns buffered information that was posted shortly
     * after an instance transition state (start, stop, reboot, or terminate). This information
     * is available for at least one hour after the most recent post. Only the most recent 64
     * KB of console output is available.
     * You can optionally retrieve the latest serial console output at any time during the
     * instance lifecycle. This option is supported on instance types that use the Nitro
     * hypervisor.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html#instance-console-console-output">Instance
     * console output in the Amazon EC2 User Guide.
     */
    suspend fun getConsoleOutput(block: GetConsoleOutputRequest.DslBuilder.() -> Unit) = getConsoleOutput(GetConsoleOutputRequest.builder().apply(block).build())

    /**
     * Retrieve a JPG-format screenshot of a running instance to help with
     * troubleshooting.
     * The returned content is Base64-encoded.
     */
    suspend fun getConsoleScreenshot(input: GetConsoleScreenshotRequest): GetConsoleScreenshotResponse

    /**
     * Retrieve a JPG-format screenshot of a running instance to help with
     * troubleshooting.
     * The returned content is Base64-encoded.
     */
    suspend fun getConsoleScreenshot(block: GetConsoleScreenshotRequest.DslBuilder.() -> Unit) = getConsoleScreenshot(GetConsoleScreenshotRequest.builder().apply(block).build())

    /**
     * Describes the default credit option for CPU usage of a burstable performance instance family.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * performance instances in the Amazon EC2 User Guide.
     */
    suspend fun getDefaultCreditSpecification(input: GetDefaultCreditSpecificationRequest): GetDefaultCreditSpecificationResponse

    /**
     * Describes the default credit option for CPU usage of a burstable performance instance family.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * performance instances in the Amazon EC2 User Guide.
     */
    suspend fun getDefaultCreditSpecification(block: GetDefaultCreditSpecificationRequest.DslBuilder.() -> Unit) = getDefaultCreditSpecification(GetDefaultCreditSpecificationRequest.builder().apply(block).build())

    /**
     * Describes the default KMS key for EBS encryption by default for your account in this Region.
     * You can change the default KMS key for encryption by default using ModifyEbsDefaultKmsKeyId or
     * ResetEbsDefaultKmsKeyId.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun getEbsDefaultKmsKeyId(input: GetEbsDefaultKmsKeyIdRequest): GetEbsDefaultKmsKeyIdResponse

    /**
     * Describes the default KMS key for EBS encryption by default for your account in this Region.
     * You can change the default KMS key for encryption by default using ModifyEbsDefaultKmsKeyId or
     * ResetEbsDefaultKmsKeyId.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun getEbsDefaultKmsKeyId(block: GetEbsDefaultKmsKeyIdRequest.DslBuilder.() -> Unit) = getEbsDefaultKmsKeyId(GetEbsDefaultKmsKeyIdRequest.builder().apply(block).build())

    /**
     * Describes whether EBS encryption by default is enabled for your account in the current
     * Region.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun getEbsEncryptionByDefault(input: GetEbsEncryptionByDefaultRequest): GetEbsEncryptionByDefaultResponse

    /**
     * Describes whether EBS encryption by default is enabled for your account in the current
     * Region.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun getEbsEncryptionByDefault(block: GetEbsEncryptionByDefaultRequest.DslBuilder.() -> Unit) = getEbsEncryptionByDefault(GetEbsEncryptionByDefaultRequest.builder().apply(block).build())

    /**
     * Generates a CloudFormation template that streamlines and automates the integration of VPC flow logs
     * with Amazon Athena. This make it easier for you to query and gain insights from VPC flow logs data.
     * Based on the information that you provide, we configure resources in the template to do the following:
     * Create a table in Athena that maps fields to a custom log format
     * Create a Lambda function that updates the table with new partitions on a daily, weekly, or
     * monthly basis
     * Create a table partitioned between two timestamps in the past
     * Create a set of named queries in Athena that you can use to get started quickly
     */
    suspend fun getFlowLogsIntegrationTemplate(input: GetFlowLogsIntegrationTemplateRequest): GetFlowLogsIntegrationTemplateResponse

    /**
     * Generates a CloudFormation template that streamlines and automates the integration of VPC flow logs
     * with Amazon Athena. This make it easier for you to query and gain insights from VPC flow logs data.
     * Based on the information that you provide, we configure resources in the template to do the following:
     * Create a table in Athena that maps fields to a custom log format
     * Create a Lambda function that updates the table with new partitions on a daily, weekly, or
     * monthly basis
     * Create a table partitioned between two timestamps in the past
     * Create a set of named queries in Athena that you can use to get started quickly
     */
    suspend fun getFlowLogsIntegrationTemplate(block: GetFlowLogsIntegrationTemplateRequest.DslBuilder.() -> Unit) = getFlowLogsIntegrationTemplate(GetFlowLogsIntegrationTemplateRequest.builder().apply(block).build())

    /**
     * Lists the resource groups to which a Capacity Reservation has been added.
     */
    suspend fun getGroupsForCapacityReservation(input: GetGroupsForCapacityReservationRequest): GetGroupsForCapacityReservationResponse

    /**
     * Lists the resource groups to which a Capacity Reservation has been added.
     */
    suspend fun getGroupsForCapacityReservation(block: GetGroupsForCapacityReservationRequest.DslBuilder.() -> Unit) = getGroupsForCapacityReservation(GetGroupsForCapacityReservationRequest.builder().apply(block).build())

    /**
     * Preview a reservation purchase with configurations that match those of your
     * Dedicated Host. You must have active Dedicated Hosts in your account before you purchase
     * a reservation.
     * This is a preview of the PurchaseHostReservation action and does
     * not result in the offering being purchased.
     */
    suspend fun getHostReservationPurchasePreview(input: GetHostReservationPurchasePreviewRequest): GetHostReservationPurchasePreviewResponse

    /**
     * Preview a reservation purchase with configurations that match those of your
     * Dedicated Host. You must have active Dedicated Hosts in your account before you purchase
     * a reservation.
     * This is a preview of the PurchaseHostReservation action and does
     * not result in the offering being purchased.
     */
    suspend fun getHostReservationPurchasePreview(block: GetHostReservationPurchasePreviewRequest.DslBuilder.() -> Unit) = getHostReservationPurchasePreview(GetHostReservationPurchasePreviewRequest.builder().apply(block).build())

    /**
     * Retrieves the configuration data of the specified instance. You can use this data
     * to create a launch template.
     * This action calls on other describe actions to get instance information. Depending on your instance configuration, you may need to allow the following
     * actions in your IAM policy: DescribeSpotInstanceRequests, DescribeInstanceCreditSpecifications, DescribeVolumes, DescribeInstanceAttribute, and DescribeElasticGpus. Or, you can allow
     * describe* depending on your instance requirements.
     */
    suspend fun getLaunchTemplateData(input: GetLaunchTemplateDataRequest): GetLaunchTemplateDataResponse

    /**
     * Retrieves the configuration data of the specified instance. You can use this data
     * to create a launch template.
     * This action calls on other describe actions to get instance information. Depending on your instance configuration, you may need to allow the following
     * actions in your IAM policy: DescribeSpotInstanceRequests, DescribeInstanceCreditSpecifications, DescribeVolumes, DescribeInstanceAttribute, and DescribeElasticGpus. Or, you can allow
     * describe* depending on your instance requirements.
     */
    suspend fun getLaunchTemplateData(block: GetLaunchTemplateDataRequest.DslBuilder.() -> Unit) = getLaunchTemplateData(GetLaunchTemplateDataRequest.builder().apply(block).build())

    /**
     * Gets information about the resources that are associated with the specified managed prefix list.
     */
    suspend fun getManagedPrefixListAssociations(input: GetManagedPrefixListAssociationsRequest): GetManagedPrefixListAssociationsResponse

    /**
     * Gets information about the resources that are associated with the specified managed prefix list.
     */
    suspend fun getManagedPrefixListAssociations(block: GetManagedPrefixListAssociationsRequest.DslBuilder.() -> Unit) = getManagedPrefixListAssociations(GetManagedPrefixListAssociationsRequest.builder().apply(block).build())

    /**
     * Gets information about the entries for a specified managed prefix list.
     */
    suspend fun getManagedPrefixListEntries(input: GetManagedPrefixListEntriesRequest): GetManagedPrefixListEntriesResponse

    /**
     * Gets information about the entries for a specified managed prefix list.
     */
    suspend fun getManagedPrefixListEntries(block: GetManagedPrefixListEntriesRequest.DslBuilder.() -> Unit) = getManagedPrefixListEntries(GetManagedPrefixListEntriesRequest.builder().apply(block).build())

    /**
     * Retrieves the encrypted administrator password for a running Windows instance.
     * The Windows password is generated at boot by the EC2Config service or
     * EC2Launch scripts (Windows Server 2016 and later). This usually only
     * happens the first time an instance is launched. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/UsingConfig_WinAMI.html">EC2Config and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2launch.html">EC2Launch in the
     * Amazon EC2 User Guide.
     * For the EC2Config service, the password is not generated for rebundled
     * AMIs unless Ec2SetPassword is enabled before bundling.
     * The password is encrypted using the key pair that you specified when you launched the
     * instance. You must provide the corresponding key pair file.
     * When you launch an instance, password generation and encryption may take a few
     * minutes. If you try to retrieve the password before it's available, the output returns
     * an empty string. We recommend that you wait up to 15 minutes after launching an instance
     * before trying to retrieve the generated password.
     */
    suspend fun getPasswordData(input: GetPasswordDataRequest): GetPasswordDataResponse

    /**
     * Retrieves the encrypted administrator password for a running Windows instance.
     * The Windows password is generated at boot by the EC2Config service or
     * EC2Launch scripts (Windows Server 2016 and later). This usually only
     * happens the first time an instance is launched. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/UsingConfig_WinAMI.html">EC2Config and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2launch.html">EC2Launch in the
     * Amazon EC2 User Guide.
     * For the EC2Config service, the password is not generated for rebundled
     * AMIs unless Ec2SetPassword is enabled before bundling.
     * The password is encrypted using the key pair that you specified when you launched the
     * instance. You must provide the corresponding key pair file.
     * When you launch an instance, password generation and encryption may take a few
     * minutes. If you try to retrieve the password before it's available, the output returns
     * an empty string. We recommend that you wait up to 15 minutes after launching an instance
     * before trying to retrieve the generated password.
     */
    suspend fun getPasswordData(block: GetPasswordDataRequest.DslBuilder.() -> Unit) = getPasswordData(GetPasswordDataRequest.builder().apply(block).build())

    /**
     * Returns a quote and exchange information for exchanging one or more specified
     * Convertible Reserved Instances for a new Convertible Reserved Instance. If the exchange
     * cannot be performed, the reason is returned in the response. Use AcceptReservedInstancesExchangeQuote to perform the exchange.
     */
    suspend fun getReservedInstancesExchangeQuote(input: GetReservedInstancesExchangeQuoteRequest): GetReservedInstancesExchangeQuoteResponse

    /**
     * Returns a quote and exchange information for exchanging one or more specified
     * Convertible Reserved Instances for a new Convertible Reserved Instance. If the exchange
     * cannot be performed, the reason is returned in the response. Use AcceptReservedInstancesExchangeQuote to perform the exchange.
     */
    suspend fun getReservedInstancesExchangeQuote(block: GetReservedInstancesExchangeQuoteRequest.DslBuilder.() -> Unit) = getReservedInstancesExchangeQuote(GetReservedInstancesExchangeQuoteRequest.builder().apply(block).build())

    /**
     * Retrieves the access status of your account to the EC2 serial console of all instances. By
     * default, access to the EC2 serial console is disabled for your account. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configure-access-to-serial-console.html#serial-console-account-access">Manage account access to the EC2 serial console in the Amazon EC2
     * User Guide.
     */
    suspend fun getSerialConsoleAccessStatus(input: GetSerialConsoleAccessStatusRequest): GetSerialConsoleAccessStatusResponse

    /**
     * Retrieves the access status of your account to the EC2 serial console of all instances. By
     * default, access to the EC2 serial console is disabled for your account. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configure-access-to-serial-console.html#serial-console-account-access">Manage account access to the EC2 serial console in the Amazon EC2
     * User Guide.
     */
    suspend fun getSerialConsoleAccessStatus(block: GetSerialConsoleAccessStatusRequest.DslBuilder.() -> Unit) = getSerialConsoleAccessStatus(GetSerialConsoleAccessStatusRequest.builder().apply(block).build())

    /**
     * Gets information about the subnet CIDR reservations.
     */
    suspend fun getSubnetCidrReservations(input: GetSubnetCidrReservationsRequest): GetSubnetCidrReservationsResponse

    /**
     * Gets information about the subnet CIDR reservations.
     */
    suspend fun getSubnetCidrReservations(block: GetSubnetCidrReservationsRequest.DslBuilder.() -> Unit) = getSubnetCidrReservations(GetSubnetCidrReservationsRequest.builder().apply(block).build())

    /**
     * Lists the route tables to which the specified resource attachment propagates routes.
     */
    suspend fun getTransitGatewayAttachmentPropagations(input: GetTransitGatewayAttachmentPropagationsRequest): GetTransitGatewayAttachmentPropagationsResponse

    /**
     * Lists the route tables to which the specified resource attachment propagates routes.
     */
    suspend fun getTransitGatewayAttachmentPropagations(block: GetTransitGatewayAttachmentPropagationsRequest.DslBuilder.() -> Unit) = getTransitGatewayAttachmentPropagations(GetTransitGatewayAttachmentPropagationsRequest.builder().apply(block).build())

    /**
     * Gets information about the associations for the transit gateway multicast domain.
     */
    suspend fun getTransitGatewayMulticastDomainAssociations(input: GetTransitGatewayMulticastDomainAssociationsRequest): GetTransitGatewayMulticastDomainAssociationsResponse

    /**
     * Gets information about the associations for the transit gateway multicast domain.
     */
    suspend fun getTransitGatewayMulticastDomainAssociations(block: GetTransitGatewayMulticastDomainAssociationsRequest.DslBuilder.() -> Unit) = getTransitGatewayMulticastDomainAssociations(GetTransitGatewayMulticastDomainAssociationsRequest.builder().apply(block).build())

    /**
     * Gets information about the prefix list references in a specified transit gateway route table.
     */
    suspend fun getTransitGatewayPrefixListReferences(input: GetTransitGatewayPrefixListReferencesRequest): GetTransitGatewayPrefixListReferencesResponse

    /**
     * Gets information about the prefix list references in a specified transit gateway route table.
     */
    suspend fun getTransitGatewayPrefixListReferences(block: GetTransitGatewayPrefixListReferencesRequest.DslBuilder.() -> Unit) = getTransitGatewayPrefixListReferences(GetTransitGatewayPrefixListReferencesRequest.builder().apply(block).build())

    /**
     * Gets information about the associations for the specified transit gateway route table.
     */
    suspend fun getTransitGatewayRouteTableAssociations(input: GetTransitGatewayRouteTableAssociationsRequest): GetTransitGatewayRouteTableAssociationsResponse

    /**
     * Gets information about the associations for the specified transit gateway route table.
     */
    suspend fun getTransitGatewayRouteTableAssociations(block: GetTransitGatewayRouteTableAssociationsRequest.DslBuilder.() -> Unit) = getTransitGatewayRouteTableAssociations(GetTransitGatewayRouteTableAssociationsRequest.builder().apply(block).build())

    /**
     * Gets information about the route table propagations for the specified transit gateway route table.
     */
    suspend fun getTransitGatewayRouteTablePropagations(input: GetTransitGatewayRouteTablePropagationsRequest): GetTransitGatewayRouteTablePropagationsResponse

    /**
     * Gets information about the route table propagations for the specified transit gateway route table.
     */
    suspend fun getTransitGatewayRouteTablePropagations(block: GetTransitGatewayRouteTablePropagationsRequest.DslBuilder.() -> Unit) = getTransitGatewayRouteTablePropagations(GetTransitGatewayRouteTablePropagationsRequest.builder().apply(block).build())

    /**
     * Download an Amazon Web Services-provided sample configuration file to be used with the customer
     * gateway device specified for your Site-to-Site VPN connection.
     */
    suspend fun getVpnConnectionDeviceSampleConfiguration(input: GetVpnConnectionDeviceSampleConfigurationRequest): GetVpnConnectionDeviceSampleConfigurationResponse

    /**
     * Download an Amazon Web Services-provided sample configuration file to be used with the customer
     * gateway device specified for your Site-to-Site VPN connection.
     */
    suspend fun getVpnConnectionDeviceSampleConfiguration(block: GetVpnConnectionDeviceSampleConfigurationRequest.DslBuilder.() -> Unit) = getVpnConnectionDeviceSampleConfiguration(GetVpnConnectionDeviceSampleConfigurationRequest.builder().apply(block).build())

    /**
     * Obtain a list of customer gateway devices for which sample configuration
     * files can be provided. The request has no additional parameters. You can also see the
     * list of device types with sample configuration files available under <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/your-cgw.html">Your customer gateway
     * device in the Amazon Web Services Site-to-Site VPN User Guide.
     */
    suspend fun getVpnConnectionDeviceTypes(input: GetVpnConnectionDeviceTypesRequest): GetVpnConnectionDeviceTypesResponse

    /**
     * Obtain a list of customer gateway devices for which sample configuration
     * files can be provided. The request has no additional parameters. You can also see the
     * list of device types with sample configuration files available under <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/your-cgw.html">Your customer gateway
     * device in the Amazon Web Services Site-to-Site VPN User Guide.
     */
    suspend fun getVpnConnectionDeviceTypes(block: GetVpnConnectionDeviceTypesRequest.DslBuilder.() -> Unit) = getVpnConnectionDeviceTypes(GetVpnConnectionDeviceTypesRequest.builder().apply(block).build())

    /**
     * Uploads a client certificate revocation list to the specified Client VPN endpoint. Uploading a client certificate revocation list overwrites the existing client certificate revocation list.
     * Uploading a client certificate revocation list resets existing client connections.
     */
    suspend fun importClientVpnClientCertificateRevocationList(input: ImportClientVpnClientCertificateRevocationListRequest): ImportClientVpnClientCertificateRevocationListResponse

    /**
     * Uploads a client certificate revocation list to the specified Client VPN endpoint. Uploading a client certificate revocation list overwrites the existing client certificate revocation list.
     * Uploading a client certificate revocation list resets existing client connections.
     */
    suspend fun importClientVpnClientCertificateRevocationList(block: ImportClientVpnClientCertificateRevocationListRequest.DslBuilder.() -> Unit) = importClientVpnClientCertificateRevocationList(ImportClientVpnClientCertificateRevocationListRequest.builder().apply(block).build())

    /**
     * Import single or multi-volume disk images or EBS snapshots into an Amazon Machine Image (AMI).
     * For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html">Importing a
     * VM as an image using VM Import/Export in the VM Import/Export User Guide.
     */
    suspend fun importImage(input: ImportImageRequest): ImportImageResponse

    /**
     * Import single or multi-volume disk images or EBS snapshots into an Amazon Machine Image (AMI).
     * For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html">Importing a
     * VM as an image using VM Import/Export in the VM Import/Export User Guide.
     */
    suspend fun importImage(block: ImportImageRequest.DslBuilder.() -> Unit) = importImage(ImportImageRequest.builder().apply(block).build())

    /**
     * Creates an import instance task using metadata from the specified disk image.
     * This API action supports only single-volume VMs. To import multi-volume VMs, use ImportImage
     * instead.
     * This API action is not supported by the Command Line Interface (CLI). For
     * information about using the Amazon EC2 CLI, which is deprecated, see
     * <a href="https://awsdocs.s3.amazonaws.com/EC2/ec2-clt.pdf#UsingVirtualMachinesinAmazonEC2">Importing a VM to Amazon EC2 in the Amazon EC2 CLI Reference PDF file.
     * For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest.
     */
    suspend fun importInstance(input: ImportInstanceRequest): ImportInstanceResponse

    /**
     * Creates an import instance task using metadata from the specified disk image.
     * This API action supports only single-volume VMs. To import multi-volume VMs, use ImportImage
     * instead.
     * This API action is not supported by the Command Line Interface (CLI). For
     * information about using the Amazon EC2 CLI, which is deprecated, see
     * <a href="https://awsdocs.s3.amazonaws.com/EC2/ec2-clt.pdf#UsingVirtualMachinesinAmazonEC2">Importing a VM to Amazon EC2 in the Amazon EC2 CLI Reference PDF file.
     * For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest.
     */
    suspend fun importInstance(block: ImportInstanceRequest.DslBuilder.() -> Unit) = importInstance(ImportInstanceRequest.builder().apply(block).build())

    /**
     * Imports the public key from an RSA or ED25519 key pair that you created with a third-party tool.
     * Compare this with CreateKeyPair, in which Amazon Web Services creates the key pair and gives the keys to you
     * (Amazon Web Services keeps a copy of the public key). With ImportKeyPair, you create the key pair and give Amazon Web Services just the public key.
     * The private key is never transferred between you and Amazon Web Services.
     * For more information about key pairs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun importKeyPair(input: ImportKeyPairRequest): ImportKeyPairResponse

    /**
     * Imports the public key from an RSA or ED25519 key pair that you created with a third-party tool.
     * Compare this with CreateKeyPair, in which Amazon Web Services creates the key pair and gives the keys to you
     * (Amazon Web Services keeps a copy of the public key). With ImportKeyPair, you create the key pair and give Amazon Web Services just the public key.
     * The private key is never transferred between you and Amazon Web Services.
     * For more information about key pairs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun importKeyPair(block: ImportKeyPairRequest.DslBuilder.() -> Unit) = importKeyPair(ImportKeyPairRequest.builder().apply(block).build())

    /**
     * Imports a disk into an EBS snapshot.
     * For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-import-snapshot.html">Importing a disk as a snapshot using VM Import/Export in the
     * VM Import/Export User Guide.
     */
    suspend fun importSnapshot(input: ImportSnapshotRequest): ImportSnapshotResponse

    /**
     * Imports a disk into an EBS snapshot.
     * For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-import-snapshot.html">Importing a disk as a snapshot using VM Import/Export in the
     * VM Import/Export User Guide.
     */
    suspend fun importSnapshot(block: ImportSnapshotRequest.DslBuilder.() -> Unit) = importSnapshot(ImportSnapshotRequest.builder().apply(block).build())

    /**
     * Creates an import volume task using metadata from the specified disk image.
     * This API action supports only single-volume VMs. To import multi-volume VMs, use
     * ImportImage instead. To import a disk to a snapshot, use
     * ImportSnapshot instead.
     * This API action is not supported by the Command Line Interface (CLI). For
     * information about using the Amazon EC2 CLI, which is deprecated, see <a href="https://awsdocs.s3.amazonaws.com/EC2/ec2-clt.pdf#importing-your-volumes-into-amazon-ebs">Importing Disks to Amazon EBS in the Amazon EC2 CLI Reference PDF file.
     * For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest.
     */
    suspend fun importVolume(input: ImportVolumeRequest): ImportVolumeResponse

    /**
     * Creates an import volume task using metadata from the specified disk image.
     * This API action supports only single-volume VMs. To import multi-volume VMs, use
     * ImportImage instead. To import a disk to a snapshot, use
     * ImportSnapshot instead.
     * This API action is not supported by the Command Line Interface (CLI). For
     * information about using the Amazon EC2 CLI, which is deprecated, see <a href="https://awsdocs.s3.amazonaws.com/EC2/ec2-clt.pdf#importing-your-volumes-into-amazon-ebs">Importing Disks to Amazon EBS in the Amazon EC2 CLI Reference PDF file.
     * For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest.
     */
    suspend fun importVolume(block: ImportVolumeRequest.DslBuilder.() -> Unit) = importVolume(ImportVolumeRequest.builder().apply(block).build())

    /**
     * Modifies an attribute of the specified Elastic IP address. For requirements, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS">Using reverse DNS for email applications.
     */
    suspend fun modifyAddressAttribute(input: ModifyAddressAttributeRequest): ModifyAddressAttributeResponse

    /**
     * Modifies an attribute of the specified Elastic IP address. For requirements, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS">Using reverse DNS for email applications.
     */
    suspend fun modifyAddressAttribute(block: ModifyAddressAttributeRequest.DslBuilder.() -> Unit) = modifyAddressAttribute(ModifyAddressAttributeRequest.builder().apply(block).build())

    /**
     * Changes the opt-in status of the Local Zone and Wavelength Zone group for your
     * account.
     * Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html">
     * DescribeAvailabilityZones to view the value for GroupName.
     */
    suspend fun modifyAvailabilityZoneGroup(input: ModifyAvailabilityZoneGroupRequest): ModifyAvailabilityZoneGroupResponse

    /**
     * Changes the opt-in status of the Local Zone and Wavelength Zone group for your
     * account.
     * Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html">
     * DescribeAvailabilityZones to view the value for GroupName.
     */
    suspend fun modifyAvailabilityZoneGroup(block: ModifyAvailabilityZoneGroupRequest.DslBuilder.() -> Unit) = modifyAvailabilityZoneGroup(ModifyAvailabilityZoneGroupRequest.builder().apply(block).build())

    /**
     * Modifies a Capacity Reservation's capacity and the conditions under which it is to be released. You
     * cannot change a Capacity Reservation's instance type, EBS optimization, instance store settings,
     * platform, Availability Zone, or instance eligibility. If you need to modify any of these
     * attributes, we recommend that you cancel the Capacity Reservation, and then create a new one with
     * the required attributes.
     */
    suspend fun modifyCapacityReservation(input: ModifyCapacityReservationRequest): ModifyCapacityReservationResponse

    /**
     * Modifies a Capacity Reservation's capacity and the conditions under which it is to be released. You
     * cannot change a Capacity Reservation's instance type, EBS optimization, instance store settings,
     * platform, Availability Zone, or instance eligibility. If you need to modify any of these
     * attributes, we recommend that you cancel the Capacity Reservation, and then create a new one with
     * the required attributes.
     */
    suspend fun modifyCapacityReservation(block: ModifyCapacityReservationRequest.DslBuilder.() -> Unit) = modifyCapacityReservation(ModifyCapacityReservationRequest.builder().apply(block).build())

    /**
     * Modifies a Capacity Reservation Fleet.
     * When you modify the total target capacity of a Capacity Reservation Fleet, the Fleet automatically
     * creates new Capacity Reservations, or modifies or cancels existing Capacity Reservations in the Fleet
     * to meet the new total target capacity. When you modify the end date for the Fleet, the end dates for
     * all of the individual Capacity Reservations in the Fleet are updated accordingly.
     */
    suspend fun modifyCapacityReservationFleet(input: ModifyCapacityReservationFleetRequest): ModifyCapacityReservationFleetResponse

    /**
     * Modifies a Capacity Reservation Fleet.
     * When you modify the total target capacity of a Capacity Reservation Fleet, the Fleet automatically
     * creates new Capacity Reservations, or modifies or cancels existing Capacity Reservations in the Fleet
     * to meet the new total target capacity. When you modify the end date for the Fleet, the end dates for
     * all of the individual Capacity Reservations in the Fleet are updated accordingly.
     */
    suspend fun modifyCapacityReservationFleet(block: ModifyCapacityReservationFleetRequest.DslBuilder.() -> Unit) = modifyCapacityReservationFleet(ModifyCapacityReservationFleetRequest.builder().apply(block).build())

    /**
     * Modifies the specified Client VPN endpoint. Modifying the DNS server resets existing client connections.
     */
    suspend fun modifyClientVpnEndpoint(input: ModifyClientVpnEndpointRequest): ModifyClientVpnEndpointResponse

    /**
     * Modifies the specified Client VPN endpoint. Modifying the DNS server resets existing client connections.
     */
    suspend fun modifyClientVpnEndpoint(block: ModifyClientVpnEndpointRequest.DslBuilder.() -> Unit) = modifyClientVpnEndpoint(ModifyClientVpnEndpointRequest.builder().apply(block).build())

    /**
     * Modifies the default credit option for CPU usage of burstable performance instances.
     * The default credit option is set at the account level per Amazon Web Services Region, and is specified
     * per instance family. All new burstable performance instances in the account launch using
     * the default credit option.
     * ModifyDefaultCreditSpecification is an asynchronous operation, which works at an Amazon Web Services Region
     * level and modifies the credit option for each Availability Zone. All zones in a
     * Region are updated within five minutes. But if instances are launched during this
     * operation, they might not get the new credit option until the zone is updated. To verify
     * whether the update has occurred, you can call GetDefaultCreditSpecification and check
     * DefaultCreditSpecification for updates.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * performance instances in the Amazon EC2 User Guide.
     */
    suspend fun modifyDefaultCreditSpecification(input: ModifyDefaultCreditSpecificationRequest): ModifyDefaultCreditSpecificationResponse

    /**
     * Modifies the default credit option for CPU usage of burstable performance instances.
     * The default credit option is set at the account level per Amazon Web Services Region, and is specified
     * per instance family. All new burstable performance instances in the account launch using
     * the default credit option.
     * ModifyDefaultCreditSpecification is an asynchronous operation, which works at an Amazon Web Services Region
     * level and modifies the credit option for each Availability Zone. All zones in a
     * Region are updated within five minutes. But if instances are launched during this
     * operation, they might not get the new credit option until the zone is updated. To verify
     * whether the update has occurred, you can call GetDefaultCreditSpecification and check
     * DefaultCreditSpecification for updates.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * performance instances in the Amazon EC2 User Guide.
     */
    suspend fun modifyDefaultCreditSpecification(block: ModifyDefaultCreditSpecificationRequest.DslBuilder.() -> Unit) = modifyDefaultCreditSpecification(ModifyDefaultCreditSpecificationRequest.builder().apply(block).build())

    /**
     * Changes the default KMS key for EBS encryption by default for your account in this Region.
     * Amazon Web Services creates a unique Amazon Web Services managed KMS key in each Region for use with encryption by default. If
     * you change the default KMS key to a symmetric customer managed KMS key, it is used instead of the Amazon Web Services
     * managed KMS key. To reset the default KMS key to the Amazon Web Services managed KMS key for EBS, use ResetEbsDefaultKmsKeyId. Amazon EBS does not support asymmetric KMS keys.
     * If you delete or disable the customer managed KMS key that you specified for use with
     * encryption by default, your instances will fail to launch.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun modifyEbsDefaultKmsKeyId(input: ModifyEbsDefaultKmsKeyIdRequest): ModifyEbsDefaultKmsKeyIdResponse

    /**
     * Changes the default KMS key for EBS encryption by default for your account in this Region.
     * Amazon Web Services creates a unique Amazon Web Services managed KMS key in each Region for use with encryption by default. If
     * you change the default KMS key to a symmetric customer managed KMS key, it is used instead of the Amazon Web Services
     * managed KMS key. To reset the default KMS key to the Amazon Web Services managed KMS key for EBS, use ResetEbsDefaultKmsKeyId. Amazon EBS does not support asymmetric KMS keys.
     * If you delete or disable the customer managed KMS key that you specified for use with
     * encryption by default, your instances will fail to launch.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun modifyEbsDefaultKmsKeyId(block: ModifyEbsDefaultKmsKeyIdRequest.DslBuilder.() -> Unit) = modifyEbsDefaultKmsKeyId(ModifyEbsDefaultKmsKeyIdRequest.builder().apply(block).build())

    /**
     * Modifies the specified EC2 Fleet.
     * You can only modify an EC2 Fleet request of type maintain.
     * While the EC2 Fleet is being modified, it is in the modifying state.
     * To scale up your EC2 Fleet, increase its target capacity. The EC2 Fleet launches the additional
     * Spot Instances according to the allocation strategy for the EC2 Fleet request. If the allocation
     * strategy is lowest-price, the EC2 Fleet launches instances using the Spot Instance
     * pool with the lowest price. If the allocation strategy is diversified, the
     * EC2 Fleet distributes the instances across the Spot Instance pools. If the allocation strategy
     * is capacity-optimized, EC2 Fleet launches instances from Spot Instance pools with optimal
     * capacity for the number of instances that are launching.
     * To scale down your EC2 Fleet, decrease its target capacity. First, the EC2 Fleet cancels any open
     * requests that exceed the new target capacity. You can request that the EC2 Fleet terminate Spot
     * Instances until the size of the fleet no longer exceeds the new target capacity. If the
     * allocation strategy is lowest-price, the EC2 Fleet terminates the instances with
     * the highest price per unit. If the allocation strategy is capacity-optimized,
     * the EC2 Fleet terminates the instances in the Spot Instance pools that have the least available
     * Spot Instance capacity. If the allocation strategy is diversified, the EC2 Fleet terminates
     * instances across the Spot Instance pools. Alternatively, you can request that the EC2 Fleet keep
     * the fleet at its current size, but not replace any Spot Instances that are interrupted or
     * that you terminate manually.
     * If you are finished with your EC2 Fleet for now, but will use it again later, you can set the
     * target capacity to 0.
     */
    suspend fun modifyFleet(input: ModifyFleetRequest): ModifyFleetResponse

    /**
     * Modifies the specified EC2 Fleet.
     * You can only modify an EC2 Fleet request of type maintain.
     * While the EC2 Fleet is being modified, it is in the modifying state.
     * To scale up your EC2 Fleet, increase its target capacity. The EC2 Fleet launches the additional
     * Spot Instances according to the allocation strategy for the EC2 Fleet request. If the allocation
     * strategy is lowest-price, the EC2 Fleet launches instances using the Spot Instance
     * pool with the lowest price. If the allocation strategy is diversified, the
     * EC2 Fleet distributes the instances across the Spot Instance pools. If the allocation strategy
     * is capacity-optimized, EC2 Fleet launches instances from Spot Instance pools with optimal
     * capacity for the number of instances that are launching.
     * To scale down your EC2 Fleet, decrease its target capacity. First, the EC2 Fleet cancels any open
     * requests that exceed the new target capacity. You can request that the EC2 Fleet terminate Spot
     * Instances until the size of the fleet no longer exceeds the new target capacity. If the
     * allocation strategy is lowest-price, the EC2 Fleet terminates the instances with
     * the highest price per unit. If the allocation strategy is capacity-optimized,
     * the EC2 Fleet terminates the instances in the Spot Instance pools that have the least available
     * Spot Instance capacity. If the allocation strategy is diversified, the EC2 Fleet terminates
     * instances across the Spot Instance pools. Alternatively, you can request that the EC2 Fleet keep
     * the fleet at its current size, but not replace any Spot Instances that are interrupted or
     * that you terminate manually.
     * If you are finished with your EC2 Fleet for now, but will use it again later, you can set the
     * target capacity to 0.
     */
    suspend fun modifyFleet(block: ModifyFleetRequest.DslBuilder.() -> Unit) = modifyFleet(ModifyFleetRequest.builder().apply(block).build())

    /**
     * Modifies the specified attribute of the specified Amazon FPGA Image (AFI).
     */
    suspend fun modifyFpgaImageAttribute(input: ModifyFpgaImageAttributeRequest): ModifyFpgaImageAttributeResponse

    /**
     * Modifies the specified attribute of the specified Amazon FPGA Image (AFI).
     */
    suspend fun modifyFpgaImageAttribute(block: ModifyFpgaImageAttributeRequest.DslBuilder.() -> Unit) = modifyFpgaImageAttribute(ModifyFpgaImageAttributeRequest.builder().apply(block).build())

    /**
     * Modify the auto-placement setting of a Dedicated Host. When auto-placement is enabled,
     * any instances that you launch with a tenancy of host but without a specific host
     * ID are placed onto any available Dedicated Host in your account that has auto-placement enabled.
     * When auto-placement is disabled, you need to provide a host ID to have the instance launch onto
     * a specific host. If no host ID is provided, the instance is launched onto a suitable host with
     * auto-placement enabled.
     * You can also use this API action to modify a Dedicated Host to support either multiple
     * instance types in an instance family, or to support a specific instance type only.
     */
    suspend fun modifyHosts(input: ModifyHostsRequest): ModifyHostsResponse

    /**
     * Modify the auto-placement setting of a Dedicated Host. When auto-placement is enabled,
     * any instances that you launch with a tenancy of host but without a specific host
     * ID are placed onto any available Dedicated Host in your account that has auto-placement enabled.
     * When auto-placement is disabled, you need to provide a host ID to have the instance launch onto
     * a specific host. If no host ID is provided, the instance is launched onto a suitable host with
     * auto-placement enabled.
     * You can also use this API action to modify a Dedicated Host to support either multiple
     * instance types in an instance family, or to support a specific instance type only.
     */
    suspend fun modifyHosts(block: ModifyHostsRequest.DslBuilder.() -> Unit) = modifyHosts(ModifyHostsRequest.builder().apply(block).build())

    /**
     * Modifies the ID format for the specified resource on a per-Region basis. You can
     * specify that resources should receive longer IDs (17-character IDs) when they are
     * created.
     * This request can only be used to modify longer ID settings for resource types that
     * are within the opt-in period. Resources currently in their opt-in period include:
     * bundle | conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | internet-gateway | network-acl
     * | network-acl-association | network-interface |
     * network-interface-attachment | prefix-list |
     * route-table | route-table-association |
     * security-group | subnet |
     * subnet-cidr-block-association | vpc |
     * vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.
     * This setting applies to the IAM user who makes the request; it does not apply to the
     * entire Amazon Web Services account. By default, an IAM user defaults to the same settings as the root user. If
     * you're using this action as the root user, then these settings apply to the entire account,
     * unless an IAM user explicitly overrides these settings for themselves. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs
     * in the Amazon Elastic Compute Cloud User Guide.
     * Resources created with longer IDs are visible to all IAM roles and users, regardless
     * of these settings and provided that they have permission to use the relevant
     * Describe command for the resource type.
     */
    suspend fun modifyIdFormat(input: ModifyIdFormatRequest): ModifyIdFormatResponse

    /**
     * Modifies the ID format for the specified resource on a per-Region basis. You can
     * specify that resources should receive longer IDs (17-character IDs) when they are
     * created.
     * This request can only be used to modify longer ID settings for resource types that
     * are within the opt-in period. Resources currently in their opt-in period include:
     * bundle | conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | internet-gateway | network-acl
     * | network-acl-association | network-interface |
     * network-interface-attachment | prefix-list |
     * route-table | route-table-association |
     * security-group | subnet |
     * subnet-cidr-block-association | vpc |
     * vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.
     * This setting applies to the IAM user who makes the request; it does not apply to the
     * entire Amazon Web Services account. By default, an IAM user defaults to the same settings as the root user. If
     * you're using this action as the root user, then these settings apply to the entire account,
     * unless an IAM user explicitly overrides these settings for themselves. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs
     * in the Amazon Elastic Compute Cloud User Guide.
     * Resources created with longer IDs are visible to all IAM roles and users, regardless
     * of these settings and provided that they have permission to use the relevant
     * Describe command for the resource type.
     */
    suspend fun modifyIdFormat(block: ModifyIdFormatRequest.DslBuilder.() -> Unit) = modifyIdFormat(ModifyIdFormatRequest.builder().apply(block).build())

    /**
     * Modifies the ID format of a resource for a specified IAM user, IAM role, or the root
     * user for an account; or all IAM users, IAM roles, and the root user for an account. You can
     * specify that resources should receive longer IDs (17-character IDs) when they are created.
     * This request can only be used to modify longer ID settings for resource types that are
     * within the opt-in period. Resources currently in their opt-in period include:
     * bundle | conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | internet-gateway | network-acl
     * | network-acl-association | network-interface |
     * network-interface-attachment | prefix-list |
     * route-table | route-table-association |
     * security-group | subnet |
     * subnet-cidr-block-association | vpc |
     * vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs in the
     * Amazon Elastic Compute Cloud User Guide.
     * This setting applies to the principal specified in the request; it does not apply to the
     * principal that makes the request.
     * Resources created with longer IDs are visible to all IAM roles and users, regardless of these
     * settings and provided that they have permission to use the relevant Describe
     * command for the resource type.
     */
    suspend fun modifyIdentityIdFormat(input: ModifyIdentityIdFormatRequest): ModifyIdentityIdFormatResponse

    /**
     * Modifies the ID format of a resource for a specified IAM user, IAM role, or the root
     * user for an account; or all IAM users, IAM roles, and the root user for an account. You can
     * specify that resources should receive longer IDs (17-character IDs) when they are created.
     * This request can only be used to modify longer ID settings for resource types that are
     * within the opt-in period. Resources currently in their opt-in period include:
     * bundle | conversion-task | customer-gateway | dhcp-options |
     * elastic-ip-allocation | elastic-ip-association |
     * export-task | flow-log | image |
     * import-task | internet-gateway | network-acl
     * | network-acl-association | network-interface |
     * network-interface-attachment | prefix-list |
     * route-table | route-table-association |
     * security-group | subnet |
     * subnet-cidr-block-association | vpc |
     * vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs in the
     * Amazon Elastic Compute Cloud User Guide.
     * This setting applies to the principal specified in the request; it does not apply to the
     * principal that makes the request.
     * Resources created with longer IDs are visible to all IAM roles and users, regardless of these
     * settings and provided that they have permission to use the relevant Describe
     * command for the resource type.
     */
    suspend fun modifyIdentityIdFormat(block: ModifyIdentityIdFormatRequest.DslBuilder.() -> Unit) = modifyIdentityIdFormat(ModifyIdentityIdFormatRequest.builder().apply(block).build())

    /**
     * Modifies the specified attribute of the specified AMI. You can specify only one attribute at a time.
     * You can use the Attribute parameter to specify the attribute or one of the following parameters:
     * Description or LaunchPermission.
     * Images with an Amazon Web Services Marketplace product code cannot be made public.
     * To enable the SriovNetSupport enhanced networking attribute of an image, enable SriovNetSupport on an instance
     * and create an AMI from the instance.
     */
    suspend fun modifyImageAttribute(input: ModifyImageAttributeRequest): ModifyImageAttributeResponse

    /**
     * Modifies the specified attribute of the specified AMI. You can specify only one attribute at a time.
     * You can use the Attribute parameter to specify the attribute or one of the following parameters:
     * Description or LaunchPermission.
     * Images with an Amazon Web Services Marketplace product code cannot be made public.
     * To enable the SriovNetSupport enhanced networking attribute of an image, enable SriovNetSupport on an instance
     * and create an AMI from the instance.
     */
    suspend fun modifyImageAttribute(block: ModifyImageAttributeRequest.DslBuilder.() -> Unit) = modifyImageAttribute(ModifyImageAttributeRequest.builder().apply(block).build())

    /**
     * Modifies the specified attribute of the specified instance. You can specify only one
     * attribute at a time.
     * Note: Using this action to change the security groups
     * associated with an elastic network interface (ENI) attached to an instance in a VPC can
     * result in an error if the instance has more than one ENI. To change the security groups
     * associated with an ENI attached to an instance that has multiple ENIs, we recommend that
     * you use the ModifyNetworkInterfaceAttribute action.
     * To modify some attributes, the instance must be stopped. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingAttributesWhileInstanceStopped.html">Modifying attributes of a stopped instance in the Amazon EC2 User Guide.
     */
    suspend fun modifyInstanceAttribute(input: ModifyInstanceAttributeRequest): ModifyInstanceAttributeResponse

    /**
     * Modifies the specified attribute of the specified instance. You can specify only one
     * attribute at a time.
     * Note: Using this action to change the security groups
     * associated with an elastic network interface (ENI) attached to an instance in a VPC can
     * result in an error if the instance has more than one ENI. To change the security groups
     * associated with an ENI attached to an instance that has multiple ENIs, we recommend that
     * you use the ModifyNetworkInterfaceAttribute action.
     * To modify some attributes, the instance must be stopped. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingAttributesWhileInstanceStopped.html">Modifying attributes of a stopped instance in the Amazon EC2 User Guide.
     */
    suspend fun modifyInstanceAttribute(block: ModifyInstanceAttributeRequest.DslBuilder.() -> Unit) = modifyInstanceAttribute(ModifyInstanceAttributeRequest.builder().apply(block).build())

    /**
     * Modifies the Capacity Reservation settings for a stopped instance. Use this action to configure an
     * instance to target a specific Capacity Reservation, run in any open Capacity Reservation with matching
     * attributes, or run On-Demand Instance capacity.
     */
    suspend fun modifyInstanceCapacityReservationAttributes(input: ModifyInstanceCapacityReservationAttributesRequest): ModifyInstanceCapacityReservationAttributesResponse

    /**
     * Modifies the Capacity Reservation settings for a stopped instance. Use this action to configure an
     * instance to target a specific Capacity Reservation, run in any open Capacity Reservation with matching
     * attributes, or run On-Demand Instance capacity.
     */
    suspend fun modifyInstanceCapacityReservationAttributes(block: ModifyInstanceCapacityReservationAttributesRequest.DslBuilder.() -> Unit) = modifyInstanceCapacityReservationAttributes(ModifyInstanceCapacityReservationAttributesRequest.builder().apply(block).build())

    /**
     * Modifies the credit option for CPU usage on a running or stopped burstable performance
     * instance. The credit options are standard and
     * unlimited.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * performance instances in the Amazon EC2 User Guide.
     */
    suspend fun modifyInstanceCreditSpecification(input: ModifyInstanceCreditSpecificationRequest): ModifyInstanceCreditSpecificationResponse

    /**
     * Modifies the credit option for CPU usage on a running or stopped burstable performance
     * instance. The credit options are standard and
     * unlimited.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * performance instances in the Amazon EC2 User Guide.
     */
    suspend fun modifyInstanceCreditSpecification(block: ModifyInstanceCreditSpecificationRequest.DslBuilder.() -> Unit) = modifyInstanceCreditSpecification(ModifyInstanceCreditSpecificationRequest.builder().apply(block).build())

    /**
     * Modifies the start time for a scheduled Amazon EC2 instance event.
     */
    suspend fun modifyInstanceEventStartTime(input: ModifyInstanceEventStartTimeRequest): ModifyInstanceEventStartTimeResponse

    /**
     * Modifies the start time for a scheduled Amazon EC2 instance event.
     */
    suspend fun modifyInstanceEventStartTime(block: ModifyInstanceEventStartTimeRequest.DslBuilder.() -> Unit) = modifyInstanceEventStartTime(ModifyInstanceEventStartTimeRequest.builder().apply(block).build())

    /**
     * Modifies the specified event window.
     * You can define either a set of time ranges or a cron expression when modifying the event
     * window, but not both.
     * To modify the targets associated with the event window, use the AssociateInstanceEventWindow and DisassociateInstanceEventWindow API.
     * If Amazon Web Services has already scheduled an event, modifying an event window won't change the time
     * of the scheduled event.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    suspend fun modifyInstanceEventWindow(input: ModifyInstanceEventWindowRequest): ModifyInstanceEventWindowResponse

    /**
     * Modifies the specified event window.
     * You can define either a set of time ranges or a cron expression when modifying the event
     * window, but not both.
     * To modify the targets associated with the event window, use the AssociateInstanceEventWindow and DisassociateInstanceEventWindow API.
     * If Amazon Web Services has already scheduled an event, modifying an event window won't change the time
     * of the scheduled event.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled
     * events in the Amazon EC2 User Guide.
     */
    suspend fun modifyInstanceEventWindow(block: ModifyInstanceEventWindowRequest.DslBuilder.() -> Unit) = modifyInstanceEventWindow(ModifyInstanceEventWindowRequest.builder().apply(block).build())

    /**
     * Modify the instance metadata parameters on a running or stopped instance. When you
     * modify the parameters on a stopped instance, they are applied when the instance is
     * started. When you modify the parameters on a running instance, the API responds with a
     * state of “pending”. After the parameter modifications are successfully applied to the
     * instance, the state of the modifications changes from “pending” to “applied” in
     * subsequent describe-instances API calls. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data
     * in the Amazon EC2 User Guide.
     */
    suspend fun modifyInstanceMetadataOptions(input: ModifyInstanceMetadataOptionsRequest): ModifyInstanceMetadataOptionsResponse

    /**
     * Modify the instance metadata parameters on a running or stopped instance. When you
     * modify the parameters on a stopped instance, they are applied when the instance is
     * started. When you modify the parameters on a running instance, the API responds with a
     * state of “pending”. After the parameter modifications are successfully applied to the
     * instance, the state of the modifications changes from “pending” to “applied” in
     * subsequent describe-instances API calls. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data
     * in the Amazon EC2 User Guide.
     */
    suspend fun modifyInstanceMetadataOptions(block: ModifyInstanceMetadataOptionsRequest.DslBuilder.() -> Unit) = modifyInstanceMetadataOptions(ModifyInstanceMetadataOptionsRequest.builder().apply(block).build())

    /**
     * Modifies the placement attributes for a specified instance. You can do the
     * following:
     * Modify the affinity between an instance and a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html">Dedicated
     * Host. When affinity is set to host and the instance is
     * not associated with a specific Dedicated Host, the next time the instance is
     * launched, it is automatically associated with the host on which it lands. If the
     * instance is restarted or rebooted, this relationship persists.
     * Change the Dedicated Host with which an instance is associated.
     * Change the instance tenancy of an instance.
     * Move an instance to or from a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">placement
     * group.
     * At least one attribute for affinity, host ID, tenancy, or placement group name must
     * be specified in the request. Affinity and tenancy can be modified in the same
     * request.
     * To modify the host ID, tenancy, placement group, or partition for an instance, the
     * instance must be in the stopped state.
     */
    suspend fun modifyInstancePlacement(input: ModifyInstancePlacementRequest): ModifyInstancePlacementResponse

    /**
     * Modifies the placement attributes for a specified instance. You can do the
     * following:
     * Modify the affinity between an instance and a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html">Dedicated
     * Host. When affinity is set to host and the instance is
     * not associated with a specific Dedicated Host, the next time the instance is
     * launched, it is automatically associated with the host on which it lands. If the
     * instance is restarted or rebooted, this relationship persists.
     * Change the Dedicated Host with which an instance is associated.
     * Change the instance tenancy of an instance.
     * Move an instance to or from a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">placement
     * group.
     * At least one attribute for affinity, host ID, tenancy, or placement group name must
     * be specified in the request. Affinity and tenancy can be modified in the same
     * request.
     * To modify the host ID, tenancy, placement group, or partition for an instance, the
     * instance must be in the stopped state.
     */
    suspend fun modifyInstancePlacement(block: ModifyInstancePlacementRequest.DslBuilder.() -> Unit) = modifyInstancePlacement(ModifyInstancePlacementRequest.builder().apply(block).build())

    /**
     * Modifies a launch template. You can specify which version of the launch template to
     * set as the default version. When launching an instance, the default version applies when
     * a launch template version is not specified.
     */
    suspend fun modifyLaunchTemplate(input: ModifyLaunchTemplateRequest): ModifyLaunchTemplateResponse

    /**
     * Modifies a launch template. You can specify which version of the launch template to
     * set as the default version. When launching an instance, the default version applies when
     * a launch template version is not specified.
     */
    suspend fun modifyLaunchTemplate(block: ModifyLaunchTemplateRequest.DslBuilder.() -> Unit) = modifyLaunchTemplate(ModifyLaunchTemplateRequest.builder().apply(block).build())

    /**
     * Modifies the specified managed prefix list.
     * Adding or removing entries in a prefix list creates a new version of the prefix list.
     * Changing the name of the prefix list does not affect the version.
     * If you specify a current version number that does not match the true current version
     * number, the request fails.
     */
    suspend fun modifyManagedPrefixList(input: ModifyManagedPrefixListRequest): ModifyManagedPrefixListResponse

    /**
     * Modifies the specified managed prefix list.
     * Adding or removing entries in a prefix list creates a new version of the prefix list.
     * Changing the name of the prefix list does not affect the version.
     * If you specify a current version number that does not match the true current version
     * number, the request fails.
     */
    suspend fun modifyManagedPrefixList(block: ModifyManagedPrefixListRequest.DslBuilder.() -> Unit) = modifyManagedPrefixList(ModifyManagedPrefixListRequest.builder().apply(block).build())

    /**
     * Modifies the specified network interface attribute. You can specify only one
     * attribute at a time. You can use this action to attach and detach security groups from
     * an existing EC2 instance.
     */
    suspend fun modifyNetworkInterfaceAttribute(input: ModifyNetworkInterfaceAttributeRequest): ModifyNetworkInterfaceAttributeResponse

    /**
     * Modifies the specified network interface attribute. You can specify only one
     * attribute at a time. You can use this action to attach and detach security groups from
     * an existing EC2 instance.
     */
    suspend fun modifyNetworkInterfaceAttribute(block: ModifyNetworkInterfaceAttributeRequest.DslBuilder.() -> Unit) = modifyNetworkInterfaceAttribute(ModifyNetworkInterfaceAttributeRequest.builder().apply(block).build())

    /**
     * Modifies the Availability Zone, instance count, instance type, or network platform
     * (EC2-Classic or EC2-VPC) of your Reserved Instances. The Reserved Instances to be
     * modified must be identical, except for Availability Zone, network platform, and instance
     * type.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying Reserved
     * Instances in the Amazon EC2 User Guide.
     */
    suspend fun modifyReservedInstances(input: ModifyReservedInstancesRequest): ModifyReservedInstancesResponse

    /**
     * Modifies the Availability Zone, instance count, instance type, or network platform
     * (EC2-Classic or EC2-VPC) of your Reserved Instances. The Reserved Instances to be
     * modified must be identical, except for Availability Zone, network platform, and instance
     * type.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying Reserved
     * Instances in the Amazon EC2 User Guide.
     */
    suspend fun modifyReservedInstances(block: ModifyReservedInstancesRequest.DslBuilder.() -> Unit) = modifyReservedInstances(ModifyReservedInstancesRequest.builder().apply(block).build())

    /**
     * Modifies the rules of a security group.
     */
    suspend fun modifySecurityGroupRules(input: ModifySecurityGroupRulesRequest): ModifySecurityGroupRulesResponse

    /**
     * Modifies the rules of a security group.
     */
    suspend fun modifySecurityGroupRules(block: ModifySecurityGroupRulesRequest.DslBuilder.() -> Unit) = modifySecurityGroupRules(ModifySecurityGroupRulesRequest.builder().apply(block).build())

    /**
     * Adds or removes permission settings for the specified snapshot. You may add or remove
     * specified Amazon Web Services account IDs from a snapshot's list of create volume permissions, but you cannot
     * do both in a single operation. If you need to both add and remove account IDs for a snapshot,
     * you must use multiple operations. You can make up to 500 modifications to a snapshot in a single operation.
     * Encrypted snapshots and snapshots with Amazon Web Services Marketplace product codes cannot be made
     * public. Snapshots encrypted with your default KMS key cannot be shared with other accounts.
     * For more information about modifying snapshot permissions, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html">Share a snapshot in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun modifySnapshotAttribute(input: ModifySnapshotAttributeRequest): ModifySnapshotAttributeResponse

    /**
     * Adds or removes permission settings for the specified snapshot. You may add or remove
     * specified Amazon Web Services account IDs from a snapshot's list of create volume permissions, but you cannot
     * do both in a single operation. If you need to both add and remove account IDs for a snapshot,
     * you must use multiple operations. You can make up to 500 modifications to a snapshot in a single operation.
     * Encrypted snapshots and snapshots with Amazon Web Services Marketplace product codes cannot be made
     * public. Snapshots encrypted with your default KMS key cannot be shared with other accounts.
     * For more information about modifying snapshot permissions, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html">Share a snapshot in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun modifySnapshotAttribute(block: ModifySnapshotAttributeRequest.DslBuilder.() -> Unit) = modifySnapshotAttribute(ModifySnapshotAttributeRequest.builder().apply(block).build())

    /**
     * Modifies the specified Spot Fleet request.
     * You can only modify a Spot Fleet request of type maintain.
     * While the Spot Fleet request is being modified, it is in the modifying
     * state.
     * To scale up your Spot Fleet, increase its target capacity. The Spot Fleet launches the
     * additional Spot Instances according to the allocation strategy for the Spot Fleet
     * request. If the allocation strategy is lowestPrice, the Spot Fleet launches
     * instances using the Spot Instance pool with the lowest price. If the allocation strategy
     * is diversified, the Spot Fleet distributes the instances across the Spot
     * Instance pools. If the allocation strategy is capacityOptimized, Spot Fleet
     * launches instances from Spot Instance pools with optimal capacity for the number of instances
     * that are launching.
     * To scale down your Spot Fleet, decrease its target capacity. First, the Spot Fleet
     * cancels any open requests that exceed the new target capacity. You can request that the
     * Spot Fleet terminate Spot Instances until the size of the fleet no longer exceeds the
     * new target capacity. If the allocation strategy is lowestPrice, the Spot
     * Fleet terminates the instances with the highest price per unit. If the allocation
     * strategy is capacityOptimized, the Spot Fleet terminates the instances in
     * the Spot Instance pools that have the least available Spot Instance capacity. If the allocation
     * strategy is diversified, the Spot Fleet terminates instances across the
     * Spot Instance pools. Alternatively, you can request that the Spot Fleet keep the fleet
     * at its current size, but not replace any Spot Instances that are interrupted or that you
     * terminate manually.
     * If you are finished with your Spot Fleet for now, but will use it again later, you can
     * set the target capacity to 0.
     */
    suspend fun modifySpotFleetRequest(input: ModifySpotFleetRequestRequest): ModifySpotFleetRequestResponse

    /**
     * Modifies the specified Spot Fleet request.
     * You can only modify a Spot Fleet request of type maintain.
     * While the Spot Fleet request is being modified, it is in the modifying
     * state.
     * To scale up your Spot Fleet, increase its target capacity. The Spot Fleet launches the
     * additional Spot Instances according to the allocation strategy for the Spot Fleet
     * request. If the allocation strategy is lowestPrice, the Spot Fleet launches
     * instances using the Spot Instance pool with the lowest price. If the allocation strategy
     * is diversified, the Spot Fleet distributes the instances across the Spot
     * Instance pools. If the allocation strategy is capacityOptimized, Spot Fleet
     * launches instances from Spot Instance pools with optimal capacity for the number of instances
     * that are launching.
     * To scale down your Spot Fleet, decrease its target capacity. First, the Spot Fleet
     * cancels any open requests that exceed the new target capacity. You can request that the
     * Spot Fleet terminate Spot Instances until the size of the fleet no longer exceeds the
     * new target capacity. If the allocation strategy is lowestPrice, the Spot
     * Fleet terminates the instances with the highest price per unit. If the allocation
     * strategy is capacityOptimized, the Spot Fleet terminates the instances in
     * the Spot Instance pools that have the least available Spot Instance capacity. If the allocation
     * strategy is diversified, the Spot Fleet terminates instances across the
     * Spot Instance pools. Alternatively, you can request that the Spot Fleet keep the fleet
     * at its current size, but not replace any Spot Instances that are interrupted or that you
     * terminate manually.
     * If you are finished with your Spot Fleet for now, but will use it again later, you can
     * set the target capacity to 0.
     */
    suspend fun modifySpotFleetRequest(block: ModifySpotFleetRequestRequest.DslBuilder.() -> Unit) = modifySpotFleetRequest(ModifySpotFleetRequestRequest.builder().apply(block).build())

    /**
     * Modifies a subnet attribute. You can only modify one attribute at a time.
     */
    suspend fun modifySubnetAttribute(input: ModifySubnetAttributeRequest): ModifySubnetAttributeResponse

    /**
     * Modifies a subnet attribute. You can only modify one attribute at a time.
     */
    suspend fun modifySubnetAttribute(block: ModifySubnetAttributeRequest.DslBuilder.() -> Unit) = modifySubnetAttribute(ModifySubnetAttributeRequest.builder().apply(block).build())

    /**
     * Allows or restricts mirroring network services.
     * By default, Amazon DNS network services are not eligible for Traffic Mirror. Use AddNetworkServices to add network services to a Traffic Mirror filter. When a network service is added to the Traffic Mirror filter, all traffic related to that network service will be mirrored.
     * When you no longer want to mirror network services, use RemoveNetworkServices to remove the network services from the Traffic Mirror filter.
     */
    suspend fun modifyTrafficMirrorFilterNetworkServices(input: ModifyTrafficMirrorFilterNetworkServicesRequest): ModifyTrafficMirrorFilterNetworkServicesResponse

    /**
     * Allows or restricts mirroring network services.
     * By default, Amazon DNS network services are not eligible for Traffic Mirror. Use AddNetworkServices to add network services to a Traffic Mirror filter. When a network service is added to the Traffic Mirror filter, all traffic related to that network service will be mirrored.
     * When you no longer want to mirror network services, use RemoveNetworkServices to remove the network services from the Traffic Mirror filter.
     */
    suspend fun modifyTrafficMirrorFilterNetworkServices(block: ModifyTrafficMirrorFilterNetworkServicesRequest.DslBuilder.() -> Unit) = modifyTrafficMirrorFilterNetworkServices(ModifyTrafficMirrorFilterNetworkServicesRequest.builder().apply(block).build())

    /**
     * Modifies the specified Traffic Mirror rule.
     * DestinationCidrBlock and SourceCidrBlock must both be an IPv4
     * range or an IPv6 range.
     */
    suspend fun modifyTrafficMirrorFilterRule(input: ModifyTrafficMirrorFilterRuleRequest): ModifyTrafficMirrorFilterRuleResponse

    /**
     * Modifies the specified Traffic Mirror rule.
     * DestinationCidrBlock and SourceCidrBlock must both be an IPv4
     * range or an IPv6 range.
     */
    suspend fun modifyTrafficMirrorFilterRule(block: ModifyTrafficMirrorFilterRuleRequest.DslBuilder.() -> Unit) = modifyTrafficMirrorFilterRule(ModifyTrafficMirrorFilterRuleRequest.builder().apply(block).build())

    /**
     * Modifies a Traffic Mirror session.
     */
    suspend fun modifyTrafficMirrorSession(input: ModifyTrafficMirrorSessionRequest): ModifyTrafficMirrorSessionResponse

    /**
     * Modifies a Traffic Mirror session.
     */
    suspend fun modifyTrafficMirrorSession(block: ModifyTrafficMirrorSessionRequest.DslBuilder.() -> Unit) = modifyTrafficMirrorSession(ModifyTrafficMirrorSessionRequest.builder().apply(block).build())

    /**
     * Modifies the specified transit gateway. When you modify a transit gateway, the modified options are applied to new transit gateway attachments only. Your existing transit gateway attachments are not modified.
     */
    suspend fun modifyTransitGateway(input: ModifyTransitGatewayRequest): ModifyTransitGatewayResponse

    /**
     * Modifies the specified transit gateway. When you modify a transit gateway, the modified options are applied to new transit gateway attachments only. Your existing transit gateway attachments are not modified.
     */
    suspend fun modifyTransitGateway(block: ModifyTransitGatewayRequest.DslBuilder.() -> Unit) = modifyTransitGateway(ModifyTransitGatewayRequest.builder().apply(block).build())

    /**
     * Modifies a reference (route) to a prefix list in a specified transit gateway route table.
     */
    suspend fun modifyTransitGatewayPrefixListReference(input: ModifyTransitGatewayPrefixListReferenceRequest): ModifyTransitGatewayPrefixListReferenceResponse

    /**
     * Modifies a reference (route) to a prefix list in a specified transit gateway route table.
     */
    suspend fun modifyTransitGatewayPrefixListReference(block: ModifyTransitGatewayPrefixListReferenceRequest.DslBuilder.() -> Unit) = modifyTransitGatewayPrefixListReference(ModifyTransitGatewayPrefixListReferenceRequest.builder().apply(block).build())

    /**
     * Modifies the specified VPC attachment.
     */
    suspend fun modifyTransitGatewayVpcAttachment(input: ModifyTransitGatewayVpcAttachmentRequest): ModifyTransitGatewayVpcAttachmentResponse

    /**
     * Modifies the specified VPC attachment.
     */
    suspend fun modifyTransitGatewayVpcAttachment(block: ModifyTransitGatewayVpcAttachmentRequest.DslBuilder.() -> Unit) = modifyTransitGatewayVpcAttachment(ModifyTransitGatewayVpcAttachmentRequest.builder().apply(block).build())

    /**
     * You can modify several parameters of an existing EBS volume, including volume size, volume
     * type, and IOPS capacity. If your EBS volume is attached to a current-generation EC2 instance
     * type, you might be able to apply these changes without stopping the instance or detaching the
     * volume from it. For more information about modifying EBS volumes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modify-volume.html">Amazon EBS Elastic Volumes (Linux instances)
     * or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-modify-volume.html">Amazon EBS Elastic Volumes (Windows instances).
     * When you complete a resize operation on your volume, you need to extend the volume's
     * file-system size to take advantage of the new storage capacity. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html#recognize-expanded-volume-linux">Extend a Linux file system or
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-expand-volume.html#recognize-expanded-volume-windows">Extend a Windows file system.
     * You can use CloudWatch Events to check the status of a modification to an EBS volume. For
     * information about CloudWatch Events, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/">Amazon CloudWatch Events User Guide. You can also track the status of a
     * modification using DescribeVolumesModifications. For information
     * about tracking status changes using either method, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-modifications.html">Monitor the progress of volume modifications.
     * With previous-generation instance types, resizing an EBS volume might require detaching and
     * reattaching the volume or stopping and restarting the instance.
     * If you reach the maximum volume modification rate per volume limit, you must wait
     * at least six hours before applying further modifications to the affected EBS volume.
     */
    suspend fun modifyVolume(input: ModifyVolumeRequest): ModifyVolumeResponse

    /**
     * You can modify several parameters of an existing EBS volume, including volume size, volume
     * type, and IOPS capacity. If your EBS volume is attached to a current-generation EC2 instance
     * type, you might be able to apply these changes without stopping the instance or detaching the
     * volume from it. For more information about modifying EBS volumes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modify-volume.html">Amazon EBS Elastic Volumes (Linux instances)
     * or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-modify-volume.html">Amazon EBS Elastic Volumes (Windows instances).
     * When you complete a resize operation on your volume, you need to extend the volume's
     * file-system size to take advantage of the new storage capacity. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html#recognize-expanded-volume-linux">Extend a Linux file system or
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-expand-volume.html#recognize-expanded-volume-windows">Extend a Windows file system.
     * You can use CloudWatch Events to check the status of a modification to an EBS volume. For
     * information about CloudWatch Events, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/">Amazon CloudWatch Events User Guide. You can also track the status of a
     * modification using DescribeVolumesModifications. For information
     * about tracking status changes using either method, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-modifications.html">Monitor the progress of volume modifications.
     * With previous-generation instance types, resizing an EBS volume might require detaching and
     * reattaching the volume or stopping and restarting the instance.
     * If you reach the maximum volume modification rate per volume limit, you must wait
     * at least six hours before applying further modifications to the affected EBS volume.
     */
    suspend fun modifyVolume(block: ModifyVolumeRequest.DslBuilder.() -> Unit) = modifyVolume(ModifyVolumeRequest.builder().apply(block).build())

    /**
     * Modifies a volume attribute.
     * By default, all I/O operations for the volume are suspended when the data on the volume is
     * determined to be potentially inconsistent, to prevent undetectable, latent data corruption.
     * The I/O access to the volume can be resumed by first enabling I/O access and then checking the
     * data consistency on your volume.
     * You can change the default behavior to resume I/O operations. We recommend that you change
     * this only for boot volumes or for volumes that are stateless or disposable.
     */
    suspend fun modifyVolumeAttribute(input: ModifyVolumeAttributeRequest): ModifyVolumeAttributeResponse

    /**
     * Modifies a volume attribute.
     * By default, all I/O operations for the volume are suspended when the data on the volume is
     * determined to be potentially inconsistent, to prevent undetectable, latent data corruption.
     * The I/O access to the volume can be resumed by first enabling I/O access and then checking the
     * data consistency on your volume.
     * You can change the default behavior to resume I/O operations. We recommend that you change
     * this only for boot volumes or for volumes that are stateless or disposable.
     */
    suspend fun modifyVolumeAttribute(block: ModifyVolumeAttributeRequest.DslBuilder.() -> Unit) = modifyVolumeAttribute(ModifyVolumeAttributeRequest.builder().apply(block).build())

    /**
     * Modifies the specified attribute of the specified VPC.
     */
    suspend fun modifyVpcAttribute(input: ModifyVpcAttributeRequest): ModifyVpcAttributeResponse

    /**
     * Modifies the specified attribute of the specified VPC.
     */
    suspend fun modifyVpcAttribute(block: ModifyVpcAttributeRequest.DslBuilder.() -> Unit) = modifyVpcAttribute(ModifyVpcAttributeRequest.builder().apply(block).build())

    /**
     * Modifies attributes of a specified VPC endpoint. The attributes that you can modify
     * depend on the type of VPC endpoint (interface, gateway, or Gateway Load Balancer). For more information, see
     * <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints.html">VPC
     * Endpoints in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun modifyVpcEndpoint(input: ModifyVpcEndpointRequest): ModifyVpcEndpointResponse

    /**
     * Modifies attributes of a specified VPC endpoint. The attributes that you can modify
     * depend on the type of VPC endpoint (interface, gateway, or Gateway Load Balancer). For more information, see
     * <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints.html">VPC
     * Endpoints in the Amazon Virtual Private Cloud User Guide.
     */
    suspend fun modifyVpcEndpoint(block: ModifyVpcEndpointRequest.DslBuilder.() -> Unit) = modifyVpcEndpoint(ModifyVpcEndpointRequest.builder().apply(block).build())

    /**
     * Modifies a connection notification for VPC endpoint or VPC endpoint service. You
     * can change the SNS topic for the notification, or the events for which to be notified.
     */
    suspend fun modifyVpcEndpointConnectionNotification(input: ModifyVpcEndpointConnectionNotificationRequest): ModifyVpcEndpointConnectionNotificationResponse

    /**
     * Modifies a connection notification for VPC endpoint or VPC endpoint service. You
     * can change the SNS topic for the notification, or the events for which to be notified.
     */
    suspend fun modifyVpcEndpointConnectionNotification(block: ModifyVpcEndpointConnectionNotificationRequest.DslBuilder.() -> Unit) = modifyVpcEndpointConnectionNotification(ModifyVpcEndpointConnectionNotificationRequest.builder().apply(block).build())

    /**
     * Modifies the attributes of your VPC endpoint service configuration. You can change the
     * Network Load Balancers or Gateway Load Balancers for your service, and you can specify whether acceptance is
     * required for requests to connect to your endpoint service through an interface VPC
     * endpoint.
     * If you set or modify the private DNS name, you must prove that you own the private DNS
     * domain name. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html">VPC Endpoint Service
     * Private DNS Name Verification in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun modifyVpcEndpointServiceConfiguration(input: ModifyVpcEndpointServiceConfigurationRequest): ModifyVpcEndpointServiceConfigurationResponse

    /**
     * Modifies the attributes of your VPC endpoint service configuration. You can change the
     * Network Load Balancers or Gateway Load Balancers for your service, and you can specify whether acceptance is
     * required for requests to connect to your endpoint service through an interface VPC
     * endpoint.
     * If you set or modify the private DNS name, you must prove that you own the private DNS
     * domain name. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html">VPC Endpoint Service
     * Private DNS Name Verification in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun modifyVpcEndpointServiceConfiguration(block: ModifyVpcEndpointServiceConfigurationRequest.DslBuilder.() -> Unit) = modifyVpcEndpointServiceConfiguration(ModifyVpcEndpointServiceConfigurationRequest.builder().apply(block).build())

    /**
     * Modifies the permissions for your <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html">VPC endpoint service. You can add or remove permissions for service consumers (IAM users,
     * IAM roles, and Amazon Web Services accounts) to connect to your endpoint service.
     * If you grant permissions to all principals, the service is public. Any users who know the name of a
     * public service can send a request to attach an endpoint. If the service does not require manual approval,
     * attachments are automatically approved.
     */
    suspend fun modifyVpcEndpointServicePermissions(input: ModifyVpcEndpointServicePermissionsRequest): ModifyVpcEndpointServicePermissionsResponse

    /**
     * Modifies the permissions for your <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html">VPC endpoint service. You can add or remove permissions for service consumers (IAM users,
     * IAM roles, and Amazon Web Services accounts) to connect to your endpoint service.
     * If you grant permissions to all principals, the service is public. Any users who know the name of a
     * public service can send a request to attach an endpoint. If the service does not require manual approval,
     * attachments are automatically approved.
     */
    suspend fun modifyVpcEndpointServicePermissions(block: ModifyVpcEndpointServicePermissionsRequest.DslBuilder.() -> Unit) = modifyVpcEndpointServicePermissions(ModifyVpcEndpointServicePermissionsRequest.builder().apply(block).build())

    /**
     * Modifies the VPC peering connection options on one side of a VPC peering connection. You can do the following:
     * Enable/disable communication over the peering connection between an EC2-Classic instance that's linked to your VPC (using ClassicLink) and instances in the peer VPC.
     * Enable/disable communication over the peering connection between instances in your VPC and an EC2-Classic instance that's linked to the peer VPC.
     * Enable/disable the ability to resolve public DNS hostnames to private IP
     * addresses when queried from instances in the peer VPC.
     * If the peered VPCs are in the same Amazon Web Services account, you can enable DNS resolution
     * for queries from the local VPC. This ensures that queries from the local VPC resolve to private IP
     * addresses in the peer VPC. This option is not available if the peered VPCs are in different
     * different Amazon Web Services accounts or different Regions. For peered VPCs in different
     * Amazon Web Services accounts, each Amazon Web Services account owner must initiate a separate request
     * to modify the peering connection options. For inter-region peering connections, you must use the
     * Region for the requester VPC to modify the requester VPC peering options and the Region for the
     * accepter VPC to modify the accepter VPC peering options. To verify which VPCs are the accepter and
     * the requester for a VPC peering connection, use the DescribeVpcPeeringConnections command.
     */
    suspend fun modifyVpcPeeringConnectionOptions(input: ModifyVpcPeeringConnectionOptionsRequest): ModifyVpcPeeringConnectionOptionsResponse

    /**
     * Modifies the VPC peering connection options on one side of a VPC peering connection. You can do the following:
     * Enable/disable communication over the peering connection between an EC2-Classic instance that's linked to your VPC (using ClassicLink) and instances in the peer VPC.
     * Enable/disable communication over the peering connection between instances in your VPC and an EC2-Classic instance that's linked to the peer VPC.
     * Enable/disable the ability to resolve public DNS hostnames to private IP
     * addresses when queried from instances in the peer VPC.
     * If the peered VPCs are in the same Amazon Web Services account, you can enable DNS resolution
     * for queries from the local VPC. This ensures that queries from the local VPC resolve to private IP
     * addresses in the peer VPC. This option is not available if the peered VPCs are in different
     * different Amazon Web Services accounts or different Regions. For peered VPCs in different
     * Amazon Web Services accounts, each Amazon Web Services account owner must initiate a separate request
     * to modify the peering connection options. For inter-region peering connections, you must use the
     * Region for the requester VPC to modify the requester VPC peering options and the Region for the
     * accepter VPC to modify the accepter VPC peering options. To verify which VPCs are the accepter and
     * the requester for a VPC peering connection, use the DescribeVpcPeeringConnections command.
     */
    suspend fun modifyVpcPeeringConnectionOptions(block: ModifyVpcPeeringConnectionOptionsRequest.DslBuilder.() -> Unit) = modifyVpcPeeringConnectionOptions(ModifyVpcPeeringConnectionOptionsRequest.builder().apply(block).build())

    /**
     * Modifies the instance tenancy attribute of the specified VPC. You can change the
     * instance tenancy attribute of a VPC to default only. You cannot change the
     * instance tenancy attribute to dedicated.
     * After you modify the tenancy of the VPC, any new instances that you launch into the
     * VPC have a tenancy of default, unless you specify otherwise during launch.
     * The tenancy of any existing instances in the VPC is not affected.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun modifyVpcTenancy(input: ModifyVpcTenancyRequest): ModifyVpcTenancyResponse

    /**
     * Modifies the instance tenancy attribute of the specified VPC. You can change the
     * instance tenancy attribute of a VPC to default only. You cannot change the
     * instance tenancy attribute to dedicated.
     * After you modify the tenancy of the VPC, any new instances that you launch into the
     * VPC have a tenancy of default, unless you specify otherwise during launch.
     * The tenancy of any existing instances in the VPC is not affected.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun modifyVpcTenancy(block: ModifyVpcTenancyRequest.DslBuilder.() -> Unit) = modifyVpcTenancy(ModifyVpcTenancyRequest.builder().apply(block).build())

    /**
     * Modifies the customer gateway or the target gateway of an Amazon Web Services Site-to-Site VPN connection. To
     * modify the target gateway, the following migration options are available:
     * An existing virtual private gateway to a new virtual private gateway
     * An existing virtual private gateway to a transit gateway
     * An existing transit gateway to a new transit gateway
     * An existing transit gateway to a virtual private gateway
     * Before you perform the migration to the new gateway, you must configure the new
     * gateway. Use CreateVpnGateway to create a virtual private gateway, or
     * CreateTransitGateway to create a transit gateway.
     * This step is required when you migrate from a virtual private gateway with static
     * routes to a transit gateway.
     * You must delete the static routes before you migrate to the new gateway.
     * Keep a copy of the static route before you delete it. You will need to add back these
     * routes to the transit gateway after the VPN connection migration is complete.
     * After you migrate to the new gateway, you might need to modify your VPC route table.
     * Use CreateRoute and DeleteRoute to make the changes
     * described in <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/modify-vpn-target.html#step-update-routing">Update VPC route
     * tables in the Amazon Web Services Site-to-Site VPN User Guide.
     * When the new gateway is a transit gateway, modify the transit gateway route table to
     * allow traffic between the VPC and the Amazon Web Services Site-to-Site VPN connection.
     * Use CreateTransitGatewayRoute to add the routes.
     * If you deleted VPN static routes, you must add the static routes to the transit
     * gateway route table.
     * After you perform this operation, the VPN endpoint's IP addresses on the Amazon Web Services side and the tunnel options remain intact. Your Amazon Web Services Site-to-Site VPN connection will
     * be temporarily unavailable for a brief period while we provision the new
     * endpoints.
     */
    suspend fun modifyVpnConnection(input: ModifyVpnConnectionRequest): ModifyVpnConnectionResponse

    /**
     * Modifies the customer gateway or the target gateway of an Amazon Web Services Site-to-Site VPN connection. To
     * modify the target gateway, the following migration options are available:
     * An existing virtual private gateway to a new virtual private gateway
     * An existing virtual private gateway to a transit gateway
     * An existing transit gateway to a new transit gateway
     * An existing transit gateway to a virtual private gateway
     * Before you perform the migration to the new gateway, you must configure the new
     * gateway. Use CreateVpnGateway to create a virtual private gateway, or
     * CreateTransitGateway to create a transit gateway.
     * This step is required when you migrate from a virtual private gateway with static
     * routes to a transit gateway.
     * You must delete the static routes before you migrate to the new gateway.
     * Keep a copy of the static route before you delete it. You will need to add back these
     * routes to the transit gateway after the VPN connection migration is complete.
     * After you migrate to the new gateway, you might need to modify your VPC route table.
     * Use CreateRoute and DeleteRoute to make the changes
     * described in <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/modify-vpn-target.html#step-update-routing">Update VPC route
     * tables in the Amazon Web Services Site-to-Site VPN User Guide.
     * When the new gateway is a transit gateway, modify the transit gateway route table to
     * allow traffic between the VPC and the Amazon Web Services Site-to-Site VPN connection.
     * Use CreateTransitGatewayRoute to add the routes.
     * If you deleted VPN static routes, you must add the static routes to the transit
     * gateway route table.
     * After you perform this operation, the VPN endpoint's IP addresses on the Amazon Web Services side and the tunnel options remain intact. Your Amazon Web Services Site-to-Site VPN connection will
     * be temporarily unavailable for a brief period while we provision the new
     * endpoints.
     */
    suspend fun modifyVpnConnection(block: ModifyVpnConnectionRequest.DslBuilder.() -> Unit) = modifyVpnConnection(ModifyVpnConnectionRequest.builder().apply(block).build())

    /**
     * Modifies the connection options for your Site-to-Site VPN connection.
     * When you modify the VPN connection options, the VPN endpoint IP addresses on the
     * Amazon Web Services side do not change, and the tunnel options do not change. Your
     * VPN connection will be temporarily unavailable for a brief period while the VPN
     * connection is updated.
     */
    suspend fun modifyVpnConnectionOptions(input: ModifyVpnConnectionOptionsRequest): ModifyVpnConnectionOptionsResponse

    /**
     * Modifies the connection options for your Site-to-Site VPN connection.
     * When you modify the VPN connection options, the VPN endpoint IP addresses on the
     * Amazon Web Services side do not change, and the tunnel options do not change. Your
     * VPN connection will be temporarily unavailable for a brief period while the VPN
     * connection is updated.
     */
    suspend fun modifyVpnConnectionOptions(block: ModifyVpnConnectionOptionsRequest.DslBuilder.() -> Unit) = modifyVpnConnectionOptions(ModifyVpnConnectionOptionsRequest.builder().apply(block).build())

    /**
     * Modifies the VPN tunnel endpoint certificate.
     */
    suspend fun modifyVpnTunnelCertificate(input: ModifyVpnTunnelCertificateRequest): ModifyVpnTunnelCertificateResponse

    /**
     * Modifies the VPN tunnel endpoint certificate.
     */
    suspend fun modifyVpnTunnelCertificate(block: ModifyVpnTunnelCertificateRequest.DslBuilder.() -> Unit) = modifyVpnTunnelCertificate(ModifyVpnTunnelCertificateRequest.builder().apply(block).build())

    /**
     * Modifies the options for a VPN tunnel in an Amazon Web Services Site-to-Site VPN connection. You can modify
     * multiple options for a tunnel in a single request, but you can only modify one tunnel at
     * a time. For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPNTunnels.html">Site-to-Site VPN tunnel options for your Site-to-Site VPN
     * connection in the Amazon Web Services Site-to-Site VPN User Guide.
     */
    suspend fun modifyVpnTunnelOptions(input: ModifyVpnTunnelOptionsRequest): ModifyVpnTunnelOptionsResponse

    /**
     * Modifies the options for a VPN tunnel in an Amazon Web Services Site-to-Site VPN connection. You can modify
     * multiple options for a tunnel in a single request, but you can only modify one tunnel at
     * a time. For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPNTunnels.html">Site-to-Site VPN tunnel options for your Site-to-Site VPN
     * connection in the Amazon Web Services Site-to-Site VPN User Guide.
     */
    suspend fun modifyVpnTunnelOptions(block: ModifyVpnTunnelOptionsRequest.DslBuilder.() -> Unit) = modifyVpnTunnelOptions(ModifyVpnTunnelOptionsRequest.builder().apply(block).build())

    /**
     * Enables detailed monitoring for a running instance. Otherwise, basic monitoring is
     * enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html">Monitoring your instances and
     * volumes in the Amazon EC2 User Guide.
     * To disable detailed monitoring, see .
     */
    suspend fun monitorInstances(input: MonitorInstancesRequest): MonitorInstancesResponse

    /**
     * Enables detailed monitoring for a running instance. Otherwise, basic monitoring is
     * enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html">Monitoring your instances and
     * volumes in the Amazon EC2 User Guide.
     * To disable detailed monitoring, see .
     */
    suspend fun monitorInstances(block: MonitorInstancesRequest.DslBuilder.() -> Unit) = monitorInstances(MonitorInstancesRequest.builder().apply(block).build())

    /**
     * Moves an Elastic IP address from the EC2-Classic platform to the EC2-VPC platform. The
     * Elastic IP address must be allocated to your account for more than 24 hours, and it must not
     * be associated with an instance. After the Elastic IP address is moved, it is no longer
     * available for use in the EC2-Classic platform, unless you move it back using the
     * RestoreAddressToClassic request. You cannot move an Elastic IP address that was
     * originally allocated for use in the EC2-VPC platform to the EC2-Classic platform.
     */
    suspend fun moveAddressToVpc(input: MoveAddressToVpcRequest): MoveAddressToVpcResponse

    /**
     * Moves an Elastic IP address from the EC2-Classic platform to the EC2-VPC platform. The
     * Elastic IP address must be allocated to your account for more than 24 hours, and it must not
     * be associated with an instance. After the Elastic IP address is moved, it is no longer
     * available for use in the EC2-Classic platform, unless you move it back using the
     * RestoreAddressToClassic request. You cannot move an Elastic IP address that was
     * originally allocated for use in the EC2-VPC platform to the EC2-Classic platform.
     */
    suspend fun moveAddressToVpc(block: MoveAddressToVpcRequest.DslBuilder.() -> Unit) = moveAddressToVpc(MoveAddressToVpcRequest.builder().apply(block).build())

    /**
     * Provisions an IPv4 or IPv6 address range for use with your Amazon Web Services resources through bring your own IP
     * addresses (BYOIP) and creates a corresponding address pool. After the address range is
     * provisioned, it is ready to be advertised using AdvertiseByoipCidr.
     * Amazon Web Services verifies that you own the address range and are authorized to advertise it.
     * You must ensure that the address range is registered to you and that you created an
     * RPKI ROA to authorize Amazon ASNs 16509 and 14618 to advertise the address range.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring your own IP addresses (BYOIP) in the Amazon Elastic Compute Cloud User Guide.
     * Provisioning an address range is an asynchronous operation, so the call returns immediately,
     * but the address range is not ready to use until its status changes from pending-provision
     * to provisioned. To monitor the status of an address range, use DescribeByoipCidrs.
     * To allocate an Elastic IP address from your IPv4 address pool, use AllocateAddress
     * with either the specific address from the address pool or the ID of the address pool.
     */
    suspend fun provisionByoipCidr(input: ProvisionByoipCidrRequest): ProvisionByoipCidrResponse

    /**
     * Provisions an IPv4 or IPv6 address range for use with your Amazon Web Services resources through bring your own IP
     * addresses (BYOIP) and creates a corresponding address pool. After the address range is
     * provisioned, it is ready to be advertised using AdvertiseByoipCidr.
     * Amazon Web Services verifies that you own the address range and are authorized to advertise it.
     * You must ensure that the address range is registered to you and that you created an
     * RPKI ROA to authorize Amazon ASNs 16509 and 14618 to advertise the address range.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring your own IP addresses (BYOIP) in the Amazon Elastic Compute Cloud User Guide.
     * Provisioning an address range is an asynchronous operation, so the call returns immediately,
     * but the address range is not ready to use until its status changes from pending-provision
     * to provisioned. To monitor the status of an address range, use DescribeByoipCidrs.
     * To allocate an Elastic IP address from your IPv4 address pool, use AllocateAddress
     * with either the specific address from the address pool or the ID of the address pool.
     */
    suspend fun provisionByoipCidr(block: ProvisionByoipCidrRequest.DslBuilder.() -> Unit) = provisionByoipCidr(ProvisionByoipCidrRequest.builder().apply(block).build())

    /**
     * Purchase a reservation with configurations that match those of your Dedicated Host.
     * You must have active Dedicated Hosts in your account before you purchase a reservation.
     * This action results in the specified reservation being purchased and charged to your
     * account.
     */
    suspend fun purchaseHostReservation(input: PurchaseHostReservationRequest): PurchaseHostReservationResponse

    /**
     * Purchase a reservation with configurations that match those of your Dedicated Host.
     * You must have active Dedicated Hosts in your account before you purchase a reservation.
     * This action results in the specified reservation being purchased and charged to your
     * account.
     */
    suspend fun purchaseHostReservation(block: PurchaseHostReservationRequest.DslBuilder.() -> Unit) = purchaseHostReservation(PurchaseHostReservationRequest.builder().apply(block).build())

    /**
     * Purchases a Reserved Instance for use with your account. With Reserved Instances, you pay a lower
     * hourly rate compared to On-Demand instance pricing.
     * Use DescribeReservedInstancesOfferings to get a list of Reserved Instance offerings
     * that match your specifications. After you've purchased a Reserved Instance, you can check for your
     * new Reserved Instance with DescribeReservedInstances.
     * To queue a purchase for a future date and time, specify a purchase time. If you do not specify a
     * purchase time, the default is the current time.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved Instances and
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace
     * in the Amazon EC2 User Guide.
     */
    suspend fun purchaseReservedInstancesOffering(input: PurchaseReservedInstancesOfferingRequest): PurchaseReservedInstancesOfferingResponse

    /**
     * Purchases a Reserved Instance for use with your account. With Reserved Instances, you pay a lower
     * hourly rate compared to On-Demand instance pricing.
     * Use DescribeReservedInstancesOfferings to get a list of Reserved Instance offerings
     * that match your specifications. After you've purchased a Reserved Instance, you can check for your
     * new Reserved Instance with DescribeReservedInstances.
     * To queue a purchase for a future date and time, specify a purchase time. If you do not specify a
     * purchase time, the default is the current time.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved Instances and
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace
     * in the Amazon EC2 User Guide.
     */
    suspend fun purchaseReservedInstancesOffering(block: PurchaseReservedInstancesOfferingRequest.DslBuilder.() -> Unit) = purchaseReservedInstancesOffering(PurchaseReservedInstancesOfferingRequest.builder().apply(block).build())

    /**
     * Purchases the Scheduled Instances with the specified schedule.
     * Scheduled Instances enable you to purchase Amazon EC2 compute capacity by the hour for a one-year term.
     * Before you can purchase a Scheduled Instance, you must call DescribeScheduledInstanceAvailability
     * to check for available schedules and obtain a purchase token. After you purchase a Scheduled Instance,
     * you must call RunScheduledInstances during each scheduled time period.
     * After you purchase a Scheduled Instance, you can't cancel, modify, or resell your purchase.
     */
    suspend fun purchaseScheduledInstances(input: PurchaseScheduledInstancesRequest): PurchaseScheduledInstancesResponse

    /**
     * Purchases the Scheduled Instances with the specified schedule.
     * Scheduled Instances enable you to purchase Amazon EC2 compute capacity by the hour for a one-year term.
     * Before you can purchase a Scheduled Instance, you must call DescribeScheduledInstanceAvailability
     * to check for available schedules and obtain a purchase token. After you purchase a Scheduled Instance,
     * you must call RunScheduledInstances during each scheduled time period.
     * After you purchase a Scheduled Instance, you can't cancel, modify, or resell your purchase.
     */
    suspend fun purchaseScheduledInstances(block: PurchaseScheduledInstancesRequest.DslBuilder.() -> Unit) = purchaseScheduledInstances(PurchaseScheduledInstancesRequest.builder().apply(block).build())

    /**
     * Requests a reboot of the specified instances. This operation is asynchronous; it only
     * queues a request to reboot the specified instances. The operation succeeds if the
     * instances are valid and belong to you. Requests to reboot terminated instances are
     * ignored.
     * If an instance does not cleanly shut down within a few minutes, Amazon EC2 performs a
     * hard reboot.
     * For more information about troubleshooting, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html">Getting console output and
     * rebooting instances in the Amazon EC2 User Guide.
     */
    suspend fun rebootInstances(input: RebootInstancesRequest): RebootInstancesResponse

    /**
     * Requests a reboot of the specified instances. This operation is asynchronous; it only
     * queues a request to reboot the specified instances. The operation succeeds if the
     * instances are valid and belong to you. Requests to reboot terminated instances are
     * ignored.
     * If an instance does not cleanly shut down within a few minutes, Amazon EC2 performs a
     * hard reboot.
     * For more information about troubleshooting, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html">Getting console output and
     * rebooting instances in the Amazon EC2 User Guide.
     */
    suspend fun rebootInstances(block: RebootInstancesRequest.DslBuilder.() -> Unit) = rebootInstances(RebootInstancesRequest.builder().apply(block).build())

    /**
     * Registers an AMI. When you're creating an AMI, this is the final step you must complete
     * before you can launch an instance from the AMI. For more information about creating AMIs, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami.html">Creating your
     * own AMIs in the Amazon Elastic Compute Cloud User Guide.
     * For Amazon EBS-backed instances, CreateImage creates and registers
     * the AMI in a single request, so you don't have to register the AMI yourself.
     * If needed, you can deregister an AMI at any time. Any modifications you make to an AMI backed by an instance store volume invalidates its registration.
     * If you make changes to an image, deregister the previous image and register the new image.
     * Register a snapshot of a root device volume
     * You can use RegisterImage to create an Amazon EBS-backed Linux AMI from
     * a snapshot of a root device volume. You specify the snapshot using a block device mapping.
     * You can't set the encryption state of the volume using the block device mapping. If the
     * snapshot is encrypted, or encryption by default is enabled, the root volume of an instance
     * launched from the AMI is encrypted.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html#creating-launching-ami-from-snapshot">Create a Linux AMI from a snapshot and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIEncryption.html">Use encryption with Amazon EBS-backed AMIs
     * in the Amazon Elastic Compute Cloud User Guide.
     * Amazon Web Services Marketplace product codes
     * If any snapshots have Amazon Web Services Marketplace product codes, they are copied to the new
     * AMI.
     * Windows and some Linux distributions, such as Red Hat Enterprise Linux (RHEL) and SUSE
     * Linux Enterprise Server (SLES), use the Amazon EC2 billing product code associated with an AMI to
     * verify the subscription status for package updates. To create a new AMI for operating systems
     * that require a billing product code, instead of registering the AMI, do the following to
     * preserve the billing product code association:
     * <ol>
     * Launch an instance from an existing AMI with that billing product code.
     * Customize the instance.
     * Create an AMI from the instance using CreateImage.
     * </ol>
     * If you purchase a Reserved Instance to apply to an On-Demand Instance that was launched
     * from an AMI with a billing product code, make sure that the Reserved Instance has the matching
     * billing product code. If you purchase a Reserved Instance without the matching billing product
     * code, the Reserved Instance will not be applied to the On-Demand Instance. For information
     * about how to obtain the platform details and billing information of an AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-billing-info.html">Understanding AMI
     * billing in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun registerImage(input: RegisterImageRequest): RegisterImageResponse

    /**
     * Registers an AMI. When you're creating an AMI, this is the final step you must complete
     * before you can launch an instance from the AMI. For more information about creating AMIs, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami.html">Creating your
     * own AMIs in the Amazon Elastic Compute Cloud User Guide.
     * For Amazon EBS-backed instances, CreateImage creates and registers
     * the AMI in a single request, so you don't have to register the AMI yourself.
     * If needed, you can deregister an AMI at any time. Any modifications you make to an AMI backed by an instance store volume invalidates its registration.
     * If you make changes to an image, deregister the previous image and register the new image.
     * Register a snapshot of a root device volume
     * You can use RegisterImage to create an Amazon EBS-backed Linux AMI from
     * a snapshot of a root device volume. You specify the snapshot using a block device mapping.
     * You can't set the encryption state of the volume using the block device mapping. If the
     * snapshot is encrypted, or encryption by default is enabled, the root volume of an instance
     * launched from the AMI is encrypted.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html#creating-launching-ami-from-snapshot">Create a Linux AMI from a snapshot and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIEncryption.html">Use encryption with Amazon EBS-backed AMIs
     * in the Amazon Elastic Compute Cloud User Guide.
     * Amazon Web Services Marketplace product codes
     * If any snapshots have Amazon Web Services Marketplace product codes, they are copied to the new
     * AMI.
     * Windows and some Linux distributions, such as Red Hat Enterprise Linux (RHEL) and SUSE
     * Linux Enterprise Server (SLES), use the Amazon EC2 billing product code associated with an AMI to
     * verify the subscription status for package updates. To create a new AMI for operating systems
     * that require a billing product code, instead of registering the AMI, do the following to
     * preserve the billing product code association:
     * <ol>
     * Launch an instance from an existing AMI with that billing product code.
     * Customize the instance.
     * Create an AMI from the instance using CreateImage.
     * </ol>
     * If you purchase a Reserved Instance to apply to an On-Demand Instance that was launched
     * from an AMI with a billing product code, make sure that the Reserved Instance has the matching
     * billing product code. If you purchase a Reserved Instance without the matching billing product
     * code, the Reserved Instance will not be applied to the On-Demand Instance. For information
     * about how to obtain the platform details and billing information of an AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-billing-info.html">Understanding AMI
     * billing in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun registerImage(block: RegisterImageRequest.DslBuilder.() -> Unit) = registerImage(RegisterImageRequest.builder().apply(block).build())

    /**
     * Registers a set of tag keys to include in scheduled event notifications for your resources.
     * To remove tags, use .
     */
    suspend fun registerInstanceEventNotificationAttributes(input: RegisterInstanceEventNotificationAttributesRequest): RegisterInstanceEventNotificationAttributesResponse

    /**
     * Registers a set of tag keys to include in scheduled event notifications for your resources.
     * To remove tags, use .
     */
    suspend fun registerInstanceEventNotificationAttributes(block: RegisterInstanceEventNotificationAttributesRequest.DslBuilder.() -> Unit) = registerInstanceEventNotificationAttributes(RegisterInstanceEventNotificationAttributesRequest.builder().apply(block).build())

    /**
     * Registers members (network interfaces) with the  transit gateway multicast group. A member is a network interface associated
     * with a supported EC2 instance that receives multicast traffic. For information about
     * supported instances, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/transit-gateway-limits.html#multicast-limits">Multicast
     * Consideration in Amazon VPC Transit Gateways.
     * After you add the members, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayMulticastGroups.html">SearchTransitGatewayMulticastGroups to verify that the members were added
     * to the  transit gateway multicast group.
     */
    suspend fun registerTransitGatewayMulticastGroupMembers(input: RegisterTransitGatewayMulticastGroupMembersRequest): RegisterTransitGatewayMulticastGroupMembersResponse

    /**
     * Registers members (network interfaces) with the  transit gateway multicast group. A member is a network interface associated
     * with a supported EC2 instance that receives multicast traffic. For information about
     * supported instances, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/transit-gateway-limits.html#multicast-limits">Multicast
     * Consideration in Amazon VPC Transit Gateways.
     * After you add the members, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayMulticastGroups.html">SearchTransitGatewayMulticastGroups to verify that the members were added
     * to the  transit gateway multicast group.
     */
    suspend fun registerTransitGatewayMulticastGroupMembers(block: RegisterTransitGatewayMulticastGroupMembersRequest.DslBuilder.() -> Unit) = registerTransitGatewayMulticastGroupMembers(RegisterTransitGatewayMulticastGroupMembersRequest.builder().apply(block).build())

    /**
     * Registers sources (network interfaces) with the specified  transit gateway multicast group.
     * A multicast source is a network interface attached to a supported instance that sends
     * multicast traffic. For information about supported instances, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/transit-gateway-limits.html#multicast-limits">Multicast
     * Considerations in Amazon VPC Transit Gateways.
     * After you add the source, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayMulticastGroups.html">SearchTransitGatewayMulticastGroups to verify that the source was added to the multicast
     * group.
     */
    suspend fun registerTransitGatewayMulticastGroupSources(input: RegisterTransitGatewayMulticastGroupSourcesRequest): RegisterTransitGatewayMulticastGroupSourcesResponse

    /**
     * Registers sources (network interfaces) with the specified  transit gateway multicast group.
     * A multicast source is a network interface attached to a supported instance that sends
     * multicast traffic. For information about supported instances, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/transit-gateway-limits.html#multicast-limits">Multicast
     * Considerations in Amazon VPC Transit Gateways.
     * After you add the source, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayMulticastGroups.html">SearchTransitGatewayMulticastGroups to verify that the source was added to the multicast
     * group.
     */
    suspend fun registerTransitGatewayMulticastGroupSources(block: RegisterTransitGatewayMulticastGroupSourcesRequest.DslBuilder.() -> Unit) = registerTransitGatewayMulticastGroupSources(RegisterTransitGatewayMulticastGroupSourcesRequest.builder().apply(block).build())

    /**
     * Rejects a request to associate cross-account subnets with a transit gateway multicast domain.
     */
    suspend fun rejectTransitGatewayMulticastDomainAssociations(input: RejectTransitGatewayMulticastDomainAssociationsRequest): RejectTransitGatewayMulticastDomainAssociationsResponse

    /**
     * Rejects a request to associate cross-account subnets with a transit gateway multicast domain.
     */
    suspend fun rejectTransitGatewayMulticastDomainAssociations(block: RejectTransitGatewayMulticastDomainAssociationsRequest.DslBuilder.() -> Unit) = rejectTransitGatewayMulticastDomainAssociations(RejectTransitGatewayMulticastDomainAssociationsRequest.builder().apply(block).build())

    /**
     * Rejects a transit gateway peering attachment request.
     */
    suspend fun rejectTransitGatewayPeeringAttachment(input: RejectTransitGatewayPeeringAttachmentRequest): RejectTransitGatewayPeeringAttachmentResponse

    /**
     * Rejects a transit gateway peering attachment request.
     */
    suspend fun rejectTransitGatewayPeeringAttachment(block: RejectTransitGatewayPeeringAttachmentRequest.DslBuilder.() -> Unit) = rejectTransitGatewayPeeringAttachment(RejectTransitGatewayPeeringAttachmentRequest.builder().apply(block).build())

    /**
     * Rejects a request to attach a VPC to a transit gateway.
     * The VPC attachment must be in the pendingAcceptance state.
     * Use DescribeTransitGatewayVpcAttachments to view your pending VPC attachment requests.
     * Use AcceptTransitGatewayVpcAttachment to accept a VPC attachment request.
     */
    suspend fun rejectTransitGatewayVpcAttachment(input: RejectTransitGatewayVpcAttachmentRequest): RejectTransitGatewayVpcAttachmentResponse

    /**
     * Rejects a request to attach a VPC to a transit gateway.
     * The VPC attachment must be in the pendingAcceptance state.
     * Use DescribeTransitGatewayVpcAttachments to view your pending VPC attachment requests.
     * Use AcceptTransitGatewayVpcAttachment to accept a VPC attachment request.
     */
    suspend fun rejectTransitGatewayVpcAttachment(block: RejectTransitGatewayVpcAttachmentRequest.DslBuilder.() -> Unit) = rejectTransitGatewayVpcAttachment(RejectTransitGatewayVpcAttachmentRequest.builder().apply(block).build())

    /**
     * Rejects one or more VPC endpoint connection requests to your VPC endpoint
     * service.
     */
    suspend fun rejectVpcEndpointConnections(input: RejectVpcEndpointConnectionsRequest): RejectVpcEndpointConnectionsResponse

    /**
     * Rejects one or more VPC endpoint connection requests to your VPC endpoint
     * service.
     */
    suspend fun rejectVpcEndpointConnections(block: RejectVpcEndpointConnectionsRequest.DslBuilder.() -> Unit) = rejectVpcEndpointConnections(RejectVpcEndpointConnectionsRequest.builder().apply(block).build())

    /**
     * Rejects a VPC peering connection request. The VPC peering connection must be in the
     * pending-acceptance state. Use the DescribeVpcPeeringConnections request
     * to view your outstanding VPC peering connection requests. To delete an active VPC peering
     * connection, or to delete a VPC peering connection request that you initiated, use	DeleteVpcPeeringConnection.
     */
    suspend fun rejectVpcPeeringConnection(input: RejectVpcPeeringConnectionRequest): RejectVpcPeeringConnectionResponse

    /**
     * Rejects a VPC peering connection request. The VPC peering connection must be in the
     * pending-acceptance state. Use the DescribeVpcPeeringConnections request
     * to view your outstanding VPC peering connection requests. To delete an active VPC peering
     * connection, or to delete a VPC peering connection request that you initiated, use	DeleteVpcPeeringConnection.
     */
    suspend fun rejectVpcPeeringConnection(block: RejectVpcPeeringConnectionRequest.DslBuilder.() -> Unit) = rejectVpcPeeringConnection(RejectVpcPeeringConnectionRequest.builder().apply(block).build())

    /**
     * Releases the specified Elastic IP address.
     * &#91;EC2-Classic, default VPC&#93; Releasing an Elastic IP address automatically disassociates it
     * from any instance that it's associated with. To disassociate an Elastic IP address without
     * releasing it, use DisassociateAddress.
     * &#91;Nondefault VPC&#93; You must use DisassociateAddress to disassociate the Elastic IP address
     * before you can release it. Otherwise, Amazon EC2 returns an error (InvalidIPAddress.InUse).
     * After releasing an Elastic IP address, it is released to the IP address pool.
     * Be sure to update your DNS records and any servers or devices that communicate with the address.
     * If you attempt to release an Elastic IP address that you already released, you'll get an
     * AuthFailure error if the address is already allocated to another Amazon Web Services account.
     * &#91;EC2-VPC&#93; After you release an Elastic IP address for use in a VPC, you might be able to recover it.
     * For more information, see AllocateAddress.
     */
    suspend fun releaseAddress(input: ReleaseAddressRequest): ReleaseAddressResponse

    /**
     * Releases the specified Elastic IP address.
     * &#91;EC2-Classic, default VPC&#93; Releasing an Elastic IP address automatically disassociates it
     * from any instance that it's associated with. To disassociate an Elastic IP address without
     * releasing it, use DisassociateAddress.
     * &#91;Nondefault VPC&#93; You must use DisassociateAddress to disassociate the Elastic IP address
     * before you can release it. Otherwise, Amazon EC2 returns an error (InvalidIPAddress.InUse).
     * After releasing an Elastic IP address, it is released to the IP address pool.
     * Be sure to update your DNS records and any servers or devices that communicate with the address.
     * If you attempt to release an Elastic IP address that you already released, you'll get an
     * AuthFailure error if the address is already allocated to another Amazon Web Services account.
     * &#91;EC2-VPC&#93; After you release an Elastic IP address for use in a VPC, you might be able to recover it.
     * For more information, see AllocateAddress.
     */
    suspend fun releaseAddress(block: ReleaseAddressRequest.DslBuilder.() -> Unit) = releaseAddress(ReleaseAddressRequest.builder().apply(block).build())

    /**
     * When you no longer want to use an On-Demand Dedicated Host it can be released.
     * On-Demand billing is stopped and the host goes into released state. The
     * host ID of Dedicated Hosts that have been released can no longer be specified in another
     * request, for example, to modify the host. You must stop or terminate all instances on a
     * host before it can be released.
     * When Dedicated Hosts are released, it may take some time for them to stop counting
     * toward your limit and you may receive capacity errors when trying to allocate new
     * Dedicated Hosts. Wait a few minutes and then try again.
     * Released hosts still appear in a DescribeHosts response.
     */
    suspend fun releaseHosts(input: ReleaseHostsRequest): ReleaseHostsResponse

    /**
     * When you no longer want to use an On-Demand Dedicated Host it can be released.
     * On-Demand billing is stopped and the host goes into released state. The
     * host ID of Dedicated Hosts that have been released can no longer be specified in another
     * request, for example, to modify the host. You must stop or terminate all instances on a
     * host before it can be released.
     * When Dedicated Hosts are released, it may take some time for them to stop counting
     * toward your limit and you may receive capacity errors when trying to allocate new
     * Dedicated Hosts. Wait a few minutes and then try again.
     * Released hosts still appear in a DescribeHosts response.
     */
    suspend fun releaseHosts(block: ReleaseHostsRequest.DslBuilder.() -> Unit) = releaseHosts(ReleaseHostsRequest.builder().apply(block).build())

    /**
     * Replaces an IAM instance profile for the specified running instance. You can use
     * this action to change the IAM instance profile that's associated with an instance
     * without having to disassociate the existing IAM instance profile first.
     * Use DescribeIamInstanceProfileAssociations to get the association
     * ID.
     */
    suspend fun replaceIamInstanceProfileAssociation(input: ReplaceIamInstanceProfileAssociationRequest): ReplaceIamInstanceProfileAssociationResponse

    /**
     * Replaces an IAM instance profile for the specified running instance. You can use
     * this action to change the IAM instance profile that's associated with an instance
     * without having to disassociate the existing IAM instance profile first.
     * Use DescribeIamInstanceProfileAssociations to get the association
     * ID.
     */
    suspend fun replaceIamInstanceProfileAssociation(block: ReplaceIamInstanceProfileAssociationRequest.DslBuilder.() -> Unit) = replaceIamInstanceProfileAssociation(ReplaceIamInstanceProfileAssociationRequest.builder().apply(block).build())

    /**
     * Changes which network ACL a subnet is associated with. By default when you create a
     * subnet, it's automatically associated with the default network ACL. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network
     * ACLs in the Amazon Virtual Private Cloud User Guide.
     * This is an idempotent operation.
     */
    suspend fun replaceNetworkAclAssociation(input: ReplaceNetworkAclAssociationRequest): ReplaceNetworkAclAssociationResponse

    /**
     * Changes which network ACL a subnet is associated with. By default when you create a
     * subnet, it's automatically associated with the default network ACL. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network
     * ACLs in the Amazon Virtual Private Cloud User Guide.
     * This is an idempotent operation.
     */
    suspend fun replaceNetworkAclAssociation(block: ReplaceNetworkAclAssociationRequest.DslBuilder.() -> Unit) = replaceNetworkAclAssociation(ReplaceNetworkAclAssociationRequest.builder().apply(block).build())

    /**
     * Replaces an entry (rule) in a network ACL. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun replaceNetworkAclEntry(input: ReplaceNetworkAclEntryRequest): ReplaceNetworkAclEntryResponse

    /**
     * Replaces an entry (rule) in a network ACL. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun replaceNetworkAclEntry(block: ReplaceNetworkAclEntryRequest.DslBuilder.() -> Unit) = replaceNetworkAclEntry(ReplaceNetworkAclEntryRequest.builder().apply(block).build())

    /**
     * Replaces an existing route within a route table in a VPC. You must provide only one of
     * the following: internet gateway, virtual private gateway, NAT instance, NAT gateway, VPC
     * peering connection, network interface, egress-only internet gateway, or transit
     * gateway.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun replaceRoute(input: ReplaceRouteRequest): ReplaceRouteResponse

    /**
     * Replaces an existing route within a route table in a VPC. You must provide only one of
     * the following: internet gateway, virtual private gateway, NAT instance, NAT gateway, VPC
     * peering connection, network interface, egress-only internet gateway, or transit
     * gateway.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables in the
     * Amazon Virtual Private Cloud User Guide.
     */
    suspend fun replaceRoute(block: ReplaceRouteRequest.DslBuilder.() -> Unit) = replaceRoute(ReplaceRouteRequest.builder().apply(block).build())

    /**
     * Changes the route table associated with a given subnet, internet gateway, or virtual private gateway in a VPC. After the operation
     * completes, the subnet or gateway uses the routes in the new route table. For more
     * information about route tables, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables in the Amazon Virtual Private Cloud User Guide.
     * You can also use this operation to change which table is the main route table in the VPC. Specify the main route table's association ID and the route table ID of the new main route table.
     */
    suspend fun replaceRouteTableAssociation(input: ReplaceRouteTableAssociationRequest): ReplaceRouteTableAssociationResponse

    /**
     * Changes the route table associated with a given subnet, internet gateway, or virtual private gateway in a VPC. After the operation
     * completes, the subnet or gateway uses the routes in the new route table. For more
     * information about route tables, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables in the Amazon Virtual Private Cloud User Guide.
     * You can also use this operation to change which table is the main route table in the VPC. Specify the main route table's association ID and the route table ID of the new main route table.
     */
    suspend fun replaceRouteTableAssociation(block: ReplaceRouteTableAssociationRequest.DslBuilder.() -> Unit) = replaceRouteTableAssociation(ReplaceRouteTableAssociationRequest.builder().apply(block).build())

    /**
     * Replaces the specified route in the specified transit gateway route table.
     */
    suspend fun replaceTransitGatewayRoute(input: ReplaceTransitGatewayRouteRequest): ReplaceTransitGatewayRouteResponse

    /**
     * Replaces the specified route in the specified transit gateway route table.
     */
    suspend fun replaceTransitGatewayRoute(block: ReplaceTransitGatewayRouteRequest.DslBuilder.() -> Unit) = replaceTransitGatewayRoute(ReplaceTransitGatewayRouteRequest.builder().apply(block).build())

    /**
     * Submits feedback about the status of an instance. The instance must be in the
     * running state. If your experience with the instance differs from the
     * instance status returned by DescribeInstanceStatus, use ReportInstanceStatus to report your experience with the instance. Amazon
     * EC2 collects this information to improve the accuracy of status checks.
     * Use of this action does not change the value returned by DescribeInstanceStatus.
     */
    suspend fun reportInstanceStatus(input: ReportInstanceStatusRequest): ReportInstanceStatusResponse

    /**
     * Submits feedback about the status of an instance. The instance must be in the
     * running state. If your experience with the instance differs from the
     * instance status returned by DescribeInstanceStatus, use ReportInstanceStatus to report your experience with the instance. Amazon
     * EC2 collects this information to improve the accuracy of status checks.
     * Use of this action does not change the value returned by DescribeInstanceStatus.
     */
    suspend fun reportInstanceStatus(block: ReportInstanceStatusRequest.DslBuilder.() -> Unit) = reportInstanceStatus(ReportInstanceStatusRequest.builder().apply(block).build())

    /**
     * Creates a Spot Fleet request.
     * The Spot Fleet request specifies the total target capacity and the On-Demand target
     * capacity. Amazon EC2 calculates the difference between the total capacity and On-Demand
     * capacity, and launches the difference as Spot capacity.
     * You can submit a single request that includes multiple launch specifications that vary
     * by instance type, AMI, Availability Zone, or subnet.
     * By default, the Spot Fleet requests Spot Instances in the Spot Instance pool where the
     * price per unit is the lowest. Each launch specification can include its own instance
     * weighting that reflects the value of the instance type to your application
     * workload.
     * Alternatively, you can specify that the Spot Fleet distribute the target capacity
     * across the Spot pools included in its launch specifications. By ensuring that the Spot
     * Instances in your Spot Fleet are in different Spot pools, you can improve the
     * availability of your fleet.
     * You can specify tags for the Spot Fleet request and instances launched by the fleet.
     * You cannot tag other resource types in a Spot Fleet request because only the
     * spot-fleet-request and instance resource types are
     * supported.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html">Spot Fleet requests
     * in the Amazon EC2 User Guide for Linux Instances.
     */
    suspend fun requestSpotFleet(input: RequestSpotFleetRequest): RequestSpotFleetResponse

    /**
     * Creates a Spot Fleet request.
     * The Spot Fleet request specifies the total target capacity and the On-Demand target
     * capacity. Amazon EC2 calculates the difference between the total capacity and On-Demand
     * capacity, and launches the difference as Spot capacity.
     * You can submit a single request that includes multiple launch specifications that vary
     * by instance type, AMI, Availability Zone, or subnet.
     * By default, the Spot Fleet requests Spot Instances in the Spot Instance pool where the
     * price per unit is the lowest. Each launch specification can include its own instance
     * weighting that reflects the value of the instance type to your application
     * workload.
     * Alternatively, you can specify that the Spot Fleet distribute the target capacity
     * across the Spot pools included in its launch specifications. By ensuring that the Spot
     * Instances in your Spot Fleet are in different Spot pools, you can improve the
     * availability of your fleet.
     * You can specify tags for the Spot Fleet request and instances launched by the fleet.
     * You cannot tag other resource types in a Spot Fleet request because only the
     * spot-fleet-request and instance resource types are
     * supported.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html">Spot Fleet requests
     * in the Amazon EC2 User Guide for Linux Instances.
     */
    suspend fun requestSpotFleet(block: RequestSpotFleetRequest.DslBuilder.() -> Unit) = requestSpotFleet(RequestSpotFleetRequest.builder().apply(block).build())

    /**
     * Creates a Spot Instance request.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html">Spot Instance requests in
     * the Amazon EC2 User Guide for Linux Instances.
     */
    suspend fun requestSpotInstances(input: RequestSpotInstancesRequest): RequestSpotInstancesResponse

    /**
     * Creates a Spot Instance request.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html">Spot Instance requests in
     * the Amazon EC2 User Guide for Linux Instances.
     */
    suspend fun requestSpotInstances(block: RequestSpotInstancesRequest.DslBuilder.() -> Unit) = requestSpotInstances(RequestSpotInstancesRequest.builder().apply(block).build())

    /**
     * Resets the attribute of the specified IP address. For requirements, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS">Using reverse DNS for email applications.
     */
    suspend fun resetAddressAttribute(input: ResetAddressAttributeRequest): ResetAddressAttributeResponse

    /**
     * Resets the attribute of the specified IP address. For requirements, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS">Using reverse DNS for email applications.
     */
    suspend fun resetAddressAttribute(block: ResetAddressAttributeRequest.DslBuilder.() -> Unit) = resetAddressAttribute(ResetAddressAttributeRequest.builder().apply(block).build())

    /**
     * Resets the default KMS key for EBS encryption for your account in this Region
     * to the Amazon Web Services managed KMS key for EBS.
     * After resetting the default KMS key to the Amazon Web Services managed KMS key, you can continue to encrypt by a
     * customer managed KMS key by specifying it when you create the volume. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun resetEbsDefaultKmsKeyId(input: ResetEbsDefaultKmsKeyIdRequest): ResetEbsDefaultKmsKeyIdResponse

    /**
     * Resets the default KMS key for EBS encryption for your account in this Region
     * to the Amazon Web Services managed KMS key for EBS.
     * After resetting the default KMS key to the Amazon Web Services managed KMS key, you can continue to encrypt by a
     * customer managed KMS key by specifying it when you create the volume. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption
     * in the Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun resetEbsDefaultKmsKeyId(block: ResetEbsDefaultKmsKeyIdRequest.DslBuilder.() -> Unit) = resetEbsDefaultKmsKeyId(ResetEbsDefaultKmsKeyIdRequest.builder().apply(block).build())

    /**
     * Resets the specified attribute of the specified Amazon FPGA Image (AFI) to its default value.
     * You can only reset the load permission attribute.
     */
    suspend fun resetFpgaImageAttribute(input: ResetFpgaImageAttributeRequest): ResetFpgaImageAttributeResponse

    /**
     * Resets the specified attribute of the specified Amazon FPGA Image (AFI) to its default value.
     * You can only reset the load permission attribute.
     */
    suspend fun resetFpgaImageAttribute(block: ResetFpgaImageAttributeRequest.DslBuilder.() -> Unit) = resetFpgaImageAttribute(ResetFpgaImageAttributeRequest.builder().apply(block).build())

    /**
     * Resets an attribute of an AMI to its default value.
     */
    suspend fun resetImageAttribute(input: ResetImageAttributeRequest): ResetImageAttributeResponse

    /**
     * Resets an attribute of an AMI to its default value.
     */
    suspend fun resetImageAttribute(block: ResetImageAttributeRequest.DslBuilder.() -> Unit) = resetImageAttribute(ResetImageAttributeRequest.builder().apply(block).build())

    /**
     * Resets an attribute of an instance to its default value. To reset the
     * kernel or ramdisk, the instance must be in a stopped
     * state. To reset the sourceDestCheck, the instance can be either running or
     * stopped.
     * The sourceDestCheck attribute controls whether source/destination
     * checking is enabled. The default value is true, which means checking is
     * enabled. This value must be false for a NAT instance to perform NAT. For
     * more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances in the
     * Amazon VPC User Guide.
     */
    suspend fun resetInstanceAttribute(input: ResetInstanceAttributeRequest): ResetInstanceAttributeResponse

    /**
     * Resets an attribute of an instance to its default value. To reset the
     * kernel or ramdisk, the instance must be in a stopped
     * state. To reset the sourceDestCheck, the instance can be either running or
     * stopped.
     * The sourceDestCheck attribute controls whether source/destination
     * checking is enabled. The default value is true, which means checking is
     * enabled. This value must be false for a NAT instance to perform NAT. For
     * more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances in the
     * Amazon VPC User Guide.
     */
    suspend fun resetInstanceAttribute(block: ResetInstanceAttributeRequest.DslBuilder.() -> Unit) = resetInstanceAttribute(ResetInstanceAttributeRequest.builder().apply(block).build())

    /**
     * Resets a network interface attribute. You can specify only one attribute at a time.
     */
    suspend fun resetNetworkInterfaceAttribute(input: ResetNetworkInterfaceAttributeRequest): ResetNetworkInterfaceAttributeResponse

    /**
     * Resets a network interface attribute. You can specify only one attribute at a time.
     */
    suspend fun resetNetworkInterfaceAttribute(block: ResetNetworkInterfaceAttributeRequest.DslBuilder.() -> Unit) = resetNetworkInterfaceAttribute(ResetNetworkInterfaceAttributeRequest.builder().apply(block).build())

    /**
     * Resets permission settings for the specified snapshot.
     * For more information about modifying snapshot permissions, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html">Share a snapshot in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun resetSnapshotAttribute(input: ResetSnapshotAttributeRequest): ResetSnapshotAttributeResponse

    /**
     * Resets permission settings for the specified snapshot.
     * For more information about modifying snapshot permissions, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html">Share a snapshot in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    suspend fun resetSnapshotAttribute(block: ResetSnapshotAttributeRequest.DslBuilder.() -> Unit) = resetSnapshotAttribute(ResetSnapshotAttributeRequest.builder().apply(block).build())

    /**
     * Restores an Elastic IP address that was previously moved to the EC2-VPC platform back to the EC2-Classic platform. You cannot move an Elastic IP address that was originally allocated for use in EC2-VPC. The Elastic IP address must not be associated with an instance or network interface.
     */
    suspend fun restoreAddressToClassic(input: RestoreAddressToClassicRequest): RestoreAddressToClassicResponse

    /**
     * Restores an Elastic IP address that was previously moved to the EC2-VPC platform back to the EC2-Classic platform. You cannot move an Elastic IP address that was originally allocated for use in EC2-VPC. The Elastic IP address must not be associated with an instance or network interface.
     */
    suspend fun restoreAddressToClassic(block: RestoreAddressToClassicRequest.DslBuilder.() -> Unit) = restoreAddressToClassic(RestoreAddressToClassicRequest.builder().apply(block).build())

    /**
     * Restores the entries from a previous version of a managed prefix list to a new version of the prefix list.
     */
    suspend fun restoreManagedPrefixListVersion(input: RestoreManagedPrefixListVersionRequest): RestoreManagedPrefixListVersionResponse

    /**
     * Restores the entries from a previous version of a managed prefix list to a new version of the prefix list.
     */
    suspend fun restoreManagedPrefixListVersion(block: RestoreManagedPrefixListVersionRequest.DslBuilder.() -> Unit) = restoreManagedPrefixListVersion(RestoreManagedPrefixListVersionRequest.builder().apply(block).build())

    /**
     * Removes an ingress authorization rule from a Client VPN endpoint.
     */
    suspend fun revokeClientVpnIngress(input: RevokeClientVpnIngressRequest): RevokeClientVpnIngressResponse

    /**
     * Removes an ingress authorization rule from a Client VPN endpoint.
     */
    suspend fun revokeClientVpnIngress(block: RevokeClientVpnIngressRequest.DslBuilder.() -> Unit) = revokeClientVpnIngress(RevokeClientVpnIngressRequest.builder().apply(block).build())

    /**
     * &#91;VPC only&#93; Removes the specified outbound (egress) rules from a security group for EC2-VPC.
     * This action does not apply to security groups for use in EC2-Classic.
     * You can specify rules using either rule IDs or security group rule properties. If you use
     * rule properties, the values that you specify (for example, ports) must match the existing rule's
     * values exactly. Each rule has a protocol, from and to ports, and destination (CIDR range,
     * security group, or prefix list). For the TCP and UDP protocols, you must also specify the
     * destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type
     * and code. If the security group rule has a description, you do not need to specify the description
     * to revoke the rule.
     * &#91;Default VPC&#93; If the values you specify do not match the existing rule's values, no error is
     * returned, and the output describes the security group rules that were not revoked.
     * Amazon Web Services recommends that you describe the security group to verify that the rules were removed.
     * Rule changes are propagated to instances within the security group as quickly as possible. However,
     * a small delay might occur.
     */
    suspend fun revokeSecurityGroupEgress(input: RevokeSecurityGroupEgressRequest): RevokeSecurityGroupEgressResponse

    /**
     * &#91;VPC only&#93; Removes the specified outbound (egress) rules from a security group for EC2-VPC.
     * This action does not apply to security groups for use in EC2-Classic.
     * You can specify rules using either rule IDs or security group rule properties. If you use
     * rule properties, the values that you specify (for example, ports) must match the existing rule's
     * values exactly. Each rule has a protocol, from and to ports, and destination (CIDR range,
     * security group, or prefix list). For the TCP and UDP protocols, you must also specify the
     * destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type
     * and code. If the security group rule has a description, you do not need to specify the description
     * to revoke the rule.
     * &#91;Default VPC&#93; If the values you specify do not match the existing rule's values, no error is
     * returned, and the output describes the security group rules that were not revoked.
     * Amazon Web Services recommends that you describe the security group to verify that the rules were removed.
     * Rule changes are propagated to instances within the security group as quickly as possible. However,
     * a small delay might occur.
     */
    suspend fun revokeSecurityGroupEgress(block: RevokeSecurityGroupEgressRequest.DslBuilder.() -> Unit) = revokeSecurityGroupEgress(RevokeSecurityGroupEgressRequest.builder().apply(block).build())

    /**
     * Removes the specified inbound (ingress) rules from a security group.
     * You can specify rules using either rule IDs or security group rule properties. If you use
     * rule properties, the values that you specify (for example, ports) must match the existing rule's
     * values exactly. Each rule has a protocol, from and to ports, and source (CIDR range,
     * security group, or prefix list). For the TCP and UDP protocols, you must also specify the
     * destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type
     * and code. If the security group rule has a description, you do not need to specify the description
     * to revoke the rule.
     * &#91;EC2-Classic, default VPC&#93; If the values you specify do not match the existing rule's values, no error is
     * returned, and the output describes the security group rules that were not revoked.
     * Amazon Web Services recommends that you describe the security group to verify that the rules were removed.
     * Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.
     */
    suspend fun revokeSecurityGroupIngress(input: RevokeSecurityGroupIngressRequest): RevokeSecurityGroupIngressResponse

    /**
     * Removes the specified inbound (ingress) rules from a security group.
     * You can specify rules using either rule IDs or security group rule properties. If you use
     * rule properties, the values that you specify (for example, ports) must match the existing rule's
     * values exactly. Each rule has a protocol, from and to ports, and source (CIDR range,
     * security group, or prefix list). For the TCP and UDP protocols, you must also specify the
     * destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type
     * and code. If the security group rule has a description, you do not need to specify the description
     * to revoke the rule.
     * &#91;EC2-Classic, default VPC&#93; If the values you specify do not match the existing rule's values, no error is
     * returned, and the output describes the security group rules that were not revoked.
     * Amazon Web Services recommends that you describe the security group to verify that the rules were removed.
     * Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.
     */
    suspend fun revokeSecurityGroupIngress(block: RevokeSecurityGroupIngressRequest.DslBuilder.() -> Unit) = revokeSecurityGroupIngress(RevokeSecurityGroupIngressRequest.builder().apply(block).build())

    /**
     * Launches the specified number of instances using an AMI for which you have
     * permissions.
     * You can specify a number of options, or leave the default options. The following rules
     * apply:
     * &#91;EC2-VPC&#93; If you don't specify a subnet ID, we choose a default subnet from
     * your default VPC for you. If you don't have a default VPC, you must specify a
     * subnet ID in the request.
     * &#91;EC2-Classic&#93; If don't specify an Availability Zone, we choose one for
     * you.
     * Some instance types must be launched into a VPC. If you do not have a default
     * VPC, or if you do not specify a subnet ID, the request fails. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-vpc.html#vpc-only-instance-types">Instance types available only in a VPC.
     * &#91;EC2-VPC&#93; All instances have a network interface with a primary private IPv4
     * address. If you don't specify this address, we choose one from the IPv4 range of
     * your subnet.
     * Not all instance types support IPv6 addresses. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance
     * types.
     * If you don't specify a security group ID, we use the default security group.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Security
     * groups.
     * If any of the AMIs have a product code attached for which the user has not
     * subscribed, the request fails.
     * You can create a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">launch template,
     * which is a resource that contains the parameters to launch an instance. When you launch
     * an instance using RunInstances, you can specify the launch template
     * instead of specifying the launch parameters.
     * To ensure faster instance launches, break up large requests into smaller batches. For
     * example, create five separate launch requests for 100 instances each instead of one
     * launch request for 500 instances.
     * An instance is ready for you to use when it's in the running state. You
     * can check the state of your instance using DescribeInstances. You can
     * tag instances and EBS volumes during launch, after launch, or both. For more
     * information, see CreateTags and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2
     * resources.
     * Linux instances have access to the public key of the key pair at boot. You can use
     * this key to provide secure access to the instance. Amazon EC2 public images use this
     * feature to provide secure access without passwords. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key
     * pairs.
     * For troubleshooting, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_InstanceStraightToTerminated.html">What to do if
     * an instance immediately terminates, and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesConnecting.html">Troubleshooting connecting to your instance.
     */
    suspend fun runInstances(input: RunInstancesRequest): RunInstancesResponse

    /**
     * Launches the specified number of instances using an AMI for which you have
     * permissions.
     * You can specify a number of options, or leave the default options. The following rules
     * apply:
     * &#91;EC2-VPC&#93; If you don't specify a subnet ID, we choose a default subnet from
     * your default VPC for you. If you don't have a default VPC, you must specify a
     * subnet ID in the request.
     * &#91;EC2-Classic&#93; If don't specify an Availability Zone, we choose one for
     * you.
     * Some instance types must be launched into a VPC. If you do not have a default
     * VPC, or if you do not specify a subnet ID, the request fails. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-vpc.html#vpc-only-instance-types">Instance types available only in a VPC.
     * &#91;EC2-VPC&#93; All instances have a network interface with a primary private IPv4
     * address. If you don't specify this address, we choose one from the IPv4 range of
     * your subnet.
     * Not all instance types support IPv6 addresses. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance
     * types.
     * If you don't specify a security group ID, we use the default security group.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Security
     * groups.
     * If any of the AMIs have a product code attached for which the user has not
     * subscribed, the request fails.
     * You can create a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">launch template,
     * which is a resource that contains the parameters to launch an instance. When you launch
     * an instance using RunInstances, you can specify the launch template
     * instead of specifying the launch parameters.
     * To ensure faster instance launches, break up large requests into smaller batches. For
     * example, create five separate launch requests for 100 instances each instead of one
     * launch request for 500 instances.
     * An instance is ready for you to use when it's in the running state. You
     * can check the state of your instance using DescribeInstances. You can
     * tag instances and EBS volumes during launch, after launch, or both. For more
     * information, see CreateTags and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2
     * resources.
     * Linux instances have access to the public key of the key pair at boot. You can use
     * this key to provide secure access to the instance. Amazon EC2 public images use this
     * feature to provide secure access without passwords. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key
     * pairs.
     * For troubleshooting, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_InstanceStraightToTerminated.html">What to do if
     * an instance immediately terminates, and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesConnecting.html">Troubleshooting connecting to your instance.
     */
    suspend fun runInstances(block: RunInstancesRequest.DslBuilder.() -> Unit) = runInstances(RunInstancesRequest.builder().apply(block).build())

    /**
     * Launches the specified Scheduled Instances.
     * Before you can launch a Scheduled Instance, you must purchase it and obtain an identifier using PurchaseScheduledInstances.
     * You must launch a Scheduled Instance during its scheduled time period. You can't stop or reboot a Scheduled Instance,
     * but you can terminate it as needed. If you terminate a Scheduled Instance before the current scheduled time period ends,
     * you can launch it again after a few minutes. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-scheduled-instances.html">Scheduled Instances
     * in the Amazon EC2 User Guide.
     */
    suspend fun runScheduledInstances(input: RunScheduledInstancesRequest): RunScheduledInstancesResponse

    /**
     * Launches the specified Scheduled Instances.
     * Before you can launch a Scheduled Instance, you must purchase it and obtain an identifier using PurchaseScheduledInstances.
     * You must launch a Scheduled Instance during its scheduled time period. You can't stop or reboot a Scheduled Instance,
     * but you can terminate it as needed. If you terminate a Scheduled Instance before the current scheduled time period ends,
     * you can launch it again after a few minutes. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-scheduled-instances.html">Scheduled Instances
     * in the Amazon EC2 User Guide.
     */
    suspend fun runScheduledInstances(block: RunScheduledInstancesRequest.DslBuilder.() -> Unit) = runScheduledInstances(RunScheduledInstancesRequest.builder().apply(block).build())

    /**
     * Searches for routes in the specified local gateway route table.
     */
    suspend fun searchLocalGatewayRoutes(input: SearchLocalGatewayRoutesRequest): SearchLocalGatewayRoutesResponse

    /**
     * Searches for routes in the specified local gateway route table.
     */
    suspend fun searchLocalGatewayRoutes(block: SearchLocalGatewayRoutesRequest.DslBuilder.() -> Unit) = searchLocalGatewayRoutes(SearchLocalGatewayRoutesRequest.builder().apply(block).build())

    /**
     * Searches one or more  transit gateway multicast groups and returns the group membership information.
     */
    suspend fun searchTransitGatewayMulticastGroups(input: SearchTransitGatewayMulticastGroupsRequest): SearchTransitGatewayMulticastGroupsResponse

    /**
     * Searches one or more  transit gateway multicast groups and returns the group membership information.
     */
    suspend fun searchTransitGatewayMulticastGroups(block: SearchTransitGatewayMulticastGroupsRequest.DslBuilder.() -> Unit) = searchTransitGatewayMulticastGroups(SearchTransitGatewayMulticastGroupsRequest.builder().apply(block).build())

    /**
     * Searches for routes in the specified transit gateway route table.
     */
    suspend fun searchTransitGatewayRoutes(input: SearchTransitGatewayRoutesRequest): SearchTransitGatewayRoutesResponse

    /**
     * Searches for routes in the specified transit gateway route table.
     */
    suspend fun searchTransitGatewayRoutes(block: SearchTransitGatewayRoutesRequest.DslBuilder.() -> Unit) = searchTransitGatewayRoutes(SearchTransitGatewayRoutesRequest.builder().apply(block).build())

    /**
     * Sends a diagnostic interrupt to the specified Amazon EC2 instance to trigger a
     * kernel panic (on Linux instances), or a
     * blue screen/stop error (on Windows
     * instances). For instances based on Intel and AMD processors, the interrupt is
     * received as a non-maskable interrupt (NMI).
     * In general, the operating system crashes and reboots when a kernel panic or stop
     * error is triggered. The operating system can also be configured to perform diagnostic
     * tasks, such as generating a memory dump file, loading a secondary kernel, or
     * obtaining a call trace.
     * Before sending a diagnostic interrupt to your instance, ensure that its operating
     * system is configured to perform the required diagnostic tasks.
     * For more information about configuring your operating system to generate a crash dump
     * when a kernel panic or stop error occurs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/diagnostic-interrupt.html">Send a diagnostic interrupt (Linux instances) or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/diagnostic-interrupt.html">Send a Diagnostic Interrupt (Windows instances).
     */
    suspend fun sendDiagnosticInterrupt(input: SendDiagnosticInterruptRequest): SendDiagnosticInterruptResponse

    /**
     * Sends a diagnostic interrupt to the specified Amazon EC2 instance to trigger a
     * kernel panic (on Linux instances), or a
     * blue screen/stop error (on Windows
     * instances). For instances based on Intel and AMD processors, the interrupt is
     * received as a non-maskable interrupt (NMI).
     * In general, the operating system crashes and reboots when a kernel panic or stop
     * error is triggered. The operating system can also be configured to perform diagnostic
     * tasks, such as generating a memory dump file, loading a secondary kernel, or
     * obtaining a call trace.
     * Before sending a diagnostic interrupt to your instance, ensure that its operating
     * system is configured to perform the required diagnostic tasks.
     * For more information about configuring your operating system to generate a crash dump
     * when a kernel panic or stop error occurs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/diagnostic-interrupt.html">Send a diagnostic interrupt (Linux instances) or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/diagnostic-interrupt.html">Send a Diagnostic Interrupt (Windows instances).
     */
    suspend fun sendDiagnosticInterrupt(block: SendDiagnosticInterruptRequest.DslBuilder.() -> Unit) = sendDiagnosticInterrupt(SendDiagnosticInterruptRequest.builder().apply(block).build())

    /**
     * Starts an Amazon EBS-backed instance that you've previously stopped.
     * Instances that use Amazon EBS volumes as their root devices can be quickly stopped and
     * started. When an instance is stopped, the compute resources are released and you are not
     * billed for instance usage. However, your root partition Amazon EBS volume remains and
     * continues to persist your data, and you are charged for Amazon EBS volume usage. You can
     * restart your instance at any time. Every time you start your instance, Amazon EC2
     * charges a one-minute minimum for instance usage, and thereafter charges per second for
     * instance usage.
     * Before stopping an instance, make sure it is in a state from which it can be
     * restarted. Stopping an instance does not preserve data stored in RAM.
     * Performing this operation on an instance that uses an instance store as its root
     * device returns an error.
     * If you attempt to start a T3 instance with host tenancy and the unlimted
     * CPU credit option, the request fails. The unlimited CPU credit option is not
     * supported on Dedicated Hosts. Before you start the instance, either change its CPU credit
     * option to standard, or change its tenancy to default or dedicated.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html">Stopping instances in the
     * Amazon EC2 User Guide.
     */
    suspend fun startInstances(input: StartInstancesRequest): StartInstancesResponse

    /**
     * Starts an Amazon EBS-backed instance that you've previously stopped.
     * Instances that use Amazon EBS volumes as their root devices can be quickly stopped and
     * started. When an instance is stopped, the compute resources are released and you are not
     * billed for instance usage. However, your root partition Amazon EBS volume remains and
     * continues to persist your data, and you are charged for Amazon EBS volume usage. You can
     * restart your instance at any time. Every time you start your instance, Amazon EC2
     * charges a one-minute minimum for instance usage, and thereafter charges per second for
     * instance usage.
     * Before stopping an instance, make sure it is in a state from which it can be
     * restarted. Stopping an instance does not preserve data stored in RAM.
     * Performing this operation on an instance that uses an instance store as its root
     * device returns an error.
     * If you attempt to start a T3 instance with host tenancy and the unlimted
     * CPU credit option, the request fails. The unlimited CPU credit option is not
     * supported on Dedicated Hosts. Before you start the instance, either change its CPU credit
     * option to standard, or change its tenancy to default or dedicated.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html">Stopping instances in the
     * Amazon EC2 User Guide.
     */
    suspend fun startInstances(block: StartInstancesRequest.DslBuilder.() -> Unit) = startInstances(StartInstancesRequest.builder().apply(block).build())

    /**
     * Starts analyzing the specified path. If the path is reachable, the
     * operation returns the shortest feasible path.
     */
    suspend fun startNetworkInsightsAnalysis(input: StartNetworkInsightsAnalysisRequest): StartNetworkInsightsAnalysisResponse

    /**
     * Starts analyzing the specified path. If the path is reachable, the
     * operation returns the shortest feasible path.
     */
    suspend fun startNetworkInsightsAnalysis(block: StartNetworkInsightsAnalysisRequest.DslBuilder.() -> Unit) = startNetworkInsightsAnalysis(StartNetworkInsightsAnalysisRequest.builder().apply(block).build())

    /**
     * Initiates the verification process to prove that the service provider owns the private
     * DNS name domain for the endpoint service.
     * The service provider must successfully perform the verification before the consumer can use the name to access the service.
     * Before the service provider runs this command, they must add a record to the DNS server. For more information, see  <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html#add-dns-txt-record">Adding a TXT Record to Your Domain's DNS Server  in the Amazon VPC User Guide.
     */
    suspend fun startVpcEndpointServicePrivateDnsVerification(input: StartVpcEndpointServicePrivateDnsVerificationRequest): StartVpcEndpointServicePrivateDnsVerificationResponse

    /**
     * Initiates the verification process to prove that the service provider owns the private
     * DNS name domain for the endpoint service.
     * The service provider must successfully perform the verification before the consumer can use the name to access the service.
     * Before the service provider runs this command, they must add a record to the DNS server. For more information, see  <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html#add-dns-txt-record">Adding a TXT Record to Your Domain's DNS Server  in the Amazon VPC User Guide.
     */
    suspend fun startVpcEndpointServicePrivateDnsVerification(block: StartVpcEndpointServicePrivateDnsVerificationRequest.DslBuilder.() -> Unit) = startVpcEndpointServicePrivateDnsVerification(StartVpcEndpointServicePrivateDnsVerificationRequest.builder().apply(block).build())

    /**
     * Stops an Amazon EBS-backed instance.
     * You can use the Stop action to hibernate an instance if the instance is <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#enabling-hibernation">enabled for
     * hibernation and it meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">hibernation
     * prerequisites. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance in the
     * Amazon EC2 User Guide.
     * We don't charge usage for a stopped instance, or data transfer fees; however, your
     * root partition Amazon EBS volume remains and continues to persist your data, and you are
     * charged for Amazon EBS volume usage. Every time you start your instance, Amazon EC2
     * charges a one-minute minimum for instance usage, and thereafter charges per second for
     * instance usage.
     * You can't stop or hibernate instance store-backed instances. You can't use the Stop
     * action to hibernate Spot Instances, but you can specify that Amazon EC2 should hibernate
     * Spot Instances when they are interrupted. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-interruptions.html#hibernate-spot-instances">Hibernating interrupted Spot Instances in the Amazon EC2 User Guide.
     * When you stop or hibernate an instance, we shut it down. You can restart your instance
     * at any time. Before stopping or hibernating an instance, make sure it is in a state from
     * which it can be restarted. Stopping an instance does not preserve data stored in RAM,
     * but hibernating an instance does preserve data stored in RAM. If an instance cannot
     * hibernate successfully, a normal shutdown occurs.
     * Stopping and hibernating an instance is different to rebooting or terminating it. For
     * example, when you stop or hibernate an instance, the root device and any other devices
     * attached to the instance persist. When you terminate an instance, the root device and
     * any other devices attached during the instance launch are automatically deleted. For
     * more information about the differences between rebooting, stopping, hibernating, and
     * terminating instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance lifecycle
     * in the Amazon EC2 User Guide.
     * When you stop an instance, we attempt to shut it down forcibly after a short while. If
     * your instance appears stuck in the stopping state after a period of time, there may be
     * an issue with the underlying host computer. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesStopping.html">Troubleshooting
     * stopping your instance in the Amazon EC2 User Guide.
     */
    suspend fun stopInstances(input: StopInstancesRequest): StopInstancesResponse

    /**
     * Stops an Amazon EBS-backed instance.
     * You can use the Stop action to hibernate an instance if the instance is <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#enabling-hibernation">enabled for
     * hibernation and it meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">hibernation
     * prerequisites. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance in the
     * Amazon EC2 User Guide.
     * We don't charge usage for a stopped instance, or data transfer fees; however, your
     * root partition Amazon EBS volume remains and continues to persist your data, and you are
     * charged for Amazon EBS volume usage. Every time you start your instance, Amazon EC2
     * charges a one-minute minimum for instance usage, and thereafter charges per second for
     * instance usage.
     * You can't stop or hibernate instance store-backed instances. You can't use the Stop
     * action to hibernate Spot Instances, but you can specify that Amazon EC2 should hibernate
     * Spot Instances when they are interrupted. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-interruptions.html#hibernate-spot-instances">Hibernating interrupted Spot Instances in the Amazon EC2 User Guide.
     * When you stop or hibernate an instance, we shut it down. You can restart your instance
     * at any time. Before stopping or hibernating an instance, make sure it is in a state from
     * which it can be restarted. Stopping an instance does not preserve data stored in RAM,
     * but hibernating an instance does preserve data stored in RAM. If an instance cannot
     * hibernate successfully, a normal shutdown occurs.
     * Stopping and hibernating an instance is different to rebooting or terminating it. For
     * example, when you stop or hibernate an instance, the root device and any other devices
     * attached to the instance persist. When you terminate an instance, the root device and
     * any other devices attached during the instance launch are automatically deleted. For
     * more information about the differences between rebooting, stopping, hibernating, and
     * terminating instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance lifecycle
     * in the Amazon EC2 User Guide.
     * When you stop an instance, we attempt to shut it down forcibly after a short while. If
     * your instance appears stuck in the stopping state after a period of time, there may be
     * an issue with the underlying host computer. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesStopping.html">Troubleshooting
     * stopping your instance in the Amazon EC2 User Guide.
     */
    suspend fun stopInstances(block: StopInstancesRequest.DslBuilder.() -> Unit) = stopInstances(StopInstancesRequest.builder().apply(block).build())

    /**
     * Terminates active Client VPN endpoint connections. This action can be used to terminate a specific client connection, or up to five connections established by a specific user.
     */
    suspend fun terminateClientVpnConnections(input: TerminateClientVpnConnectionsRequest): TerminateClientVpnConnectionsResponse

    /**
     * Terminates active Client VPN endpoint connections. This action can be used to terminate a specific client connection, or up to five connections established by a specific user.
     */
    suspend fun terminateClientVpnConnections(block: TerminateClientVpnConnectionsRequest.DslBuilder.() -> Unit) = terminateClientVpnConnections(TerminateClientVpnConnectionsRequest.builder().apply(block).build())

    /**
     * Shuts down the specified instances. This operation is idempotent; if you terminate an
     * instance more than once, each call succeeds.
     * If you specify multiple instances and the request fails (for example, because of a
     * single incorrect instance ID), none of the instances are terminated.
     * If you terminate multiple instances across multiple Availability Zones, and one or more
     * of the specified instances are enabled for termination protection, the request fails with
     * the following results:
     * The specified instances that are in the same Availability Zone as the protected
     * instance are not terminated.
     * The specified instances that are in different Availability Zones, where no other
     * specified instances are protected, are successfully terminated.
     * For example, say you have the following instances:
     * Instance A: us-east-1a; Not protected
     * Instance B: us-east-1a; Not protected
     * Instance C: us-east-1b; Protected
     * Instance D: us-east-1b; not protected
     * If you attempt to terminate all of these instances in the same request, the request reports
     * failure with the following results:
     * Instance A and Instance B are successfully terminated because none of the specified
     * instances in us-east-1a are enabled for termination protection.
     * Instance C and Instance D fail to terminate because at least one of the specified
     * instances in us-east-1b (Instance C) is enabled for termination protection.
     * Terminated instances remain visible after termination (for approximately one
     * hour).
     * By default, Amazon EC2 deletes all EBS volumes that were attached when the instance
     * launched. Volumes attached after instance launch continue running.
     * You can stop, start, and terminate EBS-backed instances. You can only terminate
     * instance store-backed instances. What happens to an instance differs if you stop it or
     * terminate it. For example, when you stop an instance, the root device and any other
     * devices attached to the instance persist. When you terminate an instance, any attached
     * EBS volumes with the DeleteOnTermination block device mapping parameter set
     * to true are automatically deleted. For more information about the
     * differences between stopping and terminating instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance lifecycle
     * in the Amazon EC2 User Guide.
     * For more information about troubleshooting, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesShuttingDown.html">Troubleshooting terminating your instance in the Amazon EC2 User Guide.
     */
    suspend fun terminateInstances(input: TerminateInstancesRequest): TerminateInstancesResponse

    /**
     * Shuts down the specified instances. This operation is idempotent; if you terminate an
     * instance more than once, each call succeeds.
     * If you specify multiple instances and the request fails (for example, because of a
     * single incorrect instance ID), none of the instances are terminated.
     * If you terminate multiple instances across multiple Availability Zones, and one or more
     * of the specified instances are enabled for termination protection, the request fails with
     * the following results:
     * The specified instances that are in the same Availability Zone as the protected
     * instance are not terminated.
     * The specified instances that are in different Availability Zones, where no other
     * specified instances are protected, are successfully terminated.
     * For example, say you have the following instances:
     * Instance A: us-east-1a; Not protected
     * Instance B: us-east-1a; Not protected
     * Instance C: us-east-1b; Protected
     * Instance D: us-east-1b; not protected
     * If you attempt to terminate all of these instances in the same request, the request reports
     * failure with the following results:
     * Instance A and Instance B are successfully terminated because none of the specified
     * instances in us-east-1a are enabled for termination protection.
     * Instance C and Instance D fail to terminate because at least one of the specified
     * instances in us-east-1b (Instance C) is enabled for termination protection.
     * Terminated instances remain visible after termination (for approximately one
     * hour).
     * By default, Amazon EC2 deletes all EBS volumes that were attached when the instance
     * launched. Volumes attached after instance launch continue running.
     * You can stop, start, and terminate EBS-backed instances. You can only terminate
     * instance store-backed instances. What happens to an instance differs if you stop it or
     * terminate it. For example, when you stop an instance, the root device and any other
     * devices attached to the instance persist. When you terminate an instance, any attached
     * EBS volumes with the DeleteOnTermination block device mapping parameter set
     * to true are automatically deleted. For more information about the
     * differences between stopping and terminating instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance lifecycle
     * in the Amazon EC2 User Guide.
     * For more information about troubleshooting, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesShuttingDown.html">Troubleshooting terminating your instance in the Amazon EC2 User Guide.
     */
    suspend fun terminateInstances(block: TerminateInstancesRequest.DslBuilder.() -> Unit) = terminateInstances(TerminateInstancesRequest.builder().apply(block).build())

    /**
     * Unassigns one or more IPv6 addresses IPv4 Prefix Delegation prefixes from a network interface.
     */
    suspend fun unassignIpv6Addresses(input: UnassignIpv6AddressesRequest): UnassignIpv6AddressesResponse

    /**
     * Unassigns one or more IPv6 addresses IPv4 Prefix Delegation prefixes from a network interface.
     */
    suspend fun unassignIpv6Addresses(block: UnassignIpv6AddressesRequest.DslBuilder.() -> Unit) = unassignIpv6Addresses(UnassignIpv6AddressesRequest.builder().apply(block).build())

    /**
     * Unassigns one or more secondary private IP addresses, or IPv4 Prefix Delegation prefixes from a network interface.
     */
    suspend fun unassignPrivateIpAddresses(input: UnassignPrivateIpAddressesRequest): UnassignPrivateIpAddressesResponse

    /**
     * Unassigns one or more secondary private IP addresses, or IPv4 Prefix Delegation prefixes from a network interface.
     */
    suspend fun unassignPrivateIpAddresses(block: UnassignPrivateIpAddressesRequest.DslBuilder.() -> Unit) = unassignPrivateIpAddresses(UnassignPrivateIpAddressesRequest.builder().apply(block).build())

    /**
     * Disables detailed monitoring for a running instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html">Monitoring
     * your instances and volumes in the Amazon EC2 User Guide.
     */
    suspend fun unmonitorInstances(input: UnmonitorInstancesRequest): UnmonitorInstancesResponse

    /**
     * Disables detailed monitoring for a running instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html">Monitoring
     * your instances and volumes in the Amazon EC2 User Guide.
     */
    suspend fun unmonitorInstances(block: UnmonitorInstancesRequest.DslBuilder.() -> Unit) = unmonitorInstances(UnmonitorInstancesRequest.builder().apply(block).build())

    /**
     * &#91;VPC only&#93; Updates the description of an egress (outbound) security group rule. You
     * can replace an existing description, or add a description to a rule that did not have one
     * previously. You can remove a description for a security group rule by omitting the
     * description parameter in the request.
     */
    suspend fun updateSecurityGroupRuleDescriptionsEgress(input: UpdateSecurityGroupRuleDescriptionsEgressRequest): UpdateSecurityGroupRuleDescriptionsEgressResponse

    /**
     * &#91;VPC only&#93; Updates the description of an egress (outbound) security group rule. You
     * can replace an existing description, or add a description to a rule that did not have one
     * previously. You can remove a description for a security group rule by omitting the
     * description parameter in the request.
     */
    suspend fun updateSecurityGroupRuleDescriptionsEgress(block: UpdateSecurityGroupRuleDescriptionsEgressRequest.DslBuilder.() -> Unit) = updateSecurityGroupRuleDescriptionsEgress(UpdateSecurityGroupRuleDescriptionsEgressRequest.builder().apply(block).build())

    /**
     * Updates the description of an ingress (inbound) security group rule. You can replace an
     * existing description, or add a description to a rule that did not have one previously.
     * You can remove a description for a security group rule by omitting the description
     * parameter in the request.
     */
    suspend fun updateSecurityGroupRuleDescriptionsIngress(input: UpdateSecurityGroupRuleDescriptionsIngressRequest): UpdateSecurityGroupRuleDescriptionsIngressResponse

    /**
     * Updates the description of an ingress (inbound) security group rule. You can replace an
     * existing description, or add a description to a rule that did not have one previously.
     * You can remove a description for a security group rule by omitting the description
     * parameter in the request.
     */
    suspend fun updateSecurityGroupRuleDescriptionsIngress(block: UpdateSecurityGroupRuleDescriptionsIngressRequest.DslBuilder.() -> Unit) = updateSecurityGroupRuleDescriptionsIngress(UpdateSecurityGroupRuleDescriptionsIngressRequest.builder().apply(block).build())

    /**
     * Stops advertising an address range that is provisioned as an address pool.
     * You can perform this operation at most once every 10 seconds, even if you specify different
     * address ranges each time.
     * It can take a few minutes before traffic to the specified addresses stops routing to Amazon Web Services
     * because of BGP propagation delays.
     */
    suspend fun withdrawByoipCidr(input: WithdrawByoipCidrRequest): WithdrawByoipCidrResponse

    /**
     * Stops advertising an address range that is provisioned as an address pool.
     * You can perform this operation at most once every 10 seconds, even if you specify different
     * address ranges each time.
     * It can take a few minutes before traffic to the specified addresses stops routing to Amazon Web Services
     * because of BGP propagation delays.
     */
    suspend fun withdrawByoipCidr(block: WithdrawByoipCidrRequest.DslBuilder.() -> Unit) = withdrawByoipCidr(WithdrawByoipCidrRequest.builder().apply(block).build())
}
