// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a running instance in a Spot Fleet.
 */
class ActiveInstance private constructor(builder: BuilderImpl) {
    /**
     * The health status of the instance. If the status of either the instance status check
     * or the system status check is impaired, the health status of the instance
     * is unhealthy. Otherwise, the health status is healthy.
     */
    val instanceHealth: InstanceHealthStatus? = builder.instanceHealth
    /**
     * The ID of the instance.
     */
    val instanceId: String? = builder.instanceId
    /**
     * The instance type.
     */
    val instanceType: String? = builder.instanceType
    /**
     * The ID of the Spot Instance request.
     */
    val spotInstanceRequestId: String? = builder.spotInstanceRequestId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ActiveInstance = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ActiveInstance(")
        append("instanceHealth=$instanceHealth,")
        append("instanceId=$instanceId,")
        append("instanceType=$instanceType,")
        append("spotInstanceRequestId=$spotInstanceRequestId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceHealth?.hashCode() ?: 0
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (spotInstanceRequestId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ActiveInstance

        if (instanceHealth != other.instanceHealth) return false
        if (instanceId != other.instanceId) return false
        if (instanceType != other.instanceType) return false
        if (spotInstanceRequestId != other.spotInstanceRequestId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ActiveInstance = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ActiveInstance
        /**
         * The health status of the instance. If the status of either the instance status check
         * or the system status check is impaired, the health status of the instance
         * is unhealthy. Otherwise, the health status is healthy.
         */
        fun instanceHealth(instanceHealth: InstanceHealthStatus): FluentBuilder
        /**
         * The ID of the instance.
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * The instance type.
         */
        fun instanceType(instanceType: String): FluentBuilder
        /**
         * The ID of the Spot Instance request.
         */
        fun spotInstanceRequestId(spotInstanceRequestId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The health status of the instance. If the status of either the instance status check
         * or the system status check is impaired, the health status of the instance
         * is unhealthy. Otherwise, the health status is healthy.
         */
        var instanceHealth: InstanceHealthStatus?
        /**
         * The ID of the instance.
         */
        var instanceId: String?
        /**
         * The instance type.
         */
        var instanceType: String?
        /**
         * The ID of the Spot Instance request.
         */
        var spotInstanceRequestId: String?

        fun build(): ActiveInstance
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var instanceHealth: InstanceHealthStatus? = null
        override var instanceId: String? = null
        override var instanceType: String? = null
        override var spotInstanceRequestId: String? = null

        constructor(x: ActiveInstance) : this() {
            this.instanceHealth = x.instanceHealth
            this.instanceId = x.instanceId
            this.instanceType = x.instanceType
            this.spotInstanceRequestId = x.spotInstanceRequestId
        }

        override fun build(): ActiveInstance = ActiveInstance(this)
        override fun instanceHealth(instanceHealth: InstanceHealthStatus): FluentBuilder = apply { this.instanceHealth = instanceHealth }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun instanceType(instanceType: String): FluentBuilder = apply { this.instanceType = instanceType }
        override fun spotInstanceRequestId(spotInstanceRequestId: String): FluentBuilder = apply { this.spotInstanceRequestId = spotInstanceRequestId }
    }
}
