// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an Elastic IP address, or a carrier IP address.
 */
class Address private constructor(builder: BuilderImpl) {
    /**
     * The ID representing the allocation of the address for use with EC2-VPC.
     */
    val allocationId: String? = builder.allocationId
    /**
     * The ID representing the association of the address with an instance in a VPC.
     */
    val associationId: String? = builder.associationId
    /**
     * The carrier IP address associated. This option is only available for network interfaces
     * which  reside in a subnet in a Wavelength Zone (for example an EC2 instance).
     */
    val carrierIp: String? = builder.carrierIp
    /**
     * The customer-owned IP address.
     */
    val customerOwnedIp: String? = builder.customerOwnedIp
    /**
     * The ID of the customer-owned address pool.
     */
    val customerOwnedIpv4Pool: String? = builder.customerOwnedIpv4Pool
    /**
     * Indicates whether this Elastic IP address is for use with instances
     * in EC2-Classic (standard) or instances in a VPC (vpc).
     */
    val domain: DomainType? = builder.domain
    /**
     * The ID of the instance that the address is associated with (if any).
     */
    val instanceId: String? = builder.instanceId
    /**
     * The name of the unique set of Availability Zones, Local Zones, or Wavelength Zones from
     * which Amazon Web Services advertises IP addresses.
     */
    val networkBorderGroup: String? = builder.networkBorderGroup
    /**
     * The ID of the network interface.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * The ID of the Amazon Web Services account that owns the network interface.
     */
    val networkInterfaceOwnerId: String? = builder.networkInterfaceOwnerId
    /**
     * The private IP address associated with the Elastic IP address.
     */
    val privateIpAddress: String? = builder.privateIpAddress
    /**
     * The Elastic IP address.
     */
    val publicIp: String? = builder.publicIp
    /**
     * The ID of an address pool.
     */
    val publicIpv4Pool: String? = builder.publicIpv4Pool
    /**
     * Any tags assigned to the Elastic IP address.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Address = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Address(")
        append("allocationId=$allocationId,")
        append("associationId=$associationId,")
        append("carrierIp=$carrierIp,")
        append("customerOwnedIp=$customerOwnedIp,")
        append("customerOwnedIpv4Pool=$customerOwnedIpv4Pool,")
        append("domain=$domain,")
        append("instanceId=$instanceId,")
        append("networkBorderGroup=$networkBorderGroup,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("networkInterfaceOwnerId=$networkInterfaceOwnerId,")
        append("privateIpAddress=$privateIpAddress,")
        append("publicIp=$publicIp,")
        append("publicIpv4Pool=$publicIpv4Pool,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationId?.hashCode() ?: 0
        result = 31 * result + (associationId?.hashCode() ?: 0)
        result = 31 * result + (carrierIp?.hashCode() ?: 0)
        result = 31 * result + (customerOwnedIp?.hashCode() ?: 0)
        result = 31 * result + (customerOwnedIpv4Pool?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (networkBorderGroup?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceOwnerId?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (publicIp?.hashCode() ?: 0)
        result = 31 * result + (publicIpv4Pool?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Address

        if (allocationId != other.allocationId) return false
        if (associationId != other.associationId) return false
        if (carrierIp != other.carrierIp) return false
        if (customerOwnedIp != other.customerOwnedIp) return false
        if (customerOwnedIpv4Pool != other.customerOwnedIpv4Pool) return false
        if (domain != other.domain) return false
        if (instanceId != other.instanceId) return false
        if (networkBorderGroup != other.networkBorderGroup) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (networkInterfaceOwnerId != other.networkInterfaceOwnerId) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (publicIp != other.publicIp) return false
        if (publicIpv4Pool != other.publicIpv4Pool) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Address = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Address
        /**
         * The ID representing the allocation of the address for use with EC2-VPC.
         */
        fun allocationId(allocationId: String): FluentBuilder
        /**
         * The ID representing the association of the address with an instance in a VPC.
         */
        fun associationId(associationId: String): FluentBuilder
        /**
         * The carrier IP address associated. This option is only available for network interfaces
         * which  reside in a subnet in a Wavelength Zone (for example an EC2 instance).
         */
        fun carrierIp(carrierIp: String): FluentBuilder
        /**
         * The customer-owned IP address.
         */
        fun customerOwnedIp(customerOwnedIp: String): FluentBuilder
        /**
         * The ID of the customer-owned address pool.
         */
        fun customerOwnedIpv4Pool(customerOwnedIpv4Pool: String): FluentBuilder
        /**
         * Indicates whether this Elastic IP address is for use with instances
         * in EC2-Classic (standard) or instances in a VPC (vpc).
         */
        fun domain(domain: DomainType): FluentBuilder
        /**
         * The ID of the instance that the address is associated with (if any).
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * The name of the unique set of Availability Zones, Local Zones, or Wavelength Zones from
         * which Amazon Web Services advertises IP addresses.
         */
        fun networkBorderGroup(networkBorderGroup: String): FluentBuilder
        /**
         * The ID of the network interface.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the network interface.
         */
        fun networkInterfaceOwnerId(networkInterfaceOwnerId: String): FluentBuilder
        /**
         * The private IP address associated with the Elastic IP address.
         */
        fun privateIpAddress(privateIpAddress: String): FluentBuilder
        /**
         * The Elastic IP address.
         */
        fun publicIp(publicIp: String): FluentBuilder
        /**
         * The ID of an address pool.
         */
        fun publicIpv4Pool(publicIpv4Pool: String): FluentBuilder
        /**
         * Any tags assigned to the Elastic IP address.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID representing the allocation of the address for use with EC2-VPC.
         */
        var allocationId: String?
        /**
         * The ID representing the association of the address with an instance in a VPC.
         */
        var associationId: String?
        /**
         * The carrier IP address associated. This option is only available for network interfaces
         * which  reside in a subnet in a Wavelength Zone (for example an EC2 instance).
         */
        var carrierIp: String?
        /**
         * The customer-owned IP address.
         */
        var customerOwnedIp: String?
        /**
         * The ID of the customer-owned address pool.
         */
        var customerOwnedIpv4Pool: String?
        /**
         * Indicates whether this Elastic IP address is for use with instances
         * in EC2-Classic (standard) or instances in a VPC (vpc).
         */
        var domain: DomainType?
        /**
         * The ID of the instance that the address is associated with (if any).
         */
        var instanceId: String?
        /**
         * The name of the unique set of Availability Zones, Local Zones, or Wavelength Zones from
         * which Amazon Web Services advertises IP addresses.
         */
        var networkBorderGroup: String?
        /**
         * The ID of the network interface.
         */
        var networkInterfaceId: String?
        /**
         * The ID of the Amazon Web Services account that owns the network interface.
         */
        var networkInterfaceOwnerId: String?
        /**
         * The private IP address associated with the Elastic IP address.
         */
        var privateIpAddress: String?
        /**
         * The Elastic IP address.
         */
        var publicIp: String?
        /**
         * The ID of an address pool.
         */
        var publicIpv4Pool: String?
        /**
         * Any tags assigned to the Elastic IP address.
         */
        var tags: List<Tag>?

        fun build(): Address
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allocationId: String? = null
        override var associationId: String? = null
        override var carrierIp: String? = null
        override var customerOwnedIp: String? = null
        override var customerOwnedIpv4Pool: String? = null
        override var domain: DomainType? = null
        override var instanceId: String? = null
        override var networkBorderGroup: String? = null
        override var networkInterfaceId: String? = null
        override var networkInterfaceOwnerId: String? = null
        override var privateIpAddress: String? = null
        override var publicIp: String? = null
        override var publicIpv4Pool: String? = null
        override var tags: List<Tag>? = null

        constructor(x: Address) : this() {
            this.allocationId = x.allocationId
            this.associationId = x.associationId
            this.carrierIp = x.carrierIp
            this.customerOwnedIp = x.customerOwnedIp
            this.customerOwnedIpv4Pool = x.customerOwnedIpv4Pool
            this.domain = x.domain
            this.instanceId = x.instanceId
            this.networkBorderGroup = x.networkBorderGroup
            this.networkInterfaceId = x.networkInterfaceId
            this.networkInterfaceOwnerId = x.networkInterfaceOwnerId
            this.privateIpAddress = x.privateIpAddress
            this.publicIp = x.publicIp
            this.publicIpv4Pool = x.publicIpv4Pool
            this.tags = x.tags
        }

        override fun build(): Address = Address(this)
        override fun allocationId(allocationId: String): FluentBuilder = apply { this.allocationId = allocationId }
        override fun associationId(associationId: String): FluentBuilder = apply { this.associationId = associationId }
        override fun carrierIp(carrierIp: String): FluentBuilder = apply { this.carrierIp = carrierIp }
        override fun customerOwnedIp(customerOwnedIp: String): FluentBuilder = apply { this.customerOwnedIp = customerOwnedIp }
        override fun customerOwnedIpv4Pool(customerOwnedIpv4Pool: String): FluentBuilder = apply { this.customerOwnedIpv4Pool = customerOwnedIpv4Pool }
        override fun domain(domain: DomainType): FluentBuilder = apply { this.domain = domain }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun networkBorderGroup(networkBorderGroup: String): FluentBuilder = apply { this.networkBorderGroup = networkBorderGroup }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun networkInterfaceOwnerId(networkInterfaceOwnerId: String): FluentBuilder = apply { this.networkInterfaceOwnerId = networkInterfaceOwnerId }
        override fun privateIpAddress(privateIpAddress: String): FluentBuilder = apply { this.privateIpAddress = privateIpAddress }
        override fun publicIp(publicIp: String): FluentBuilder = apply { this.publicIp = publicIp }
        override fun publicIpv4Pool(publicIpv4Pool: String): FluentBuilder = apply { this.publicIpv4Pool = publicIpv4Pool }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
