// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class AllocateAddressResponse private constructor(builder: BuilderImpl) {
    /**
     * &#91;EC2-VPC&#93; The ID that Amazon Web Services assigns to represent the allocation of the Elastic IP address for use with instances in a VPC.
     */
    val allocationId: String? = builder.allocationId
    /**
     * The carrier IP address. This option is only available for network interfaces which  reside
     * in a subnet in a Wavelength Zone (for example an EC2 instance).
     */
    val carrierIp: String? = builder.carrierIp
    /**
     * The customer-owned IP address.
     */
    val customerOwnedIp: String? = builder.customerOwnedIp
    /**
     * The ID of the customer-owned address pool.
     */
    val customerOwnedIpv4Pool: String? = builder.customerOwnedIpv4Pool
    /**
     * Indicates whether the Elastic IP address is for use with instances in a VPC (vpc) or
     * instances in EC2-Classic (standard).
     */
    val domain: DomainType? = builder.domain
    /**
     * The set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises
     * IP addresses.
     */
    val networkBorderGroup: String? = builder.networkBorderGroup
    /**
     * The Elastic IP address.
     */
    val publicIp: String? = builder.publicIp
    /**
     * The ID of an address pool.
     */
    val publicIpv4Pool: String? = builder.publicIpv4Pool

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AllocateAddressResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AllocateAddressResponse(")
        append("allocationId=$allocationId,")
        append("carrierIp=$carrierIp,")
        append("customerOwnedIp=$customerOwnedIp,")
        append("customerOwnedIpv4Pool=$customerOwnedIpv4Pool,")
        append("domain=$domain,")
        append("networkBorderGroup=$networkBorderGroup,")
        append("publicIp=$publicIp,")
        append("publicIpv4Pool=$publicIpv4Pool)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationId?.hashCode() ?: 0
        result = 31 * result + (carrierIp?.hashCode() ?: 0)
        result = 31 * result + (customerOwnedIp?.hashCode() ?: 0)
        result = 31 * result + (customerOwnedIpv4Pool?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (networkBorderGroup?.hashCode() ?: 0)
        result = 31 * result + (publicIp?.hashCode() ?: 0)
        result = 31 * result + (publicIpv4Pool?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AllocateAddressResponse

        if (allocationId != other.allocationId) return false
        if (carrierIp != other.carrierIp) return false
        if (customerOwnedIp != other.customerOwnedIp) return false
        if (customerOwnedIpv4Pool != other.customerOwnedIpv4Pool) return false
        if (domain != other.domain) return false
        if (networkBorderGroup != other.networkBorderGroup) return false
        if (publicIp != other.publicIp) return false
        if (publicIpv4Pool != other.publicIpv4Pool) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AllocateAddressResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AllocateAddressResponse
        /**
         * &#91;EC2-VPC&#93; The ID that Amazon Web Services assigns to represent the allocation of the Elastic IP address for use with instances in a VPC.
         */
        fun allocationId(allocationId: String): FluentBuilder
        /**
         * The carrier IP address. This option is only available for network interfaces which  reside
         * in a subnet in a Wavelength Zone (for example an EC2 instance).
         */
        fun carrierIp(carrierIp: String): FluentBuilder
        /**
         * The customer-owned IP address.
         */
        fun customerOwnedIp(customerOwnedIp: String): FluentBuilder
        /**
         * The ID of the customer-owned address pool.
         */
        fun customerOwnedIpv4Pool(customerOwnedIpv4Pool: String): FluentBuilder
        /**
         * Indicates whether the Elastic IP address is for use with instances in a VPC (vpc) or
         * instances in EC2-Classic (standard).
         */
        fun domain(domain: DomainType): FluentBuilder
        /**
         * The set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises
         * IP addresses.
         */
        fun networkBorderGroup(networkBorderGroup: String): FluentBuilder
        /**
         * The Elastic IP address.
         */
        fun publicIp(publicIp: String): FluentBuilder
        /**
         * The ID of an address pool.
         */
        fun publicIpv4Pool(publicIpv4Pool: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * &#91;EC2-VPC&#93; The ID that Amazon Web Services assigns to represent the allocation of the Elastic IP address for use with instances in a VPC.
         */
        var allocationId: String?
        /**
         * The carrier IP address. This option is only available for network interfaces which  reside
         * in a subnet in a Wavelength Zone (for example an EC2 instance).
         */
        var carrierIp: String?
        /**
         * The customer-owned IP address.
         */
        var customerOwnedIp: String?
        /**
         * The ID of the customer-owned address pool.
         */
        var customerOwnedIpv4Pool: String?
        /**
         * Indicates whether the Elastic IP address is for use with instances in a VPC (vpc) or
         * instances in EC2-Classic (standard).
         */
        var domain: DomainType?
        /**
         * The set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises
         * IP addresses.
         */
        var networkBorderGroup: String?
        /**
         * The Elastic IP address.
         */
        var publicIp: String?
        /**
         * The ID of an address pool.
         */
        var publicIpv4Pool: String?

        fun build(): AllocateAddressResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allocationId: String? = null
        override var carrierIp: String? = null
        override var customerOwnedIp: String? = null
        override var customerOwnedIpv4Pool: String? = null
        override var domain: DomainType? = null
        override var networkBorderGroup: String? = null
        override var publicIp: String? = null
        override var publicIpv4Pool: String? = null

        constructor(x: AllocateAddressResponse) : this() {
            this.allocationId = x.allocationId
            this.carrierIp = x.carrierIp
            this.customerOwnedIp = x.customerOwnedIp
            this.customerOwnedIpv4Pool = x.customerOwnedIpv4Pool
            this.domain = x.domain
            this.networkBorderGroup = x.networkBorderGroup
            this.publicIp = x.publicIp
            this.publicIpv4Pool = x.publicIpv4Pool
        }

        override fun build(): AllocateAddressResponse = AllocateAddressResponse(this)
        override fun allocationId(allocationId: String): FluentBuilder = apply { this.allocationId = allocationId }
        override fun carrierIp(carrierIp: String): FluentBuilder = apply { this.carrierIp = carrierIp }
        override fun customerOwnedIp(customerOwnedIp: String): FluentBuilder = apply { this.customerOwnedIp = customerOwnedIp }
        override fun customerOwnedIpv4Pool(customerOwnedIpv4Pool: String): FluentBuilder = apply { this.customerOwnedIpv4Pool = customerOwnedIpv4Pool }
        override fun domain(domain: DomainType): FluentBuilder = apply { this.domain = domain }
        override fun networkBorderGroup(networkBorderGroup: String): FluentBuilder = apply { this.networkBorderGroup = networkBorderGroup }
        override fun publicIp(publicIp: String): FluentBuilder = apply { this.publicIp = publicIp }
        override fun publicIpv4Pool(publicIpv4Pool: String): FluentBuilder = apply { this.publicIpv4Pool = publicIpv4Pool }
    }
}
