// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class AllocateHostsRequest private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether the host accepts any untargeted instance launches that
     * match its instance type configuration, or if it only accepts Host tenancy
     * instance launches that specify its unique host ID. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding">
     * Understanding auto-placement and affinity in the Amazon EC2 User Guide.
     * Default: on
     */
    val autoPlacement: AutoPlacement? = builder.autoPlacement
    /**
     * The Availability Zone in which to allocate the Dedicated Host.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Indicates whether to enable or disable host recovery for the Dedicated Host.
     * Host recovery is disabled by default. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html">
     * Host recovery in the Amazon EC2 User Guide.
     * Default: off
     */
    val hostRecovery: HostRecovery? = builder.hostRecovery
    /**
     * Specifies the instance family to be supported by the Dedicated Hosts. If you specify
     * an instance family, the Dedicated Hosts support multiple instance types within that
     * instance family.
     * If you want the Dedicated Hosts to support a specific instance type only, omit this
     * parameter and specify InstanceType
     * instead. You cannot specify InstanceFamily and
     * InstanceType in the same request.
     */
    val instanceFamily: String? = builder.instanceFamily
    /**
     * Specifies the instance type to be supported by the Dedicated Hosts. If you
     * specify an instance type, the Dedicated Hosts support instances of the
     * specified instance type only.
     * If you want the Dedicated Hosts to support multiple instance types in a specific
     * instance family, omit this parameter and specify InstanceFamily
     * instead. You cannot specify InstanceType and
     * InstanceFamily in the same request.
     */
    val instanceType: String? = builder.instanceType
    /**
     * The number of Dedicated Hosts to allocate to your account with these parameters.
     */
    val quantity: Int? = builder.quantity
    /**
     * The tags to apply to the Dedicated Host during creation.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AllocateHostsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AllocateHostsRequest(")
        append("autoPlacement=$autoPlacement,")
        append("availabilityZone=$availabilityZone,")
        append("clientToken=$clientToken,")
        append("hostRecovery=$hostRecovery,")
        append("instanceFamily=$instanceFamily,")
        append("instanceType=$instanceType,")
        append("quantity=$quantity,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoPlacement?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (hostRecovery?.hashCode() ?: 0)
        result = 31 * result + (instanceFamily?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (quantity ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AllocateHostsRequest

        if (autoPlacement != other.autoPlacement) return false
        if (availabilityZone != other.availabilityZone) return false
        if (clientToken != other.clientToken) return false
        if (hostRecovery != other.hostRecovery) return false
        if (instanceFamily != other.instanceFamily) return false
        if (instanceType != other.instanceType) return false
        if (quantity != other.quantity) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AllocateHostsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AllocateHostsRequest
        /**
         * Indicates whether the host accepts any untargeted instance launches that
         * match its instance type configuration, or if it only accepts Host tenancy
         * instance launches that specify its unique host ID. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding">
         * Understanding auto-placement and affinity in the Amazon EC2 User Guide.
         * Default: on
         */
        fun autoPlacement(autoPlacement: AutoPlacement): FluentBuilder
        /**
         * The Availability Zone in which to allocate the Dedicated Host.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Indicates whether to enable or disable host recovery for the Dedicated Host.
         * Host recovery is disabled by default. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html">
         * Host recovery in the Amazon EC2 User Guide.
         * Default: off
         */
        fun hostRecovery(hostRecovery: HostRecovery): FluentBuilder
        /**
         * Specifies the instance family to be supported by the Dedicated Hosts. If you specify
         * an instance family, the Dedicated Hosts support multiple instance types within that
         * instance family.
         * If you want the Dedicated Hosts to support a specific instance type only, omit this
         * parameter and specify InstanceType
         * instead. You cannot specify InstanceFamily and
         * InstanceType in the same request.
         */
        fun instanceFamily(instanceFamily: String): FluentBuilder
        /**
         * Specifies the instance type to be supported by the Dedicated Hosts. If you
         * specify an instance type, the Dedicated Hosts support instances of the
         * specified instance type only.
         * If you want the Dedicated Hosts to support multiple instance types in a specific
         * instance family, omit this parameter and specify InstanceFamily
         * instead. You cannot specify InstanceType and
         * InstanceFamily in the same request.
         */
        fun instanceType(instanceType: String): FluentBuilder
        /**
         * The number of Dedicated Hosts to allocate to your account with these parameters.
         */
        fun quantity(quantity: Int): FluentBuilder
        /**
         * The tags to apply to the Dedicated Host during creation.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether the host accepts any untargeted instance launches that
         * match its instance type configuration, or if it only accepts Host tenancy
         * instance launches that specify its unique host ID. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding">
         * Understanding auto-placement and affinity in the Amazon EC2 User Guide.
         * Default: on
         */
        var autoPlacement: AutoPlacement?
        /**
         * The Availability Zone in which to allocate the Dedicated Host.
         */
        var availabilityZone: String?
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency.
         */
        var clientToken: String?
        /**
         * Indicates whether to enable or disable host recovery for the Dedicated Host.
         * Host recovery is disabled by default. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html">
         * Host recovery in the Amazon EC2 User Guide.
         * Default: off
         */
        var hostRecovery: HostRecovery?
        /**
         * Specifies the instance family to be supported by the Dedicated Hosts. If you specify
         * an instance family, the Dedicated Hosts support multiple instance types within that
         * instance family.
         * If you want the Dedicated Hosts to support a specific instance type only, omit this
         * parameter and specify InstanceType
         * instead. You cannot specify InstanceFamily and
         * InstanceType in the same request.
         */
        var instanceFamily: String?
        /**
         * Specifies the instance type to be supported by the Dedicated Hosts. If you
         * specify an instance type, the Dedicated Hosts support instances of the
         * specified instance type only.
         * If you want the Dedicated Hosts to support multiple instance types in a specific
         * instance family, omit this parameter and specify InstanceFamily
         * instead. You cannot specify InstanceType and
         * InstanceFamily in the same request.
         */
        var instanceType: String?
        /**
         * The number of Dedicated Hosts to allocate to your account with these parameters.
         */
        var quantity: Int?
        /**
         * The tags to apply to the Dedicated Host during creation.
         */
        var tagSpecifications: List<TagSpecification>?

        fun build(): AllocateHostsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var autoPlacement: AutoPlacement? = null
        override var availabilityZone: String? = null
        override var clientToken: String? = null
        override var hostRecovery: HostRecovery? = null
        override var instanceFamily: String? = null
        override var instanceType: String? = null
        override var quantity: Int? = null
        override var tagSpecifications: List<TagSpecification>? = null

        constructor(x: AllocateHostsRequest) : this() {
            this.autoPlacement = x.autoPlacement
            this.availabilityZone = x.availabilityZone
            this.clientToken = x.clientToken
            this.hostRecovery = x.hostRecovery
            this.instanceFamily = x.instanceFamily
            this.instanceType = x.instanceType
            this.quantity = x.quantity
            this.tagSpecifications = x.tagSpecifications
        }

        override fun build(): AllocateHostsRequest = AllocateHostsRequest(this)
        override fun autoPlacement(autoPlacement: AutoPlacement): FluentBuilder = apply { this.autoPlacement = autoPlacement }
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun hostRecovery(hostRecovery: HostRecovery): FluentBuilder = apply { this.hostRecovery = hostRecovery }
        override fun instanceFamily(instanceFamily: String): FluentBuilder = apply { this.instanceFamily = instanceFamily }
        override fun instanceType(instanceType: String): FluentBuilder = apply { this.instanceType = instanceType }
        override fun quantity(quantity: Int): FluentBuilder = apply { this.quantity = quantity }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
    }
}
