// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a network access control (ACL) rule.
 */
class AnalysisAclRule private constructor(builder: BuilderImpl) {
    /**
     * The IPv4 address range, in CIDR notation.
     */
    val cidr: String? = builder.cidr
    /**
     * Indicates whether the rule is an outbound rule.
     */
    val egress: Boolean? = builder.egress
    /**
     * The range of ports.
     */
    val portRange: PortRange? = builder.portRange
    /**
     * The protocol.
     */
    val protocol: String? = builder.protocol
    /**
     * Indicates whether to allow or deny traffic that matches the rule.
     */
    val ruleAction: String? = builder.ruleAction
    /**
     * The rule number.
     */
    val ruleNumber: Int? = builder.ruleNumber

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AnalysisAclRule = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AnalysisAclRule(")
        append("cidr=$cidr,")
        append("egress=$egress,")
        append("portRange=$portRange,")
        append("protocol=$protocol,")
        append("ruleAction=$ruleAction,")
        append("ruleNumber=$ruleNumber)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidr?.hashCode() ?: 0
        result = 31 * result + (egress?.hashCode() ?: 0)
        result = 31 * result + (portRange?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (ruleAction?.hashCode() ?: 0)
        result = 31 * result + (ruleNumber ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AnalysisAclRule

        if (cidr != other.cidr) return false
        if (egress != other.egress) return false
        if (portRange != other.portRange) return false
        if (protocol != other.protocol) return false
        if (ruleAction != other.ruleAction) return false
        if (ruleNumber != other.ruleNumber) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AnalysisAclRule = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AnalysisAclRule
        /**
         * The IPv4 address range, in CIDR notation.
         */
        fun cidr(cidr: String): FluentBuilder
        /**
         * Indicates whether the rule is an outbound rule.
         */
        fun egress(egress: Boolean): FluentBuilder
        /**
         * The range of ports.
         */
        fun portRange(portRange: PortRange): FluentBuilder
        /**
         * The protocol.
         */
        fun protocol(protocol: String): FluentBuilder
        /**
         * Indicates whether to allow or deny traffic that matches the rule.
         */
        fun ruleAction(ruleAction: String): FluentBuilder
        /**
         * The rule number.
         */
        fun ruleNumber(ruleNumber: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The IPv4 address range, in CIDR notation.
         */
        var cidr: String?
        /**
         * Indicates whether the rule is an outbound rule.
         */
        var egress: Boolean?
        /**
         * The range of ports.
         */
        var portRange: PortRange?
        /**
         * The protocol.
         */
        var protocol: String?
        /**
         * Indicates whether to allow or deny traffic that matches the rule.
         */
        var ruleAction: String?
        /**
         * The rule number.
         */
        var ruleNumber: Int?

        fun build(): AnalysisAclRule
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.PortRange] inside the given [block]
         */
        fun portRange(block: PortRange.DslBuilder.() -> kotlin.Unit) {
            this.portRange = PortRange.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cidr: String? = null
        override var egress: Boolean? = null
        override var portRange: PortRange? = null
        override var protocol: String? = null
        override var ruleAction: String? = null
        override var ruleNumber: Int? = null

        constructor(x: AnalysisAclRule) : this() {
            this.cidr = x.cidr
            this.egress = x.egress
            this.portRange = x.portRange
            this.protocol = x.protocol
            this.ruleAction = x.ruleAction
            this.ruleNumber = x.ruleNumber
        }

        override fun build(): AnalysisAclRule = AnalysisAclRule(this)
        override fun cidr(cidr: String): FluentBuilder = apply { this.cidr = cidr }
        override fun egress(egress: Boolean): FluentBuilder = apply { this.egress = egress }
        override fun portRange(portRange: PortRange): FluentBuilder = apply { this.portRange = portRange }
        override fun protocol(protocol: String): FluentBuilder = apply { this.protocol = protocol }
        override fun ruleAction(ruleAction: String): FluentBuilder = apply { this.ruleAction = ruleAction }
        override fun ruleNumber(ruleNumber: Int): FluentBuilder = apply { this.ruleNumber = ruleNumber }
    }
}
