// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a route table route.
 */
class AnalysisRouteTableRoute private constructor(builder: BuilderImpl) {
    /**
     * The destination IPv4 address, in CIDR notation.
     */
    val destinationCidr: String? = builder.destinationCidr
    /**
     * The prefix of the Amazon Web Service.
     */
    val destinationPrefixListId: String? = builder.destinationPrefixListId
    /**
     * The ID of an egress-only internet gateway.
     */
    val egressOnlyInternetGatewayId: String? = builder.egressOnlyInternetGatewayId
    /**
     * The ID of the gateway, such as an internet gateway or virtual private gateway.
     */
    val gatewayId: String? = builder.gatewayId
    /**
     * The ID of the instance, such as a NAT instance.
     */
    val instanceId: String? = builder.instanceId
    /**
     * The ID of a NAT gateway.
     */
    val natGatewayId: String? = builder.natGatewayId
    /**
     * The ID of a network interface.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * Describes how the route was created. The following are possible values:
     * CreateRouteTable - The route was automatically created when the route table was created.
     * CreateRoute - The route was manually added to the route table.
     * EnableVgwRoutePropagation - The route was propagated by route propagation.
     */
    val origin: String? = builder.origin
    /**
     * The ID of a transit gateway.
     */
    val transitGatewayId: String? = builder.transitGatewayId
    /**
     * The ID of a VPC peering connection.
     */
    val vpcPeeringConnectionId: String? = builder.vpcPeeringConnectionId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AnalysisRouteTableRoute = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AnalysisRouteTableRoute(")
        append("destinationCidr=$destinationCidr,")
        append("destinationPrefixListId=$destinationPrefixListId,")
        append("egressOnlyInternetGatewayId=$egressOnlyInternetGatewayId,")
        append("gatewayId=$gatewayId,")
        append("instanceId=$instanceId,")
        append("natGatewayId=$natGatewayId,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("origin=$origin,")
        append("transitGatewayId=$transitGatewayId,")
        append("vpcPeeringConnectionId=$vpcPeeringConnectionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationCidr?.hashCode() ?: 0
        result = 31 * result + (destinationPrefixListId?.hashCode() ?: 0)
        result = 31 * result + (egressOnlyInternetGatewayId?.hashCode() ?: 0)
        result = 31 * result + (gatewayId?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (natGatewayId?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (origin?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayId?.hashCode() ?: 0)
        result = 31 * result + (vpcPeeringConnectionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AnalysisRouteTableRoute

        if (destinationCidr != other.destinationCidr) return false
        if (destinationPrefixListId != other.destinationPrefixListId) return false
        if (egressOnlyInternetGatewayId != other.egressOnlyInternetGatewayId) return false
        if (gatewayId != other.gatewayId) return false
        if (instanceId != other.instanceId) return false
        if (natGatewayId != other.natGatewayId) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (origin != other.origin) return false
        if (transitGatewayId != other.transitGatewayId) return false
        if (vpcPeeringConnectionId != other.vpcPeeringConnectionId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AnalysisRouteTableRoute = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AnalysisRouteTableRoute
        /**
         * The destination IPv4 address, in CIDR notation.
         */
        fun destinationCidr(destinationCidr: String): FluentBuilder
        /**
         * The prefix of the Amazon Web Service.
         */
        fun destinationPrefixListId(destinationPrefixListId: String): FluentBuilder
        /**
         * The ID of an egress-only internet gateway.
         */
        fun egressOnlyInternetGatewayId(egressOnlyInternetGatewayId: String): FluentBuilder
        /**
         * The ID of the gateway, such as an internet gateway or virtual private gateway.
         */
        fun gatewayId(gatewayId: String): FluentBuilder
        /**
         * The ID of the instance, such as a NAT instance.
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * The ID of a NAT gateway.
         */
        fun natGatewayId(natGatewayId: String): FluentBuilder
        /**
         * The ID of a network interface.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * Describes how the route was created. The following are possible values:
         * CreateRouteTable - The route was automatically created when the route table was created.
         * CreateRoute - The route was manually added to the route table.
         * EnableVgwRoutePropagation - The route was propagated by route propagation.
         */
        fun origin(origin: String): FluentBuilder
        /**
         * The ID of a transit gateway.
         */
        fun transitGatewayId(transitGatewayId: String): FluentBuilder
        /**
         * The ID of a VPC peering connection.
         */
        fun vpcPeeringConnectionId(vpcPeeringConnectionId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The destination IPv4 address, in CIDR notation.
         */
        var destinationCidr: String?
        /**
         * The prefix of the Amazon Web Service.
         */
        var destinationPrefixListId: String?
        /**
         * The ID of an egress-only internet gateway.
         */
        var egressOnlyInternetGatewayId: String?
        /**
         * The ID of the gateway, such as an internet gateway or virtual private gateway.
         */
        var gatewayId: String?
        /**
         * The ID of the instance, such as a NAT instance.
         */
        var instanceId: String?
        /**
         * The ID of a NAT gateway.
         */
        var natGatewayId: String?
        /**
         * The ID of a network interface.
         */
        var networkInterfaceId: String?
        /**
         * Describes how the route was created. The following are possible values:
         * CreateRouteTable - The route was automatically created when the route table was created.
         * CreateRoute - The route was manually added to the route table.
         * EnableVgwRoutePropagation - The route was propagated by route propagation.
         */
        var origin: String?
        /**
         * The ID of a transit gateway.
         */
        var transitGatewayId: String?
        /**
         * The ID of a VPC peering connection.
         */
        var vpcPeeringConnectionId: String?

        fun build(): AnalysisRouteTableRoute
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var destinationCidr: String? = null
        override var destinationPrefixListId: String? = null
        override var egressOnlyInternetGatewayId: String? = null
        override var gatewayId: String? = null
        override var instanceId: String? = null
        override var natGatewayId: String? = null
        override var networkInterfaceId: String? = null
        override var origin: String? = null
        override var transitGatewayId: String? = null
        override var vpcPeeringConnectionId: String? = null

        constructor(x: AnalysisRouteTableRoute) : this() {
            this.destinationCidr = x.destinationCidr
            this.destinationPrefixListId = x.destinationPrefixListId
            this.egressOnlyInternetGatewayId = x.egressOnlyInternetGatewayId
            this.gatewayId = x.gatewayId
            this.instanceId = x.instanceId
            this.natGatewayId = x.natGatewayId
            this.networkInterfaceId = x.networkInterfaceId
            this.origin = x.origin
            this.transitGatewayId = x.transitGatewayId
            this.vpcPeeringConnectionId = x.vpcPeeringConnectionId
        }

        override fun build(): AnalysisRouteTableRoute = AnalysisRouteTableRoute(this)
        override fun destinationCidr(destinationCidr: String): FluentBuilder = apply { this.destinationCidr = destinationCidr }
        override fun destinationPrefixListId(destinationPrefixListId: String): FluentBuilder = apply { this.destinationPrefixListId = destinationPrefixListId }
        override fun egressOnlyInternetGatewayId(egressOnlyInternetGatewayId: String): FluentBuilder = apply { this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId }
        override fun gatewayId(gatewayId: String): FluentBuilder = apply { this.gatewayId = gatewayId }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun natGatewayId(natGatewayId: String): FluentBuilder = apply { this.natGatewayId = natGatewayId }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun origin(origin: String): FluentBuilder = apply { this.origin = origin }
        override fun transitGatewayId(transitGatewayId: String): FluentBuilder = apply { this.transitGatewayId = transitGatewayId }
        override fun vpcPeeringConnectionId(vpcPeeringConnectionId: String): FluentBuilder = apply { this.vpcPeeringConnectionId = vpcPeeringConnectionId }
    }
}
