// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for AssignPrivateIpAddresses.
 */
class AssignPrivateIpAddressesRequest private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether to allow an IP address that is already assigned to another network interface or instance to be reassigned to the specified network interface.
     */
    val allowReassignment: Boolean? = builder.allowReassignment
    /**
     * The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the Ipv4 Prefixes option.
     */
    val ipv4PrefixCount: Int? = builder.ipv4PrefixCount
    /**
     * One or more IPv4 prefixes assigned to the network interface. You cannot use this option if you use the Ipv4PrefixCount option.
     */
    val ipv4Prefixes: List<String>? = builder.ipv4Prefixes
    /**
     * The ID of the network interface.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can't specify this parameter when also specifying a number of secondary IP addresses.
     * If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.
     */
    val privateIpAddresses: List<String>? = builder.privateIpAddresses
    /**
     * The number of secondary IP addresses to assign to the network interface. You can't specify this parameter when also specifying private IP addresses.
     */
    val secondaryPrivateIpAddressCount: Int? = builder.secondaryPrivateIpAddressCount

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssignPrivateIpAddressesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssignPrivateIpAddressesRequest(")
        append("allowReassignment=$allowReassignment,")
        append("ipv4PrefixCount=$ipv4PrefixCount,")
        append("ipv4Prefixes=$ipv4Prefixes,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("privateIpAddresses=$privateIpAddresses,")
        append("secondaryPrivateIpAddressCount=$secondaryPrivateIpAddressCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowReassignment?.hashCode() ?: 0
        result = 31 * result + (ipv4PrefixCount ?: 0)
        result = 31 * result + (ipv4Prefixes?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddresses?.hashCode() ?: 0)
        result = 31 * result + (secondaryPrivateIpAddressCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssignPrivateIpAddressesRequest

        if (allowReassignment != other.allowReassignment) return false
        if (ipv4PrefixCount != other.ipv4PrefixCount) return false
        if (ipv4Prefixes != other.ipv4Prefixes) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (privateIpAddresses != other.privateIpAddresses) return false
        if (secondaryPrivateIpAddressCount != other.secondaryPrivateIpAddressCount) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssignPrivateIpAddressesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssignPrivateIpAddressesRequest
        /**
         * Indicates whether to allow an IP address that is already assigned to another network interface or instance to be reassigned to the specified network interface.
         */
        fun allowReassignment(allowReassignment: Boolean): FluentBuilder
        /**
         * The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the Ipv4 Prefixes option.
         */
        fun ipv4PrefixCount(ipv4PrefixCount: Int): FluentBuilder
        /**
         * One or more IPv4 prefixes assigned to the network interface. You cannot use this option if you use the Ipv4PrefixCount option.
         */
        fun ipv4Prefixes(ipv4Prefixes: List<String>): FluentBuilder
        /**
         * The ID of the network interface.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can't specify this parameter when also specifying a number of secondary IP addresses.
         * If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.
         */
        fun privateIpAddresses(privateIpAddresses: List<String>): FluentBuilder
        /**
         * The number of secondary IP addresses to assign to the network interface. You can't specify this parameter when also specifying private IP addresses.
         */
        fun secondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether to allow an IP address that is already assigned to another network interface or instance to be reassigned to the specified network interface.
         */
        var allowReassignment: Boolean?
        /**
         * The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the Ipv4 Prefixes option.
         */
        var ipv4PrefixCount: Int?
        /**
         * One or more IPv4 prefixes assigned to the network interface. You cannot use this option if you use the Ipv4PrefixCount option.
         */
        var ipv4Prefixes: List<String>?
        /**
         * The ID of the network interface.
         */
        var networkInterfaceId: String?
        /**
         * One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can't specify this parameter when also specifying a number of secondary IP addresses.
         * If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.
         */
        var privateIpAddresses: List<String>?
        /**
         * The number of secondary IP addresses to assign to the network interface. You can't specify this parameter when also specifying private IP addresses.
         */
        var secondaryPrivateIpAddressCount: Int?

        fun build(): AssignPrivateIpAddressesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allowReassignment: Boolean? = null
        override var ipv4PrefixCount: Int? = null
        override var ipv4Prefixes: List<String>? = null
        override var networkInterfaceId: String? = null
        override var privateIpAddresses: List<String>? = null
        override var secondaryPrivateIpAddressCount: Int? = null

        constructor(x: AssignPrivateIpAddressesRequest) : this() {
            this.allowReassignment = x.allowReassignment
            this.ipv4PrefixCount = x.ipv4PrefixCount
            this.ipv4Prefixes = x.ipv4Prefixes
            this.networkInterfaceId = x.networkInterfaceId
            this.privateIpAddresses = x.privateIpAddresses
            this.secondaryPrivateIpAddressCount = x.secondaryPrivateIpAddressCount
        }

        override fun build(): AssignPrivateIpAddressesRequest = AssignPrivateIpAddressesRequest(this)
        override fun allowReassignment(allowReassignment: Boolean): FluentBuilder = apply { this.allowReassignment = allowReassignment }
        override fun ipv4PrefixCount(ipv4PrefixCount: Int): FluentBuilder = apply { this.ipv4PrefixCount = ipv4PrefixCount }
        override fun ipv4Prefixes(ipv4Prefixes: List<String>): FluentBuilder = apply { this.ipv4Prefixes = ipv4Prefixes }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun privateIpAddresses(privateIpAddresses: List<String>): FluentBuilder = apply { this.privateIpAddresses = privateIpAddresses }
        override fun secondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount: Int): FluentBuilder = apply { this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount }
    }
}
