// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class AssociateAddressRequest private constructor(builder: BuilderImpl) {
    /**
     * &#91;EC2-VPC&#93; The allocation ID. This is required for EC2-VPC.
     */
    val allocationId: String? = builder.allocationId
    /**
     * &#91;EC2-VPC&#93; For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is already associated with an instance or network interface to be reassociated with the specified instance or network interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation is automatic, therefore you can specify false to ensure the operation fails if the Elastic IP address is already associated with another resource.
     */
    val allowReassociation: Boolean? = builder.allowReassociation
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The ID of the instance. The instance must have exactly one attached network interface.
     * For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both.
     * For EC2-Classic, you must specify an instance ID and the instance must be in the running
     * state.
     */
    val instanceId: String? = builder.instanceId
    /**
     * &#91;EC2-VPC&#93; The ID of the network interface. If the instance has more than one network interface, you must specify a network interface ID.
     * For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * &#91;EC2-VPC&#93; The primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
     */
    val privateIpAddress: String? = builder.privateIpAddress
    /**
     * &#91;EC2-Classic&#93; The Elastic IP address to associate with the instance. This is required for
     * EC2-Classic.
     */
    val publicIp: String? = builder.publicIp

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssociateAddressRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssociateAddressRequest(")
        append("allocationId=$allocationId,")
        append("allowReassociation=$allowReassociation,")
        append("dryRun=$dryRun,")
        append("instanceId=$instanceId,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("privateIpAddress=$privateIpAddress,")
        append("publicIp=$publicIp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationId?.hashCode() ?: 0
        result = 31 * result + (allowReassociation?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (publicIp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssociateAddressRequest

        if (allocationId != other.allocationId) return false
        if (allowReassociation != other.allowReassociation) return false
        if (dryRun != other.dryRun) return false
        if (instanceId != other.instanceId) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (publicIp != other.publicIp) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssociateAddressRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssociateAddressRequest
        /**
         * &#91;EC2-VPC&#93; The allocation ID. This is required for EC2-VPC.
         */
        fun allocationId(allocationId: String): FluentBuilder
        /**
         * &#91;EC2-VPC&#93; For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is already associated with an instance or network interface to be reassociated with the specified instance or network interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation is automatic, therefore you can specify false to ensure the operation fails if the Elastic IP address is already associated with another resource.
         */
        fun allowReassociation(allowReassociation: Boolean): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The ID of the instance. The instance must have exactly one attached network interface.
         * For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both.
         * For EC2-Classic, you must specify an instance ID and the instance must be in the running
         * state.
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * &#91;EC2-VPC&#93; The ID of the network interface. If the instance has more than one network interface, you must specify a network interface ID.
         * For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * &#91;EC2-VPC&#93; The primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
         */
        fun privateIpAddress(privateIpAddress: String): FluentBuilder
        /**
         * &#91;EC2-Classic&#93; The Elastic IP address to associate with the instance. This is required for
         * EC2-Classic.
         */
        fun publicIp(publicIp: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * &#91;EC2-VPC&#93; The allocation ID. This is required for EC2-VPC.
         */
        var allocationId: String?
        /**
         * &#91;EC2-VPC&#93; For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is already associated with an instance or network interface to be reassociated with the specified instance or network interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation is automatic, therefore you can specify false to ensure the operation fails if the Elastic IP address is already associated with another resource.
         */
        var allowReassociation: Boolean?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The ID of the instance. The instance must have exactly one attached network interface.
         * For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both.
         * For EC2-Classic, you must specify an instance ID and the instance must be in the running
         * state.
         */
        var instanceId: String?
        /**
         * &#91;EC2-VPC&#93; The ID of the network interface. If the instance has more than one network interface, you must specify a network interface ID.
         * For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both.
         */
        var networkInterfaceId: String?
        /**
         * &#91;EC2-VPC&#93; The primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
         */
        var privateIpAddress: String?
        /**
         * &#91;EC2-Classic&#93; The Elastic IP address to associate with the instance. This is required for
         * EC2-Classic.
         */
        var publicIp: String?

        fun build(): AssociateAddressRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allocationId: String? = null
        override var allowReassociation: Boolean? = null
        override var dryRun: Boolean? = null
        override var instanceId: String? = null
        override var networkInterfaceId: String? = null
        override var privateIpAddress: String? = null
        override var publicIp: String? = null

        constructor(x: AssociateAddressRequest) : this() {
            this.allocationId = x.allocationId
            this.allowReassociation = x.allowReassociation
            this.dryRun = x.dryRun
            this.instanceId = x.instanceId
            this.networkInterfaceId = x.networkInterfaceId
            this.privateIpAddress = x.privateIpAddress
            this.publicIp = x.publicIp
        }

        override fun build(): AssociateAddressRequest = AssociateAddressRequest(this)
        override fun allocationId(allocationId: String): FluentBuilder = apply { this.allocationId = allocationId }
        override fun allowReassociation(allowReassociation: Boolean): FluentBuilder = apply { this.allowReassociation = allowReassociation }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun privateIpAddress(privateIpAddress: String): FluentBuilder = apply { this.privateIpAddress = privateIpAddress }
        override fun publicIp(publicIp: String): FluentBuilder = apply { this.publicIp = publicIp }
    }
}
