// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class AssociateTrunkInterfaceRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the branch network interface.
     */
    val branchInterfaceId: String? = builder.branchInterfaceId
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The application key. This applies to the GRE protocol.
     */
    val greKey: Int? = builder.greKey
    /**
     * The ID of the trunk network interface.
     */
    val trunkInterfaceId: String? = builder.trunkInterfaceId
    /**
     * The ID of the VLAN. This applies to the VLAN protocol.
     */
    val vlanId: Int? = builder.vlanId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssociateTrunkInterfaceRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssociateTrunkInterfaceRequest(")
        append("branchInterfaceId=$branchInterfaceId,")
        append("clientToken=$clientToken,")
        append("dryRun=$dryRun,")
        append("greKey=$greKey,")
        append("trunkInterfaceId=$trunkInterfaceId,")
        append("vlanId=$vlanId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = branchInterfaceId?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (greKey ?: 0)
        result = 31 * result + (trunkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (vlanId ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssociateTrunkInterfaceRequest

        if (branchInterfaceId != other.branchInterfaceId) return false
        if (clientToken != other.clientToken) return false
        if (dryRun != other.dryRun) return false
        if (greKey != other.greKey) return false
        if (trunkInterfaceId != other.trunkInterfaceId) return false
        if (vlanId != other.vlanId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssociateTrunkInterfaceRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssociateTrunkInterfaceRequest
        /**
         * The ID of the branch network interface.
         */
        fun branchInterfaceId(branchInterfaceId: String): FluentBuilder
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The application key. This applies to the GRE protocol.
         */
        fun greKey(greKey: Int): FluentBuilder
        /**
         * The ID of the trunk network interface.
         */
        fun trunkInterfaceId(trunkInterfaceId: String): FluentBuilder
        /**
         * The ID of the VLAN. This applies to the VLAN protocol.
         */
        fun vlanId(vlanId: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the branch network interface.
         */
        var branchInterfaceId: String?
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency.
         */
        var clientToken: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The application key. This applies to the GRE protocol.
         */
        var greKey: Int?
        /**
         * The ID of the trunk network interface.
         */
        var trunkInterfaceId: String?
        /**
         * The ID of the VLAN. This applies to the VLAN protocol.
         */
        var vlanId: Int?

        fun build(): AssociateTrunkInterfaceRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var branchInterfaceId: String? = null
        override var clientToken: String? = null
        override var dryRun: Boolean? = null
        override var greKey: Int? = null
        override var trunkInterfaceId: String? = null
        override var vlanId: Int? = null

        constructor(x: AssociateTrunkInterfaceRequest) : this() {
            this.branchInterfaceId = x.branchInterfaceId
            this.clientToken = x.clientToken
            this.dryRun = x.dryRun
            this.greKey = x.greKey
            this.trunkInterfaceId = x.trunkInterfaceId
            this.vlanId = x.vlanId
        }

        override fun build(): AssociateTrunkInterfaceRequest = AssociateTrunkInterfaceRequest(this)
        override fun branchInterfaceId(branchInterfaceId: String): FluentBuilder = apply { this.branchInterfaceId = branchInterfaceId }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun greKey(greKey: Int): FluentBuilder = apply { this.greKey = greKey }
        override fun trunkInterfaceId(trunkInterfaceId: String): FluentBuilder = apply { this.trunkInterfaceId = trunkInterfaceId }
        override fun vlanId(vlanId: Int): FluentBuilder = apply { this.vlanId = vlanId }
    }
}
