// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Information about the associated IAM roles.
 */
class AssociatedRole private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the associated IAM role.
     */
    val associatedRoleArn: String? = builder.associatedRoleArn
    /**
     * The name of the Amazon S3 bucket in which the Amazon S3 object is stored.
     */
    val certificateS3BucketName: String? = builder.certificateS3BucketName
    /**
     * The key of the Amazon S3 object ey where the certificate, certificate chain, and encrypted private key bundle
     * is stored. The object key is formated as follows:  role_arn/certificate_arn.
     */
    val certificateS3ObjectKey: String? = builder.certificateS3ObjectKey
    /**
     * The ID of the KMS customer master key (CMK) used to encrypt the private key.
     */
    val encryptionKmsKeyId: String? = builder.encryptionKmsKeyId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AssociatedRole = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AssociatedRole(")
        append("associatedRoleArn=$associatedRoleArn,")
        append("certificateS3BucketName=$certificateS3BucketName,")
        append("certificateS3ObjectKey=$certificateS3ObjectKey,")
        append("encryptionKmsKeyId=$encryptionKmsKeyId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedRoleArn?.hashCode() ?: 0
        result = 31 * result + (certificateS3BucketName?.hashCode() ?: 0)
        result = 31 * result + (certificateS3ObjectKey?.hashCode() ?: 0)
        result = 31 * result + (encryptionKmsKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AssociatedRole

        if (associatedRoleArn != other.associatedRoleArn) return false
        if (certificateS3BucketName != other.certificateS3BucketName) return false
        if (certificateS3ObjectKey != other.certificateS3ObjectKey) return false
        if (encryptionKmsKeyId != other.encryptionKmsKeyId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AssociatedRole = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AssociatedRole
        /**
         * The ARN of the associated IAM role.
         */
        fun associatedRoleArn(associatedRoleArn: String): FluentBuilder
        /**
         * The name of the Amazon S3 bucket in which the Amazon S3 object is stored.
         */
        fun certificateS3BucketName(certificateS3BucketName: String): FluentBuilder
        /**
         * The key of the Amazon S3 object ey where the certificate, certificate chain, and encrypted private key bundle
         * is stored. The object key is formated as follows:  role_arn/certificate_arn.
         */
        fun certificateS3ObjectKey(certificateS3ObjectKey: String): FluentBuilder
        /**
         * The ID of the KMS customer master key (CMK) used to encrypt the private key.
         */
        fun encryptionKmsKeyId(encryptionKmsKeyId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the associated IAM role.
         */
        var associatedRoleArn: String?
        /**
         * The name of the Amazon S3 bucket in which the Amazon S3 object is stored.
         */
        var certificateS3BucketName: String?
        /**
         * The key of the Amazon S3 object ey where the certificate, certificate chain, and encrypted private key bundle
         * is stored. The object key is formated as follows:  role_arn/certificate_arn.
         */
        var certificateS3ObjectKey: String?
        /**
         * The ID of the KMS customer master key (CMK) used to encrypt the private key.
         */
        var encryptionKmsKeyId: String?

        fun build(): AssociatedRole
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associatedRoleArn: String? = null
        override var certificateS3BucketName: String? = null
        override var certificateS3ObjectKey: String? = null
        override var encryptionKmsKeyId: String? = null

        constructor(x: AssociatedRole) : this() {
            this.associatedRoleArn = x.associatedRoleArn
            this.certificateS3BucketName = x.certificateS3BucketName
            this.certificateS3ObjectKey = x.certificateS3ObjectKey
            this.encryptionKmsKeyId = x.encryptionKmsKeyId
        }

        override fun build(): AssociatedRole = AssociatedRole(this)
        override fun associatedRoleArn(associatedRoleArn: String): FluentBuilder = apply { this.associatedRoleArn = associatedRoleArn }
        override fun certificateS3BucketName(certificateS3BucketName: String): FluentBuilder = apply { this.certificateS3BucketName = certificateS3BucketName }
        override fun certificateS3ObjectKey(certificateS3ObjectKey: String): FluentBuilder = apply { this.certificateS3ObjectKey = certificateS3ObjectKey }
        override fun encryptionKmsKeyId(encryptionKmsKeyId: String): FluentBuilder = apply { this.encryptionKmsKeyId = encryptionKmsKeyId }
    }
}
