// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for AttachNetworkInterface.
 */
class AttachNetworkInterfaceRequest private constructor(builder: BuilderImpl) {
    /**
     * The index of the device for the network interface attachment.
     */
    val deviceIndex: Int? = builder.deviceIndex
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The ID of the instance.
     */
    val instanceId: String? = builder.instanceId
    /**
     * The index of the network card. Some instance types support multiple network cards.
     * The primary network interface must be assigned to network card index 0.
     * The default is network card index 0.
     */
    val networkCardIndex: Int? = builder.networkCardIndex
    /**
     * The ID of the network interface.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AttachNetworkInterfaceRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AttachNetworkInterfaceRequest(")
        append("deviceIndex=$deviceIndex,")
        append("dryRun=$dryRun,")
        append("instanceId=$instanceId,")
        append("networkCardIndex=$networkCardIndex,")
        append("networkInterfaceId=$networkInterfaceId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deviceIndex ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (networkCardIndex ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AttachNetworkInterfaceRequest

        if (deviceIndex != other.deviceIndex) return false
        if (dryRun != other.dryRun) return false
        if (instanceId != other.instanceId) return false
        if (networkCardIndex != other.networkCardIndex) return false
        if (networkInterfaceId != other.networkInterfaceId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AttachNetworkInterfaceRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AttachNetworkInterfaceRequest
        /**
         * The index of the device for the network interface attachment.
         */
        fun deviceIndex(deviceIndex: Int): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The ID of the instance.
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * The index of the network card. Some instance types support multiple network cards.
         * The primary network interface must be assigned to network card index 0.
         * The default is network card index 0.
         */
        fun networkCardIndex(networkCardIndex: Int): FluentBuilder
        /**
         * The ID of the network interface.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The index of the device for the network interface attachment.
         */
        var deviceIndex: Int?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The ID of the instance.
         */
        var instanceId: String?
        /**
         * The index of the network card. Some instance types support multiple network cards.
         * The primary network interface must be assigned to network card index 0.
         * The default is network card index 0.
         */
        var networkCardIndex: Int?
        /**
         * The ID of the network interface.
         */
        var networkInterfaceId: String?

        fun build(): AttachNetworkInterfaceRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deviceIndex: Int? = null
        override var dryRun: Boolean? = null
        override var instanceId: String? = null
        override var networkCardIndex: Int? = null
        override var networkInterfaceId: String? = null

        constructor(x: AttachNetworkInterfaceRequest) : this() {
            this.deviceIndex = x.deviceIndex
            this.dryRun = x.dryRun
            this.instanceId = x.instanceId
            this.networkCardIndex = x.networkCardIndex
            this.networkInterfaceId = x.networkInterfaceId
        }

        override fun build(): AttachNetworkInterfaceRequest = AttachNetworkInterfaceRequest(this)
        override fun deviceIndex(deviceIndex: Int): FluentBuilder = apply { this.deviceIndex = deviceIndex }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun networkCardIndex(networkCardIndex: Int): FluentBuilder = apply { this.networkCardIndex = networkCardIndex }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
    }
}
