// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Information about an authorization rule.
 */
class AuthorizationRule private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether the authorization rule grants access to all clients.
     */
    val accessAll: Boolean? = builder.accessAll
    /**
     * The ID of the Client VPN endpoint with which the authorization rule is associated.
     */
    val clientVpnEndpointId: String? = builder.clientVpnEndpointId
    /**
     * A brief description of the authorization rule.
     */
    val description: String? = builder.description
    /**
     * The IPv4 address range, in CIDR notation, of the network to which the authorization rule applies.
     */
    val destinationCidr: String? = builder.destinationCidr
    /**
     * The ID of the Active Directory group to which the authorization rule grants access.
     */
    val groupId: String? = builder.groupId
    /**
     * The current state of the authorization rule.
     */
    val status: ClientVpnAuthorizationRuleStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AuthorizationRule = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AuthorizationRule(")
        append("accessAll=$accessAll,")
        append("clientVpnEndpointId=$clientVpnEndpointId,")
        append("description=$description,")
        append("destinationCidr=$destinationCidr,")
        append("groupId=$groupId,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessAll?.hashCode() ?: 0
        result = 31 * result + (clientVpnEndpointId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationCidr?.hashCode() ?: 0)
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AuthorizationRule

        if (accessAll != other.accessAll) return false
        if (clientVpnEndpointId != other.clientVpnEndpointId) return false
        if (description != other.description) return false
        if (destinationCidr != other.destinationCidr) return false
        if (groupId != other.groupId) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AuthorizationRule = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AuthorizationRule
        /**
         * Indicates whether the authorization rule grants access to all clients.
         */
        fun accessAll(accessAll: Boolean): FluentBuilder
        /**
         * The ID of the Client VPN endpoint with which the authorization rule is associated.
         */
        fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder
        /**
         * A brief description of the authorization rule.
         */
        fun description(description: String): FluentBuilder
        /**
         * The IPv4 address range, in CIDR notation, of the network to which the authorization rule applies.
         */
        fun destinationCidr(destinationCidr: String): FluentBuilder
        /**
         * The ID of the Active Directory group to which the authorization rule grants access.
         */
        fun groupId(groupId: String): FluentBuilder
        /**
         * The current state of the authorization rule.
         */
        fun status(status: ClientVpnAuthorizationRuleStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether the authorization rule grants access to all clients.
         */
        var accessAll: Boolean?
        /**
         * The ID of the Client VPN endpoint with which the authorization rule is associated.
         */
        var clientVpnEndpointId: String?
        /**
         * A brief description of the authorization rule.
         */
        var description: String?
        /**
         * The IPv4 address range, in CIDR notation, of the network to which the authorization rule applies.
         */
        var destinationCidr: String?
        /**
         * The ID of the Active Directory group to which the authorization rule grants access.
         */
        var groupId: String?
        /**
         * The current state of the authorization rule.
         */
        var status: ClientVpnAuthorizationRuleStatus?

        fun build(): AuthorizationRule
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ClientVpnAuthorizationRuleStatus] inside the given [block]
         */
        fun status(block: ClientVpnAuthorizationRuleStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = ClientVpnAuthorizationRuleStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accessAll: Boolean? = null
        override var clientVpnEndpointId: String? = null
        override var description: String? = null
        override var destinationCidr: String? = null
        override var groupId: String? = null
        override var status: ClientVpnAuthorizationRuleStatus? = null

        constructor(x: AuthorizationRule) : this() {
            this.accessAll = x.accessAll
            this.clientVpnEndpointId = x.clientVpnEndpointId
            this.description = x.description
            this.destinationCidr = x.destinationCidr
            this.groupId = x.groupId
            this.status = x.status
        }

        override fun build(): AuthorizationRule = AuthorizationRule(this)
        override fun accessAll(accessAll: Boolean): FluentBuilder = apply { this.accessAll = accessAll }
        override fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder = apply { this.clientVpnEndpointId = clientVpnEndpointId }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun destinationCidr(destinationCidr: String): FluentBuilder = apply { this.destinationCidr = destinationCidr }
        override fun groupId(groupId: String): FluentBuilder = apply { this.groupId = groupId }
        override fun status(status: ClientVpnAuthorizationRuleStatus): FluentBuilder = apply { this.status = status }
    }
}
