// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class AuthorizeClientVpnIngressRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group. Required if AuthorizeAllGroups is false or not specified.
     */
    val accessGroupId: String? = builder.accessGroupId
    /**
     * Indicates whether to grant access to all clients. Specify true to grant all
     * clients who successfully establish a VPN connection access to the network. Must be set
     * to true if AccessGroupId is not specified.
     */
    val authorizeAllGroups: Boolean? = builder.authorizeAllGroups
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The ID of the Client VPN endpoint.
     */
    val clientVpnEndpointId: String? = builder.clientVpnEndpointId
    /**
     * A brief description of the authorization rule.
     */
    val description: String? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The IPv4 address range, in CIDR notation, of the network for which access is being authorized.
     */
    val targetNetworkCidr: String? = builder.targetNetworkCidr

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AuthorizeClientVpnIngressRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AuthorizeClientVpnIngressRequest(")
        append("accessGroupId=$accessGroupId,")
        append("authorizeAllGroups=$authorizeAllGroups,")
        append("clientToken=$clientToken,")
        append("clientVpnEndpointId=$clientVpnEndpointId,")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("targetNetworkCidr=$targetNetworkCidr)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessGroupId?.hashCode() ?: 0
        result = 31 * result + (authorizeAllGroups?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (clientVpnEndpointId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (targetNetworkCidr?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AuthorizeClientVpnIngressRequest

        if (accessGroupId != other.accessGroupId) return false
        if (authorizeAllGroups != other.authorizeAllGroups) return false
        if (clientToken != other.clientToken) return false
        if (clientVpnEndpointId != other.clientVpnEndpointId) return false
        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (targetNetworkCidr != other.targetNetworkCidr) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AuthorizeClientVpnIngressRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AuthorizeClientVpnIngressRequest
        /**
         * The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group. Required if AuthorizeAllGroups is false or not specified.
         */
        fun accessGroupId(accessGroupId: String): FluentBuilder
        /**
         * Indicates whether to grant access to all clients. Specify true to grant all
         * clients who successfully establish a VPN connection access to the network. Must be set
         * to true if AccessGroupId is not specified.
         */
        fun authorizeAllGroups(authorizeAllGroups: Boolean): FluentBuilder
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The ID of the Client VPN endpoint.
         */
        fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder
        /**
         * A brief description of the authorization rule.
         */
        fun description(description: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The IPv4 address range, in CIDR notation, of the network for which access is being authorized.
         */
        fun targetNetworkCidr(targetNetworkCidr: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group. Required if AuthorizeAllGroups is false or not specified.
         */
        var accessGroupId: String?
        /**
         * Indicates whether to grant access to all clients. Specify true to grant all
         * clients who successfully establish a VPN connection access to the network. Must be set
         * to true if AccessGroupId is not specified.
         */
        var authorizeAllGroups: Boolean?
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
         */
        var clientToken: String?
        /**
         * The ID of the Client VPN endpoint.
         */
        var clientVpnEndpointId: String?
        /**
         * A brief description of the authorization rule.
         */
        var description: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The IPv4 address range, in CIDR notation, of the network for which access is being authorized.
         */
        var targetNetworkCidr: String?

        fun build(): AuthorizeClientVpnIngressRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accessGroupId: String? = null
        override var authorizeAllGroups: Boolean? = null
        override var clientToken: String? = null
        override var clientVpnEndpointId: String? = null
        override var description: String? = null
        override var dryRun: Boolean? = null
        override var targetNetworkCidr: String? = null

        constructor(x: AuthorizeClientVpnIngressRequest) : this() {
            this.accessGroupId = x.accessGroupId
            this.authorizeAllGroups = x.authorizeAllGroups
            this.clientToken = x.clientToken
            this.clientVpnEndpointId = x.clientVpnEndpointId
            this.description = x.description
            this.dryRun = x.dryRun
            this.targetNetworkCidr = x.targetNetworkCidr
        }

        override fun build(): AuthorizeClientVpnIngressRequest = AuthorizeClientVpnIngressRequest(this)
        override fun accessGroupId(accessGroupId: String): FluentBuilder = apply { this.accessGroupId = accessGroupId }
        override fun authorizeAllGroups(authorizeAllGroups: Boolean): FluentBuilder = apply { this.authorizeAllGroups = authorizeAllGroups }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder = apply { this.clientVpnEndpointId = clientVpnEndpointId }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun targetNetworkCidr(targetNetworkCidr: String): FluentBuilder = apply { this.targetNetworkCidr = targetNetworkCidr }
    }
}
