// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class AuthorizeSecurityGroupIngressRequest private constructor(builder: BuilderImpl) {
    /**
     * The IPv4 address range, in CIDR format. You can't specify this parameter when specifying a source
     * security group. To specify an IPv6 address range, use a set of IP permissions.
     * Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.
     */
    val cidrIp: String? = builder.cidrIp
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The start of port range for the TCP and UDP protocols, or an ICMP type number.
     * For the ICMP type number, use -1 to specify all types. If you
     * specify all ICMP types, you must specify all codes.
     * Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.
     */
    val fromPort: Int? = builder.fromPort
    /**
     * The ID of the security group. You must specify either the security group ID or the
     * security group name in the request. For security groups in a nondefault VPC, you must
     * specify the security group ID.
     */
    val groupId: String? = builder.groupId
    /**
     * &#91;EC2-Classic, default VPC&#93; The name of the security group. You must specify either the
     * security group ID or the security group name in the request.
     */
    val groupName: String? = builder.groupName
    /**
     * The sets of IP permissions.
     */
    val ipPermissions: List<IpPermission>? = builder.ipPermissions
    /**
     * The IP protocol name (tcp, udp, icmp) or number
     * (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers). To specify icmpv6, use a set of IP permissions.
     * &#91;VPC only&#93; Use -1 to specify all protocols. If you specify -1 or a
     * protocol other than tcp, udp, or icmp, traffic on all ports
     * is allowed, regardless of any ports you specify.
     * Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.
     */
    val ipProtocol: String? = builder.ipProtocol
    /**
     * &#91;EC2-Classic, default VPC&#93; The name of the source security group. You can't specify this parameter
     * in combination with the following parameters: the CIDR IP address range, the start of the port range,
     * the IP protocol, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access.
     * To create a rule with a specific IP protocol and port range, use a set of IP permissions instead. For
     * EC2-VPC, the source security group must be in the same VPC.
     */
    val sourceSecurityGroupName: String? = builder.sourceSecurityGroupName
    /**
     * &#91;nondefault VPC&#93; The Amazon Web Services account ID for the source security group, if the source security group is
     * in a different account. You can't specify this parameter in combination with the following parameters:
     * the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range.
     * Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol
     * and port range, use a set of IP permissions instead.
     */
    val sourceSecurityGroupOwnerId: String? = builder.sourceSecurityGroupOwnerId
    /**
     * &#91;VPC Only&#93; The tags applied to the security group rule.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The end of port range for the TCP and UDP protocols, or an ICMP code number.
     * For the ICMP code number, use -1 to specify all codes. If you
     * specify all ICMP types, you must specify all codes.
     * Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.
     */
    val toPort: Int? = builder.toPort

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AuthorizeSecurityGroupIngressRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AuthorizeSecurityGroupIngressRequest(")
        append("cidrIp=$cidrIp,")
        append("dryRun=$dryRun,")
        append("fromPort=$fromPort,")
        append("groupId=$groupId,")
        append("groupName=$groupName,")
        append("ipPermissions=$ipPermissions,")
        append("ipProtocol=$ipProtocol,")
        append("sourceSecurityGroupName=$sourceSecurityGroupName,")
        append("sourceSecurityGroupOwnerId=$sourceSecurityGroupOwnerId,")
        append("tagSpecifications=$tagSpecifications,")
        append("toPort=$toPort)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrIp?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (fromPort ?: 0)
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (ipPermissions?.hashCode() ?: 0)
        result = 31 * result + (ipProtocol?.hashCode() ?: 0)
        result = 31 * result + (sourceSecurityGroupName?.hashCode() ?: 0)
        result = 31 * result + (sourceSecurityGroupOwnerId?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (toPort ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AuthorizeSecurityGroupIngressRequest

        if (cidrIp != other.cidrIp) return false
        if (dryRun != other.dryRun) return false
        if (fromPort != other.fromPort) return false
        if (groupId != other.groupId) return false
        if (groupName != other.groupName) return false
        if (ipPermissions != other.ipPermissions) return false
        if (ipProtocol != other.ipProtocol) return false
        if (sourceSecurityGroupName != other.sourceSecurityGroupName) return false
        if (sourceSecurityGroupOwnerId != other.sourceSecurityGroupOwnerId) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (toPort != other.toPort) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AuthorizeSecurityGroupIngressRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AuthorizeSecurityGroupIngressRequest
        /**
         * The IPv4 address range, in CIDR format. You can't specify this parameter when specifying a source
         * security group. To specify an IPv6 address range, use a set of IP permissions.
         * Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.
         */
        fun cidrIp(cidrIp: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The start of port range for the TCP and UDP protocols, or an ICMP type number.
         * For the ICMP type number, use -1 to specify all types. If you
         * specify all ICMP types, you must specify all codes.
         * Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.
         */
        fun fromPort(fromPort: Int): FluentBuilder
        /**
         * The ID of the security group. You must specify either the security group ID or the
         * security group name in the request. For security groups in a nondefault VPC, you must
         * specify the security group ID.
         */
        fun groupId(groupId: String): FluentBuilder
        /**
         * &#91;EC2-Classic, default VPC&#93; The name of the security group. You must specify either the
         * security group ID or the security group name in the request.
         */
        fun groupName(groupName: String): FluentBuilder
        /**
         * The sets of IP permissions.
         */
        fun ipPermissions(ipPermissions: List<IpPermission>): FluentBuilder
        /**
         * The IP protocol name (tcp, udp, icmp) or number
         * (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers). To specify icmpv6, use a set of IP permissions.
         * &#91;VPC only&#93; Use -1 to specify all protocols. If you specify -1 or a
         * protocol other than tcp, udp, or icmp, traffic on all ports
         * is allowed, regardless of any ports you specify.
         * Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.
         */
        fun ipProtocol(ipProtocol: String): FluentBuilder
        /**
         * &#91;EC2-Classic, default VPC&#93; The name of the source security group. You can't specify this parameter
         * in combination with the following parameters: the CIDR IP address range, the start of the port range,
         * the IP protocol, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access.
         * To create a rule with a specific IP protocol and port range, use a set of IP permissions instead. For
         * EC2-VPC, the source security group must be in the same VPC.
         */
        fun sourceSecurityGroupName(sourceSecurityGroupName: String): FluentBuilder
        /**
         * &#91;nondefault VPC&#93; The Amazon Web Services account ID for the source security group, if the source security group is
         * in a different account. You can't specify this parameter in combination with the following parameters:
         * the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range.
         * Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol
         * and port range, use a set of IP permissions instead.
         */
        fun sourceSecurityGroupOwnerId(sourceSecurityGroupOwnerId: String): FluentBuilder
        /**
         * &#91;VPC Only&#93; The tags applied to the security group rule.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
        /**
         * The end of port range for the TCP and UDP protocols, or an ICMP code number.
         * For the ICMP code number, use -1 to specify all codes. If you
         * specify all ICMP types, you must specify all codes.
         * Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.
         */
        fun toPort(toPort: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The IPv4 address range, in CIDR format. You can't specify this parameter when specifying a source
         * security group. To specify an IPv6 address range, use a set of IP permissions.
         * Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.
         */
        var cidrIp: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The start of port range for the TCP and UDP protocols, or an ICMP type number.
         * For the ICMP type number, use -1 to specify all types. If you
         * specify all ICMP types, you must specify all codes.
         * Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.
         */
        var fromPort: Int?
        /**
         * The ID of the security group. You must specify either the security group ID or the
         * security group name in the request. For security groups in a nondefault VPC, you must
         * specify the security group ID.
         */
        var groupId: String?
        /**
         * &#91;EC2-Classic, default VPC&#93; The name of the security group. You must specify either the
         * security group ID or the security group name in the request.
         */
        var groupName: String?
        /**
         * The sets of IP permissions.
         */
        var ipPermissions: List<IpPermission>?
        /**
         * The IP protocol name (tcp, udp, icmp) or number
         * (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers). To specify icmpv6, use a set of IP permissions.
         * &#91;VPC only&#93; Use -1 to specify all protocols. If you specify -1 or a
         * protocol other than tcp, udp, or icmp, traffic on all ports
         * is allowed, regardless of any ports you specify.
         * Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.
         */
        var ipProtocol: String?
        /**
         * &#91;EC2-Classic, default VPC&#93; The name of the source security group. You can't specify this parameter
         * in combination with the following parameters: the CIDR IP address range, the start of the port range,
         * the IP protocol, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access.
         * To create a rule with a specific IP protocol and port range, use a set of IP permissions instead. For
         * EC2-VPC, the source security group must be in the same VPC.
         */
        var sourceSecurityGroupName: String?
        /**
         * &#91;nondefault VPC&#93; The Amazon Web Services account ID for the source security group, if the source security group is
         * in a different account. You can't specify this parameter in combination with the following parameters:
         * the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range.
         * Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol
         * and port range, use a set of IP permissions instead.
         */
        var sourceSecurityGroupOwnerId: String?
        /**
         * &#91;VPC Only&#93; The tags applied to the security group rule.
         */
        var tagSpecifications: List<TagSpecification>?
        /**
         * The end of port range for the TCP and UDP protocols, or an ICMP code number.
         * For the ICMP code number, use -1 to specify all codes. If you
         * specify all ICMP types, you must specify all codes.
         * Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.
         */
        var toPort: Int?

        fun build(): AuthorizeSecurityGroupIngressRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cidrIp: String? = null
        override var dryRun: Boolean? = null
        override var fromPort: Int? = null
        override var groupId: String? = null
        override var groupName: String? = null
        override var ipPermissions: List<IpPermission>? = null
        override var ipProtocol: String? = null
        override var sourceSecurityGroupName: String? = null
        override var sourceSecurityGroupOwnerId: String? = null
        override var tagSpecifications: List<TagSpecification>? = null
        override var toPort: Int? = null

        constructor(x: AuthorizeSecurityGroupIngressRequest) : this() {
            this.cidrIp = x.cidrIp
            this.dryRun = x.dryRun
            this.fromPort = x.fromPort
            this.groupId = x.groupId
            this.groupName = x.groupName
            this.ipPermissions = x.ipPermissions
            this.ipProtocol = x.ipProtocol
            this.sourceSecurityGroupName = x.sourceSecurityGroupName
            this.sourceSecurityGroupOwnerId = x.sourceSecurityGroupOwnerId
            this.tagSpecifications = x.tagSpecifications
            this.toPort = x.toPort
        }

        override fun build(): AuthorizeSecurityGroupIngressRequest = AuthorizeSecurityGroupIngressRequest(this)
        override fun cidrIp(cidrIp: String): FluentBuilder = apply { this.cidrIp = cidrIp }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun fromPort(fromPort: Int): FluentBuilder = apply { this.fromPort = fromPort }
        override fun groupId(groupId: String): FluentBuilder = apply { this.groupId = groupId }
        override fun groupName(groupName: String): FluentBuilder = apply { this.groupName = groupName }
        override fun ipPermissions(ipPermissions: List<IpPermission>): FluentBuilder = apply { this.ipPermissions = ipPermissions }
        override fun ipProtocol(ipProtocol: String): FluentBuilder = apply { this.ipProtocol = ipProtocol }
        override fun sourceSecurityGroupName(sourceSecurityGroupName: String): FluentBuilder = apply { this.sourceSecurityGroupName = sourceSecurityGroupName }
        override fun sourceSecurityGroupOwnerId(sourceSecurityGroupOwnerId: String): FluentBuilder = apply { this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun toPort(toPort: Int): FluentBuilder = apply { this.toPort = toPort }
    }
}
