// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes Availability Zones, Local Zones, and Wavelength Zones.
 */
class AvailabilityZone private constructor(builder: BuilderImpl) {
    /**
     * For Availability Zones, this parameter has the same value as the Region name.
     * For Local Zones, the name of the associated group, for example
     * us-west-2-lax-1.
     * For Wavelength Zones, the name of the associated group, for example
     * us-east-1-wl1-bos-wlz-1.
     */
    val groupName: String? = builder.groupName
    /**
     * Any messages about the Availability Zone, Local Zone, or Wavelength Zone.
     */
    val messages: List<AvailabilityZoneMessage>? = builder.messages
    /**
     * The name of the network border group.
     */
    val networkBorderGroup: String? = builder.networkBorderGroup
    /**
     * For Availability Zones, this parameter always has the value of
     * opt-in-not-required.
     * For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible
     * values are opted-in, and not-opted-in.
     */
    val optInStatus: AvailabilityZoneOptInStatus? = builder.optInStatus
    /**
     * The ID of the zone that handles some of the Local Zone or Wavelength Zone control plane
     * operations, such as API calls.
     */
    val parentZoneId: String? = builder.parentZoneId
    /**
     * The name of the zone that handles some of the Local Zone or Wavelength Zone control plane
     * operations, such as API calls.
     */
    val parentZoneName: String? = builder.parentZoneName
    /**
     * The name of the Region.
     */
    val regionName: String? = builder.regionName
    /**
     * The state of the Availability Zone, Local Zone, or Wavelength Zone.
     */
    val state: AvailabilityZoneState? = builder.state
    /**
     * The ID of the Availability Zone, Local Zone, or Wavelength Zone.
     */
    val zoneId: String? = builder.zoneId
    /**
     * The name of the Availability Zone, Local Zone, or Wavelength Zone.
     */
    val zoneName: String? = builder.zoneName
    /**
     * The type of zone. The valid values are availability-zone,
     * local-zone, and wavelength-zone.
     */
    val zoneType: String? = builder.zoneType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AvailabilityZone = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AvailabilityZone(")
        append("groupName=$groupName,")
        append("messages=$messages,")
        append("networkBorderGroup=$networkBorderGroup,")
        append("optInStatus=$optInStatus,")
        append("parentZoneId=$parentZoneId,")
        append("parentZoneName=$parentZoneName,")
        append("regionName=$regionName,")
        append("state=$state,")
        append("zoneId=$zoneId,")
        append("zoneName=$zoneName,")
        append("zoneType=$zoneType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupName?.hashCode() ?: 0
        result = 31 * result + (messages?.hashCode() ?: 0)
        result = 31 * result + (networkBorderGroup?.hashCode() ?: 0)
        result = 31 * result + (optInStatus?.hashCode() ?: 0)
        result = 31 * result + (parentZoneId?.hashCode() ?: 0)
        result = 31 * result + (parentZoneName?.hashCode() ?: 0)
        result = 31 * result + (regionName?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (zoneId?.hashCode() ?: 0)
        result = 31 * result + (zoneName?.hashCode() ?: 0)
        result = 31 * result + (zoneType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AvailabilityZone

        if (groupName != other.groupName) return false
        if (messages != other.messages) return false
        if (networkBorderGroup != other.networkBorderGroup) return false
        if (optInStatus != other.optInStatus) return false
        if (parentZoneId != other.parentZoneId) return false
        if (parentZoneName != other.parentZoneName) return false
        if (regionName != other.regionName) return false
        if (state != other.state) return false
        if (zoneId != other.zoneId) return false
        if (zoneName != other.zoneName) return false
        if (zoneType != other.zoneType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AvailabilityZone = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AvailabilityZone
        /**
         * For Availability Zones, this parameter has the same value as the Region name.
         * For Local Zones, the name of the associated group, for example
         * us-west-2-lax-1.
         * For Wavelength Zones, the name of the associated group, for example
         * us-east-1-wl1-bos-wlz-1.
         */
        fun groupName(groupName: String): FluentBuilder
        /**
         * Any messages about the Availability Zone, Local Zone, or Wavelength Zone.
         */
        fun messages(messages: List<AvailabilityZoneMessage>): FluentBuilder
        /**
         * The name of the network border group.
         */
        fun networkBorderGroup(networkBorderGroup: String): FluentBuilder
        /**
         * For Availability Zones, this parameter always has the value of
         * opt-in-not-required.
         * For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible
         * values are opted-in, and not-opted-in.
         */
        fun optInStatus(optInStatus: AvailabilityZoneOptInStatus): FluentBuilder
        /**
         * The ID of the zone that handles some of the Local Zone or Wavelength Zone control plane
         * operations, such as API calls.
         */
        fun parentZoneId(parentZoneId: String): FluentBuilder
        /**
         * The name of the zone that handles some of the Local Zone or Wavelength Zone control plane
         * operations, such as API calls.
         */
        fun parentZoneName(parentZoneName: String): FluentBuilder
        /**
         * The name of the Region.
         */
        fun regionName(regionName: String): FluentBuilder
        /**
         * The state of the Availability Zone, Local Zone, or Wavelength Zone.
         */
        fun state(state: AvailabilityZoneState): FluentBuilder
        /**
         * The ID of the Availability Zone, Local Zone, or Wavelength Zone.
         */
        fun zoneId(zoneId: String): FluentBuilder
        /**
         * The name of the Availability Zone, Local Zone, or Wavelength Zone.
         */
        fun zoneName(zoneName: String): FluentBuilder
        /**
         * The type of zone. The valid values are availability-zone,
         * local-zone, and wavelength-zone.
         */
        fun zoneType(zoneType: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * For Availability Zones, this parameter has the same value as the Region name.
         * For Local Zones, the name of the associated group, for example
         * us-west-2-lax-1.
         * For Wavelength Zones, the name of the associated group, for example
         * us-east-1-wl1-bos-wlz-1.
         */
        var groupName: String?
        /**
         * Any messages about the Availability Zone, Local Zone, or Wavelength Zone.
         */
        var messages: List<AvailabilityZoneMessage>?
        /**
         * The name of the network border group.
         */
        var networkBorderGroup: String?
        /**
         * For Availability Zones, this parameter always has the value of
         * opt-in-not-required.
         * For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible
         * values are opted-in, and not-opted-in.
         */
        var optInStatus: AvailabilityZoneOptInStatus?
        /**
         * The ID of the zone that handles some of the Local Zone or Wavelength Zone control plane
         * operations, such as API calls.
         */
        var parentZoneId: String?
        /**
         * The name of the zone that handles some of the Local Zone or Wavelength Zone control plane
         * operations, such as API calls.
         */
        var parentZoneName: String?
        /**
         * The name of the Region.
         */
        var regionName: String?
        /**
         * The state of the Availability Zone, Local Zone, or Wavelength Zone.
         */
        var state: AvailabilityZoneState?
        /**
         * The ID of the Availability Zone, Local Zone, or Wavelength Zone.
         */
        var zoneId: String?
        /**
         * The name of the Availability Zone, Local Zone, or Wavelength Zone.
         */
        var zoneName: String?
        /**
         * The type of zone. The valid values are availability-zone,
         * local-zone, and wavelength-zone.
         */
        var zoneType: String?

        fun build(): AvailabilityZone
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var groupName: String? = null
        override var messages: List<AvailabilityZoneMessage>? = null
        override var networkBorderGroup: String? = null
        override var optInStatus: AvailabilityZoneOptInStatus? = null
        override var parentZoneId: String? = null
        override var parentZoneName: String? = null
        override var regionName: String? = null
        override var state: AvailabilityZoneState? = null
        override var zoneId: String? = null
        override var zoneName: String? = null
        override var zoneType: String? = null

        constructor(x: AvailabilityZone) : this() {
            this.groupName = x.groupName
            this.messages = x.messages
            this.networkBorderGroup = x.networkBorderGroup
            this.optInStatus = x.optInStatus
            this.parentZoneId = x.parentZoneId
            this.parentZoneName = x.parentZoneName
            this.regionName = x.regionName
            this.state = x.state
            this.zoneId = x.zoneId
            this.zoneName = x.zoneName
            this.zoneType = x.zoneType
        }

        override fun build(): AvailabilityZone = AvailabilityZone(this)
        override fun groupName(groupName: String): FluentBuilder = apply { this.groupName = groupName }
        override fun messages(messages: List<AvailabilityZoneMessage>): FluentBuilder = apply { this.messages = messages }
        override fun networkBorderGroup(networkBorderGroup: String): FluentBuilder = apply { this.networkBorderGroup = networkBorderGroup }
        override fun optInStatus(optInStatus: AvailabilityZoneOptInStatus): FluentBuilder = apply { this.optInStatus = optInStatus }
        override fun parentZoneId(parentZoneId: String): FluentBuilder = apply { this.parentZoneId = parentZoneId }
        override fun parentZoneName(parentZoneName: String): FluentBuilder = apply { this.parentZoneName = parentZoneName }
        override fun regionName(regionName: String): FluentBuilder = apply { this.regionName = regionName }
        override fun state(state: AvailabilityZoneState): FluentBuilder = apply { this.state = state }
        override fun zoneId(zoneId: String): FluentBuilder = apply { this.zoneId = zoneId }
        override fun zoneName(zoneName: String): FluentBuilder = apply { this.zoneName = zoneName }
        override fun zoneType(zoneType: String): FluentBuilder = apply { this.zoneType = zoneType }
    }
}
