// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The capacity information for instances that can be launched onto the Dedicated Host.
 */
class AvailableCapacity private constructor(builder: BuilderImpl) {
    /**
     * The number of instances that can be launched onto the Dedicated Host depending on
     * the host's available capacity. For Dedicated Hosts that support multiple instance types,
     * this parameter represents the number of instances for each instance size that is
     * supported on the host.
     */
    val availableInstanceCapacity: List<InstanceCapacity>? = builder.availableInstanceCapacity
    /**
     * The number of vCPUs available for launching instances onto the Dedicated Host.
     */
    val availableVCpus: Int? = builder.availableVCpus

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AvailableCapacity = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AvailableCapacity(")
        append("availableInstanceCapacity=$availableInstanceCapacity,")
        append("availableVCpus=$availableVCpus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availableInstanceCapacity?.hashCode() ?: 0
        result = 31 * result + (availableVCpus ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AvailableCapacity

        if (availableInstanceCapacity != other.availableInstanceCapacity) return false
        if (availableVCpus != other.availableVCpus) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AvailableCapacity = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AvailableCapacity
        /**
         * The number of instances that can be launched onto the Dedicated Host depending on
         * the host's available capacity. For Dedicated Hosts that support multiple instance types,
         * this parameter represents the number of instances for each instance size that is
         * supported on the host.
         */
        fun availableInstanceCapacity(availableInstanceCapacity: List<InstanceCapacity>): FluentBuilder
        /**
         * The number of vCPUs available for launching instances onto the Dedicated Host.
         */
        fun availableVCpus(availableVCpus: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of instances that can be launched onto the Dedicated Host depending on
         * the host's available capacity. For Dedicated Hosts that support multiple instance types,
         * this parameter represents the number of instances for each instance size that is
         * supported on the host.
         */
        var availableInstanceCapacity: List<InstanceCapacity>?
        /**
         * The number of vCPUs available for launching instances onto the Dedicated Host.
         */
        var availableVCpus: Int?

        fun build(): AvailableCapacity
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availableInstanceCapacity: List<InstanceCapacity>? = null
        override var availableVCpus: Int? = null

        constructor(x: AvailableCapacity) : this() {
            this.availableInstanceCapacity = x.availableInstanceCapacity
            this.availableVCpus = x.availableVCpus
        }

        override fun build(): AvailableCapacity = AvailableCapacity(this)
        override fun availableInstanceCapacity(availableInstanceCapacity: List<InstanceCapacity>): FluentBuilder = apply { this.availableInstanceCapacity = availableInstanceCapacity }
        override fun availableVCpus(availableVCpus: Int): FluentBuilder = apply { this.availableVCpus = availableVCpus }
    }
}
