// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for BundleInstance.
 */
class BundleInstanceRequest private constructor(builder: BuilderImpl) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The ID of the instance to bundle.
     * Type: String
     * Default: None
     * Required: Yes
     */
    val instanceId: String? = builder.instanceId
    /**
     * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.
     */
    val storage: Storage? = builder.storage

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BundleInstanceRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BundleInstanceRequest(")
        append("dryRun=$dryRun,")
        append("instanceId=$instanceId,")
        append("storage=$storage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (storage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BundleInstanceRequest

        if (dryRun != other.dryRun) return false
        if (instanceId != other.instanceId) return false
        if (storage != other.storage) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BundleInstanceRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BundleInstanceRequest
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The ID of the instance to bundle.
         * Type: String
         * Default: None
         * Required: Yes
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.
         */
        fun storage(storage: Storage): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The ID of the instance to bundle.
         * Type: String
         * Default: None
         * Required: Yes
         */
        var instanceId: String?
        /**
         * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.
         */
        var storage: Storage?

        fun build(): BundleInstanceRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.Storage] inside the given [block]
         */
        fun storage(block: Storage.DslBuilder.() -> kotlin.Unit) {
            this.storage = Storage.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dryRun: Boolean? = null
        override var instanceId: String? = null
        override var storage: Storage? = null

        constructor(x: BundleInstanceRequest) : this() {
            this.dryRun = x.dryRun
            this.instanceId = x.instanceId
            this.storage = x.storage
        }

        override fun build(): BundleInstanceRequest = BundleInstanceRequest(this)
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun storage(storage: Storage): FluentBuilder = apply { this.storage = storage }
    }
}
