// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a bundle task.
 */
class BundleTask private constructor(builder: BuilderImpl) {
    /**
     * The ID of the bundle task.
     */
    val bundleId: String? = builder.bundleId
    /**
     * If the task fails, a description of the error.
     */
    val bundleTaskError: BundleTaskError? = builder.bundleTaskError
    /**
     * The ID of the instance associated with this bundle task.
     */
    val instanceId: String? = builder.instanceId
    /**
     * The level of task completion, as a percent (for example, 20%).
     */
    val progress: String? = builder.progress
    /**
     * The time this task started.
     */
    val startTime: Instant? = builder.startTime
    /**
     * The state of the task.
     */
    val state: BundleTaskState? = builder.state
    /**
     * The Amazon S3 storage locations.
     */
    val storage: Storage? = builder.storage
    /**
     * The time of the most recent update for the task.
     */
    val updateTime: Instant? = builder.updateTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BundleTask = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BundleTask(")
        append("bundleId=$bundleId,")
        append("bundleTaskError=$bundleTaskError,")
        append("instanceId=$instanceId,")
        append("progress=$progress,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("storage=$storage,")
        append("updateTime=$updateTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bundleId?.hashCode() ?: 0
        result = 31 * result + (bundleTaskError?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (progress?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (storage?.hashCode() ?: 0)
        result = 31 * result + (updateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BundleTask

        if (bundleId != other.bundleId) return false
        if (bundleTaskError != other.bundleTaskError) return false
        if (instanceId != other.instanceId) return false
        if (progress != other.progress) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (storage != other.storage) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BundleTask = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BundleTask
        /**
         * The ID of the bundle task.
         */
        fun bundleId(bundleId: String): FluentBuilder
        /**
         * If the task fails, a description of the error.
         */
        fun bundleTaskError(bundleTaskError: BundleTaskError): FluentBuilder
        /**
         * The ID of the instance associated with this bundle task.
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * The level of task completion, as a percent (for example, 20%).
         */
        fun progress(progress: String): FluentBuilder
        /**
         * The time this task started.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * The state of the task.
         */
        fun state(state: BundleTaskState): FluentBuilder
        /**
         * The Amazon S3 storage locations.
         */
        fun storage(storage: Storage): FluentBuilder
        /**
         * The time of the most recent update for the task.
         */
        fun updateTime(updateTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the bundle task.
         */
        var bundleId: String?
        /**
         * If the task fails, a description of the error.
         */
        var bundleTaskError: BundleTaskError?
        /**
         * The ID of the instance associated with this bundle task.
         */
        var instanceId: String?
        /**
         * The level of task completion, as a percent (for example, 20%).
         */
        var progress: String?
        /**
         * The time this task started.
         */
        var startTime: Instant?
        /**
         * The state of the task.
         */
        var state: BundleTaskState?
        /**
         * The Amazon S3 storage locations.
         */
        var storage: Storage?
        /**
         * The time of the most recent update for the task.
         */
        var updateTime: Instant?

        fun build(): BundleTask
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.BundleTaskError] inside the given [block]
         */
        fun bundleTaskError(block: BundleTaskError.DslBuilder.() -> kotlin.Unit) {
            this.bundleTaskError = BundleTaskError.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.Storage] inside the given [block]
         */
        fun storage(block: Storage.DslBuilder.() -> kotlin.Unit) {
            this.storage = Storage.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bundleId: String? = null
        override var bundleTaskError: BundleTaskError? = null
        override var instanceId: String? = null
        override var progress: String? = null
        override var startTime: Instant? = null
        override var state: BundleTaskState? = null
        override var storage: Storage? = null
        override var updateTime: Instant? = null

        constructor(x: BundleTask) : this() {
            this.bundleId = x.bundleId
            this.bundleTaskError = x.bundleTaskError
            this.instanceId = x.instanceId
            this.progress = x.progress
            this.startTime = x.startTime
            this.state = x.state
            this.storage = x.storage
            this.updateTime = x.updateTime
        }

        override fun build(): BundleTask = BundleTask(this)
        override fun bundleId(bundleId: String): FluentBuilder = apply { this.bundleId = bundleId }
        override fun bundleTaskError(bundleTaskError: BundleTaskError): FluentBuilder = apply { this.bundleTaskError = bundleTaskError }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun progress(progress: String): FluentBuilder = apply { this.progress = progress }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun state(state: BundleTaskState): FluentBuilder = apply { this.state = state }
        override fun storage(storage: Storage): FluentBuilder = apply { this.storage = storage }
        override fun updateTime(updateTime: Instant): FluentBuilder = apply { this.updateTime = updateTime }
    }
}
