// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a Capacity Reservation.
 */
class CapacityReservation private constructor(builder: BuilderImpl) {
    /**
     * The Availability Zone in which the capacity is reserved.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The Availability Zone ID of the Capacity Reservation.
     */
    val availabilityZoneId: String? = builder.availabilityZoneId
    /**
     * The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.
     */
    val availableInstanceCount: Int? = builder.availableInstanceCount
    /**
     * The Amazon Resource Name (ARN) of the Capacity Reservation.
     */
    val capacityReservationArn: String? = builder.capacityReservationArn
    /**
     * The ID of the Capacity Reservation Fleet to which the Capacity Reservation belongs.
     * Only valid for Capacity Reservations that were created by a Capacity Reservation Fleet.
     */
    val capacityReservationFleetId: String? = builder.capacityReservationFleetId
    /**
     * The ID of the Capacity Reservation.
     */
    val capacityReservationId: String? = builder.capacityReservationId
    /**
     * The date and time at which the Capacity Reservation was created.
     */
    val createDate: Instant? = builder.createDate
    /**
     * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides
     * dedicated throughput to Amazon EBS and an optimized configuration stack to provide
     * optimal I/O performance. This optimization isn't available with all instance types.
     * Additional usage charges apply when using an EBS- optimized instance.
     */
    val ebsOptimized: Boolean? = builder.ebsOptimized
    /**
     * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity
     * is released and you can no longer launch instances into it. The Capacity Reservation's state changes to
     * expired when it reaches its end date and time.
     */
    val endDate: Instant? = builder.endDate
    /**
     * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end
     * types:
     * unlimited - The Capacity Reservation remains active until you explicitly cancel it.
     * limited - The Capacity Reservation expires automatically at a specified date and time.
     */
    val endDateType: EndDateType? = builder.endDateType
    /**
     * Indicates whether the Capacity Reservation supports instances with temporary, block-level
     * storage.
     */
    val ephemeralStorage: Boolean? = builder.ephemeralStorage
    /**
     * Indicates the type of instance launches that the Capacity Reservation accepts. The options
     * include:
     * open - The Capacity Reservation accepts all instances that have matching attributes (instance type, platform,
     * and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation automatically without specifying
     * any additional parameters.
     * targeted - The Capacity Reservation only accepts instances that have matching attributes
     * (instance type, platform, and Availability Zone), and explicitly target the
     * Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.
     */
    val instanceMatchCriteria: InstanceMatchCriteria? = builder.instanceMatchCriteria
    /**
     * The type of operating system for which the Capacity Reservation reserves capacity.
     */
    val instancePlatform: CapacityReservationInstancePlatform? = builder.instancePlatform
    /**
     * The type of instance for which the Capacity Reservation reserves capacity.
     */
    val instanceType: String? = builder.instanceType
    /**
     * The Amazon Resource Name (ARN) of the Outpost on which the Capacity
     * Reservation was created.
     */
    val outpostArn: String? = builder.outpostArn
    /**
     * The ID of the Amazon Web Services account that owns the Capacity Reservation.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The date and time at which the Capacity Reservation was started.
     */
    val startDate: Instant? = builder.startDate
    /**
     * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
     * active - The Capacity Reservation is active and the capacity is available for your use.
     * expired - The Capacity Reservation expired automatically at the date and time specified
     * in your request. The reserved capacity is no longer available for your use.
     * cancelled - The Capacity Reservation was cancelled. The reserved capacity is no
     * longer available for your use.
     * pending - The Capacity Reservation request was successful but the capacity
     * provisioning is still pending.
     * failed - The Capacity Reservation request has failed. A request might fail
     * due to invalid request parameters, capacity constraints, or instance limit constraints.
     * Failed requests are retained for 60 minutes.
     */
    val state: CapacityReservationState? = builder.state
    /**
     * Any tags assigned to the Capacity Reservation.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:
     * default - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.
     * dedicated - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.
     */
    val tenancy: CapacityReservationTenancy? = builder.tenancy
    /**
     * The total number of instances for which the Capacity Reservation reserves capacity.
     */
    val totalInstanceCount: Int? = builder.totalInstanceCount

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CapacityReservation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CapacityReservation(")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneId=$availabilityZoneId,")
        append("availableInstanceCount=$availableInstanceCount,")
        append("capacityReservationArn=$capacityReservationArn,")
        append("capacityReservationFleetId=$capacityReservationFleetId,")
        append("capacityReservationId=$capacityReservationId,")
        append("createDate=$createDate,")
        append("ebsOptimized=$ebsOptimized,")
        append("endDate=$endDate,")
        append("endDateType=$endDateType,")
        append("ephemeralStorage=$ephemeralStorage,")
        append("instanceMatchCriteria=$instanceMatchCriteria,")
        append("instancePlatform=$instancePlatform,")
        append("instanceType=$instanceType,")
        append("outpostArn=$outpostArn,")
        append("ownerId=$ownerId,")
        append("startDate=$startDate,")
        append("state=$state,")
        append("tags=$tags,")
        append("tenancy=$tenancy,")
        append("totalInstanceCount=$totalInstanceCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (availabilityZoneId?.hashCode() ?: 0)
        result = 31 * result + (availableInstanceCount ?: 0)
        result = 31 * result + (capacityReservationArn?.hashCode() ?: 0)
        result = 31 * result + (capacityReservationFleetId?.hashCode() ?: 0)
        result = 31 * result + (capacityReservationId?.hashCode() ?: 0)
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (endDate?.hashCode() ?: 0)
        result = 31 * result + (endDateType?.hashCode() ?: 0)
        result = 31 * result + (ephemeralStorage?.hashCode() ?: 0)
        result = 31 * result + (instanceMatchCriteria?.hashCode() ?: 0)
        result = 31 * result + (instancePlatform?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tenancy?.hashCode() ?: 0)
        result = 31 * result + (totalInstanceCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CapacityReservation

        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneId != other.availabilityZoneId) return false
        if (availableInstanceCount != other.availableInstanceCount) return false
        if (capacityReservationArn != other.capacityReservationArn) return false
        if (capacityReservationFleetId != other.capacityReservationFleetId) return false
        if (capacityReservationId != other.capacityReservationId) return false
        if (createDate != other.createDate) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (endDate != other.endDate) return false
        if (endDateType != other.endDateType) return false
        if (ephemeralStorage != other.ephemeralStorage) return false
        if (instanceMatchCriteria != other.instanceMatchCriteria) return false
        if (instancePlatform != other.instancePlatform) return false
        if (instanceType != other.instanceType) return false
        if (outpostArn != other.outpostArn) return false
        if (ownerId != other.ownerId) return false
        if (startDate != other.startDate) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (tenancy != other.tenancy) return false
        if (totalInstanceCount != other.totalInstanceCount) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CapacityReservation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CapacityReservation
        /**
         * The Availability Zone in which the capacity is reserved.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The Availability Zone ID of the Capacity Reservation.
         */
        fun availabilityZoneId(availabilityZoneId: String): FluentBuilder
        /**
         * The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.
         */
        fun availableInstanceCount(availableInstanceCount: Int): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Capacity Reservation.
         */
        fun capacityReservationArn(capacityReservationArn: String): FluentBuilder
        /**
         * The ID of the Capacity Reservation Fleet to which the Capacity Reservation belongs.
         * Only valid for Capacity Reservations that were created by a Capacity Reservation Fleet.
         */
        fun capacityReservationFleetId(capacityReservationFleetId: String): FluentBuilder
        /**
         * The ID of the Capacity Reservation.
         */
        fun capacityReservationId(capacityReservationId: String): FluentBuilder
        /**
         * The date and time at which the Capacity Reservation was created.
         */
        fun createDate(createDate: Instant): FluentBuilder
        /**
         * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides
         * dedicated throughput to Amazon EBS and an optimized configuration stack to provide
         * optimal I/O performance. This optimization isn't available with all instance types.
         * Additional usage charges apply when using an EBS- optimized instance.
         */
        fun ebsOptimized(ebsOptimized: Boolean): FluentBuilder
        /**
         * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity
         * is released and you can no longer launch instances into it. The Capacity Reservation's state changes to
         * expired when it reaches its end date and time.
         */
        fun endDate(endDate: Instant): FluentBuilder
        /**
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end
         * types:
         * unlimited - The Capacity Reservation remains active until you explicitly cancel it.
         * limited - The Capacity Reservation expires automatically at a specified date and time.
         */
        fun endDateType(endDateType: EndDateType): FluentBuilder
        /**
         * Indicates whether the Capacity Reservation supports instances with temporary, block-level
         * storage.
         */
        fun ephemeralStorage(ephemeralStorage: Boolean): FluentBuilder
        /**
         * Indicates the type of instance launches that the Capacity Reservation accepts. The options
         * include:
         * open - The Capacity Reservation accepts all instances that have matching attributes (instance type, platform,
         * and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation automatically without specifying
         * any additional parameters.
         * targeted - The Capacity Reservation only accepts instances that have matching attributes
         * (instance type, platform, and Availability Zone), and explicitly target the
         * Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.
         */
        fun instanceMatchCriteria(instanceMatchCriteria: InstanceMatchCriteria): FluentBuilder
        /**
         * The type of operating system for which the Capacity Reservation reserves capacity.
         */
        fun instancePlatform(instancePlatform: CapacityReservationInstancePlatform): FluentBuilder
        /**
         * The type of instance for which the Capacity Reservation reserves capacity.
         */
        fun instanceType(instanceType: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Outpost on which the Capacity
         * Reservation was created.
         */
        fun outpostArn(outpostArn: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the Capacity Reservation.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The date and time at which the Capacity Reservation was started.
         */
        fun startDate(startDate: Instant): FluentBuilder
        /**
         * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
         * active - The Capacity Reservation is active and the capacity is available for your use.
         * expired - The Capacity Reservation expired automatically at the date and time specified
         * in your request. The reserved capacity is no longer available for your use.
         * cancelled - The Capacity Reservation was cancelled. The reserved capacity is no
         * longer available for your use.
         * pending - The Capacity Reservation request was successful but the capacity
         * provisioning is still pending.
         * failed - The Capacity Reservation request has failed. A request might fail
         * due to invalid request parameters, capacity constraints, or instance limit constraints.
         * Failed requests are retained for 60 minutes.
         */
        fun state(state: CapacityReservationState): FluentBuilder
        /**
         * Any tags assigned to the Capacity Reservation.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:
         * default - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.
         * dedicated - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.
         */
        fun tenancy(tenancy: CapacityReservationTenancy): FluentBuilder
        /**
         * The total number of instances for which the Capacity Reservation reserves capacity.
         */
        fun totalInstanceCount(totalInstanceCount: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Availability Zone in which the capacity is reserved.
         */
        var availabilityZone: String?
        /**
         * The Availability Zone ID of the Capacity Reservation.
         */
        var availabilityZoneId: String?
        /**
         * The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.
         */
        var availableInstanceCount: Int?
        /**
         * The Amazon Resource Name (ARN) of the Capacity Reservation.
         */
        var capacityReservationArn: String?
        /**
         * The ID of the Capacity Reservation Fleet to which the Capacity Reservation belongs.
         * Only valid for Capacity Reservations that were created by a Capacity Reservation Fleet.
         */
        var capacityReservationFleetId: String?
        /**
         * The ID of the Capacity Reservation.
         */
        var capacityReservationId: String?
        /**
         * The date and time at which the Capacity Reservation was created.
         */
        var createDate: Instant?
        /**
         * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides
         * dedicated throughput to Amazon EBS and an optimized configuration stack to provide
         * optimal I/O performance. This optimization isn't available with all instance types.
         * Additional usage charges apply when using an EBS- optimized instance.
         */
        var ebsOptimized: Boolean?
        /**
         * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity
         * is released and you can no longer launch instances into it. The Capacity Reservation's state changes to
         * expired when it reaches its end date and time.
         */
        var endDate: Instant?
        /**
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end
         * types:
         * unlimited - The Capacity Reservation remains active until you explicitly cancel it.
         * limited - The Capacity Reservation expires automatically at a specified date and time.
         */
        var endDateType: EndDateType?
        /**
         * Indicates whether the Capacity Reservation supports instances with temporary, block-level
         * storage.
         */
        var ephemeralStorage: Boolean?
        /**
         * Indicates the type of instance launches that the Capacity Reservation accepts. The options
         * include:
         * open - The Capacity Reservation accepts all instances that have matching attributes (instance type, platform,
         * and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation automatically without specifying
         * any additional parameters.
         * targeted - The Capacity Reservation only accepts instances that have matching attributes
         * (instance type, platform, and Availability Zone), and explicitly target the
         * Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.
         */
        var instanceMatchCriteria: InstanceMatchCriteria?
        /**
         * The type of operating system for which the Capacity Reservation reserves capacity.
         */
        var instancePlatform: CapacityReservationInstancePlatform?
        /**
         * The type of instance for which the Capacity Reservation reserves capacity.
         */
        var instanceType: String?
        /**
         * The Amazon Resource Name (ARN) of the Outpost on which the Capacity
         * Reservation was created.
         */
        var outpostArn: String?
        /**
         * The ID of the Amazon Web Services account that owns the Capacity Reservation.
         */
        var ownerId: String?
        /**
         * The date and time at which the Capacity Reservation was started.
         */
        var startDate: Instant?
        /**
         * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
         * active - The Capacity Reservation is active and the capacity is available for your use.
         * expired - The Capacity Reservation expired automatically at the date and time specified
         * in your request. The reserved capacity is no longer available for your use.
         * cancelled - The Capacity Reservation was cancelled. The reserved capacity is no
         * longer available for your use.
         * pending - The Capacity Reservation request was successful but the capacity
         * provisioning is still pending.
         * failed - The Capacity Reservation request has failed. A request might fail
         * due to invalid request parameters, capacity constraints, or instance limit constraints.
         * Failed requests are retained for 60 minutes.
         */
        var state: CapacityReservationState?
        /**
         * Any tags assigned to the Capacity Reservation.
         */
        var tags: List<Tag>?
        /**
         * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:
         * default - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.
         * dedicated - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.
         */
        var tenancy: CapacityReservationTenancy?
        /**
         * The total number of instances for which the Capacity Reservation reserves capacity.
         */
        var totalInstanceCount: Int?

        fun build(): CapacityReservation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZone: String? = null
        override var availabilityZoneId: String? = null
        override var availableInstanceCount: Int? = null
        override var capacityReservationArn: String? = null
        override var capacityReservationFleetId: String? = null
        override var capacityReservationId: String? = null
        override var createDate: Instant? = null
        override var ebsOptimized: Boolean? = null
        override var endDate: Instant? = null
        override var endDateType: EndDateType? = null
        override var ephemeralStorage: Boolean? = null
        override var instanceMatchCriteria: InstanceMatchCriteria? = null
        override var instancePlatform: CapacityReservationInstancePlatform? = null
        override var instanceType: String? = null
        override var outpostArn: String? = null
        override var ownerId: String? = null
        override var startDate: Instant? = null
        override var state: CapacityReservationState? = null
        override var tags: List<Tag>? = null
        override var tenancy: CapacityReservationTenancy? = null
        override var totalInstanceCount: Int? = null

        constructor(x: CapacityReservation) : this() {
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneId = x.availabilityZoneId
            this.availableInstanceCount = x.availableInstanceCount
            this.capacityReservationArn = x.capacityReservationArn
            this.capacityReservationFleetId = x.capacityReservationFleetId
            this.capacityReservationId = x.capacityReservationId
            this.createDate = x.createDate
            this.ebsOptimized = x.ebsOptimized
            this.endDate = x.endDate
            this.endDateType = x.endDateType
            this.ephemeralStorage = x.ephemeralStorage
            this.instanceMatchCriteria = x.instanceMatchCriteria
            this.instancePlatform = x.instancePlatform
            this.instanceType = x.instanceType
            this.outpostArn = x.outpostArn
            this.ownerId = x.ownerId
            this.startDate = x.startDate
            this.state = x.state
            this.tags = x.tags
            this.tenancy = x.tenancy
            this.totalInstanceCount = x.totalInstanceCount
        }

        override fun build(): CapacityReservation = CapacityReservation(this)
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun availabilityZoneId(availabilityZoneId: String): FluentBuilder = apply { this.availabilityZoneId = availabilityZoneId }
        override fun availableInstanceCount(availableInstanceCount: Int): FluentBuilder = apply { this.availableInstanceCount = availableInstanceCount }
        override fun capacityReservationArn(capacityReservationArn: String): FluentBuilder = apply { this.capacityReservationArn = capacityReservationArn }
        override fun capacityReservationFleetId(capacityReservationFleetId: String): FluentBuilder = apply { this.capacityReservationFleetId = capacityReservationFleetId }
        override fun capacityReservationId(capacityReservationId: String): FluentBuilder = apply { this.capacityReservationId = capacityReservationId }
        override fun createDate(createDate: Instant): FluentBuilder = apply { this.createDate = createDate }
        override fun ebsOptimized(ebsOptimized: Boolean): FluentBuilder = apply { this.ebsOptimized = ebsOptimized }
        override fun endDate(endDate: Instant): FluentBuilder = apply { this.endDate = endDate }
        override fun endDateType(endDateType: EndDateType): FluentBuilder = apply { this.endDateType = endDateType }
        override fun ephemeralStorage(ephemeralStorage: Boolean): FluentBuilder = apply { this.ephemeralStorage = ephemeralStorage }
        override fun instanceMatchCriteria(instanceMatchCriteria: InstanceMatchCriteria): FluentBuilder = apply { this.instanceMatchCriteria = instanceMatchCriteria }
        override fun instancePlatform(instancePlatform: CapacityReservationInstancePlatform): FluentBuilder = apply { this.instancePlatform = instancePlatform }
        override fun instanceType(instanceType: String): FluentBuilder = apply { this.instanceType = instanceType }
        override fun outpostArn(outpostArn: String): FluentBuilder = apply { this.outpostArn = outpostArn }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun startDate(startDate: Instant): FluentBuilder = apply { this.startDate = startDate }
        override fun state(state: CapacityReservationState): FluentBuilder = apply { this.state = state }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun tenancy(tenancy: CapacityReservationTenancy): FluentBuilder = apply { this.tenancy = tenancy }
        override fun totalInstanceCount(totalInstanceCount: Int): FluentBuilder = apply { this.totalInstanceCount = totalInstanceCount }
    }
}
