// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the strategy for using unused Capacity Reservations for fulfilling On-Demand
 * capacity.
 * This strategy can only be used if the EC2 Fleet is of type
 * instant.
 * For more information about Capacity Reservations, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">On-Demand Capacity
 * Reservations in the Amazon EC2 User Guide. For examples of using
 * Capacity Reservations in an EC2 Fleet, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-examples.html">EC2 Fleet example
 * configurations in the Amazon EC2 User Guide.
 */
class CapacityReservationOptions private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.
     * If you specify use-capacity-reservations-first, the fleet uses unused
     * Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If
     * multiple instance pools have unused Capacity Reservations, the On-Demand allocation
     * strategy (lowest-price or prioritized) is applied. If the number
     * of unused Capacity Reservations is less than the On-Demand target capacity, the remaining
     * On-Demand target capacity is launched according to the On-Demand allocation strategy
     * (lowest-price or prioritized).
     * If you do not specify a value, the fleet fulfils the On-Demand capacity according to the
     * chosen On-Demand allocation strategy.
     */
    val usageStrategy: FleetCapacityReservationUsageStrategy? = builder.usageStrategy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CapacityReservationOptions = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CapacityReservationOptions(")
        append("usageStrategy=$usageStrategy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = usageStrategy?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CapacityReservationOptions

        if (usageStrategy != other.usageStrategy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CapacityReservationOptions = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CapacityReservationOptions
        /**
         * Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.
         * If you specify use-capacity-reservations-first, the fleet uses unused
         * Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If
         * multiple instance pools have unused Capacity Reservations, the On-Demand allocation
         * strategy (lowest-price or prioritized) is applied. If the number
         * of unused Capacity Reservations is less than the On-Demand target capacity, the remaining
         * On-Demand target capacity is launched according to the On-Demand allocation strategy
         * (lowest-price or prioritized).
         * If you do not specify a value, the fleet fulfils the On-Demand capacity according to the
         * chosen On-Demand allocation strategy.
         */
        fun usageStrategy(usageStrategy: FleetCapacityReservationUsageStrategy): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.
         * If you specify use-capacity-reservations-first, the fleet uses unused
         * Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If
         * multiple instance pools have unused Capacity Reservations, the On-Demand allocation
         * strategy (lowest-price or prioritized) is applied. If the number
         * of unused Capacity Reservations is less than the On-Demand target capacity, the remaining
         * On-Demand target capacity is launched according to the On-Demand allocation strategy
         * (lowest-price or prioritized).
         * If you do not specify a value, the fleet fulfils the On-Demand capacity according to the
         * chosen On-Demand allocation strategy.
         */
        var usageStrategy: FleetCapacityReservationUsageStrategy?

        fun build(): CapacityReservationOptions
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var usageStrategy: FleetCapacityReservationUsageStrategy? = null

        constructor(x: CapacityReservationOptions) : this() {
            this.usageStrategy = x.usageStrategy
        }

        override fun build(): CapacityReservationOptions = CapacityReservationOptions(this)
        override fun usageStrategy(usageStrategy: FleetCapacityReservationUsageStrategy): FluentBuilder = apply { this.usageStrategy = usageStrategy }
    }
}
