// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Provides authorization for Amazon to bring a specific IP address range to a specific
 * Amazon Web Services account using bring your own IP addresses (BYOIP). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#prepare-for-byoip">Configuring your BYOIP address range in the Amazon Elastic Compute Cloud User Guide.
 */
class CidrAuthorizationContext private constructor(builder: BuilderImpl) {
    /**
     * The plain-text authorization message for the prefix and account.
     */
    val message: String? = builder.message
    /**
     * The signed authorization message for the prefix and account.
     */
    val signature: String? = builder.signature

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CidrAuthorizationContext = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CidrAuthorizationContext(")
        append("message=$message,")
        append("signature=$signature)")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (signature?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CidrAuthorizationContext

        if (message != other.message) return false
        if (signature != other.signature) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CidrAuthorizationContext = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CidrAuthorizationContext
        /**
         * The plain-text authorization message for the prefix and account.
         */
        fun message(message: String): FluentBuilder
        /**
         * The signed authorization message for the prefix and account.
         */
        fun signature(signature: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The plain-text authorization message for the prefix and account.
         */
        var message: String?
        /**
         * The signed authorization message for the prefix and account.
         */
        var signature: String?

        fun build(): CidrAuthorizationContext
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var message: String? = null
        override var signature: String? = null

        constructor(x: CidrAuthorizationContext) : this() {
            this.message = x.message
            this.signature = x.signature
        }

        override fun build(): CidrAuthorizationContext = CidrAuthorizationContext(this)
        override fun message(message: String): FluentBuilder = apply { this.message = message }
        override fun signature(signature: String): FluentBuilder = apply { this.signature = signature }
    }
}
