// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the authentication methods used by a Client VPN endpoint. For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/client-authentication.html">Authentication
 * in the Client VPN Administrator Guide.
 */
class ClientVpnAuthentication private constructor(builder: BuilderImpl) {
    /**
     * Information about the Active Directory, if applicable.
     */
    val activeDirectory: DirectoryServiceAuthentication? = builder.activeDirectory
    /**
     * Information about the IAM SAML identity provider, if applicable.
     */
    val federatedAuthentication: FederatedAuthentication? = builder.federatedAuthentication
    /**
     * Information about the authentication certificates, if applicable.
     */
    val mutualAuthentication: CertificateAuthentication? = builder.mutualAuthentication
    /**
     * The authentication type used.
     */
    val type: ClientVpnAuthenticationType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ClientVpnAuthentication = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ClientVpnAuthentication(")
        append("activeDirectory=$activeDirectory,")
        append("federatedAuthentication=$federatedAuthentication,")
        append("mutualAuthentication=$mutualAuthentication,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeDirectory?.hashCode() ?: 0
        result = 31 * result + (federatedAuthentication?.hashCode() ?: 0)
        result = 31 * result + (mutualAuthentication?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ClientVpnAuthentication

        if (activeDirectory != other.activeDirectory) return false
        if (federatedAuthentication != other.federatedAuthentication) return false
        if (mutualAuthentication != other.mutualAuthentication) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ClientVpnAuthentication = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ClientVpnAuthentication
        /**
         * Information about the Active Directory, if applicable.
         */
        fun activeDirectory(activeDirectory: DirectoryServiceAuthentication): FluentBuilder
        /**
         * Information about the IAM SAML identity provider, if applicable.
         */
        fun federatedAuthentication(federatedAuthentication: FederatedAuthentication): FluentBuilder
        /**
         * Information about the authentication certificates, if applicable.
         */
        fun mutualAuthentication(mutualAuthentication: CertificateAuthentication): FluentBuilder
        /**
         * The authentication type used.
         */
        fun type(type: ClientVpnAuthenticationType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information about the Active Directory, if applicable.
         */
        var activeDirectory: DirectoryServiceAuthentication?
        /**
         * Information about the IAM SAML identity provider, if applicable.
         */
        var federatedAuthentication: FederatedAuthentication?
        /**
         * Information about the authentication certificates, if applicable.
         */
        var mutualAuthentication: CertificateAuthentication?
        /**
         * The authentication type used.
         */
        var type: ClientVpnAuthenticationType?

        fun build(): ClientVpnAuthentication
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.DirectoryServiceAuthentication] inside the given [block]
         */
        fun activeDirectory(block: DirectoryServiceAuthentication.DslBuilder.() -> kotlin.Unit) {
            this.activeDirectory = DirectoryServiceAuthentication.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.FederatedAuthentication] inside the given [block]
         */
        fun federatedAuthentication(block: FederatedAuthentication.DslBuilder.() -> kotlin.Unit) {
            this.federatedAuthentication = FederatedAuthentication.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.CertificateAuthentication] inside the given [block]
         */
        fun mutualAuthentication(block: CertificateAuthentication.DslBuilder.() -> kotlin.Unit) {
            this.mutualAuthentication = CertificateAuthentication.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var activeDirectory: DirectoryServiceAuthentication? = null
        override var federatedAuthentication: FederatedAuthentication? = null
        override var mutualAuthentication: CertificateAuthentication? = null
        override var type: ClientVpnAuthenticationType? = null

        constructor(x: ClientVpnAuthentication) : this() {
            this.activeDirectory = x.activeDirectory
            this.federatedAuthentication = x.federatedAuthentication
            this.mutualAuthentication = x.mutualAuthentication
            this.type = x.type
        }

        override fun build(): ClientVpnAuthentication = ClientVpnAuthentication(this)
        override fun activeDirectory(activeDirectory: DirectoryServiceAuthentication): FluentBuilder = apply { this.activeDirectory = activeDirectory }
        override fun federatedAuthentication(federatedAuthentication: FederatedAuthentication): FluentBuilder = apply { this.federatedAuthentication = federatedAuthentication }
        override fun mutualAuthentication(mutualAuthentication: CertificateAuthentication): FluentBuilder = apply { this.mutualAuthentication = mutualAuthentication }
        override fun type(type: ClientVpnAuthenticationType): FluentBuilder = apply { this.type = type }
    }
}
