// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the authentication method to be used by a Client VPN endpoint. For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/authentication-authrization.html#client-authentication">Authentication
 * in the Client VPN Administrator Guide.
 */
class ClientVpnAuthenticationRequest private constructor(builder: BuilderImpl) {
    /**
     * Information about the Active Directory to be used, if applicable. You must provide this information if Type is directory-service-authentication.
     */
    val activeDirectory: DirectoryServiceAuthenticationRequest? = builder.activeDirectory
    /**
     * Information about the IAM SAML identity provider to be used, if applicable. You must provide this information if Type is federated-authentication.
     */
    val federatedAuthentication: FederatedAuthenticationRequest? = builder.federatedAuthentication
    /**
     * Information about the authentication certificates to be used, if applicable. You must provide this information if Type is certificate-authentication.
     */
    val mutualAuthentication: CertificateAuthenticationRequest? = builder.mutualAuthentication
    /**
     * The type of client authentication to be used.
     */
    val type: ClientVpnAuthenticationType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ClientVpnAuthenticationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ClientVpnAuthenticationRequest(")
        append("activeDirectory=$activeDirectory,")
        append("federatedAuthentication=$federatedAuthentication,")
        append("mutualAuthentication=$mutualAuthentication,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeDirectory?.hashCode() ?: 0
        result = 31 * result + (federatedAuthentication?.hashCode() ?: 0)
        result = 31 * result + (mutualAuthentication?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ClientVpnAuthenticationRequest

        if (activeDirectory != other.activeDirectory) return false
        if (federatedAuthentication != other.federatedAuthentication) return false
        if (mutualAuthentication != other.mutualAuthentication) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ClientVpnAuthenticationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ClientVpnAuthenticationRequest
        /**
         * Information about the Active Directory to be used, if applicable. You must provide this information if Type is directory-service-authentication.
         */
        fun activeDirectory(activeDirectory: DirectoryServiceAuthenticationRequest): FluentBuilder
        /**
         * Information about the IAM SAML identity provider to be used, if applicable. You must provide this information if Type is federated-authentication.
         */
        fun federatedAuthentication(federatedAuthentication: FederatedAuthenticationRequest): FluentBuilder
        /**
         * Information about the authentication certificates to be used, if applicable. You must provide this information if Type is certificate-authentication.
         */
        fun mutualAuthentication(mutualAuthentication: CertificateAuthenticationRequest): FluentBuilder
        /**
         * The type of client authentication to be used.
         */
        fun type(type: ClientVpnAuthenticationType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information about the Active Directory to be used, if applicable. You must provide this information if Type is directory-service-authentication.
         */
        var activeDirectory: DirectoryServiceAuthenticationRequest?
        /**
         * Information about the IAM SAML identity provider to be used, if applicable. You must provide this information if Type is federated-authentication.
         */
        var federatedAuthentication: FederatedAuthenticationRequest?
        /**
         * Information about the authentication certificates to be used, if applicable. You must provide this information if Type is certificate-authentication.
         */
        var mutualAuthentication: CertificateAuthenticationRequest?
        /**
         * The type of client authentication to be used.
         */
        var type: ClientVpnAuthenticationType?

        fun build(): ClientVpnAuthenticationRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.DirectoryServiceAuthenticationRequest] inside the given [block]
         */
        fun activeDirectory(block: DirectoryServiceAuthenticationRequest.DslBuilder.() -> kotlin.Unit) {
            this.activeDirectory = DirectoryServiceAuthenticationRequest.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.FederatedAuthenticationRequest] inside the given [block]
         */
        fun federatedAuthentication(block: FederatedAuthenticationRequest.DslBuilder.() -> kotlin.Unit) {
            this.federatedAuthentication = FederatedAuthenticationRequest.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.CertificateAuthenticationRequest] inside the given [block]
         */
        fun mutualAuthentication(block: CertificateAuthenticationRequest.DslBuilder.() -> kotlin.Unit) {
            this.mutualAuthentication = CertificateAuthenticationRequest.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var activeDirectory: DirectoryServiceAuthenticationRequest? = null
        override var federatedAuthentication: FederatedAuthenticationRequest? = null
        override var mutualAuthentication: CertificateAuthenticationRequest? = null
        override var type: ClientVpnAuthenticationType? = null

        constructor(x: ClientVpnAuthenticationRequest) : this() {
            this.activeDirectory = x.activeDirectory
            this.federatedAuthentication = x.federatedAuthentication
            this.mutualAuthentication = x.mutualAuthentication
            this.type = x.type
        }

        override fun build(): ClientVpnAuthenticationRequest = ClientVpnAuthenticationRequest(this)
        override fun activeDirectory(activeDirectory: DirectoryServiceAuthenticationRequest): FluentBuilder = apply { this.activeDirectory = activeDirectory }
        override fun federatedAuthentication(federatedAuthentication: FederatedAuthenticationRequest): FluentBuilder = apply { this.federatedAuthentication = federatedAuthentication }
        override fun mutualAuthentication(mutualAuthentication: CertificateAuthenticationRequest): FluentBuilder = apply { this.mutualAuthentication = mutualAuthentication }
        override fun type(type: ClientVpnAuthenticationType): FluentBuilder = apply { this.type = type }
    }
}
