// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a client connection.
 */
class ClientVpnConnection private constructor(builder: BuilderImpl) {
    /**
     * The IP address of the client.
     */
    val clientIp: String? = builder.clientIp
    /**
     * The ID of the Client VPN endpoint to which the client is connected.
     */
    val clientVpnEndpointId: String? = builder.clientVpnEndpointId
    /**
     * The common name associated with the client. This is either the name of the client certificate,
     * or the Active Directory user name.
     */
    val commonName: String? = builder.commonName
    /**
     * The date and time the client connection was terminated.
     */
    val connectionEndTime: String? = builder.connectionEndTime
    /**
     * The date and time the client connection was established.
     */
    val connectionEstablishedTime: String? = builder.connectionEstablishedTime
    /**
     * The ID of the client connection.
     */
    val connectionId: String? = builder.connectionId
    /**
     * The number of bytes received by the client.
     */
    val egressBytes: String? = builder.egressBytes
    /**
     * The number of packets received by the client.
     */
    val egressPackets: String? = builder.egressPackets
    /**
     * The number of bytes sent by the client.
     */
    val ingressBytes: String? = builder.ingressBytes
    /**
     * The number of packets sent by the client.
     */
    val ingressPackets: String? = builder.ingressPackets
    /**
     * The statuses returned by the client connect handler for posture compliance, if applicable.
     */
    val postureComplianceStatuses: List<String>? = builder.postureComplianceStatuses
    /**
     * The current state of the client connection.
     */
    val status: ClientVpnConnectionStatus? = builder.status
    /**
     * The current date and time.
     */
    val timestamp: String? = builder.timestamp
    /**
     * The username of the client who established the client connection. This information is only provided
     * if Active Directory client authentication is used.
     */
    val username: String? = builder.username

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ClientVpnConnection = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ClientVpnConnection(")
        append("clientIp=$clientIp,")
        append("clientVpnEndpointId=$clientVpnEndpointId,")
        append("commonName=$commonName,")
        append("connectionEndTime=$connectionEndTime,")
        append("connectionEstablishedTime=$connectionEstablishedTime,")
        append("connectionId=$connectionId,")
        append("egressBytes=$egressBytes,")
        append("egressPackets=$egressPackets,")
        append("ingressBytes=$ingressBytes,")
        append("ingressPackets=$ingressPackets,")
        append("postureComplianceStatuses=$postureComplianceStatuses,")
        append("status=$status,")
        append("timestamp=$timestamp,")
        append("username=$username)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientIp?.hashCode() ?: 0
        result = 31 * result + (clientVpnEndpointId?.hashCode() ?: 0)
        result = 31 * result + (commonName?.hashCode() ?: 0)
        result = 31 * result + (connectionEndTime?.hashCode() ?: 0)
        result = 31 * result + (connectionEstablishedTime?.hashCode() ?: 0)
        result = 31 * result + (connectionId?.hashCode() ?: 0)
        result = 31 * result + (egressBytes?.hashCode() ?: 0)
        result = 31 * result + (egressPackets?.hashCode() ?: 0)
        result = 31 * result + (ingressBytes?.hashCode() ?: 0)
        result = 31 * result + (ingressPackets?.hashCode() ?: 0)
        result = 31 * result + (postureComplianceStatuses?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ClientVpnConnection

        if (clientIp != other.clientIp) return false
        if (clientVpnEndpointId != other.clientVpnEndpointId) return false
        if (commonName != other.commonName) return false
        if (connectionEndTime != other.connectionEndTime) return false
        if (connectionEstablishedTime != other.connectionEstablishedTime) return false
        if (connectionId != other.connectionId) return false
        if (egressBytes != other.egressBytes) return false
        if (egressPackets != other.egressPackets) return false
        if (ingressBytes != other.ingressBytes) return false
        if (ingressPackets != other.ingressPackets) return false
        if (postureComplianceStatuses != other.postureComplianceStatuses) return false
        if (status != other.status) return false
        if (timestamp != other.timestamp) return false
        if (username != other.username) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ClientVpnConnection = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ClientVpnConnection
        /**
         * The IP address of the client.
         */
        fun clientIp(clientIp: String): FluentBuilder
        /**
         * The ID of the Client VPN endpoint to which the client is connected.
         */
        fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder
        /**
         * The common name associated with the client. This is either the name of the client certificate,
         * or the Active Directory user name.
         */
        fun commonName(commonName: String): FluentBuilder
        /**
         * The date and time the client connection was terminated.
         */
        fun connectionEndTime(connectionEndTime: String): FluentBuilder
        /**
         * The date and time the client connection was established.
         */
        fun connectionEstablishedTime(connectionEstablishedTime: String): FluentBuilder
        /**
         * The ID of the client connection.
         */
        fun connectionId(connectionId: String): FluentBuilder
        /**
         * The number of bytes received by the client.
         */
        fun egressBytes(egressBytes: String): FluentBuilder
        /**
         * The number of packets received by the client.
         */
        fun egressPackets(egressPackets: String): FluentBuilder
        /**
         * The number of bytes sent by the client.
         */
        fun ingressBytes(ingressBytes: String): FluentBuilder
        /**
         * The number of packets sent by the client.
         */
        fun ingressPackets(ingressPackets: String): FluentBuilder
        /**
         * The statuses returned by the client connect handler for posture compliance, if applicable.
         */
        fun postureComplianceStatuses(postureComplianceStatuses: List<String>): FluentBuilder
        /**
         * The current state of the client connection.
         */
        fun status(status: ClientVpnConnectionStatus): FluentBuilder
        /**
         * The current date and time.
         */
        fun timestamp(timestamp: String): FluentBuilder
        /**
         * The username of the client who established the client connection. This information is only provided
         * if Active Directory client authentication is used.
         */
        fun username(username: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The IP address of the client.
         */
        var clientIp: String?
        /**
         * The ID of the Client VPN endpoint to which the client is connected.
         */
        var clientVpnEndpointId: String?
        /**
         * The common name associated with the client. This is either the name of the client certificate,
         * or the Active Directory user name.
         */
        var commonName: String?
        /**
         * The date and time the client connection was terminated.
         */
        var connectionEndTime: String?
        /**
         * The date and time the client connection was established.
         */
        var connectionEstablishedTime: String?
        /**
         * The ID of the client connection.
         */
        var connectionId: String?
        /**
         * The number of bytes received by the client.
         */
        var egressBytes: String?
        /**
         * The number of packets received by the client.
         */
        var egressPackets: String?
        /**
         * The number of bytes sent by the client.
         */
        var ingressBytes: String?
        /**
         * The number of packets sent by the client.
         */
        var ingressPackets: String?
        /**
         * The statuses returned by the client connect handler for posture compliance, if applicable.
         */
        var postureComplianceStatuses: List<String>?
        /**
         * The current state of the client connection.
         */
        var status: ClientVpnConnectionStatus?
        /**
         * The current date and time.
         */
        var timestamp: String?
        /**
         * The username of the client who established the client connection. This information is only provided
         * if Active Directory client authentication is used.
         */
        var username: String?

        fun build(): ClientVpnConnection
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ClientVpnConnectionStatus] inside the given [block]
         */
        fun status(block: ClientVpnConnectionStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = ClientVpnConnectionStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientIp: String? = null
        override var clientVpnEndpointId: String? = null
        override var commonName: String? = null
        override var connectionEndTime: String? = null
        override var connectionEstablishedTime: String? = null
        override var connectionId: String? = null
        override var egressBytes: String? = null
        override var egressPackets: String? = null
        override var ingressBytes: String? = null
        override var ingressPackets: String? = null
        override var postureComplianceStatuses: List<String>? = null
        override var status: ClientVpnConnectionStatus? = null
        override var timestamp: String? = null
        override var username: String? = null

        constructor(x: ClientVpnConnection) : this() {
            this.clientIp = x.clientIp
            this.clientVpnEndpointId = x.clientVpnEndpointId
            this.commonName = x.commonName
            this.connectionEndTime = x.connectionEndTime
            this.connectionEstablishedTime = x.connectionEstablishedTime
            this.connectionId = x.connectionId
            this.egressBytes = x.egressBytes
            this.egressPackets = x.egressPackets
            this.ingressBytes = x.ingressBytes
            this.ingressPackets = x.ingressPackets
            this.postureComplianceStatuses = x.postureComplianceStatuses
            this.status = x.status
            this.timestamp = x.timestamp
            this.username = x.username
        }

        override fun build(): ClientVpnConnection = ClientVpnConnection(this)
        override fun clientIp(clientIp: String): FluentBuilder = apply { this.clientIp = clientIp }
        override fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder = apply { this.clientVpnEndpointId = clientVpnEndpointId }
        override fun commonName(commonName: String): FluentBuilder = apply { this.commonName = commonName }
        override fun connectionEndTime(connectionEndTime: String): FluentBuilder = apply { this.connectionEndTime = connectionEndTime }
        override fun connectionEstablishedTime(connectionEstablishedTime: String): FluentBuilder = apply { this.connectionEstablishedTime = connectionEstablishedTime }
        override fun connectionId(connectionId: String): FluentBuilder = apply { this.connectionId = connectionId }
        override fun egressBytes(egressBytes: String): FluentBuilder = apply { this.egressBytes = egressBytes }
        override fun egressPackets(egressPackets: String): FluentBuilder = apply { this.egressPackets = egressPackets }
        override fun ingressBytes(ingressBytes: String): FluentBuilder = apply { this.ingressBytes = ingressBytes }
        override fun ingressPackets(ingressPackets: String): FluentBuilder = apply { this.ingressPackets = ingressPackets }
        override fun postureComplianceStatuses(postureComplianceStatuses: List<String>): FluentBuilder = apply { this.postureComplianceStatuses = postureComplianceStatuses }
        override fun status(status: ClientVpnConnectionStatus): FluentBuilder = apply { this.status = status }
        override fun timestamp(timestamp: String): FluentBuilder = apply { this.timestamp = timestamp }
        override fun username(username: String): FluentBuilder = apply { this.username = username }
    }
}
