// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a Client VPN endpoint.
 */
class ClientVpnEndpoint private constructor(builder: BuilderImpl) {
    /**
     * Information about the associated target networks. A target network is a subnet in a VPC.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val associatedTargetNetworks: List<AssociatedTargetNetwork>? = builder.associatedTargetNetworks
    /**
     * Information about the authentication method used by the Client VPN endpoint.
     */
    val authenticationOptions: List<ClientVpnAuthentication>? = builder.authenticationOptions
    /**
     * The IPv4 address range, in CIDR notation, from which client IP addresses are assigned.
     */
    val clientCidrBlock: String? = builder.clientCidrBlock
    /**
     * The options for managing connection authorization for new client connections.
     */
    val clientConnectOptions: ClientConnectResponseOptions? = builder.clientConnectOptions
    /**
     * The ID of the Client VPN endpoint.
     */
    val clientVpnEndpointId: String? = builder.clientVpnEndpointId
    /**
     * Information about the client connection logging options for the Client VPN endpoint.
     */
    val connectionLogOptions: ConnectionLogResponseOptions? = builder.connectionLogOptions
    /**
     * The date and time the Client VPN endpoint was created.
     */
    val creationTime: String? = builder.creationTime
    /**
     * The date and time the Client VPN endpoint was deleted, if applicable.
     */
    val deletionTime: String? = builder.deletionTime
    /**
     * A brief description of the endpoint.
     */
    val description: String? = builder.description
    /**
     * The DNS name to be used by clients when connecting to the Client VPN endpoint.
     */
    val dnsName: String? = builder.dnsName
    /**
     * Information about the DNS servers to be used for DNS resolution.
     */
    val dnsServers: List<String>? = builder.dnsServers
    /**
     * The IDs of the security groups for the target network.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The URL of the self-service portal.
     */
    val selfServicePortalUrl: String? = builder.selfServicePortalUrl
    /**
     * The ARN of the server certificate.
     */
    val serverCertificateArn: String? = builder.serverCertificateArn
    /**
     * Indicates whether split-tunnel is enabled in the Client VPN endpoint.
     * For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-Tunnel Client VPN endpoint
     * in the Client VPN Administrator Guide.
     */
    val splitTunnel: Boolean? = builder.splitTunnel
    /**
     * The current state of the Client VPN endpoint.
     */
    val status: ClientVpnEndpointStatus? = builder.status
    /**
     * Any tags assigned to the Client VPN endpoint.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The transport protocol used by the Client VPN endpoint.
     */
    val transportProtocol: TransportProtocol? = builder.transportProtocol
    /**
     * The ID of the VPC.
     */
    val vpcId: String? = builder.vpcId
    /**
     * The port number for the  Client VPN endpoint.
     */
    val vpnPort: Int? = builder.vpnPort
    /**
     * The protocol used by the VPN session.
     */
    val vpnProtocol: VpnProtocol? = builder.vpnProtocol

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ClientVpnEndpoint = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ClientVpnEndpoint(")
        append("associatedTargetNetworks=$associatedTargetNetworks,")
        append("authenticationOptions=$authenticationOptions,")
        append("clientCidrBlock=$clientCidrBlock,")
        append("clientConnectOptions=$clientConnectOptions,")
        append("clientVpnEndpointId=$clientVpnEndpointId,")
        append("connectionLogOptions=$connectionLogOptions,")
        append("creationTime=$creationTime,")
        append("deletionTime=$deletionTime,")
        append("description=$description,")
        append("dnsName=$dnsName,")
        append("dnsServers=$dnsServers,")
        append("securityGroupIds=$securityGroupIds,")
        append("selfServicePortalUrl=$selfServicePortalUrl,")
        append("serverCertificateArn=$serverCertificateArn,")
        append("splitTunnel=$splitTunnel,")
        append("status=$status,")
        append("tags=$tags,")
        append("transportProtocol=$transportProtocol,")
        append("vpcId=$vpcId,")
        append("vpnPort=$vpnPort,")
        append("vpnProtocol=$vpnProtocol)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedTargetNetworks?.hashCode() ?: 0
        result = 31 * result + (authenticationOptions?.hashCode() ?: 0)
        result = 31 * result + (clientCidrBlock?.hashCode() ?: 0)
        result = 31 * result + (clientConnectOptions?.hashCode() ?: 0)
        result = 31 * result + (clientVpnEndpointId?.hashCode() ?: 0)
        result = 31 * result + (connectionLogOptions?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (deletionTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dnsName?.hashCode() ?: 0)
        result = 31 * result + (dnsServers?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (selfServicePortalUrl?.hashCode() ?: 0)
        result = 31 * result + (serverCertificateArn?.hashCode() ?: 0)
        result = 31 * result + (splitTunnel?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (transportProtocol?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        result = 31 * result + (vpnPort ?: 0)
        result = 31 * result + (vpnProtocol?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ClientVpnEndpoint

        if (associatedTargetNetworks != other.associatedTargetNetworks) return false
        if (authenticationOptions != other.authenticationOptions) return false
        if (clientCidrBlock != other.clientCidrBlock) return false
        if (clientConnectOptions != other.clientConnectOptions) return false
        if (clientVpnEndpointId != other.clientVpnEndpointId) return false
        if (connectionLogOptions != other.connectionLogOptions) return false
        if (creationTime != other.creationTime) return false
        if (deletionTime != other.deletionTime) return false
        if (description != other.description) return false
        if (dnsName != other.dnsName) return false
        if (dnsServers != other.dnsServers) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (selfServicePortalUrl != other.selfServicePortalUrl) return false
        if (serverCertificateArn != other.serverCertificateArn) return false
        if (splitTunnel != other.splitTunnel) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (transportProtocol != other.transportProtocol) return false
        if (vpcId != other.vpcId) return false
        if (vpnPort != other.vpnPort) return false
        if (vpnProtocol != other.vpnProtocol) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ClientVpnEndpoint = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ClientVpnEndpoint
        /**
         * Information about the associated target networks. A target network is a subnet in a VPC.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        fun associatedTargetNetworks(associatedTargetNetworks: List<AssociatedTargetNetwork>): FluentBuilder
        /**
         * Information about the authentication method used by the Client VPN endpoint.
         */
        fun authenticationOptions(authenticationOptions: List<ClientVpnAuthentication>): FluentBuilder
        /**
         * The IPv4 address range, in CIDR notation, from which client IP addresses are assigned.
         */
        fun clientCidrBlock(clientCidrBlock: String): FluentBuilder
        /**
         * The options for managing connection authorization for new client connections.
         */
        fun clientConnectOptions(clientConnectOptions: ClientConnectResponseOptions): FluentBuilder
        /**
         * The ID of the Client VPN endpoint.
         */
        fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder
        /**
         * Information about the client connection logging options for the Client VPN endpoint.
         */
        fun connectionLogOptions(connectionLogOptions: ConnectionLogResponseOptions): FluentBuilder
        /**
         * The date and time the Client VPN endpoint was created.
         */
        fun creationTime(creationTime: String): FluentBuilder
        /**
         * The date and time the Client VPN endpoint was deleted, if applicable.
         */
        fun deletionTime(deletionTime: String): FluentBuilder
        /**
         * A brief description of the endpoint.
         */
        fun description(description: String): FluentBuilder
        /**
         * The DNS name to be used by clients when connecting to the Client VPN endpoint.
         */
        fun dnsName(dnsName: String): FluentBuilder
        /**
         * Information about the DNS servers to be used for DNS resolution.
         */
        fun dnsServers(dnsServers: List<String>): FluentBuilder
        /**
         * The IDs of the security groups for the target network.
         */
        fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder
        /**
         * The URL of the self-service portal.
         */
        fun selfServicePortalUrl(selfServicePortalUrl: String): FluentBuilder
        /**
         * The ARN of the server certificate.
         */
        fun serverCertificateArn(serverCertificateArn: String): FluentBuilder
        /**
         * Indicates whether split-tunnel is enabled in the Client VPN endpoint.
         * For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-Tunnel Client VPN endpoint
         * in the Client VPN Administrator Guide.
         */
        fun splitTunnel(splitTunnel: Boolean): FluentBuilder
        /**
         * The current state of the Client VPN endpoint.
         */
        fun status(status: ClientVpnEndpointStatus): FluentBuilder
        /**
         * Any tags assigned to the Client VPN endpoint.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The transport protocol used by the Client VPN endpoint.
         */
        fun transportProtocol(transportProtocol: TransportProtocol): FluentBuilder
        /**
         * The ID of the VPC.
         */
        fun vpcId(vpcId: String): FluentBuilder
        /**
         * The port number for the  Client VPN endpoint.
         */
        fun vpnPort(vpnPort: Int): FluentBuilder
        /**
         * The protocol used by the VPN session.
         */
        fun vpnProtocol(vpnProtocol: VpnProtocol): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information about the associated target networks. A target network is a subnet in a VPC.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var associatedTargetNetworks: List<AssociatedTargetNetwork>?
        /**
         * Information about the authentication method used by the Client VPN endpoint.
         */
        var authenticationOptions: List<ClientVpnAuthentication>?
        /**
         * The IPv4 address range, in CIDR notation, from which client IP addresses are assigned.
         */
        var clientCidrBlock: String?
        /**
         * The options for managing connection authorization for new client connections.
         */
        var clientConnectOptions: ClientConnectResponseOptions?
        /**
         * The ID of the Client VPN endpoint.
         */
        var clientVpnEndpointId: String?
        /**
         * Information about the client connection logging options for the Client VPN endpoint.
         */
        var connectionLogOptions: ConnectionLogResponseOptions?
        /**
         * The date and time the Client VPN endpoint was created.
         */
        var creationTime: String?
        /**
         * The date and time the Client VPN endpoint was deleted, if applicable.
         */
        var deletionTime: String?
        /**
         * A brief description of the endpoint.
         */
        var description: String?
        /**
         * The DNS name to be used by clients when connecting to the Client VPN endpoint.
         */
        var dnsName: String?
        /**
         * Information about the DNS servers to be used for DNS resolution.
         */
        var dnsServers: List<String>?
        /**
         * The IDs of the security groups for the target network.
         */
        var securityGroupIds: List<String>?
        /**
         * The URL of the self-service portal.
         */
        var selfServicePortalUrl: String?
        /**
         * The ARN of the server certificate.
         */
        var serverCertificateArn: String?
        /**
         * Indicates whether split-tunnel is enabled in the Client VPN endpoint.
         * For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-Tunnel Client VPN endpoint
         * in the Client VPN Administrator Guide.
         */
        var splitTunnel: Boolean?
        /**
         * The current state of the Client VPN endpoint.
         */
        var status: ClientVpnEndpointStatus?
        /**
         * Any tags assigned to the Client VPN endpoint.
         */
        var tags: List<Tag>?
        /**
         * The transport protocol used by the Client VPN endpoint.
         */
        var transportProtocol: TransportProtocol?
        /**
         * The ID of the VPC.
         */
        var vpcId: String?
        /**
         * The port number for the  Client VPN endpoint.
         */
        var vpnPort: Int?
        /**
         * The protocol used by the VPN session.
         */
        var vpnProtocol: VpnProtocol?

        fun build(): ClientVpnEndpoint
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ClientConnectResponseOptions] inside the given [block]
         */
        fun clientConnectOptions(block: ClientConnectResponseOptions.DslBuilder.() -> kotlin.Unit) {
            this.clientConnectOptions = ClientConnectResponseOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ConnectionLogResponseOptions] inside the given [block]
         */
        fun connectionLogOptions(block: ConnectionLogResponseOptions.DslBuilder.() -> kotlin.Unit) {
            this.connectionLogOptions = ConnectionLogResponseOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ClientVpnEndpointStatus] inside the given [block]
         */
        fun status(block: ClientVpnEndpointStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = ClientVpnEndpointStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associatedTargetNetworks: List<AssociatedTargetNetwork>? = null
        override var authenticationOptions: List<ClientVpnAuthentication>? = null
        override var clientCidrBlock: String? = null
        override var clientConnectOptions: ClientConnectResponseOptions? = null
        override var clientVpnEndpointId: String? = null
        override var connectionLogOptions: ConnectionLogResponseOptions? = null
        override var creationTime: String? = null
        override var deletionTime: String? = null
        override var description: String? = null
        override var dnsName: String? = null
        override var dnsServers: List<String>? = null
        override var securityGroupIds: List<String>? = null
        override var selfServicePortalUrl: String? = null
        override var serverCertificateArn: String? = null
        override var splitTunnel: Boolean? = null
        override var status: ClientVpnEndpointStatus? = null
        override var tags: List<Tag>? = null
        override var transportProtocol: TransportProtocol? = null
        override var vpcId: String? = null
        override var vpnPort: Int? = null
        override var vpnProtocol: VpnProtocol? = null

        constructor(x: ClientVpnEndpoint) : this() {
            this.associatedTargetNetworks = x.associatedTargetNetworks
            this.authenticationOptions = x.authenticationOptions
            this.clientCidrBlock = x.clientCidrBlock
            this.clientConnectOptions = x.clientConnectOptions
            this.clientVpnEndpointId = x.clientVpnEndpointId
            this.connectionLogOptions = x.connectionLogOptions
            this.creationTime = x.creationTime
            this.deletionTime = x.deletionTime
            this.description = x.description
            this.dnsName = x.dnsName
            this.dnsServers = x.dnsServers
            this.securityGroupIds = x.securityGroupIds
            this.selfServicePortalUrl = x.selfServicePortalUrl
            this.serverCertificateArn = x.serverCertificateArn
            this.splitTunnel = x.splitTunnel
            this.status = x.status
            this.tags = x.tags
            this.transportProtocol = x.transportProtocol
            this.vpcId = x.vpcId
            this.vpnPort = x.vpnPort
            this.vpnProtocol = x.vpnProtocol
        }

        override fun build(): ClientVpnEndpoint = ClientVpnEndpoint(this)
        override fun associatedTargetNetworks(associatedTargetNetworks: List<AssociatedTargetNetwork>): FluentBuilder = apply { this.associatedTargetNetworks = associatedTargetNetworks }
        override fun authenticationOptions(authenticationOptions: List<ClientVpnAuthentication>): FluentBuilder = apply { this.authenticationOptions = authenticationOptions }
        override fun clientCidrBlock(clientCidrBlock: String): FluentBuilder = apply { this.clientCidrBlock = clientCidrBlock }
        override fun clientConnectOptions(clientConnectOptions: ClientConnectResponseOptions): FluentBuilder = apply { this.clientConnectOptions = clientConnectOptions }
        override fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder = apply { this.clientVpnEndpointId = clientVpnEndpointId }
        override fun connectionLogOptions(connectionLogOptions: ConnectionLogResponseOptions): FluentBuilder = apply { this.connectionLogOptions = connectionLogOptions }
        override fun creationTime(creationTime: String): FluentBuilder = apply { this.creationTime = creationTime }
        override fun deletionTime(deletionTime: String): FluentBuilder = apply { this.deletionTime = deletionTime }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dnsName(dnsName: String): FluentBuilder = apply { this.dnsName = dnsName }
        override fun dnsServers(dnsServers: List<String>): FluentBuilder = apply { this.dnsServers = dnsServers }
        override fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder = apply { this.securityGroupIds = securityGroupIds }
        override fun selfServicePortalUrl(selfServicePortalUrl: String): FluentBuilder = apply { this.selfServicePortalUrl = selfServicePortalUrl }
        override fun serverCertificateArn(serverCertificateArn: String): FluentBuilder = apply { this.serverCertificateArn = serverCertificateArn }
        override fun splitTunnel(splitTunnel: Boolean): FluentBuilder = apply { this.splitTunnel = splitTunnel }
        override fun status(status: ClientVpnEndpointStatus): FluentBuilder = apply { this.status = status }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun transportProtocol(transportProtocol: TransportProtocol): FluentBuilder = apply { this.transportProtocol = transportProtocol }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
        override fun vpnPort(vpnPort: Int): FluentBuilder = apply { this.vpnPort = vpnPort }
        override fun vpnProtocol(vpnProtocol: VpnProtocol): FluentBuilder = apply { this.vpnProtocol = vpnProtocol }
    }
}
