// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Information about a Client VPN endpoint route.
 */
class ClientVpnRoute private constructor(builder: BuilderImpl) {
    /**
     * The ID of the Client VPN endpoint with which the route is associated.
     */
    val clientVpnEndpointId: String? = builder.clientVpnEndpointId
    /**
     * A brief description of the route.
     */
    val description: String? = builder.description
    /**
     * The IPv4 address range, in CIDR notation, of the route destination.
     */
    val destinationCidr: String? = builder.destinationCidr
    /**
     * Indicates how the route was associated with the Client VPN endpoint.
     * associate indicates that the route was automatically added when the target network
     * was associated with the Client VPN endpoint. add-route indicates that the route
     * was manually added using the CreateClientVpnRoute action.
     */
    val origin: String? = builder.origin
    /**
     * The current state of the route.
     */
    val status: ClientVpnRouteStatus? = builder.status
    /**
     * The ID of the subnet through which traffic is routed.
     */
    val targetSubnet: String? = builder.targetSubnet
    /**
     * The route type.
     */
    val type: String? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ClientVpnRoute = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ClientVpnRoute(")
        append("clientVpnEndpointId=$clientVpnEndpointId,")
        append("description=$description,")
        append("destinationCidr=$destinationCidr,")
        append("origin=$origin,")
        append("status=$status,")
        append("targetSubnet=$targetSubnet,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientVpnEndpointId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationCidr?.hashCode() ?: 0)
        result = 31 * result + (origin?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetSubnet?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ClientVpnRoute

        if (clientVpnEndpointId != other.clientVpnEndpointId) return false
        if (description != other.description) return false
        if (destinationCidr != other.destinationCidr) return false
        if (origin != other.origin) return false
        if (status != other.status) return false
        if (targetSubnet != other.targetSubnet) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ClientVpnRoute = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ClientVpnRoute
        /**
         * The ID of the Client VPN endpoint with which the route is associated.
         */
        fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder
        /**
         * A brief description of the route.
         */
        fun description(description: String): FluentBuilder
        /**
         * The IPv4 address range, in CIDR notation, of the route destination.
         */
        fun destinationCidr(destinationCidr: String): FluentBuilder
        /**
         * Indicates how the route was associated with the Client VPN endpoint.
         * associate indicates that the route was automatically added when the target network
         * was associated with the Client VPN endpoint. add-route indicates that the route
         * was manually added using the CreateClientVpnRoute action.
         */
        fun origin(origin: String): FluentBuilder
        /**
         * The current state of the route.
         */
        fun status(status: ClientVpnRouteStatus): FluentBuilder
        /**
         * The ID of the subnet through which traffic is routed.
         */
        fun targetSubnet(targetSubnet: String): FluentBuilder
        /**
         * The route type.
         */
        fun type(type: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the Client VPN endpoint with which the route is associated.
         */
        var clientVpnEndpointId: String?
        /**
         * A brief description of the route.
         */
        var description: String?
        /**
         * The IPv4 address range, in CIDR notation, of the route destination.
         */
        var destinationCidr: String?
        /**
         * Indicates how the route was associated with the Client VPN endpoint.
         * associate indicates that the route was automatically added when the target network
         * was associated with the Client VPN endpoint. add-route indicates that the route
         * was manually added using the CreateClientVpnRoute action.
         */
        var origin: String?
        /**
         * The current state of the route.
         */
        var status: ClientVpnRouteStatus?
        /**
         * The ID of the subnet through which traffic is routed.
         */
        var targetSubnet: String?
        /**
         * The route type.
         */
        var type: String?

        fun build(): ClientVpnRoute
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ClientVpnRouteStatus] inside the given [block]
         */
        fun status(block: ClientVpnRouteStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = ClientVpnRouteStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientVpnEndpointId: String? = null
        override var description: String? = null
        override var destinationCidr: String? = null
        override var origin: String? = null
        override var status: ClientVpnRouteStatus? = null
        override var targetSubnet: String? = null
        override var type: String? = null

        constructor(x: ClientVpnRoute) : this() {
            this.clientVpnEndpointId = x.clientVpnEndpointId
            this.description = x.description
            this.destinationCidr = x.destinationCidr
            this.origin = x.origin
            this.status = x.status
            this.targetSubnet = x.targetSubnet
            this.type = x.type
        }

        override fun build(): ClientVpnRoute = ClientVpnRoute(this)
        override fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder = apply { this.clientVpnEndpointId = clientVpnEndpointId }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun destinationCidr(destinationCidr: String): FluentBuilder = apply { this.destinationCidr = destinationCidr }
        override fun origin(origin: String): FluentBuilder = apply { this.origin = origin }
        override fun status(status: ClientVpnRouteStatus): FluentBuilder = apply { this.status = status }
        override fun targetSubnet(targetSubnet: String): FluentBuilder = apply { this.targetSubnet = targetSubnet }
        override fun type(type: String): FluentBuilder = apply { this.type = type }
    }
}
