// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the client connection logging options for the Client VPN endpoint.
 */
class ConnectionLogOptions private constructor(builder: BuilderImpl) {
    /**
     * The name of the CloudWatch Logs log group. Required if connection logging is enabled.
     */
    val cloudwatchLogGroup: String? = builder.cloudwatchLogGroup
    /**
     * The name of the CloudWatch Logs log stream to which the connection data is published.
     */
    val cloudwatchLogStream: String? = builder.cloudwatchLogStream
    /**
     * Indicates whether connection logging is enabled.
     */
    val enabled: Boolean? = builder.enabled

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ConnectionLogOptions = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ConnectionLogOptions(")
        append("cloudwatchLogGroup=$cloudwatchLogGroup,")
        append("cloudwatchLogStream=$cloudwatchLogStream,")
        append("enabled=$enabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudwatchLogGroup?.hashCode() ?: 0
        result = 31 * result + (cloudwatchLogStream?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ConnectionLogOptions

        if (cloudwatchLogGroup != other.cloudwatchLogGroup) return false
        if (cloudwatchLogStream != other.cloudwatchLogStream) return false
        if (enabled != other.enabled) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ConnectionLogOptions = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ConnectionLogOptions
        /**
         * The name of the CloudWatch Logs log group. Required if connection logging is enabled.
         */
        fun cloudwatchLogGroup(cloudwatchLogGroup: String): FluentBuilder
        /**
         * The name of the CloudWatch Logs log stream to which the connection data is published.
         */
        fun cloudwatchLogStream(cloudwatchLogStream: String): FluentBuilder
        /**
         * Indicates whether connection logging is enabled.
         */
        fun enabled(enabled: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the CloudWatch Logs log group. Required if connection logging is enabled.
         */
        var cloudwatchLogGroup: String?
        /**
         * The name of the CloudWatch Logs log stream to which the connection data is published.
         */
        var cloudwatchLogStream: String?
        /**
         * Indicates whether connection logging is enabled.
         */
        var enabled: Boolean?

        fun build(): ConnectionLogOptions
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cloudwatchLogGroup: String? = null
        override var cloudwatchLogStream: String? = null
        override var enabled: Boolean? = null

        constructor(x: ConnectionLogOptions) : this() {
            this.cloudwatchLogGroup = x.cloudwatchLogGroup
            this.cloudwatchLogStream = x.cloudwatchLogStream
            this.enabled = x.enabled
        }

        override fun build(): ConnectionLogOptions = ConnectionLogOptions(this)
        override fun cloudwatchLogGroup(cloudwatchLogGroup: String): FluentBuilder = apply { this.cloudwatchLogGroup = cloudwatchLogGroup }
        override fun cloudwatchLogStream(cloudwatchLogStream: String): FluentBuilder = apply { this.cloudwatchLogStream = cloudwatchLogStream }
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
    }
}
