// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a conversion task.
 */
class ConversionTask private constructor(builder: BuilderImpl) {
    /**
     * The ID of the conversion task.
     */
    val conversionTaskId: String? = builder.conversionTaskId
    /**
     * The time when the task expires. If the upload isn't complete before the expiration time, we automatically cancel
     * the task.
     */
    val expirationTime: String? = builder.expirationTime
    /**
     * If the task is for importing an instance, this contains information about the import instance task.
     */
    val importInstance: ImportInstanceTaskDetails? = builder.importInstance
    /**
     * If the task is for importing a volume, this contains information about the import volume task.
     */
    val importVolume: ImportVolumeTaskDetails? = builder.importVolume
    /**
     * The state of the conversion task.
     */
    val state: ConversionTaskState? = builder.state
    /**
     * The status message related to the conversion task.
     */
    val statusMessage: String? = builder.statusMessage
    /**
     * Any tags assigned to the task.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ConversionTask = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ConversionTask(")
        append("conversionTaskId=$conversionTaskId,")
        append("expirationTime=$expirationTime,")
        append("importInstance=$importInstance,")
        append("importVolume=$importVolume,")
        append("state=$state,")
        append("statusMessage=$statusMessage,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = conversionTaskId?.hashCode() ?: 0
        result = 31 * result + (expirationTime?.hashCode() ?: 0)
        result = 31 * result + (importInstance?.hashCode() ?: 0)
        result = 31 * result + (importVolume?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ConversionTask

        if (conversionTaskId != other.conversionTaskId) return false
        if (expirationTime != other.expirationTime) return false
        if (importInstance != other.importInstance) return false
        if (importVolume != other.importVolume) return false
        if (state != other.state) return false
        if (statusMessage != other.statusMessage) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ConversionTask = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ConversionTask
        /**
         * The ID of the conversion task.
         */
        fun conversionTaskId(conversionTaskId: String): FluentBuilder
        /**
         * The time when the task expires. If the upload isn't complete before the expiration time, we automatically cancel
         * the task.
         */
        fun expirationTime(expirationTime: String): FluentBuilder
        /**
         * If the task is for importing an instance, this contains information about the import instance task.
         */
        fun importInstance(importInstance: ImportInstanceTaskDetails): FluentBuilder
        /**
         * If the task is for importing a volume, this contains information about the import volume task.
         */
        fun importVolume(importVolume: ImportVolumeTaskDetails): FluentBuilder
        /**
         * The state of the conversion task.
         */
        fun state(state: ConversionTaskState): FluentBuilder
        /**
         * The status message related to the conversion task.
         */
        fun statusMessage(statusMessage: String): FluentBuilder
        /**
         * Any tags assigned to the task.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the conversion task.
         */
        var conversionTaskId: String?
        /**
         * The time when the task expires. If the upload isn't complete before the expiration time, we automatically cancel
         * the task.
         */
        var expirationTime: String?
        /**
         * If the task is for importing an instance, this contains information about the import instance task.
         */
        var importInstance: ImportInstanceTaskDetails?
        /**
         * If the task is for importing a volume, this contains information about the import volume task.
         */
        var importVolume: ImportVolumeTaskDetails?
        /**
         * The state of the conversion task.
         */
        var state: ConversionTaskState?
        /**
         * The status message related to the conversion task.
         */
        var statusMessage: String?
        /**
         * Any tags assigned to the task.
         */
        var tags: List<Tag>?

        fun build(): ConversionTask
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ImportInstanceTaskDetails] inside the given [block]
         */
        fun importInstance(block: ImportInstanceTaskDetails.DslBuilder.() -> kotlin.Unit) {
            this.importInstance = ImportInstanceTaskDetails.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ImportVolumeTaskDetails] inside the given [block]
         */
        fun importVolume(block: ImportVolumeTaskDetails.DslBuilder.() -> kotlin.Unit) {
            this.importVolume = ImportVolumeTaskDetails.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var conversionTaskId: String? = null
        override var expirationTime: String? = null
        override var importInstance: ImportInstanceTaskDetails? = null
        override var importVolume: ImportVolumeTaskDetails? = null
        override var state: ConversionTaskState? = null
        override var statusMessage: String? = null
        override var tags: List<Tag>? = null

        constructor(x: ConversionTask) : this() {
            this.conversionTaskId = x.conversionTaskId
            this.expirationTime = x.expirationTime
            this.importInstance = x.importInstance
            this.importVolume = x.importVolume
            this.state = x.state
            this.statusMessage = x.statusMessage
            this.tags = x.tags
        }

        override fun build(): ConversionTask = ConversionTask(this)
        override fun conversionTaskId(conversionTaskId: String): FluentBuilder = apply { this.conversionTaskId = conversionTaskId }
        override fun expirationTime(expirationTime: String): FluentBuilder = apply { this.expirationTime = expirationTime }
        override fun importInstance(importInstance: ImportInstanceTaskDetails): FluentBuilder = apply { this.importInstance = importInstance }
        override fun importVolume(importVolume: ImportVolumeTaskDetails): FluentBuilder = apply { this.importVolume = importVolume }
        override fun state(state: ConversionTaskState): FluentBuilder = apply { this.state = state }
        override fun statusMessage(statusMessage: String): FluentBuilder = apply { this.statusMessage = statusMessage }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
