// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for CopyImage.
 */
class CopyImageRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier you provide to ensure
     * idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency
     * in the Amazon EC2 API Reference.
     */
    val clientToken: String? = builder.clientToken
    /**
     * A description for the new AMI in the destination Region.
     */
    val description: String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI. Only
     * specify this parameter when copying an AMI from an Amazon Web Services Region to an Outpost.
     * The AMI must be in the Region of the destination Outpost. You cannot copy an
     * AMI from an Outpost to a Region, from one Outpost to another, or within the same
     * Outpost.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-amis">
     * Copying AMIs from an Amazon Web Services Region to an Outpost in the
     * Amazon Elastic Compute Cloud User Guide.
     */
    val destinationOutpostArn: String? = builder.destinationOutpostArn
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * Specifies whether the destination snapshots of the copied image should be encrypted.
     * You can encrypt a copy of an unencrypted snapshot, but you cannot create an unencrypted
     * copy of an encrypted snapshot. The default KMS key for Amazon EBS is used unless you specify a non-default
     * Key Management Service (KMS) KMS key using KmsKeyId. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption in the Amazon Elastic Compute Cloud User Guide.
     */
    val encrypted: Boolean? = builder.encrypted
    /**
     * The identifier of the symmetric Key Management Service (KMS) KMS key to use when creating
     * encrypted volumes. If this parameter is not specified, your Amazon Web Services managed KMS key for Amazon EBS is used.
     * If you specify a KMS key, you must also set the encrypted state to true.
     * You can specify a KMS key using any of the following:
     * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
     * Key alias. For example, alias/ExampleAlias.
     * Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
     * Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
     * Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an identifier that is not valid,
     * the action can appear to complete, but eventually fails.
     * The specified KMS key must exist in the destination Region.
     * Amazon EBS does not support asymmetric KMS keys.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The name of the new AMI in the destination Region.
     */
    val name: String? = builder.name
    /**
     * The ID of the AMI to copy.
     */
    val sourceImageId: String? = builder.sourceImageId
    /**
     * The name of the Region that contains the AMI to copy.
     */
    val sourceRegion: String? = builder.sourceRegion

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CopyImageRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CopyImageRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("destinationOutpostArn=$destinationOutpostArn,")
        append("dryRun=$dryRun,")
        append("encrypted=$encrypted,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("sourceImageId=$sourceImageId,")
        append("sourceRegion=$sourceRegion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationOutpostArn?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sourceImageId?.hashCode() ?: 0)
        result = 31 * result + (sourceRegion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CopyImageRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (destinationOutpostArn != other.destinationOutpostArn) return false
        if (dryRun != other.dryRun) return false
        if (encrypted != other.encrypted) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (sourceImageId != other.sourceImageId) return false
        if (sourceRegion != other.sourceRegion) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CopyImageRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CopyImageRequest
        /**
         * Unique, case-sensitive identifier you provide to ensure
         * idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency
         * in the Amazon EC2 API Reference.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * A description for the new AMI in the destination Region.
         */
        fun description(description: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI. Only
         * specify this parameter when copying an AMI from an Amazon Web Services Region to an Outpost.
         * The AMI must be in the Region of the destination Outpost. You cannot copy an
         * AMI from an Outpost to a Region, from one Outpost to another, or within the same
         * Outpost.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-amis">
         * Copying AMIs from an Amazon Web Services Region to an Outpost in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        fun destinationOutpostArn(destinationOutpostArn: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * Specifies whether the destination snapshots of the copied image should be encrypted.
         * You can encrypt a copy of an unencrypted snapshot, but you cannot create an unencrypted
         * copy of an encrypted snapshot. The default KMS key for Amazon EBS is used unless you specify a non-default
         * Key Management Service (KMS) KMS key using KmsKeyId. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption in the Amazon Elastic Compute Cloud User Guide.
         */
        fun encrypted(encrypted: Boolean): FluentBuilder
        /**
         * The identifier of the symmetric Key Management Service (KMS) KMS key to use when creating
         * encrypted volumes. If this parameter is not specified, your Amazon Web Services managed KMS key for Amazon EBS is used.
         * If you specify a KMS key, you must also set the encrypted state to true.
         * You can specify a KMS key using any of the following:
         * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
         * Key alias. For example, alias/ExampleAlias.
         * Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
         * Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
         * Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an identifier that is not valid,
         * the action can appear to complete, but eventually fails.
         * The specified KMS key must exist in the destination Region.
         * Amazon EBS does not support asymmetric KMS keys.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The name of the new AMI in the destination Region.
         */
        fun name(name: String): FluentBuilder
        /**
         * The ID of the AMI to copy.
         */
        fun sourceImageId(sourceImageId: String): FluentBuilder
        /**
         * The name of the Region that contains the AMI to copy.
         */
        fun sourceRegion(sourceRegion: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier you provide to ensure
         * idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency
         * in the Amazon EC2 API Reference.
         */
        var clientToken: String?
        /**
         * A description for the new AMI in the destination Region.
         */
        var description: String?
        /**
         * The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI. Only
         * specify this parameter when copying an AMI from an Amazon Web Services Region to an Outpost.
         * The AMI must be in the Region of the destination Outpost. You cannot copy an
         * AMI from an Outpost to a Region, from one Outpost to another, or within the same
         * Outpost.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-amis">
         * Copying AMIs from an Amazon Web Services Region to an Outpost in the
         * Amazon Elastic Compute Cloud User Guide.
         */
        var destinationOutpostArn: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * Specifies whether the destination snapshots of the copied image should be encrypted.
         * You can encrypt a copy of an unencrypted snapshot, but you cannot create an unencrypted
         * copy of an encrypted snapshot. The default KMS key for Amazon EBS is used unless you specify a non-default
         * Key Management Service (KMS) KMS key using KmsKeyId. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption in the Amazon Elastic Compute Cloud User Guide.
         */
        var encrypted: Boolean?
        /**
         * The identifier of the symmetric Key Management Service (KMS) KMS key to use when creating
         * encrypted volumes. If this parameter is not specified, your Amazon Web Services managed KMS key for Amazon EBS is used.
         * If you specify a KMS key, you must also set the encrypted state to true.
         * You can specify a KMS key using any of the following:
         * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
         * Key alias. For example, alias/ExampleAlias.
         * Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
         * Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
         * Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an identifier that is not valid,
         * the action can appear to complete, but eventually fails.
         * The specified KMS key must exist in the destination Region.
         * Amazon EBS does not support asymmetric KMS keys.
         */
        var kmsKeyId: String?
        /**
         * The name of the new AMI in the destination Region.
         */
        var name: String?
        /**
         * The ID of the AMI to copy.
         */
        var sourceImageId: String?
        /**
         * The name of the Region that contains the AMI to copy.
         */
        var sourceRegion: String?

        fun build(): CopyImageRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var description: String? = null
        override var destinationOutpostArn: String? = null
        override var dryRun: Boolean? = null
        override var encrypted: Boolean? = null
        override var kmsKeyId: String? = null
        override var name: String? = null
        override var sourceImageId: String? = null
        override var sourceRegion: String? = null

        constructor(x: CopyImageRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.destinationOutpostArn = x.destinationOutpostArn
            this.dryRun = x.dryRun
            this.encrypted = x.encrypted
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.sourceImageId = x.sourceImageId
            this.sourceRegion = x.sourceRegion
        }

        override fun build(): CopyImageRequest = CopyImageRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun destinationOutpostArn(destinationOutpostArn: String): FluentBuilder = apply { this.destinationOutpostArn = destinationOutpostArn }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun encrypted(encrypted: Boolean): FluentBuilder = apply { this.encrypted = encrypted }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun sourceImageId(sourceImageId: String): FluentBuilder = apply { this.sourceImageId = sourceImageId }
        override fun sourceRegion(sourceRegion: String): FluentBuilder = apply { this.sourceRegion = sourceRegion }
    }
}
