// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

class CreateCapacityReservationRequest private constructor(builder: BuilderImpl) {
    /**
     * The Availability Zone in which to create the Capacity Reservation.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The ID of the Availability Zone in which to create the Capacity Reservation.
     */
    val availabilityZoneId: String? = builder.availabilityZoneId
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure Idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides
     * dedicated throughput to Amazon EBS and an optimized configuration stack to provide
     * optimal I/O performance. This optimization isn't available with all instance types.
     * Additional usage charges apply when using an EBS- optimized instance.
     */
    val ebsOptimized: Boolean? = builder.ebsOptimized
    /**
     * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity
     * is released and you can no longer launch instances into it. The Capacity Reservation's state changes to
     * expired when it reaches its end date and time.
     * You must provide an EndDate value if EndDateType is
     * limited. Omit EndDate if EndDateType is
     * unlimited.
     * If the EndDateType is limited, the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify
     * 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
     */
    val endDate: Instant? = builder.endDate
    /**
     * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end
     * types:
     * unlimited - The Capacity Reservation remains active until you explicitly cancel it. Do not
     * provide an EndDate if the EndDateType is
     * unlimited.
     * limited - The Capacity Reservation expires automatically at a specified date and time. You must
     * provide an EndDate value if the EndDateType value is
     * limited.
     */
    val endDateType: EndDateType? = builder.endDateType
    /**
     * Indicates whether the Capacity Reservation supports instances with temporary, block-level
     * storage.
     */
    val ephemeralStorage: Boolean? = builder.ephemeralStorage
    /**
     * The number of instances for which to reserve capacity.
     * Valid range: 1 - 1000
     */
    val instanceCount: Int? = builder.instanceCount
    /**
     * Indicates the type of instance launches that the Capacity Reservation accepts. The options
     * include:
     * open - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform,
     * and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying
     * any additional parameters.
     * targeted - The Capacity Reservation only accepts instances that have matching attributes
     * (instance type, platform, and Availability Zone), and explicitly target the
     * Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.
     * Default: open
     */
    val instanceMatchCriteria: InstanceMatchCriteria? = builder.instanceMatchCriteria
    /**
     * The type of operating system for which to reserve capacity.
     */
    val instancePlatform: CapacityReservationInstancePlatform? = builder.instancePlatform
    /**
     * The instance type for which to reserve capacity. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types in the Amazon EC2 User Guide.
     */
    val instanceType: String? = builder.instanceType
    /**
     * The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.
     */
    val outpostArn: String? = builder.outpostArn
    /**
     * The tags to apply to the Capacity Reservation during launch.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:
     * default - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.
     * dedicated - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.
     */
    val tenancy: CapacityReservationTenancy? = builder.tenancy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateCapacityReservationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCapacityReservationRequest(")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneId=$availabilityZoneId,")
        append("clientToken=$clientToken,")
        append("dryRun=$dryRun,")
        append("ebsOptimized=$ebsOptimized,")
        append("endDate=$endDate,")
        append("endDateType=$endDateType,")
        append("ephemeralStorage=$ephemeralStorage,")
        append("instanceCount=$instanceCount,")
        append("instanceMatchCriteria=$instanceMatchCriteria,")
        append("instancePlatform=$instancePlatform,")
        append("instanceType=$instanceType,")
        append("outpostArn=$outpostArn,")
        append("tagSpecifications=$tagSpecifications,")
        append("tenancy=$tenancy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (availabilityZoneId?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (endDate?.hashCode() ?: 0)
        result = 31 * result + (endDateType?.hashCode() ?: 0)
        result = 31 * result + (ephemeralStorage?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (instanceMatchCriteria?.hashCode() ?: 0)
        result = 31 * result + (instancePlatform?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (tenancy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateCapacityReservationRequest

        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneId != other.availabilityZoneId) return false
        if (clientToken != other.clientToken) return false
        if (dryRun != other.dryRun) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (endDate != other.endDate) return false
        if (endDateType != other.endDateType) return false
        if (ephemeralStorage != other.ephemeralStorage) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceMatchCriteria != other.instanceMatchCriteria) return false
        if (instancePlatform != other.instancePlatform) return false
        if (instanceType != other.instanceType) return false
        if (outpostArn != other.outpostArn) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (tenancy != other.tenancy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateCapacityReservationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateCapacityReservationRequest
        /**
         * The Availability Zone in which to create the Capacity Reservation.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The ID of the Availability Zone in which to create the Capacity Reservation.
         */
        fun availabilityZoneId(availabilityZoneId: String): FluentBuilder
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure Idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides
         * dedicated throughput to Amazon EBS and an optimized configuration stack to provide
         * optimal I/O performance. This optimization isn't available with all instance types.
         * Additional usage charges apply when using an EBS- optimized instance.
         */
        fun ebsOptimized(ebsOptimized: Boolean): FluentBuilder
        /**
         * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity
         * is released and you can no longer launch instances into it. The Capacity Reservation's state changes to
         * expired when it reaches its end date and time.
         * You must provide an EndDate value if EndDateType is
         * limited. Omit EndDate if EndDateType is
         * unlimited.
         * If the EndDateType is limited, the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify
         * 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
         */
        fun endDate(endDate: Instant): FluentBuilder
        /**
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end
         * types:
         * unlimited - The Capacity Reservation remains active until you explicitly cancel it. Do not
         * provide an EndDate if the EndDateType is
         * unlimited.
         * limited - The Capacity Reservation expires automatically at a specified date and time. You must
         * provide an EndDate value if the EndDateType value is
         * limited.
         */
        fun endDateType(endDateType: EndDateType): FluentBuilder
        /**
         * Indicates whether the Capacity Reservation supports instances with temporary, block-level
         * storage.
         */
        fun ephemeralStorage(ephemeralStorage: Boolean): FluentBuilder
        /**
         * The number of instances for which to reserve capacity.
         * Valid range: 1 - 1000
         */
        fun instanceCount(instanceCount: Int): FluentBuilder
        /**
         * Indicates the type of instance launches that the Capacity Reservation accepts. The options
         * include:
         * open - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform,
         * and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying
         * any additional parameters.
         * targeted - The Capacity Reservation only accepts instances that have matching attributes
         * (instance type, platform, and Availability Zone), and explicitly target the
         * Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.
         * Default: open
         */
        fun instanceMatchCriteria(instanceMatchCriteria: InstanceMatchCriteria): FluentBuilder
        /**
         * The type of operating system for which to reserve capacity.
         */
        fun instancePlatform(instancePlatform: CapacityReservationInstancePlatform): FluentBuilder
        /**
         * The instance type for which to reserve capacity. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types in the Amazon EC2 User Guide.
         */
        fun instanceType(instanceType: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.
         */
        fun outpostArn(outpostArn: String): FluentBuilder
        /**
         * The tags to apply to the Capacity Reservation during launch.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
        /**
         * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:
         * default - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.
         * dedicated - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.
         */
        fun tenancy(tenancy: CapacityReservationTenancy): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Availability Zone in which to create the Capacity Reservation.
         */
        var availabilityZone: String?
        /**
         * The ID of the Availability Zone in which to create the Capacity Reservation.
         */
        var availabilityZoneId: String?
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure Idempotency.
         */
        var clientToken: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides
         * dedicated throughput to Amazon EBS and an optimized configuration stack to provide
         * optimal I/O performance. This optimization isn't available with all instance types.
         * Additional usage charges apply when using an EBS- optimized instance.
         */
        var ebsOptimized: Boolean?
        /**
         * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity
         * is released and you can no longer launch instances into it. The Capacity Reservation's state changes to
         * expired when it reaches its end date and time.
         * You must provide an EndDate value if EndDateType is
         * limited. Omit EndDate if EndDateType is
         * unlimited.
         * If the EndDateType is limited, the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify
         * 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
         */
        var endDate: Instant?
        /**
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end
         * types:
         * unlimited - The Capacity Reservation remains active until you explicitly cancel it. Do not
         * provide an EndDate if the EndDateType is
         * unlimited.
         * limited - The Capacity Reservation expires automatically at a specified date and time. You must
         * provide an EndDate value if the EndDateType value is
         * limited.
         */
        var endDateType: EndDateType?
        /**
         * Indicates whether the Capacity Reservation supports instances with temporary, block-level
         * storage.
         */
        var ephemeralStorage: Boolean?
        /**
         * The number of instances for which to reserve capacity.
         * Valid range: 1 - 1000
         */
        var instanceCount: Int?
        /**
         * Indicates the type of instance launches that the Capacity Reservation accepts. The options
         * include:
         * open - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform,
         * and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying
         * any additional parameters.
         * targeted - The Capacity Reservation only accepts instances that have matching attributes
         * (instance type, platform, and Availability Zone), and explicitly target the
         * Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.
         * Default: open
         */
        var instanceMatchCriteria: InstanceMatchCriteria?
        /**
         * The type of operating system for which to reserve capacity.
         */
        var instancePlatform: CapacityReservationInstancePlatform?
        /**
         * The instance type for which to reserve capacity. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types in the Amazon EC2 User Guide.
         */
        var instanceType: String?
        /**
         * The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.
         */
        var outpostArn: String?
        /**
         * The tags to apply to the Capacity Reservation during launch.
         */
        var tagSpecifications: List<TagSpecification>?
        /**
         * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:
         * default - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.
         * dedicated - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.
         */
        var tenancy: CapacityReservationTenancy?

        fun build(): CreateCapacityReservationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZone: String? = null
        override var availabilityZoneId: String? = null
        override var clientToken: String? = null
        override var dryRun: Boolean? = null
        override var ebsOptimized: Boolean? = null
        override var endDate: Instant? = null
        override var endDateType: EndDateType? = null
        override var ephemeralStorage: Boolean? = null
        override var instanceCount: Int? = null
        override var instanceMatchCriteria: InstanceMatchCriteria? = null
        override var instancePlatform: CapacityReservationInstancePlatform? = null
        override var instanceType: String? = null
        override var outpostArn: String? = null
        override var tagSpecifications: List<TagSpecification>? = null
        override var tenancy: CapacityReservationTenancy? = null

        constructor(x: CreateCapacityReservationRequest) : this() {
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneId = x.availabilityZoneId
            this.clientToken = x.clientToken
            this.dryRun = x.dryRun
            this.ebsOptimized = x.ebsOptimized
            this.endDate = x.endDate
            this.endDateType = x.endDateType
            this.ephemeralStorage = x.ephemeralStorage
            this.instanceCount = x.instanceCount
            this.instanceMatchCriteria = x.instanceMatchCriteria
            this.instancePlatform = x.instancePlatform
            this.instanceType = x.instanceType
            this.outpostArn = x.outpostArn
            this.tagSpecifications = x.tagSpecifications
            this.tenancy = x.tenancy
        }

        override fun build(): CreateCapacityReservationRequest = CreateCapacityReservationRequest(this)
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun availabilityZoneId(availabilityZoneId: String): FluentBuilder = apply { this.availabilityZoneId = availabilityZoneId }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun ebsOptimized(ebsOptimized: Boolean): FluentBuilder = apply { this.ebsOptimized = ebsOptimized }
        override fun endDate(endDate: Instant): FluentBuilder = apply { this.endDate = endDate }
        override fun endDateType(endDateType: EndDateType): FluentBuilder = apply { this.endDateType = endDateType }
        override fun ephemeralStorage(ephemeralStorage: Boolean): FluentBuilder = apply { this.ephemeralStorage = ephemeralStorage }
        override fun instanceCount(instanceCount: Int): FluentBuilder = apply { this.instanceCount = instanceCount }
        override fun instanceMatchCriteria(instanceMatchCriteria: InstanceMatchCriteria): FluentBuilder = apply { this.instanceMatchCriteria = instanceMatchCriteria }
        override fun instancePlatform(instancePlatform: CapacityReservationInstancePlatform): FluentBuilder = apply { this.instancePlatform = instancePlatform }
        override fun instanceType(instanceType: String): FluentBuilder = apply { this.instanceType = instanceType }
        override fun outpostArn(outpostArn: String): FluentBuilder = apply { this.outpostArn = outpostArn }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun tenancy(tenancy: CapacityReservationTenancy): FluentBuilder = apply { this.tenancy = tenancy }
    }
}
