// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateClientVpnEndpointRequest private constructor(builder: BuilderImpl) {
    /**
     * Information about the authentication method to be used to authenticate clients.
     */
    val authenticationOptions: List<ClientVpnAuthenticationRequest>? = builder.authenticationOptions
    /**
     * The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
     */
    val clientCidrBlock: String? = builder.clientCidrBlock
    /**
     * The options for managing connection authorization for new client connections.
     */
    val clientConnectOptions: ClientConnectOptions? = builder.clientConnectOptions
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Information about the client connection logging options.
     * If you enable client connection logging, data about client connections is sent to a
     * Cloudwatch Logs log stream. The following information is logged:
     * Client connection requests
     * Client connection results (successful and unsuccessful)
     * Reasons for unsuccessful client connection requests
     * Client connection termination time
     */
    val connectionLogOptions: ConnectionLogOptions? = builder.connectionLogOptions
    /**
     * A brief description of the Client VPN endpoint.
     */
    val description: String? = builder.description
    /**
     * Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can
     * have up to two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.
     */
    val dnsServers: List<String>? = builder.dnsServers
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * Specify whether to enable the self-service portal for the Client VPN endpoint.
     * Default Value: enabled
     */
    val selfServicePortal: SelfServicePortal? = builder.selfServicePortal
    /**
     * The ARN of the server certificate. For more information, see
     * the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">Certificate Manager User Guide.
     */
    val serverCertificateArn: String? = builder.serverCertificateArn
    /**
     * Indicates whether split-tunnel is enabled on the Client VPN endpoint.
     * By default, split-tunnel on a VPN endpoint is disabled.
     * For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN endpoint in the
     * Client VPN Administrator Guide.
     */
    val splitTunnel: Boolean? = builder.splitTunnel
    /**
     * The tags to apply to the Client VPN endpoint during creation.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The transport protocol to be used by the VPN session.
     * Default value: udp
     */
    val transportProtocol: TransportProtocol? = builder.transportProtocol
    /**
     * The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
     */
    val vpcId: String? = builder.vpcId
    /**
     * The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
     * Valid Values: 443 | 1194
     * Default Value: 443
     */
    val vpnPort: Int? = builder.vpnPort

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateClientVpnEndpointRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClientVpnEndpointRequest(")
        append("authenticationOptions=$authenticationOptions,")
        append("clientCidrBlock=$clientCidrBlock,")
        append("clientConnectOptions=$clientConnectOptions,")
        append("clientToken=$clientToken,")
        append("connectionLogOptions=$connectionLogOptions,")
        append("description=$description,")
        append("dnsServers=$dnsServers,")
        append("dryRun=$dryRun,")
        append("securityGroupIds=$securityGroupIds,")
        append("selfServicePortal=$selfServicePortal,")
        append("serverCertificateArn=$serverCertificateArn,")
        append("splitTunnel=$splitTunnel,")
        append("tagSpecifications=$tagSpecifications,")
        append("transportProtocol=$transportProtocol,")
        append("vpcId=$vpcId,")
        append("vpnPort=$vpnPort)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationOptions?.hashCode() ?: 0
        result = 31 * result + (clientCidrBlock?.hashCode() ?: 0)
        result = 31 * result + (clientConnectOptions?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (connectionLogOptions?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dnsServers?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (selfServicePortal?.hashCode() ?: 0)
        result = 31 * result + (serverCertificateArn?.hashCode() ?: 0)
        result = 31 * result + (splitTunnel?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (transportProtocol?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        result = 31 * result + (vpnPort ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateClientVpnEndpointRequest

        if (authenticationOptions != other.authenticationOptions) return false
        if (clientCidrBlock != other.clientCidrBlock) return false
        if (clientConnectOptions != other.clientConnectOptions) return false
        if (clientToken != other.clientToken) return false
        if (connectionLogOptions != other.connectionLogOptions) return false
        if (description != other.description) return false
        if (dnsServers != other.dnsServers) return false
        if (dryRun != other.dryRun) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (selfServicePortal != other.selfServicePortal) return false
        if (serverCertificateArn != other.serverCertificateArn) return false
        if (splitTunnel != other.splitTunnel) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (transportProtocol != other.transportProtocol) return false
        if (vpcId != other.vpcId) return false
        if (vpnPort != other.vpnPort) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateClientVpnEndpointRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateClientVpnEndpointRequest
        /**
         * Information about the authentication method to be used to authenticate clients.
         */
        fun authenticationOptions(authenticationOptions: List<ClientVpnAuthenticationRequest>): FluentBuilder
        /**
         * The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
         */
        fun clientCidrBlock(clientCidrBlock: String): FluentBuilder
        /**
         * The options for managing connection authorization for new client connections.
         */
        fun clientConnectOptions(clientConnectOptions: ClientConnectOptions): FluentBuilder
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Information about the client connection logging options.
         * If you enable client connection logging, data about client connections is sent to a
         * Cloudwatch Logs log stream. The following information is logged:
         * Client connection requests
         * Client connection results (successful and unsuccessful)
         * Reasons for unsuccessful client connection requests
         * Client connection termination time
         */
        fun connectionLogOptions(connectionLogOptions: ConnectionLogOptions): FluentBuilder
        /**
         * A brief description of the Client VPN endpoint.
         */
        fun description(description: String): FluentBuilder
        /**
         * Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can
         * have up to two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.
         */
        fun dnsServers(dnsServers: List<String>): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
         */
        fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder
        /**
         * Specify whether to enable the self-service portal for the Client VPN endpoint.
         * Default Value: enabled
         */
        fun selfServicePortal(selfServicePortal: SelfServicePortal): FluentBuilder
        /**
         * The ARN of the server certificate. For more information, see
         * the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">Certificate Manager User Guide.
         */
        fun serverCertificateArn(serverCertificateArn: String): FluentBuilder
        /**
         * Indicates whether split-tunnel is enabled on the Client VPN endpoint.
         * By default, split-tunnel on a VPN endpoint is disabled.
         * For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN endpoint in the
         * Client VPN Administrator Guide.
         */
        fun splitTunnel(splitTunnel: Boolean): FluentBuilder
        /**
         * The tags to apply to the Client VPN endpoint during creation.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
        /**
         * The transport protocol to be used by the VPN session.
         * Default value: udp
         */
        fun transportProtocol(transportProtocol: TransportProtocol): FluentBuilder
        /**
         * The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
         */
        fun vpcId(vpcId: String): FluentBuilder
        /**
         * The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
         * Valid Values: 443 | 1194
         * Default Value: 443
         */
        fun vpnPort(vpnPort: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information about the authentication method to be used to authenticate clients.
         */
        var authenticationOptions: List<ClientVpnAuthenticationRequest>?
        /**
         * The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
         */
        var clientCidrBlock: String?
        /**
         * The options for managing connection authorization for new client connections.
         */
        var clientConnectOptions: ClientConnectOptions?
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
         */
        var clientToken: String?
        /**
         * Information about the client connection logging options.
         * If you enable client connection logging, data about client connections is sent to a
         * Cloudwatch Logs log stream. The following information is logged:
         * Client connection requests
         * Client connection results (successful and unsuccessful)
         * Reasons for unsuccessful client connection requests
         * Client connection termination time
         */
        var connectionLogOptions: ConnectionLogOptions?
        /**
         * A brief description of the Client VPN endpoint.
         */
        var description: String?
        /**
         * Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can
         * have up to two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.
         */
        var dnsServers: List<String>?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
         */
        var securityGroupIds: List<String>?
        /**
         * Specify whether to enable the self-service portal for the Client VPN endpoint.
         * Default Value: enabled
         */
        var selfServicePortal: SelfServicePortal?
        /**
         * The ARN of the server certificate. For more information, see
         * the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">Certificate Manager User Guide.
         */
        var serverCertificateArn: String?
        /**
         * Indicates whether split-tunnel is enabled on the Client VPN endpoint.
         * By default, split-tunnel on a VPN endpoint is disabled.
         * For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN endpoint in the
         * Client VPN Administrator Guide.
         */
        var splitTunnel: Boolean?
        /**
         * The tags to apply to the Client VPN endpoint during creation.
         */
        var tagSpecifications: List<TagSpecification>?
        /**
         * The transport protocol to be used by the VPN session.
         * Default value: udp
         */
        var transportProtocol: TransportProtocol?
        /**
         * The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
         */
        var vpcId: String?
        /**
         * The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
         * Valid Values: 443 | 1194
         * Default Value: 443
         */
        var vpnPort: Int?

        fun build(): CreateClientVpnEndpointRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ClientConnectOptions] inside the given [block]
         */
        fun clientConnectOptions(block: ClientConnectOptions.DslBuilder.() -> kotlin.Unit) {
            this.clientConnectOptions = ClientConnectOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ConnectionLogOptions] inside the given [block]
         */
        fun connectionLogOptions(block: ConnectionLogOptions.DslBuilder.() -> kotlin.Unit) {
            this.connectionLogOptions = ConnectionLogOptions.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var authenticationOptions: List<ClientVpnAuthenticationRequest>? = null
        override var clientCidrBlock: String? = null
        override var clientConnectOptions: ClientConnectOptions? = null
        override var clientToken: String? = null
        override var connectionLogOptions: ConnectionLogOptions? = null
        override var description: String? = null
        override var dnsServers: List<String>? = null
        override var dryRun: Boolean? = null
        override var securityGroupIds: List<String>? = null
        override var selfServicePortal: SelfServicePortal? = null
        override var serverCertificateArn: String? = null
        override var splitTunnel: Boolean? = null
        override var tagSpecifications: List<TagSpecification>? = null
        override var transportProtocol: TransportProtocol? = null
        override var vpcId: String? = null
        override var vpnPort: Int? = null

        constructor(x: CreateClientVpnEndpointRequest) : this() {
            this.authenticationOptions = x.authenticationOptions
            this.clientCidrBlock = x.clientCidrBlock
            this.clientConnectOptions = x.clientConnectOptions
            this.clientToken = x.clientToken
            this.connectionLogOptions = x.connectionLogOptions
            this.description = x.description
            this.dnsServers = x.dnsServers
            this.dryRun = x.dryRun
            this.securityGroupIds = x.securityGroupIds
            this.selfServicePortal = x.selfServicePortal
            this.serverCertificateArn = x.serverCertificateArn
            this.splitTunnel = x.splitTunnel
            this.tagSpecifications = x.tagSpecifications
            this.transportProtocol = x.transportProtocol
            this.vpcId = x.vpcId
            this.vpnPort = x.vpnPort
        }

        override fun build(): CreateClientVpnEndpointRequest = CreateClientVpnEndpointRequest(this)
        override fun authenticationOptions(authenticationOptions: List<ClientVpnAuthenticationRequest>): FluentBuilder = apply { this.authenticationOptions = authenticationOptions }
        override fun clientCidrBlock(clientCidrBlock: String): FluentBuilder = apply { this.clientCidrBlock = clientCidrBlock }
        override fun clientConnectOptions(clientConnectOptions: ClientConnectOptions): FluentBuilder = apply { this.clientConnectOptions = clientConnectOptions }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun connectionLogOptions(connectionLogOptions: ConnectionLogOptions): FluentBuilder = apply { this.connectionLogOptions = connectionLogOptions }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dnsServers(dnsServers: List<String>): FluentBuilder = apply { this.dnsServers = dnsServers }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder = apply { this.securityGroupIds = securityGroupIds }
        override fun selfServicePortal(selfServicePortal: SelfServicePortal): FluentBuilder = apply { this.selfServicePortal = selfServicePortal }
        override fun serverCertificateArn(serverCertificateArn: String): FluentBuilder = apply { this.serverCertificateArn = serverCertificateArn }
        override fun splitTunnel(splitTunnel: Boolean): FluentBuilder = apply { this.splitTunnel = splitTunnel }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun transportProtocol(transportProtocol: TransportProtocol): FluentBuilder = apply { this.transportProtocol = transportProtocol }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
        override fun vpnPort(vpnPort: Int): FluentBuilder = apply { this.vpnPort = vpnPort }
    }
}
