// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateClientVpnRouteRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The ID of the Client VPN endpoint to which to add the route.
     */
    val clientVpnEndpointId: String? = builder.clientVpnEndpointId
    /**
     * A brief description of the route.
     */
    val description: String? = builder.description
    /**
     * The IPv4 address range, in CIDR notation, of the route destination. For example:
     * To add a route for Internet access, enter 0.0.0.0/0
     * To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range
     * To add a route for an on-premises network, enter the Amazon Web Services Site-to-Site VPN connection's IPv4 CIDR range
     * To add a route for the local network, enter the client CIDR range
     */
    val destinationCidrBlock: String? = builder.destinationCidrBlock
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The ID of the subnet through which you want to route traffic. The specified subnet must be
     * an existing target network of the Client VPN endpoint.
     * Alternatively, if you're adding a route for the local network, specify local.
     */
    val targetVpcSubnetId: String? = builder.targetVpcSubnetId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateClientVpnRouteRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClientVpnRouteRequest(")
        append("clientToken=$clientToken,")
        append("clientVpnEndpointId=$clientVpnEndpointId,")
        append("description=$description,")
        append("destinationCidrBlock=$destinationCidrBlock,")
        append("dryRun=$dryRun,")
        append("targetVpcSubnetId=$targetVpcSubnetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (clientVpnEndpointId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationCidrBlock?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (targetVpcSubnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateClientVpnRouteRequest

        if (clientToken != other.clientToken) return false
        if (clientVpnEndpointId != other.clientVpnEndpointId) return false
        if (description != other.description) return false
        if (destinationCidrBlock != other.destinationCidrBlock) return false
        if (dryRun != other.dryRun) return false
        if (targetVpcSubnetId != other.targetVpcSubnetId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateClientVpnRouteRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateClientVpnRouteRequest
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The ID of the Client VPN endpoint to which to add the route.
         */
        fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder
        /**
         * A brief description of the route.
         */
        fun description(description: String): FluentBuilder
        /**
         * The IPv4 address range, in CIDR notation, of the route destination. For example:
         * To add a route for Internet access, enter 0.0.0.0/0
         * To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range
         * To add a route for an on-premises network, enter the Amazon Web Services Site-to-Site VPN connection's IPv4 CIDR range
         * To add a route for the local network, enter the client CIDR range
         */
        fun destinationCidrBlock(destinationCidrBlock: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The ID of the subnet through which you want to route traffic. The specified subnet must be
         * an existing target network of the Client VPN endpoint.
         * Alternatively, if you're adding a route for the local network, specify local.
         */
        fun targetVpcSubnetId(targetVpcSubnetId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency.
         */
        var clientToken: String?
        /**
         * The ID of the Client VPN endpoint to which to add the route.
         */
        var clientVpnEndpointId: String?
        /**
         * A brief description of the route.
         */
        var description: String?
        /**
         * The IPv4 address range, in CIDR notation, of the route destination. For example:
         * To add a route for Internet access, enter 0.0.0.0/0
         * To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range
         * To add a route for an on-premises network, enter the Amazon Web Services Site-to-Site VPN connection's IPv4 CIDR range
         * To add a route for the local network, enter the client CIDR range
         */
        var destinationCidrBlock: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The ID of the subnet through which you want to route traffic. The specified subnet must be
         * an existing target network of the Client VPN endpoint.
         * Alternatively, if you're adding a route for the local network, specify local.
         */
        var targetVpcSubnetId: String?

        fun build(): CreateClientVpnRouteRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var clientVpnEndpointId: String? = null
        override var description: String? = null
        override var destinationCidrBlock: String? = null
        override var dryRun: Boolean? = null
        override var targetVpcSubnetId: String? = null

        constructor(x: CreateClientVpnRouteRequest) : this() {
            this.clientToken = x.clientToken
            this.clientVpnEndpointId = x.clientVpnEndpointId
            this.description = x.description
            this.destinationCidrBlock = x.destinationCidrBlock
            this.dryRun = x.dryRun
            this.targetVpcSubnetId = x.targetVpcSubnetId
        }

        override fun build(): CreateClientVpnRouteRequest = CreateClientVpnRouteRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun clientVpnEndpointId(clientVpnEndpointId: String): FluentBuilder = apply { this.clientVpnEndpointId = clientVpnEndpointId }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun destinationCidrBlock(destinationCidrBlock: String): FluentBuilder = apply { this.destinationCidrBlock = destinationCidrBlock }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun targetVpcSubnetId(targetVpcSubnetId: String): FluentBuilder = apply { this.targetVpcSubnetId = targetVpcSubnetId }
    }
}
