// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for CreateCustomerGateway.
 */
class CreateCustomerGatewayRequest private constructor(builder: BuilderImpl) {
    /**
     * For devices that support BGP, the customer gateway's BGP ASN.
     * Default: 65000
     */
    val bgpAsn: Int? = builder.bgpAsn
    /**
     * The Amazon Resource Name (ARN) for the customer gateway certificate.
     */
    val certificateArn: String? = builder.certificateArn
    /**
     * A name for the customer gateway device.
     * Length Constraints: Up to 255 characters.
     */
    val deviceName: String? = builder.deviceName
    /**
     * Checks whether you have the required permissions for the action, without actually
     * making the request, and provides an error response. If you have the required
     * permissions, the error response is DryRunOperation. Otherwise, it is
     * UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The Internet-routable IP address for the customer gateway's outside interface. The
     * address must be static.
     */
    val publicIp: String? = builder.publicIp
    /**
     * The tags to apply to the customer gateway.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The type of VPN connection that this customer gateway supports
     * (ipsec.1).
     */
    val type: GatewayType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateCustomerGatewayRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCustomerGatewayRequest(")
        append("bgpAsn=$bgpAsn,")
        append("certificateArn=$certificateArn,")
        append("deviceName=$deviceName,")
        append("dryRun=$dryRun,")
        append("publicIp=$publicIp,")
        append("tagSpecifications=$tagSpecifications,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bgpAsn ?: 0
        result = 31 * result + (certificateArn?.hashCode() ?: 0)
        result = 31 * result + (deviceName?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (publicIp?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateCustomerGatewayRequest

        if (bgpAsn != other.bgpAsn) return false
        if (certificateArn != other.certificateArn) return false
        if (deviceName != other.deviceName) return false
        if (dryRun != other.dryRun) return false
        if (publicIp != other.publicIp) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateCustomerGatewayRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateCustomerGatewayRequest
        /**
         * For devices that support BGP, the customer gateway's BGP ASN.
         * Default: 65000
         */
        fun bgpAsn(bgpAsn: Int): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) for the customer gateway certificate.
         */
        fun certificateArn(certificateArn: String): FluentBuilder
        /**
         * A name for the customer gateway device.
         * Length Constraints: Up to 255 characters.
         */
        fun deviceName(deviceName: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually
         * making the request, and provides an error response. If you have the required
         * permissions, the error response is DryRunOperation. Otherwise, it is
         * UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The Internet-routable IP address for the customer gateway's outside interface. The
         * address must be static.
         */
        fun publicIp(publicIp: String): FluentBuilder
        /**
         * The tags to apply to the customer gateway.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
        /**
         * The type of VPN connection that this customer gateway supports
         * (ipsec.1).
         */
        fun type(type: GatewayType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * For devices that support BGP, the customer gateway's BGP ASN.
         * Default: 65000
         */
        var bgpAsn: Int?
        /**
         * The Amazon Resource Name (ARN) for the customer gateway certificate.
         */
        var certificateArn: String?
        /**
         * A name for the customer gateway device.
         * Length Constraints: Up to 255 characters.
         */
        var deviceName: String?
        /**
         * Checks whether you have the required permissions for the action, without actually
         * making the request, and provides an error response. If you have the required
         * permissions, the error response is DryRunOperation. Otherwise, it is
         * UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The Internet-routable IP address for the customer gateway's outside interface. The
         * address must be static.
         */
        var publicIp: String?
        /**
         * The tags to apply to the customer gateway.
         */
        var tagSpecifications: List<TagSpecification>?
        /**
         * The type of VPN connection that this customer gateway supports
         * (ipsec.1).
         */
        var type: GatewayType?

        fun build(): CreateCustomerGatewayRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bgpAsn: Int? = null
        override var certificateArn: String? = null
        override var deviceName: String? = null
        override var dryRun: Boolean? = null
        override var publicIp: String? = null
        override var tagSpecifications: List<TagSpecification>? = null
        override var type: GatewayType? = null

        constructor(x: CreateCustomerGatewayRequest) : this() {
            this.bgpAsn = x.bgpAsn
            this.certificateArn = x.certificateArn
            this.deviceName = x.deviceName
            this.dryRun = x.dryRun
            this.publicIp = x.publicIp
            this.tagSpecifications = x.tagSpecifications
            this.type = x.type
        }

        override fun build(): CreateCustomerGatewayRequest = CreateCustomerGatewayRequest(this)
        override fun bgpAsn(bgpAsn: Int): FluentBuilder = apply { this.bgpAsn = bgpAsn }
        override fun certificateArn(certificateArn: String): FluentBuilder = apply { this.certificateArn = certificateArn }
        override fun deviceName(deviceName: String): FluentBuilder = apply { this.deviceName = deviceName }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun publicIp(publicIp: String): FluentBuilder = apply { this.publicIp = publicIp }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun type(type: GatewayType): FluentBuilder = apply { this.type = type }
    }
}
