// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the instances that could not be launched by the fleet.
 */
class CreateFleetError private constructor(builder: BuilderImpl) {
    /**
     * The error code that indicates why the instance could not be launched. For more
     * information about error codes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error Codes.
     */
    val errorCode: String? = builder.errorCode
    /**
     * The error message that describes why the instance could not be launched. For more
     * information about error messages, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error Codes.
     */
    val errorMessage: String? = builder.errorMessage
    /**
     * The launch templates and overrides that were used for launching the instances. The
     * values that you specify in the Overrides replace the values in the launch template.
     */
    val launchTemplateAndOverrides: LaunchTemplateAndOverridesResponse? = builder.launchTemplateAndOverrides
    /**
     * Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.
     */
    val lifecycle: InstanceLifecycle? = builder.lifecycle

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateFleetError = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFleetError(")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage,")
        append("launchTemplateAndOverrides=$launchTemplateAndOverrides,")
        append("lifecycle=$lifecycle)")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCode?.hashCode() ?: 0
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateAndOverrides?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateFleetError

        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false
        if (launchTemplateAndOverrides != other.launchTemplateAndOverrides) return false
        if (lifecycle != other.lifecycle) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateFleetError = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateFleetError
        /**
         * The error code that indicates why the instance could not be launched. For more
         * information about error codes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error Codes.
         */
        fun errorCode(errorCode: String): FluentBuilder
        /**
         * The error message that describes why the instance could not be launched. For more
         * information about error messages, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error Codes.
         */
        fun errorMessage(errorMessage: String): FluentBuilder
        /**
         * The launch templates and overrides that were used for launching the instances. The
         * values that you specify in the Overrides replace the values in the launch template.
         */
        fun launchTemplateAndOverrides(launchTemplateAndOverrides: LaunchTemplateAndOverridesResponse): FluentBuilder
        /**
         * Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.
         */
        fun lifecycle(lifecycle: InstanceLifecycle): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The error code that indicates why the instance could not be launched. For more
         * information about error codes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error Codes.
         */
        var errorCode: String?
        /**
         * The error message that describes why the instance could not be launched. For more
         * information about error messages, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error Codes.
         */
        var errorMessage: String?
        /**
         * The launch templates and overrides that were used for launching the instances. The
         * values that you specify in the Overrides replace the values in the launch template.
         */
        var launchTemplateAndOverrides: LaunchTemplateAndOverridesResponse?
        /**
         * Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.
         */
        var lifecycle: InstanceLifecycle?

        fun build(): CreateFleetError
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LaunchTemplateAndOverridesResponse] inside the given [block]
         */
        fun launchTemplateAndOverrides(block: LaunchTemplateAndOverridesResponse.DslBuilder.() -> kotlin.Unit) {
            this.launchTemplateAndOverrides = LaunchTemplateAndOverridesResponse.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var errorCode: String? = null
        override var errorMessage: String? = null
        override var launchTemplateAndOverrides: LaunchTemplateAndOverridesResponse? = null
        override var lifecycle: InstanceLifecycle? = null

        constructor(x: CreateFleetError) : this() {
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
            this.launchTemplateAndOverrides = x.launchTemplateAndOverrides
            this.lifecycle = x.lifecycle
        }

        override fun build(): CreateFleetError = CreateFleetError(this)
        override fun errorCode(errorCode: String): FluentBuilder = apply { this.errorCode = errorCode }
        override fun errorMessage(errorMessage: String): FluentBuilder = apply { this.errorMessage = errorMessage }
        override fun launchTemplateAndOverrides(launchTemplateAndOverrides: LaunchTemplateAndOverridesResponse): FluentBuilder = apply { this.launchTemplateAndOverrides = launchTemplateAndOverrides }
        override fun lifecycle(lifecycle: InstanceLifecycle): FluentBuilder = apply { this.lifecycle = lifecycle }
    }
}
