// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

class CreateFleetRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Reserved.
     */
    val context: String? = builder.context
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * Indicates whether running instances should be terminated if the total target capacity of
     * the EC2 Fleet is decreased below the current size of the EC2 Fleet.
     */
    val excessCapacityTerminationPolicy: FleetExcessCapacityTerminationPolicy? = builder.excessCapacityTerminationPolicy
    /**
     * The configuration for the EC2 Fleet.
     */
    val launchTemplateConfigs: List<FleetLaunchTemplateConfigRequest>? = builder.launchTemplateConfigs
    /**
     * Describes the configuration of On-Demand Instances in an EC2 Fleet.
     */
    val onDemandOptions: OnDemandOptionsRequest? = builder.onDemandOptions
    /**
     * Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for
     * fleets of type maintain. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet
     * health checks in the Amazon EC2 User Guide.
     */
    val replaceUnhealthyInstances: Boolean? = builder.replaceUnhealthyInstances
    /**
     * Describes the configuration of Spot Instances in an EC2 Fleet.
     */
    val spotOptions: SpotOptionsRequest? = builder.spotOptions
    /**
     * The key-value pair for tagging the EC2 Fleet request on creation. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging your resources.
     * If the fleet type is instant, specify a resource type of fleet
     * to tag the fleet or instance to tag the instances at launch.
     * If the fleet type is maintain or request, specify a resource
     * type of fleet to tag the fleet. You cannot specify a resource type of
     * instance. To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The number of units to request.
     */
    val targetCapacitySpecification: TargetCapacitySpecificationRequest? = builder.targetCapacitySpecification
    /**
     * Indicates whether running instances should be terminated when the EC2 Fleet expires.
     */
    val terminateInstancesWithExpiration: Boolean? = builder.terminateInstancesWithExpiration
    /**
     * The fleet type. The default value is maintain.
     * maintain - The EC2 Fleet places an asynchronous request for your desired
     * capacity, and continues to maintain your desired Spot capacity by replenishing
     * interrupted Spot Instances.
     * request - The EC2 Fleet places an asynchronous one-time request for your
     * desired capacity, but does submit Spot requests in alternative capacity pools if Spot
     * capacity is unavailable, and does not maintain Spot capacity if Spot Instances are
     * interrupted.
     * instant - The EC2 Fleet places a synchronous one-time request for your
     * desired capacity, and returns errors for any instances that could not be
     * launched.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type">EC2 Fleet
     * request types in the Amazon EC2 User Guide.
     */
    val type: FleetType? = builder.type
    /**
     * The start date and time of the request, in UTC format (for example,
     * YYYY-MM-DDTHH:MM:SSZ).
     * The default is to start fulfilling the request immediately.
     */
    val validFrom: Instant? = builder.validFrom
    /**
     * The end date and time of the request, in UTC format (for example,
     * YYYY-MM-DDTHH:MM:SSZ).
     * At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
     */
    val validUntil: Instant? = builder.validUntil

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateFleetRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFleetRequest(")
        append("clientToken=$clientToken,")
        append("context=$context,")
        append("dryRun=$dryRun,")
        append("excessCapacityTerminationPolicy=$excessCapacityTerminationPolicy,")
        append("launchTemplateConfigs=$launchTemplateConfigs,")
        append("onDemandOptions=$onDemandOptions,")
        append("replaceUnhealthyInstances=$replaceUnhealthyInstances,")
        append("spotOptions=$spotOptions,")
        append("tagSpecifications=$tagSpecifications,")
        append("targetCapacitySpecification=$targetCapacitySpecification,")
        append("terminateInstancesWithExpiration=$terminateInstancesWithExpiration,")
        append("type=$type,")
        append("validFrom=$validFrom,")
        append("validUntil=$validUntil)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (context?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (excessCapacityTerminationPolicy?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateConfigs?.hashCode() ?: 0)
        result = 31 * result + (onDemandOptions?.hashCode() ?: 0)
        result = 31 * result + (replaceUnhealthyInstances?.hashCode() ?: 0)
        result = 31 * result + (spotOptions?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (targetCapacitySpecification?.hashCode() ?: 0)
        result = 31 * result + (terminateInstancesWithExpiration?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (validFrom?.hashCode() ?: 0)
        result = 31 * result + (validUntil?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateFleetRequest

        if (clientToken != other.clientToken) return false
        if (context != other.context) return false
        if (dryRun != other.dryRun) return false
        if (excessCapacityTerminationPolicy != other.excessCapacityTerminationPolicy) return false
        if (launchTemplateConfigs != other.launchTemplateConfigs) return false
        if (onDemandOptions != other.onDemandOptions) return false
        if (replaceUnhealthyInstances != other.replaceUnhealthyInstances) return false
        if (spotOptions != other.spotOptions) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (targetCapacitySpecification != other.targetCapacitySpecification) return false
        if (terminateInstancesWithExpiration != other.terminateInstancesWithExpiration) return false
        if (type != other.type) return false
        if (validFrom != other.validFrom) return false
        if (validUntil != other.validUntil) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateFleetRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateFleetRequest
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Reserved.
         */
        fun context(context: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * Indicates whether running instances should be terminated if the total target capacity of
         * the EC2 Fleet is decreased below the current size of the EC2 Fleet.
         */
        fun excessCapacityTerminationPolicy(excessCapacityTerminationPolicy: FleetExcessCapacityTerminationPolicy): FluentBuilder
        /**
         * The configuration for the EC2 Fleet.
         */
        fun launchTemplateConfigs(launchTemplateConfigs: List<FleetLaunchTemplateConfigRequest>): FluentBuilder
        /**
         * Describes the configuration of On-Demand Instances in an EC2 Fleet.
         */
        fun onDemandOptions(onDemandOptions: OnDemandOptionsRequest): FluentBuilder
        /**
         * Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for
         * fleets of type maintain. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet
         * health checks in the Amazon EC2 User Guide.
         */
        fun replaceUnhealthyInstances(replaceUnhealthyInstances: Boolean): FluentBuilder
        /**
         * Describes the configuration of Spot Instances in an EC2 Fleet.
         */
        fun spotOptions(spotOptions: SpotOptionsRequest): FluentBuilder
        /**
         * The key-value pair for tagging the EC2 Fleet request on creation. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging your resources.
         * If the fleet type is instant, specify a resource type of fleet
         * to tag the fleet or instance to tag the instances at launch.
         * If the fleet type is maintain or request, specify a resource
         * type of fleet to tag the fleet. You cannot specify a resource type of
         * instance. To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
        /**
         * The number of units to request.
         */
        fun targetCapacitySpecification(targetCapacitySpecification: TargetCapacitySpecificationRequest): FluentBuilder
        /**
         * Indicates whether running instances should be terminated when the EC2 Fleet expires.
         */
        fun terminateInstancesWithExpiration(terminateInstancesWithExpiration: Boolean): FluentBuilder
        /**
         * The fleet type. The default value is maintain.
         * maintain - The EC2 Fleet places an asynchronous request for your desired
         * capacity, and continues to maintain your desired Spot capacity by replenishing
         * interrupted Spot Instances.
         * request - The EC2 Fleet places an asynchronous one-time request for your
         * desired capacity, but does submit Spot requests in alternative capacity pools if Spot
         * capacity is unavailable, and does not maintain Spot capacity if Spot Instances are
         * interrupted.
         * instant - The EC2 Fleet places a synchronous one-time request for your
         * desired capacity, and returns errors for any instances that could not be
         * launched.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type">EC2 Fleet
         * request types in the Amazon EC2 User Guide.
         */
        fun type(type: FleetType): FluentBuilder
        /**
         * The start date and time of the request, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         * The default is to start fulfilling the request immediately.
         */
        fun validFrom(validFrom: Instant): FluentBuilder
        /**
         * The end date and time of the request, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         * At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
         */
        fun validUntil(validUntil: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency.
         */
        var clientToken: String?
        /**
         * Reserved.
         */
        var context: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * Indicates whether running instances should be terminated if the total target capacity of
         * the EC2 Fleet is decreased below the current size of the EC2 Fleet.
         */
        var excessCapacityTerminationPolicy: FleetExcessCapacityTerminationPolicy?
        /**
         * The configuration for the EC2 Fleet.
         */
        var launchTemplateConfigs: List<FleetLaunchTemplateConfigRequest>?
        /**
         * Describes the configuration of On-Demand Instances in an EC2 Fleet.
         */
        var onDemandOptions: OnDemandOptionsRequest?
        /**
         * Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for
         * fleets of type maintain. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet
         * health checks in the Amazon EC2 User Guide.
         */
        var replaceUnhealthyInstances: Boolean?
        /**
         * Describes the configuration of Spot Instances in an EC2 Fleet.
         */
        var spotOptions: SpotOptionsRequest?
        /**
         * The key-value pair for tagging the EC2 Fleet request on creation. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging your resources.
         * If the fleet type is instant, specify a resource type of fleet
         * to tag the fleet or instance to tag the instances at launch.
         * If the fleet type is maintain or request, specify a resource
         * type of fleet to tag the fleet. You cannot specify a resource type of
         * instance. To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template.
         */
        var tagSpecifications: List<TagSpecification>?
        /**
         * The number of units to request.
         */
        var targetCapacitySpecification: TargetCapacitySpecificationRequest?
        /**
         * Indicates whether running instances should be terminated when the EC2 Fleet expires.
         */
        var terminateInstancesWithExpiration: Boolean?
        /**
         * The fleet type. The default value is maintain.
         * maintain - The EC2 Fleet places an asynchronous request for your desired
         * capacity, and continues to maintain your desired Spot capacity by replenishing
         * interrupted Spot Instances.
         * request - The EC2 Fleet places an asynchronous one-time request for your
         * desired capacity, but does submit Spot requests in alternative capacity pools if Spot
         * capacity is unavailable, and does not maintain Spot capacity if Spot Instances are
         * interrupted.
         * instant - The EC2 Fleet places a synchronous one-time request for your
         * desired capacity, and returns errors for any instances that could not be
         * launched.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type">EC2 Fleet
         * request types in the Amazon EC2 User Guide.
         */
        var type: FleetType?
        /**
         * The start date and time of the request, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         * The default is to start fulfilling the request immediately.
         */
        var validFrom: Instant?
        /**
         * The end date and time of the request, in UTC format (for example,
         * YYYY-MM-DDTHH:MM:SSZ).
         * At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
         */
        var validUntil: Instant?

        fun build(): CreateFleetRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.OnDemandOptionsRequest] inside the given [block]
         */
        fun onDemandOptions(block: OnDemandOptionsRequest.DslBuilder.() -> kotlin.Unit) {
            this.onDemandOptions = OnDemandOptionsRequest.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.SpotOptionsRequest] inside the given [block]
         */
        fun spotOptions(block: SpotOptionsRequest.DslBuilder.() -> kotlin.Unit) {
            this.spotOptions = SpotOptionsRequest.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.TargetCapacitySpecificationRequest] inside the given [block]
         */
        fun targetCapacitySpecification(block: TargetCapacitySpecificationRequest.DslBuilder.() -> kotlin.Unit) {
            this.targetCapacitySpecification = TargetCapacitySpecificationRequest.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var context: String? = null
        override var dryRun: Boolean? = null
        override var excessCapacityTerminationPolicy: FleetExcessCapacityTerminationPolicy? = null
        override var launchTemplateConfigs: List<FleetLaunchTemplateConfigRequest>? = null
        override var onDemandOptions: OnDemandOptionsRequest? = null
        override var replaceUnhealthyInstances: Boolean? = null
        override var spotOptions: SpotOptionsRequest? = null
        override var tagSpecifications: List<TagSpecification>? = null
        override var targetCapacitySpecification: TargetCapacitySpecificationRequest? = null
        override var terminateInstancesWithExpiration: Boolean? = null
        override var type: FleetType? = null
        override var validFrom: Instant? = null
        override var validUntil: Instant? = null

        constructor(x: CreateFleetRequest) : this() {
            this.clientToken = x.clientToken
            this.context = x.context
            this.dryRun = x.dryRun
            this.excessCapacityTerminationPolicy = x.excessCapacityTerminationPolicy
            this.launchTemplateConfigs = x.launchTemplateConfigs
            this.onDemandOptions = x.onDemandOptions
            this.replaceUnhealthyInstances = x.replaceUnhealthyInstances
            this.spotOptions = x.spotOptions
            this.tagSpecifications = x.tagSpecifications
            this.targetCapacitySpecification = x.targetCapacitySpecification
            this.terminateInstancesWithExpiration = x.terminateInstancesWithExpiration
            this.type = x.type
            this.validFrom = x.validFrom
            this.validUntil = x.validUntil
        }

        override fun build(): CreateFleetRequest = CreateFleetRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun context(context: String): FluentBuilder = apply { this.context = context }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun excessCapacityTerminationPolicy(excessCapacityTerminationPolicy: FleetExcessCapacityTerminationPolicy): FluentBuilder = apply { this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy }
        override fun launchTemplateConfigs(launchTemplateConfigs: List<FleetLaunchTemplateConfigRequest>): FluentBuilder = apply { this.launchTemplateConfigs = launchTemplateConfigs }
        override fun onDemandOptions(onDemandOptions: OnDemandOptionsRequest): FluentBuilder = apply { this.onDemandOptions = onDemandOptions }
        override fun replaceUnhealthyInstances(replaceUnhealthyInstances: Boolean): FluentBuilder = apply { this.replaceUnhealthyInstances = replaceUnhealthyInstances }
        override fun spotOptions(spotOptions: SpotOptionsRequest): FluentBuilder = apply { this.spotOptions = spotOptions }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun targetCapacitySpecification(targetCapacitySpecification: TargetCapacitySpecificationRequest): FluentBuilder = apply { this.targetCapacitySpecification = targetCapacitySpecification }
        override fun terminateInstancesWithExpiration(terminateInstancesWithExpiration: Boolean): FluentBuilder = apply { this.terminateInstancesWithExpiration = terminateInstancesWithExpiration }
        override fun type(type: FleetType): FluentBuilder = apply { this.type = type }
        override fun validFrom(validFrom: Instant): FluentBuilder = apply { this.validFrom = validFrom }
        override fun validUntil(validUntil: Instant): FluentBuilder = apply { this.validUntil = validUntil }
    }
}
