// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateFlowLogsRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure
     * idempotency.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group
     * in your account.
     * If you specify LogDestinationType as s3, do not specify
     * DeliverLogsPermissionArn or LogGroupName.
     */
    val deliverLogsPermissionArn: String? = builder.deliverLogsPermissionArn
    /**
     * The destination options.
     */
    val destinationOptions: DestinationOptionsRequest? = builder.destinationOptions
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The destination to which the flow log data is to be published. Flow log data can be published
     * to a CloudWatch Logs log group or an Amazon S3 bucket. The value specified for this parameter depends on the value specified
     * for LogDestinationType.
     * If LogDestinationType is not specified or cloud-watch-logs,
     * specify the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For example, to publish
     * to a log group called my-logs, specify
     * arn:aws:logs:us-east-1:123456789012:log-group:my-logs. Alternatively,
     * use LogGroupName instead.
     * If LogDestinationType is s3, specify the ARN of the Amazon S3 bucket. You can also specify a
     * subfolder in the bucket. To specify a subfolder in the bucket, use the following  ARN format:
     * bucket_ARN/subfolder_name/. For example, to specify a subfolder named my-logs in a
     * bucket named my-bucket, use the following ARN: arn:aws:s3:::my-bucket/my-logs/. You
     * cannot use AWSLogs as a subfolder name. This is a reserved term.
     */
    val logDestination: String? = builder.logDestination
    /**
     * The type of destination to which the flow log data is to be published. Flow log data can be
     * published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify cloud-watch-logs. To
     * publish flow log data to Amazon S3, specify s3.
     * If you specify LogDestinationType as s3, do not specify
     * DeliverLogsPermissionArn or LogGroupName.
     * Default: cloud-watch-logs
     */
    val logDestinationType: LogDestinationType? = builder.logDestinationType
    /**
     * The fields to include in the flow log record, in the order in which they should
     * appear. For a list of available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records. If you
     * omit this parameter, the flow log is created using the default format. If you specify this parameter,
     * you must specify at least one field.
     * Specify the fields using the ${field-id} format, separated by spaces. For
     * the CLI, surround this parameter value with single quotes on Linux or
     * double quotes on Windows.
     */
    val logFormat: String? = builder.logFormat
    /**
     * The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.
     * If you specify LogDestinationType as s3, do not specify
     * DeliverLogsPermissionArn or LogGroupName.
     */
    val logGroupName: String? = builder.logGroupName
    /**
     * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).
     * When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based
     * instance, the aggregation interval is always 60 seconds or less, regardless
     * of the value that you specify.
     * Default: 600
     */
    val maxAggregationInterval: Int? = builder.maxAggregationInterval
    /**
     * The ID of the subnet, network interface, or VPC for which you want to create a flow log.
     * Constraints: Maximum of 1000 resources
     */
    val resourceIds: List<String>? = builder.resourceIds
    /**
     * The type of resource for which to create the flow log. For example, if you specified a VPC ID for
     * the ResourceId property, specify VPC for this property.
     */
    val resourceType: FlowLogsResourceType? = builder.resourceType
    /**
     * The tags to apply to the flow logs.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The type of traffic to log. You can log traffic that the resource accepts or rejects, or all traffic.
     */
    val trafficType: TrafficType? = builder.trafficType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateFlowLogsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFlowLogsRequest(")
        append("clientToken=$clientToken,")
        append("deliverLogsPermissionArn=$deliverLogsPermissionArn,")
        append("destinationOptions=$destinationOptions,")
        append("dryRun=$dryRun,")
        append("logDestination=$logDestination,")
        append("logDestinationType=$logDestinationType,")
        append("logFormat=$logFormat,")
        append("logGroupName=$logGroupName,")
        append("maxAggregationInterval=$maxAggregationInterval,")
        append("resourceIds=$resourceIds,")
        append("resourceType=$resourceType,")
        append("tagSpecifications=$tagSpecifications,")
        append("trafficType=$trafficType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (deliverLogsPermissionArn?.hashCode() ?: 0)
        result = 31 * result + (destinationOptions?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (logDestination?.hashCode() ?: 0)
        result = 31 * result + (logDestinationType?.hashCode() ?: 0)
        result = 31 * result + (logFormat?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (maxAggregationInterval ?: 0)
        result = 31 * result + (resourceIds?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (trafficType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateFlowLogsRequest

        if (clientToken != other.clientToken) return false
        if (deliverLogsPermissionArn != other.deliverLogsPermissionArn) return false
        if (destinationOptions != other.destinationOptions) return false
        if (dryRun != other.dryRun) return false
        if (logDestination != other.logDestination) return false
        if (logDestinationType != other.logDestinationType) return false
        if (logFormat != other.logFormat) return false
        if (logGroupName != other.logGroupName) return false
        if (maxAggregationInterval != other.maxAggregationInterval) return false
        if (resourceIds != other.resourceIds) return false
        if (resourceType != other.resourceType) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (trafficType != other.trafficType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateFlowLogsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateFlowLogsRequest
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure
         * idempotency.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group
         * in your account.
         * If you specify LogDestinationType as s3, do not specify
         * DeliverLogsPermissionArn or LogGroupName.
         */
        fun deliverLogsPermissionArn(deliverLogsPermissionArn: String): FluentBuilder
        /**
         * The destination options.
         */
        fun destinationOptions(destinationOptions: DestinationOptionsRequest): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The destination to which the flow log data is to be published. Flow log data can be published
         * to a CloudWatch Logs log group or an Amazon S3 bucket. The value specified for this parameter depends on the value specified
         * for LogDestinationType.
         * If LogDestinationType is not specified or cloud-watch-logs,
         * specify the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For example, to publish
         * to a log group called my-logs, specify
         * arn:aws:logs:us-east-1:123456789012:log-group:my-logs. Alternatively,
         * use LogGroupName instead.
         * If LogDestinationType is s3, specify the ARN of the Amazon S3 bucket. You can also specify a
         * subfolder in the bucket. To specify a subfolder in the bucket, use the following  ARN format:
         * bucket_ARN/subfolder_name/. For example, to specify a subfolder named my-logs in a
         * bucket named my-bucket, use the following ARN: arn:aws:s3:::my-bucket/my-logs/. You
         * cannot use AWSLogs as a subfolder name. This is a reserved term.
         */
        fun logDestination(logDestination: String): FluentBuilder
        /**
         * The type of destination to which the flow log data is to be published. Flow log data can be
         * published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify cloud-watch-logs. To
         * publish flow log data to Amazon S3, specify s3.
         * If you specify LogDestinationType as s3, do not specify
         * DeliverLogsPermissionArn or LogGroupName.
         * Default: cloud-watch-logs
         */
        fun logDestinationType(logDestinationType: LogDestinationType): FluentBuilder
        /**
         * The fields to include in the flow log record, in the order in which they should
         * appear. For a list of available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records. If you
         * omit this parameter, the flow log is created using the default format. If you specify this parameter,
         * you must specify at least one field.
         * Specify the fields using the ${field-id} format, separated by spaces. For
         * the CLI, surround this parameter value with single quotes on Linux or
         * double quotes on Windows.
         */
        fun logFormat(logFormat: String): FluentBuilder
        /**
         * The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.
         * If you specify LogDestinationType as s3, do not specify
         * DeliverLogsPermissionArn or LogGroupName.
         */
        fun logGroupName(logGroupName: String): FluentBuilder
        /**
         * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).
         * When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based
         * instance, the aggregation interval is always 60 seconds or less, regardless
         * of the value that you specify.
         * Default: 600
         */
        fun maxAggregationInterval(maxAggregationInterval: Int): FluentBuilder
        /**
         * The ID of the subnet, network interface, or VPC for which you want to create a flow log.
         * Constraints: Maximum of 1000 resources
         */
        fun resourceIds(resourceIds: List<String>): FluentBuilder
        /**
         * The type of resource for which to create the flow log. For example, if you specified a VPC ID for
         * the ResourceId property, specify VPC for this property.
         */
        fun resourceType(resourceType: FlowLogsResourceType): FluentBuilder
        /**
         * The tags to apply to the flow logs.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
        /**
         * The type of traffic to log. You can log traffic that the resource accepts or rejects, or all traffic.
         */
        fun trafficType(trafficType: TrafficType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure
         * idempotency.
         */
        var clientToken: String?
        /**
         * The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group
         * in your account.
         * If you specify LogDestinationType as s3, do not specify
         * DeliverLogsPermissionArn or LogGroupName.
         */
        var deliverLogsPermissionArn: String?
        /**
         * The destination options.
         */
        var destinationOptions: DestinationOptionsRequest?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The destination to which the flow log data is to be published. Flow log data can be published
         * to a CloudWatch Logs log group or an Amazon S3 bucket. The value specified for this parameter depends on the value specified
         * for LogDestinationType.
         * If LogDestinationType is not specified or cloud-watch-logs,
         * specify the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For example, to publish
         * to a log group called my-logs, specify
         * arn:aws:logs:us-east-1:123456789012:log-group:my-logs. Alternatively,
         * use LogGroupName instead.
         * If LogDestinationType is s3, specify the ARN of the Amazon S3 bucket. You can also specify a
         * subfolder in the bucket. To specify a subfolder in the bucket, use the following  ARN format:
         * bucket_ARN/subfolder_name/. For example, to specify a subfolder named my-logs in a
         * bucket named my-bucket, use the following ARN: arn:aws:s3:::my-bucket/my-logs/. You
         * cannot use AWSLogs as a subfolder name. This is a reserved term.
         */
        var logDestination: String?
        /**
         * The type of destination to which the flow log data is to be published. Flow log data can be
         * published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify cloud-watch-logs. To
         * publish flow log data to Amazon S3, specify s3.
         * If you specify LogDestinationType as s3, do not specify
         * DeliverLogsPermissionArn or LogGroupName.
         * Default: cloud-watch-logs
         */
        var logDestinationType: LogDestinationType?
        /**
         * The fields to include in the flow log record, in the order in which they should
         * appear. For a list of available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records. If you
         * omit this parameter, the flow log is created using the default format. If you specify this parameter,
         * you must specify at least one field.
         * Specify the fields using the ${field-id} format, separated by spaces. For
         * the CLI, surround this parameter value with single quotes on Linux or
         * double quotes on Windows.
         */
        var logFormat: String?
        /**
         * The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.
         * If you specify LogDestinationType as s3, do not specify
         * DeliverLogsPermissionArn or LogGroupName.
         */
        var logGroupName: String?
        /**
         * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).
         * When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based
         * instance, the aggregation interval is always 60 seconds or less, regardless
         * of the value that you specify.
         * Default: 600
         */
        var maxAggregationInterval: Int?
        /**
         * The ID of the subnet, network interface, or VPC for which you want to create a flow log.
         * Constraints: Maximum of 1000 resources
         */
        var resourceIds: List<String>?
        /**
         * The type of resource for which to create the flow log. For example, if you specified a VPC ID for
         * the ResourceId property, specify VPC for this property.
         */
        var resourceType: FlowLogsResourceType?
        /**
         * The tags to apply to the flow logs.
         */
        var tagSpecifications: List<TagSpecification>?
        /**
         * The type of traffic to log. You can log traffic that the resource accepts or rejects, or all traffic.
         */
        var trafficType: TrafficType?

        fun build(): CreateFlowLogsRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.DestinationOptionsRequest] inside the given [block]
         */
        fun destinationOptions(block: DestinationOptionsRequest.DslBuilder.() -> kotlin.Unit) {
            this.destinationOptions = DestinationOptionsRequest.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var deliverLogsPermissionArn: String? = null
        override var destinationOptions: DestinationOptionsRequest? = null
        override var dryRun: Boolean? = null
        override var logDestination: String? = null
        override var logDestinationType: LogDestinationType? = null
        override var logFormat: String? = null
        override var logGroupName: String? = null
        override var maxAggregationInterval: Int? = null
        override var resourceIds: List<String>? = null
        override var resourceType: FlowLogsResourceType? = null
        override var tagSpecifications: List<TagSpecification>? = null
        override var trafficType: TrafficType? = null

        constructor(x: CreateFlowLogsRequest) : this() {
            this.clientToken = x.clientToken
            this.deliverLogsPermissionArn = x.deliverLogsPermissionArn
            this.destinationOptions = x.destinationOptions
            this.dryRun = x.dryRun
            this.logDestination = x.logDestination
            this.logDestinationType = x.logDestinationType
            this.logFormat = x.logFormat
            this.logGroupName = x.logGroupName
            this.maxAggregationInterval = x.maxAggregationInterval
            this.resourceIds = x.resourceIds
            this.resourceType = x.resourceType
            this.tagSpecifications = x.tagSpecifications
            this.trafficType = x.trafficType
        }

        override fun build(): CreateFlowLogsRequest = CreateFlowLogsRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun deliverLogsPermissionArn(deliverLogsPermissionArn: String): FluentBuilder = apply { this.deliverLogsPermissionArn = deliverLogsPermissionArn }
        override fun destinationOptions(destinationOptions: DestinationOptionsRequest): FluentBuilder = apply { this.destinationOptions = destinationOptions }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun logDestination(logDestination: String): FluentBuilder = apply { this.logDestination = logDestination }
        override fun logDestinationType(logDestinationType: LogDestinationType): FluentBuilder = apply { this.logDestinationType = logDestinationType }
        override fun logFormat(logFormat: String): FluentBuilder = apply { this.logFormat = logFormat }
        override fun logGroupName(logGroupName: String): FluentBuilder = apply { this.logGroupName = logGroupName }
        override fun maxAggregationInterval(maxAggregationInterval: Int): FluentBuilder = apply { this.maxAggregationInterval = maxAggregationInterval }
        override fun resourceIds(resourceIds: List<String>): FluentBuilder = apply { this.resourceIds = resourceIds }
        override fun resourceType(resourceType: FlowLogsResourceType): FluentBuilder = apply { this.resourceType = resourceType }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun trafficType(trafficType: TrafficType): FluentBuilder = apply { this.trafficType = trafficType }
    }
}
