// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateImageRequest private constructor(builder: BuilderImpl) {
    /**
     * The block device mappings. This parameter cannot be used to modify the encryption
     * status of existing volumes or snapshots. To create an AMI with encrypted snapshots,
     * use the CopyImage action.
     */
    val blockDeviceMappings: List<BlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * A description for the new image.
     */
    val description: String? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The ID of the instance.
     */
    val instanceId: String? = builder.instanceId
    /**
     * A name for the new image.
     * Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets (&#91;&#93;), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
     */
    val name: String? = builder.name
    /**
     * By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image.
     * If the No Reboot option is set, Amazon EC2 doesn't shut down the instance before creating
     * the image. Without a reboot, the AMI will be crash consistent (all the volumes are snapshotted
     * at the same time), but not application consistent (all the operating system buffers are not flushed
     * to disk before the snapshots are created).
     */
    val noReboot: Boolean? = builder.noReboot
    /**
     * The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the
     * snapshots, or both.
     * To tag the AMI, the value for ResourceType must be
     * image.
     * To tag the snapshots that are created of the root volume and of other Amazon EBS volumes that
     * are attached to the instance, the value for ResourceType must be
     * snapshot. The same tag is applied to all of the snapshots that are
     * created.
     * If you specify other values for ResourceType, the request fails.
     * To tag an AMI or snapshot after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateImageRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateImageRequest(")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("instanceId=$instanceId,")
        append("name=$name,")
        append("noReboot=$noReboot,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockDeviceMappings?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (noReboot?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateImageRequest

        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (instanceId != other.instanceId) return false
        if (name != other.name) return false
        if (noReboot != other.noReboot) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateImageRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateImageRequest
        /**
         * The block device mappings. This parameter cannot be used to modify the encryption
         * status of existing volumes or snapshots. To create an AMI with encrypted snapshots,
         * use the CopyImage action.
         */
        fun blockDeviceMappings(blockDeviceMappings: List<BlockDeviceMapping>): FluentBuilder
        /**
         * A description for the new image.
         */
        fun description(description: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The ID of the instance.
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * A name for the new image.
         * Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets (&#91;&#93;), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
         */
        fun name(name: String): FluentBuilder
        /**
         * By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image.
         * If the No Reboot option is set, Amazon EC2 doesn't shut down the instance before creating
         * the image. Without a reboot, the AMI will be crash consistent (all the volumes are snapshotted
         * at the same time), but not application consistent (all the operating system buffers are not flushed
         * to disk before the snapshots are created).
         */
        fun noReboot(noReboot: Boolean): FluentBuilder
        /**
         * The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the
         * snapshots, or both.
         * To tag the AMI, the value for ResourceType must be
         * image.
         * To tag the snapshots that are created of the root volume and of other Amazon EBS volumes that
         * are attached to the instance, the value for ResourceType must be
         * snapshot. The same tag is applied to all of the snapshots that are
         * created.
         * If you specify other values for ResourceType, the request fails.
         * To tag an AMI or snapshot after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The block device mappings. This parameter cannot be used to modify the encryption
         * status of existing volumes or snapshots. To create an AMI with encrypted snapshots,
         * use the CopyImage action.
         */
        var blockDeviceMappings: List<BlockDeviceMapping>?
        /**
         * A description for the new image.
         */
        var description: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The ID of the instance.
         */
        var instanceId: String?
        /**
         * A name for the new image.
         * Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets (&#91;&#93;), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
         */
        var name: String?
        /**
         * By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image.
         * If the No Reboot option is set, Amazon EC2 doesn't shut down the instance before creating
         * the image. Without a reboot, the AMI will be crash consistent (all the volumes are snapshotted
         * at the same time), but not application consistent (all the operating system buffers are not flushed
         * to disk before the snapshots are created).
         */
        var noReboot: Boolean?
        /**
         * The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the
         * snapshots, or both.
         * To tag the AMI, the value for ResourceType must be
         * image.
         * To tag the snapshots that are created of the root volume and of other Amazon EBS volumes that
         * are attached to the instance, the value for ResourceType must be
         * snapshot. The same tag is applied to all of the snapshots that are
         * created.
         * If you specify other values for ResourceType, the request fails.
         * To tag an AMI or snapshot after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags.
         */
        var tagSpecifications: List<TagSpecification>?

        fun build(): CreateImageRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var blockDeviceMappings: List<BlockDeviceMapping>? = null
        override var description: String? = null
        override var dryRun: Boolean? = null
        override var instanceId: String? = null
        override var name: String? = null
        override var noReboot: Boolean? = null
        override var tagSpecifications: List<TagSpecification>? = null

        constructor(x: CreateImageRequest) : this() {
            this.blockDeviceMappings = x.blockDeviceMappings
            this.description = x.description
            this.dryRun = x.dryRun
            this.instanceId = x.instanceId
            this.name = x.name
            this.noReboot = x.noReboot
            this.tagSpecifications = x.tagSpecifications
        }

        override fun build(): CreateImageRequest = CreateImageRequest(this)
        override fun blockDeviceMappings(blockDeviceMappings: List<BlockDeviceMapping>): FluentBuilder = apply { this.blockDeviceMappings = blockDeviceMappings }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun noReboot(noReboot: Boolean): FluentBuilder = apply { this.noReboot = noReboot }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
    }
}
