// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateLaunchTemplateRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the
     * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency.
     * Constraint: Maximum 128 ASCII characters.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Checks whether you have the required permissions for the action, without actually
     * making the request, and provides an error response. If you have the required
     * permissions, the error response is DryRunOperation. Otherwise, it is
     * UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The information for the launch template.
     */
    val launchTemplateData: RequestLaunchTemplateData? = builder.launchTemplateData
    /**
     * A name for the launch template.
     */
    val launchTemplateName: String? = builder.launchTemplateName
    /**
     * The tags to apply to the launch template during creation.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * A description for the first version of the launch template.
     */
    val versionDescription: String? = builder.versionDescription

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateLaunchTemplateRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLaunchTemplateRequest(")
        append("clientToken=$clientToken,")
        append("dryRun=$dryRun,")
        append("launchTemplateData=$launchTemplateData,")
        append("launchTemplateName=$launchTemplateName,")
        append("tagSpecifications=$tagSpecifications,")
        append("versionDescription=$versionDescription)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateData?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateName?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (versionDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateLaunchTemplateRequest

        if (clientToken != other.clientToken) return false
        if (dryRun != other.dryRun) return false
        if (launchTemplateData != other.launchTemplateData) return false
        if (launchTemplateName != other.launchTemplateName) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (versionDescription != other.versionDescription) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateLaunchTemplateRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateLaunchTemplateRequest
        /**
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency.
         * Constraint: Maximum 128 ASCII characters.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually
         * making the request, and provides an error response. If you have the required
         * permissions, the error response is DryRunOperation. Otherwise, it is
         * UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The information for the launch template.
         */
        fun launchTemplateData(launchTemplateData: RequestLaunchTemplateData): FluentBuilder
        /**
         * A name for the launch template.
         */
        fun launchTemplateName(launchTemplateName: String): FluentBuilder
        /**
         * The tags to apply to the launch template during creation.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
        /**
         * A description for the first version of the launch template.
         */
        fun versionDescription(versionDescription: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency.
         * Constraint: Maximum 128 ASCII characters.
         */
        var clientToken: String?
        /**
         * Checks whether you have the required permissions for the action, without actually
         * making the request, and provides an error response. If you have the required
         * permissions, the error response is DryRunOperation. Otherwise, it is
         * UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The information for the launch template.
         */
        var launchTemplateData: RequestLaunchTemplateData?
        /**
         * A name for the launch template.
         */
        var launchTemplateName: String?
        /**
         * The tags to apply to the launch template during creation.
         */
        var tagSpecifications: List<TagSpecification>?
        /**
         * A description for the first version of the launch template.
         */
        var versionDescription: String?

        fun build(): CreateLaunchTemplateRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.RequestLaunchTemplateData] inside the given [block]
         */
        fun launchTemplateData(block: RequestLaunchTemplateData.DslBuilder.() -> kotlin.Unit) {
            this.launchTemplateData = RequestLaunchTemplateData.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var dryRun: Boolean? = null
        override var launchTemplateData: RequestLaunchTemplateData? = null
        override var launchTemplateName: String? = null
        override var tagSpecifications: List<TagSpecification>? = null
        override var versionDescription: String? = null

        constructor(x: CreateLaunchTemplateRequest) : this() {
            this.clientToken = x.clientToken
            this.dryRun = x.dryRun
            this.launchTemplateData = x.launchTemplateData
            this.launchTemplateName = x.launchTemplateName
            this.tagSpecifications = x.tagSpecifications
            this.versionDescription = x.versionDescription
        }

        override fun build(): CreateLaunchTemplateRequest = CreateLaunchTemplateRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun launchTemplateData(launchTemplateData: RequestLaunchTemplateData): FluentBuilder = apply { this.launchTemplateData = launchTemplateData }
        override fun launchTemplateName(launchTemplateName: String): FluentBuilder = apply { this.launchTemplateName = launchTemplateName }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
        override fun versionDescription(versionDescription: String): FluentBuilder = apply { this.versionDescription = versionDescription }
    }
}
