// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateLaunchTemplateVersionRequest private constructor(builder: BuilderImpl) {
    /**
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the
     * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency.
     * Constraint: Maximum 128 ASCII characters.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Checks whether you have the required permissions for the action, without actually
     * making the request, and provides an error response. If you have the required
     * permissions, the error response is DryRunOperation. Otherwise, it is
     * UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * The information for the launch template.
     */
    val launchTemplateData: RequestLaunchTemplateData? = builder.launchTemplateData
    /**
     * The ID of the launch template. You must specify either the launch template ID or
     * launch template name in the request.
     */
    val launchTemplateId: String? = builder.launchTemplateId
    /**
     * The name of the launch template. You must specify either the launch template ID or
     * launch template name in the request.
     */
    val launchTemplateName: String? = builder.launchTemplateName
    /**
     * The version number of the launch template version on which to base the new version.
     * The new version inherits the same launch parameters as the source version, except for
     * parameters that you specify in LaunchTemplateData. Snapshots applied
     * to the block device mapping are ignored when creating a new version unless they
     * are explicitly included.
     */
    val sourceVersion: String? = builder.sourceVersion
    /**
     * A description for the version of the launch template.
     */
    val versionDescription: String? = builder.versionDescription

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateLaunchTemplateVersionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLaunchTemplateVersionRequest(")
        append("clientToken=$clientToken,")
        append("dryRun=$dryRun,")
        append("launchTemplateData=$launchTemplateData,")
        append("launchTemplateId=$launchTemplateId,")
        append("launchTemplateName=$launchTemplateName,")
        append("sourceVersion=$sourceVersion,")
        append("versionDescription=$versionDescription)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateData?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateId?.hashCode() ?: 0)
        result = 31 * result + (launchTemplateName?.hashCode() ?: 0)
        result = 31 * result + (sourceVersion?.hashCode() ?: 0)
        result = 31 * result + (versionDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateLaunchTemplateVersionRequest

        if (clientToken != other.clientToken) return false
        if (dryRun != other.dryRun) return false
        if (launchTemplateData != other.launchTemplateData) return false
        if (launchTemplateId != other.launchTemplateId) return false
        if (launchTemplateName != other.launchTemplateName) return false
        if (sourceVersion != other.sourceVersion) return false
        if (versionDescription != other.versionDescription) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateLaunchTemplateVersionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateLaunchTemplateVersionRequest
        /**
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency.
         * Constraint: Maximum 128 ASCII characters.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually
         * making the request, and provides an error response. If you have the required
         * permissions, the error response is DryRunOperation. Otherwise, it is
         * UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * The information for the launch template.
         */
        fun launchTemplateData(launchTemplateData: RequestLaunchTemplateData): FluentBuilder
        /**
         * The ID of the launch template. You must specify either the launch template ID or
         * launch template name in the request.
         */
        fun launchTemplateId(launchTemplateId: String): FluentBuilder
        /**
         * The name of the launch template. You must specify either the launch template ID or
         * launch template name in the request.
         */
        fun launchTemplateName(launchTemplateName: String): FluentBuilder
        /**
         * The version number of the launch template version on which to base the new version.
         * The new version inherits the same launch parameters as the source version, except for
         * parameters that you specify in LaunchTemplateData. Snapshots applied
         * to the block device mapping are ignored when creating a new version unless they
         * are explicitly included.
         */
        fun sourceVersion(sourceVersion: String): FluentBuilder
        /**
         * A description for the version of the launch template.
         */
        fun versionDescription(versionDescription: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency.
         * Constraint: Maximum 128 ASCII characters.
         */
        var clientToken: String?
        /**
         * Checks whether you have the required permissions for the action, without actually
         * making the request, and provides an error response. If you have the required
         * permissions, the error response is DryRunOperation. Otherwise, it is
         * UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * The information for the launch template.
         */
        var launchTemplateData: RequestLaunchTemplateData?
        /**
         * The ID of the launch template. You must specify either the launch template ID or
         * launch template name in the request.
         */
        var launchTemplateId: String?
        /**
         * The name of the launch template. You must specify either the launch template ID or
         * launch template name in the request.
         */
        var launchTemplateName: String?
        /**
         * The version number of the launch template version on which to base the new version.
         * The new version inherits the same launch parameters as the source version, except for
         * parameters that you specify in LaunchTemplateData. Snapshots applied
         * to the block device mapping are ignored when creating a new version unless they
         * are explicitly included.
         */
        var sourceVersion: String?
        /**
         * A description for the version of the launch template.
         */
        var versionDescription: String?

        fun build(): CreateLaunchTemplateVersionRequest
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.RequestLaunchTemplateData] inside the given [block]
         */
        fun launchTemplateData(block: RequestLaunchTemplateData.DslBuilder.() -> kotlin.Unit) {
            this.launchTemplateData = RequestLaunchTemplateData.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientToken: String? = null
        override var dryRun: Boolean? = null
        override var launchTemplateData: RequestLaunchTemplateData? = null
        override var launchTemplateId: String? = null
        override var launchTemplateName: String? = null
        override var sourceVersion: String? = null
        override var versionDescription: String? = null

        constructor(x: CreateLaunchTemplateVersionRequest) : this() {
            this.clientToken = x.clientToken
            this.dryRun = x.dryRun
            this.launchTemplateData = x.launchTemplateData
            this.launchTemplateId = x.launchTemplateId
            this.launchTemplateName = x.launchTemplateName
            this.sourceVersion = x.sourceVersion
            this.versionDescription = x.versionDescription
        }

        override fun build(): CreateLaunchTemplateVersionRequest = CreateLaunchTemplateVersionRequest(this)
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun launchTemplateData(launchTemplateData: RequestLaunchTemplateData): FluentBuilder = apply { this.launchTemplateData = launchTemplateData }
        override fun launchTemplateId(launchTemplateId: String): FluentBuilder = apply { this.launchTemplateId = launchTemplateId }
        override fun launchTemplateName(launchTemplateName: String): FluentBuilder = apply { this.launchTemplateName = launchTemplateName }
        override fun sourceVersion(sourceVersion: String): FluentBuilder = apply { this.sourceVersion = sourceVersion }
        override fun versionDescription(versionDescription: String): FluentBuilder = apply { this.versionDescription = versionDescription }
    }
}
