// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateManagedPrefixListRequest private constructor(builder: BuilderImpl) {
    /**
     * The IP address type.
     * Valid Values: IPv4 | IPv6
     */
    val addressFamily: String? = builder.addressFamily
    /**
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the
     * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency.
     * Constraints: Up to 255 UTF-8 characters in length.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Checks whether you have the required permissions for the action, without actually making the request,
     * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
     * Otherwise, it is UnauthorizedOperation.
     */
    val dryRun: Boolean? = builder.dryRun
    /**
     * One or more entries for the prefix list.
     */
    val entries: List<AddPrefixListEntry>? = builder.entries
    /**
     * The maximum number of entries for the prefix list.
     */
    val maxEntries: Int? = builder.maxEntries
    /**
     * A name for the prefix list.
     * Constraints: Up to 255 characters in length. The name cannot start with com.amazonaws.
     */
    val prefixListName: String? = builder.prefixListName
    /**
     * The tags to apply to the prefix list during creation.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateManagedPrefixListRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateManagedPrefixListRequest(")
        append("addressFamily=$addressFamily,")
        append("clientToken=$clientToken,")
        append("dryRun=$dryRun,")
        append("entries=$entries,")
        append("maxEntries=$maxEntries,")
        append("prefixListName=$prefixListName,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressFamily?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (entries?.hashCode() ?: 0)
        result = 31 * result + (maxEntries ?: 0)
        result = 31 * result + (prefixListName?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateManagedPrefixListRequest

        if (addressFamily != other.addressFamily) return false
        if (clientToken != other.clientToken) return false
        if (dryRun != other.dryRun) return false
        if (entries != other.entries) return false
        if (maxEntries != other.maxEntries) return false
        if (prefixListName != other.prefixListName) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateManagedPrefixListRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateManagedPrefixListRequest
        /**
         * The IP address type.
         * Valid Values: IPv4 | IPv6
         */
        fun addressFamily(addressFamily: String): FluentBuilder
        /**
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency.
         * Constraints: Up to 255 UTF-8 characters in length.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        fun dryRun(dryRun: Boolean): FluentBuilder
        /**
         * One or more entries for the prefix list.
         */
        fun entries(entries: List<AddPrefixListEntry>): FluentBuilder
        /**
         * The maximum number of entries for the prefix list.
         */
        fun maxEntries(maxEntries: Int): FluentBuilder
        /**
         * A name for the prefix list.
         * Constraints: Up to 255 characters in length. The name cannot start with com.amazonaws.
         */
        fun prefixListName(prefixListName: String): FluentBuilder
        /**
         * The tags to apply to the prefix list during creation.
         */
        fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The IP address type.
         * Valid Values: IPv4 | IPv6
         */
        var addressFamily: String?
        /**
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the
         * request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency.
         * Constraints: Up to 255 UTF-8 characters in length.
         */
        var clientToken: String?
        /**
         * Checks whether you have the required permissions for the action, without actually making the request,
         * and provides an error response. If you have the required permissions, the error response is DryRunOperation.
         * Otherwise, it is UnauthorizedOperation.
         */
        var dryRun: Boolean?
        /**
         * One or more entries for the prefix list.
         */
        var entries: List<AddPrefixListEntry>?
        /**
         * The maximum number of entries for the prefix list.
         */
        var maxEntries: Int?
        /**
         * A name for the prefix list.
         * Constraints: Up to 255 characters in length. The name cannot start with com.amazonaws.
         */
        var prefixListName: String?
        /**
         * The tags to apply to the prefix list during creation.
         */
        var tagSpecifications: List<TagSpecification>?

        fun build(): CreateManagedPrefixListRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var addressFamily: String? = null
        override var clientToken: String? = null
        override var dryRun: Boolean? = null
        override var entries: List<AddPrefixListEntry>? = null
        override var maxEntries: Int? = null
        override var prefixListName: String? = null
        override var tagSpecifications: List<TagSpecification>? = null

        constructor(x: CreateManagedPrefixListRequest) : this() {
            this.addressFamily = x.addressFamily
            this.clientToken = x.clientToken
            this.dryRun = x.dryRun
            this.entries = x.entries
            this.maxEntries = x.maxEntries
            this.prefixListName = x.prefixListName
            this.tagSpecifications = x.tagSpecifications
        }

        override fun build(): CreateManagedPrefixListRequest = CreateManagedPrefixListRequest(this)
        override fun addressFamily(addressFamily: String): FluentBuilder = apply { this.addressFamily = addressFamily }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun dryRun(dryRun: Boolean): FluentBuilder = apply { this.dryRun = dryRun }
        override fun entries(entries: List<AddPrefixListEntry>): FluentBuilder = apply { this.entries = entries }
        override fun maxEntries(maxEntries: Int): FluentBuilder = apply { this.maxEntries = maxEntries }
        override fun prefixListName(prefixListName: String): FluentBuilder = apply { this.prefixListName = prefixListName }
        override fun tagSpecifications(tagSpecifications: List<TagSpecification>): FluentBuilder = apply { this.tagSpecifications = tagSpecifications }
    }
}
